/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg;

import com.sun.media.imageio.plugins.tiff.BaselineTIFFTagSet;
import com.sun.media.imageio.plugins.tiff.EXIFParentTIFFTagSet;
import com.sun.media.imageio.plugins.tiff.TIFFDirectory;
import com.sun.media.imageio.plugins.tiff.TIFFField;
import com.sun.media.imageio.plugins.tiff.TIFFTagSet;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.plugins.jpeg.JPEGHuffmanTable;
import javax.imageio.plugins.jpeg.JPEGQTable;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CLibJPEGMetadata
extends IIOMetadata {
    static final String NATIVE_FORMAT = "javax_imageio_jpeg_image_1.0";
    static final String NATIVE_FORMAT_CLASS = "com.sun.imageio.plugins.jpeg.JPEGImageMetadataFormat";
    static final String TIFF_FORMAT = "com_sun_media_imageio_plugins_tiff_image_1.0";
    static final String TIFF_FORMAT_CLASS = "com.sun.media.imageioimpl.plugins.tiff.TIFFImageMetadataFormat";
    static final int TEM = 1;
    static final int SOF0 = 192;
    static final int SOF1 = 193;
    static final int SOF2 = 194;
    static final int SOF3 = 195;
    static final int DHT = 196;
    static final int SOF5 = 197;
    static final int SOF6 = 198;
    static final int SOF7 = 199;
    static final int JPG = 200;
    static final int SOF9 = 201;
    static final int SOF10 = 202;
    static final int SOF11 = 203;
    static final int DAC = 204;
    static final int SOF13 = 205;
    static final int SOF14 = 206;
    static final int SOF15 = 207;
    static final int RST0 = 208;
    static final int RST1 = 209;
    static final int RST2 = 210;
    static final int RST3 = 211;
    static final int RST4 = 212;
    static final int RST5 = 213;
    static final int RST6 = 214;
    static final int RST7 = 215;
    static final int RESTART_RANGE = 8;
    static final int SOI = 216;
    static final int EOI = 217;
    static final int SOS = 218;
    static final int DQT = 219;
    static final int DNL = 220;
    static final int DRI = 221;
    static final int DHP = 222;
    static final int EXP = 223;
    static final int APP0 = 224;
    static final int APP1 = 225;
    static final int APP2 = 226;
    static final int APP3 = 227;
    static final int APP4 = 228;
    static final int APP5 = 229;
    static final int APP6 = 230;
    static final int APP7 = 231;
    static final int APP8 = 232;
    static final int APP9 = 233;
    static final int APP10 = 234;
    static final int APP11 = 235;
    static final int APP12 = 236;
    static final int APP13 = 237;
    static final int APP14 = 238;
    static final int APP15 = 239;
    static final int COM = 254;
    static final int SOF55 = 247;
    static final int LSE = 242;
    static final int APPN_MIN = 224;
    static final int APPN_MAX = 239;
    static final int SOFN_MIN = 192;
    static final int SOFN_MAX = 207;
    static final int RST_MIN = 208;
    static final int RST_MAX = 215;
    static final int APP0_JFIF = 57344;
    static final int APP0_JFXX = 57345;
    static final int APP1_EXIF = 57600;
    static final int APP2_ICC = 57856;
    static final int APP14_ADOBE = 60928;
    static final int UNKNOWN_MARKER = 65535;
    static final int SOF_MARKER = 49152;
    static final int JFIF_RESUNITS_ASPECT = 0;
    static final int JFIF_RESUNITS_DPI = 1;
    static final int JFIF_RESUNITS_DPC = 2;
    static final int THUMBNAIL_JPEG = 16;
    static final int THUMBNAIL_PALETTE = 17;
    static final int THUMBNAIL_RGB = 18;
    static final int ADOBE_TRANSFORM_UNKNOWN = 0;
    static final int ADOBE_TRANSFORM_YCC = 1;
    static final int ADOBE_TRANSFORM_YCCK = 2;
    static final int[] zigzag = new int[]{0, 1, 5, 6, 14, 15, 27, 28, 2, 4, 7, 13, 16, 26, 29, 42, 3, 8, 12, 17, 25, 30, 41, 43, 9, 11, 18, 24, 31, 40, 44, 53, 10, 19, 23, 32, 39, 45, 52, 54, 20, 22, 33, 38, 46, 51, 55, 60, 21, 34, 37, 47, 50, 56, 59, 61, 35, 36, 48, 49, 57, 58, 62, 63};
    private boolean isReadOnly = true;
    boolean app0JFIFPresent;
    int majorVersion = 1;
    int minorVersion = 2;
    int resUnits;
    int Xdensity = 1;
    int Ydensity = 1;
    int thumbWidth = 0;
    int thumbHeight = 0;
    BufferedImage jfifThumbnail;
    boolean app0JFXXPresent;
    List extensionCodes;
    List jfxxThumbnails;
    boolean app2ICCPresent;
    ICC_Profile profile = null;
    boolean dqtPresent;
    List qtables;
    boolean dhtPresent;
    List htables;
    boolean driPresent;
    int driInterval;
    boolean comPresent;
    List comments;
    boolean unknownPresent;
    List markerTags;
    List unknownData;
    boolean app14AdobePresent;
    int version = 100;
    int flags0 = 0;
    int flags1 = 0;
    int transform;
    boolean sofPresent;
    int sofProcess;
    int samplePrecision = 8;
    int numLines;
    int samplesPerLine;
    int numFrameComponents;
    int[] componentId;
    int[] hSamplingFactor;
    int[] vSamplingFactor;
    int[] qtableSelector;
    boolean sosPresent;
    int numScanComponents;
    int[] componentSelector;
    int[] dcHuffTable;
    int[] acHuffTable;
    int startSpectralSelection;
    int endSpectralSelection;
    int approxHigh;
    int approxLow;
    byte[] exifData = null;
    private List markers = null;
    private boolean hasAlpha = false;
    private boolean thumbnailsInitialized = false;
    private List thumbnails = new ArrayList();

    private static IIOImage getThumbnail(ImageInputStream imageInputStream, int n, int n2, int n3, int n4) throws IOException {
        IIOImage iIOImage;
        long l = imageInputStream.getStreamPosition();
        if (n2 == 16) {
            Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
            if (iterator == null || !iterator.hasNext()) {
                return null;
            }
            ImageReader imageReader = iterator.next();
            imageReader.setInput(imageInputStream);
            BufferedImage bufferedImage = imageReader.read(0, null);
            IIOMetadata iIOMetadata = null;
            try {
                iIOMetadata = imageReader.getImageMetadata(0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            iIOImage = new IIOImage(bufferedImage, null, iIOMetadata);
        } else {
            ColorModel colorModel;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            int n5;
            if (n2 == 17) {
                if (n < 768 + n3 * n4) {
                    return null;
                }
                n5 = 1;
                object4 = new byte[768];
                imageInputStream.readFully((byte[])object4);
                object3 = new byte[256];
                object2 = new byte[256];
                object = new byte[256];
                int n6 = 0;
                for (int i = 0; i < 256; ++i) {
                    object3[i] = object4[n6++];
                    object2[i] = object4[n6++];
                    object[i] = object4[n6++];
                }
                colorModel = new IndexColorModel(8, 256, (byte[])object3, (byte[])object2, (byte[])object);
            } else {
                if (n < 3 * n3 * n4) {
                    return null;
                }
                n5 = 3;
                object4 = ColorSpace.getInstance(1000);
                colorModel = new ComponentColorModel((ColorSpace)object4, false, false, 1, 0);
            }
            object4 = new byte[n3 * n4 * n5];
            imageInputStream.readFully((byte[])object4);
            object3 = new DataBufferByte((byte[])object4, ((byte[])object4).length);
            object2 = Raster.createInterleavedRaster((DataBuffer)object3, n3, n4, n3 * n5, n5, new int[]{0, 1, 2}, null);
            object = new BufferedImage(colorModel, (WritableRaster)object2, false, null);
            iIOImage = new IIOImage((RenderedImage)object, null, null);
        }
        imageInputStream.seek(l + (long)n);
        return iIOImage;
    }

    CLibJPEGMetadata() {
        super(true, NATIVE_FORMAT, NATIVE_FORMAT_CLASS, new String[]{TIFF_FORMAT}, new String[]{TIFF_FORMAT_CLASS});
        this.isReadOnly = this.isReadOnly;
    }

    CLibJPEGMetadata(ImageInputStream imageInputStream) throws IIOException {
        this();
        try {
            this.initializeFromStream(imageInputStream);
        }
        catch (IOException iOException) {
            throw new IIOException("Cannot initialize JPEG metadata!", iOException);
        }
    }

    private synchronized void initializeFromStream(ImageInputStream imageInputStream) throws IOException {
        int n;
        int n2;
        imageInputStream.mark();
        imageInputStream.setByteOrder(ByteOrder.BIG_ENDIAN);
        this.markers = new ArrayList();
        boolean bl = true;
        int n3 = 0;
        long[] lArray = null;
        int[] nArray = null;
        try {
            block8: while (true) {
                Object object;
                if (imageInputStream.read() != 255 || (n2 = imageInputStream.read()) == 0 || n2 == 255 || n2 == 216 || n2 == 1 || n2 >= 208 && n2 <= 215) {
                    continue;
                }
                if (n2 == 217) break;
                n = imageInputStream.readUnsignedShort() - 2;
                if (224 <= n2 && n2 <= 239) {
                    long l = imageInputStream.getStreamPosition();
                    boolean bl2 = false;
                    switch (n2) {
                        case 224: {
                            IIOImage iIOImage;
                            if (n < 5) break;
                            byte[] byArray = new byte[5];
                            imageInputStream.readFully(byArray);
                            String string = new String(byArray);
                            if (string.startsWith("JFIF") && !this.app0JFIFPresent) {
                                IIOImage iIOImage2;
                                this.app0JFIFPresent = true;
                                this.markers.add(new Integer(57344));
                                this.majorVersion = imageInputStream.read();
                                this.minorVersion = imageInputStream.read();
                                this.resUnits = imageInputStream.read();
                                this.Xdensity = imageInputStream.readUnsignedShort();
                                this.Ydensity = imageInputStream.readUnsignedShort();
                                this.thumbWidth = imageInputStream.read();
                                this.thumbHeight = imageInputStream.read();
                                if (this.thumbWidth > 0 && this.thumbHeight > 0 && (iIOImage2 = CLibJPEGMetadata.getThumbnail(imageInputStream, n - 14, 18, this.thumbWidth, this.thumbHeight)) != null) {
                                    this.jfifThumbnail = (BufferedImage)iIOImage2.getRenderedImage();
                                }
                                bl2 = true;
                                break;
                            }
                            if (!string.startsWith("JFXX")) break;
                            if (!this.app0JFXXPresent) {
                                this.extensionCodes = new ArrayList(1);
                                this.jfxxThumbnails = new ArrayList(1);
                                this.app0JFXXPresent = true;
                            }
                            this.markers.add(new Integer(57345));
                            int n4 = imageInputStream.read();
                            this.extensionCodes.add(new Integer(n4));
                            int n5 = 0;
                            int n6 = 0;
                            int n7 = 6;
                            if (n4 != 16) {
                                n5 = imageInputStream.read();
                                n6 = imageInputStream.read();
                                n7 += 2;
                            }
                            if ((iIOImage = CLibJPEGMetadata.getThumbnail(imageInputStream, n - n7, n4, n5, n6)) != null) {
                                this.jfxxThumbnails.add(iIOImage);
                            }
                            bl2 = true;
                            break;
                        }
                        case 225: {
                            byte[] byArray;
                            if (n >= 6) {
                                byArray = new byte[6];
                                imageInputStream.readFully(byArray);
                                if (byArray[0] == 69 && byArray[1] == 120 && byArray[2] == 105 && byArray[3] == 102 && byArray[4] == 0 && byArray[5] == 0) {
                                    this.exifData = new byte[n - 6];
                                    imageInputStream.readFully(this.exifData);
                                }
                            }
                        }
                        case 226: {
                            if (n < 12) break;
                            byte[] byArray = new byte[12];
                            imageInputStream.readFully(byArray);
                            String string = new String(byArray);
                            if (!string.startsWith("ICC_PROFILE")) break;
                            if (!bl) {
                                imageInputStream.skipBytes(n - 12);
                                continue block8;
                            }
                            int n8 = imageInputStream.read();
                            int n5 = imageInputStream.read();
                            if (n5 == 0 || n8 == 0 || n8 > n5 || this.app2ICCPresent && (n5 != n3 || lArray[n8] != 0L)) {
                                bl = false;
                                imageInputStream.skipBytes(n - 14);
                                continue block8;
                            }
                            if (!this.app2ICCPresent) {
                                this.app2ICCPresent = true;
                                this.markers.add(new Integer(57856));
                                n3 = n5;
                                if (n5 == 1) {
                                    byArray = new byte[n - 14];
                                    imageInputStream.readFully(byArray);
                                    this.profile = ICC_Profile.getInstance(byArray);
                                } else {
                                    lArray = new long[n5 + 1];
                                    nArray = new int[n5 + 1];
                                    lArray[n8] = imageInputStream.getStreamPosition();
                                    nArray[n8] = n - 14;
                                    imageInputStream.skipBytes(n - 14);
                                }
                            } else {
                                lArray[n8] = imageInputStream.getStreamPosition();
                                nArray[n8] = n - 14;
                                imageInputStream.skipBytes(n - 14);
                            }
                            bl2 = true;
                            break;
                        }
                        case 238: {
                            if (n < 5) break;
                            byte[] byArray = new byte[5];
                            imageInputStream.readFully(byArray);
                            String string = new String(byArray);
                            if (!string.startsWith("Adobe") || this.app14AdobePresent) break;
                            this.app14AdobePresent = true;
                            this.markers.add(new Integer(60928));
                            this.version = imageInputStream.readUnsignedShort();
                            this.flags0 = imageInputStream.readUnsignedShort();
                            this.flags1 = imageInputStream.readUnsignedShort();
                            this.transform = imageInputStream.read();
                            imageInputStream.skipBytes(n - 12);
                            bl2 = true;
                            break;
                        }
                        default: {
                            bl2 = false;
                        }
                    }
                    if (bl2) continue;
                    imageInputStream.seek(l);
                    this.addUnknownMarkerSegment(imageInputStream, n2, n);
                    continue;
                }
                if (n2 == 219) {
                    if (!this.dqtPresent) {
                        this.dqtPresent = true;
                        this.qtables = new ArrayList(1);
                    }
                    this.markers.add(new Integer(219));
                    ArrayList<QTable> arrayList = new ArrayList<QTable>(1);
                    do {
                        object = new QTable(imageInputStream);
                        arrayList.add((QTable)object);
                    } while ((n -= ((QTable)object).length) > 0);
                    this.qtables.add(arrayList);
                    continue;
                }
                if (n2 == 196) {
                    if (!this.dhtPresent) {
                        this.dhtPresent = true;
                        this.htables = new ArrayList(1);
                    }
                    this.markers.add(new Integer(196));
                    ArrayList<Object> arrayList = new ArrayList<Object>(1);
                    do {
                        object = new HuffmanTable(imageInputStream);
                        arrayList.add(object);
                    } while ((n -= ((HuffmanTable)object).length) > 0);
                    this.htables.add(arrayList);
                    continue;
                }
                if (n2 == 221) {
                    if (!this.driPresent) {
                        this.driPresent = true;
                    }
                    this.markers.add(new Integer(221));
                    this.driInterval = imageInputStream.readUnsignedShort();
                    continue;
                }
                if (n2 == 254) {
                    if (!this.comPresent) {
                        this.comPresent = true;
                        this.comments = new ArrayList(1);
                    }
                    this.markers.add(new Integer(254));
                    byte[] byArray = new byte[n];
                    imageInputStream.readFully(byArray);
                    this.comments.add(byArray);
                    continue;
                }
                if (n2 >= 192 && n2 <= 207 || n2 == 247) {
                    if (this.sofPresent) continue;
                    this.sofPresent = true;
                    this.sofProcess = n2 - 192;
                    this.samplePrecision = imageInputStream.read();
                    this.numLines = imageInputStream.readUnsignedShort();
                    this.samplesPerLine = imageInputStream.readUnsignedShort();
                    this.numFrameComponents = imageInputStream.read();
                    this.componentId = new int[this.numFrameComponents];
                    this.hSamplingFactor = new int[this.numFrameComponents];
                    this.vSamplingFactor = new int[this.numFrameComponents];
                    this.qtableSelector = new int[this.numFrameComponents];
                    for (int i = 0; i < this.numFrameComponents; ++i) {
                        this.componentId[i] = imageInputStream.read();
                        this.hSamplingFactor[i] = (int)imageInputStream.readBits(4);
                        this.vSamplingFactor[i] = (int)imageInputStream.readBits(4);
                        this.qtableSelector[i] = imageInputStream.read();
                    }
                    this.markers.add(new Integer(49152));
                    continue;
                }
                if (n2 == 218) {
                    if (!this.sosPresent) {
                        this.sosPresent = true;
                        this.numScanComponents = imageInputStream.read();
                        this.componentSelector = new int[this.numScanComponents];
                        this.dcHuffTable = new int[this.numScanComponents];
                        this.acHuffTable = new int[this.numScanComponents];
                        for (int i = 0; i < this.numScanComponents; ++i) {
                            this.componentSelector[i] = imageInputStream.read();
                            this.dcHuffTable[i] = (int)imageInputStream.readBits(4);
                            this.acHuffTable[i] = (int)imageInputStream.readBits(4);
                        }
                        this.startSpectralSelection = imageInputStream.read();
                        this.endSpectralSelection = imageInputStream.read();
                        this.approxHigh = (int)imageInputStream.readBits(4);
                        this.approxLow = (int)imageInputStream.readBits(4);
                        this.markers.add(new Integer(218));
                    }
                    break;
                }
                this.addUnknownMarkerSegment(imageInputStream, n2, n);
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        if (this.app2ICCPresent && bl && this.profile == null) {
            n2 = 0;
            for (n = 1; n <= n3; ++n) {
                if (lArray[n] == 0L) {
                    bl = false;
                    break;
                }
                n2 += nArray[n];
            }
            if (bl) {
                byte[] byArray = new byte[n2];
                int n9 = 0;
                for (int i = 1; i <= n3; ++i) {
                    imageInputStream.seek((long)lArray[i]);
                    imageInputStream.read(byArray, n9, (int)nArray[i]);
                    n9 += nArray[i];
                }
                this.profile = ICC_Profile.getInstance(byArray);
            }
        }
        imageInputStream.reset();
    }

    private void addUnknownMarkerSegment(ImageInputStream imageInputStream, int n, int n2) throws IOException {
        if (!this.unknownPresent) {
            this.unknownPresent = true;
            this.markerTags = new ArrayList(1);
            this.unknownData = new ArrayList(1);
        }
        this.markerTags.add(new Integer(n));
        byte[] byArray = new byte[n2];
        imageInputStream.readFully(byArray);
        this.unknownData.add(byArray);
        this.markers.add(new Integer(65535));
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public Node getAsTree(String string) {
        if (string.equals(this.nativeMetadataFormatName)) {
            return this.getNativeTree();
        }
        if (string.equals("javax_imageio_1.0")) {
            return this.getStandardTree();
        }
        if (string.equals(TIFF_FORMAT)) {
            return this.getTIFFTree();
        }
        throw new IllegalArgumentException("Not a recognized format!");
    }

    public void mergeTree(String string, Node node) throws IIOInvalidTreeException {
        if (this.isReadOnly) {
            throw new IllegalStateException("isReadOnly() == true!");
        }
    }

    public void reset() {
        if (this.isReadOnly) {
            throw new IllegalStateException("isReadOnly() == true!");
        }
    }

    private Node getNativeTree() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode(this.nativeMetadataFormatName);
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("JPEGvariety");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("markerSequence");
        iIOMetadataNode.appendChild(iIOMetadataNode3);
        IIOMetadataNode iIOMetadataNode4 = null;
        if (this.app0JFIFPresent || this.app0JFXXPresent || this.app2ICCPresent) {
            iIOMetadataNode4 = new IIOMetadataNode("app0JFIF");
            iIOMetadataNode4.setAttribute("majorVersion", Integer.toString(this.majorVersion));
            iIOMetadataNode4.setAttribute("minorVersion", Integer.toString(this.minorVersion));
            iIOMetadataNode4.setAttribute("resUnits", Integer.toString(this.resUnits));
            iIOMetadataNode4.setAttribute("Xdensity", Integer.toString(this.Xdensity));
            iIOMetadataNode4.setAttribute("Ydensity", Integer.toString(this.Ydensity));
            iIOMetadataNode4.setAttribute("thumbWidth", Integer.toString(this.thumbWidth));
            iIOMetadataNode4.setAttribute("thumbHeight", Integer.toString(this.thumbHeight));
            iIOMetadataNode2.appendChild(iIOMetadataNode4);
        }
        IIOMetadataNode iIOMetadataNode5 = null;
        if (this.app0JFXXPresent) {
            iIOMetadataNode5 = new IIOMetadataNode("JFXX");
            iIOMetadataNode4.appendChild(iIOMetadataNode5);
        }
        Iterator iterator = this.markers.iterator();
        while (iterator.hasNext()) {
            int n6 = (Integer)iterator.next();
            switch (n6) {
                case 57344: {
                    break;
                }
                case 57345: {
                    NodeList nodeList;
                    Object object4;
                    Object object2;
                    Object object3;
                    IIOMetadataNode iIOMetadataNode6 = new IIOMetadataNode("app0JFXX");
                    Integer n7 = (Integer)this.extensionCodes.get(n);
                    iIOMetadataNode6.setAttribute("extensionCode", n7.toString());
                    IIOMetadataNode iIOMetadataNode7 = null;
                    switch (n7) {
                        case 16: {
                            iIOMetadataNode7 = new IIOMetadataNode("JFIFthumbJPEG");
                            break;
                        }
                        case 17: {
                            iIOMetadataNode7 = new IIOMetadataNode("JFIFthumbPalette");
                            break;
                        }
                        case 18: {
                            iIOMetadataNode7 = new IIOMetadataNode("JFIFthumbRGB");
                            break;
                        }
                    }
                    if (iIOMetadataNode7 != null) {
                        object3 = (IIOImage)this.jfxxThumbnails.get(n++);
                        if (n7 == 16) {
                            IIOMetadataNode iIOMetadataNode8;
                            object2 = ((IIOImage)object3).getMetadata();
                            if (object2 != null && (object4 = ((IIOMetadata)object2).getAsTree(this.nativeMetadataFormatName)) instanceof IIOMetadataNode && (nodeList = (iIOMetadataNode8 = (IIOMetadataNode)object4).getElementsByTagName("markerSequence")).getLength() > 0) {
                                iIOMetadataNode7.appendChild(nodeList.item(0));
                            }
                        } else {
                            object2 = (BufferedImage)((IIOImage)object3).getRenderedImage();
                            iIOMetadataNode7.setAttribute("thumbWidth", Integer.toString(((BufferedImage)object2).getWidth()));
                            iIOMetadataNode7.setAttribute("thumbHeight", Integer.toString(((BufferedImage)object2).getHeight()));
                        }
                        iIOMetadataNode7.setUserObject(object3);
                        iIOMetadataNode6.appendChild(iIOMetadataNode7);
                    }
                    iIOMetadataNode5.appendChild(iIOMetadataNode6);
                    break;
                }
                case 57856: {
                    Object object3 = new IIOMetadataNode("app2ICC");
                    ((IIOMetadataNode)object3).setUserObject(this.profile);
                    iIOMetadataNode4.appendChild((Node)object3);
                    break;
                }
                case 219: {
                    Object object5;
                    Object object2 = new IIOMetadataNode("dqt");
                    Object object4 = (List)this.qtables.get(n2++);
                    int n8 = object4.size();
                    for (int i = 0; i < n8; ++i) {
                        IIOMetadataNode iIOMetadataNode9 = new IIOMetadataNode("dqtable");
                        object5 = (QTable)object4.get(i);
                        iIOMetadataNode9.setAttribute("elementPrecision", Integer.toString(((QTable)object5).elementPrecision));
                        iIOMetadataNode9.setAttribute("qtableId", Integer.toString(((QTable)object5).tableID));
                        iIOMetadataNode9.setUserObject(((QTable)object5).table);
                        ((IIOMetadataNode)object2).appendChild(iIOMetadataNode9);
                    }
                    iIOMetadataNode3.appendChild((Node)object2);
                    break;
                }
                case 196: {
                    Object object;
                    Object object5;
                    NodeList nodeList = new IIOMetadataNode("dht");
                    Object object4 = (List)this.htables.get(n3++);
                    int n9 = object4.size();
                    for (int i = 0; i < n9; ++i) {
                        object5 = new IIOMetadataNode("dhtable");
                        object = (HuffmanTable)object4.get(i);
                        ((IIOMetadataNode)object5).setAttribute("class", Integer.toString(((HuffmanTable)object).tableClass));
                        ((IIOMetadataNode)object5).setAttribute("htableId", Integer.toString(((HuffmanTable)object).tableID));
                        ((IIOMetadataNode)object5).setUserObject(((HuffmanTable)object).table);
                        ((IIOMetadataNode)nodeList).appendChild((Node)object5);
                    }
                    iIOMetadataNode3.appendChild((Node)((Object)nodeList));
                    break;
                }
                case 221: {
                    IIOMetadataNode iIOMetadataNode10 = new IIOMetadataNode("dri");
                    iIOMetadataNode10.setAttribute("interval", Integer.toString(this.driInterval));
                    iIOMetadataNode3.appendChild(iIOMetadataNode10);
                    break;
                }
                case 254: {
                    Object object5 = new IIOMetadataNode("com");
                    ((IIOMetadataNode)object5).setUserObject(this.comments.get(n4++));
                    iIOMetadataNode3.appendChild((Node)object5);
                    break;
                }
                case 65535: {
                    Object object = new IIOMetadataNode("unknown");
                    Integer n10 = (Integer)this.markerTags.get(n5);
                    ((IIOMetadataNode)object).setAttribute("MarkerTag", n10.toString());
                    ((IIOMetadataNode)object).setUserObject(this.unknownData.get(n5++));
                    iIOMetadataNode3.appendChild((Node)object);
                    break;
                }
                case 60928: {
                    IIOMetadataNode iIOMetadataNode11 = new IIOMetadataNode("app14Adobe");
                    iIOMetadataNode11.setAttribute("version", Integer.toString(this.version));
                    iIOMetadataNode11.setAttribute("flags0", Integer.toString(this.flags0));
                    iIOMetadataNode11.setAttribute("flags1", Integer.toString(this.flags1));
                    iIOMetadataNode11.setAttribute("transform", Integer.toString(this.transform));
                    iIOMetadataNode3.appendChild(iIOMetadataNode11);
                    break;
                }
                case 49152: {
                    IIOMetadataNode iIOMetadataNode12 = new IIOMetadataNode("sof");
                    iIOMetadataNode12.setAttribute("process", Integer.toString(this.sofProcess));
                    iIOMetadataNode12.setAttribute("samplePrecision", Integer.toString(this.samplePrecision));
                    iIOMetadataNode12.setAttribute("numLines", Integer.toString(this.numLines));
                    iIOMetadataNode12.setAttribute("samplesPerLine", Integer.toString(this.samplesPerLine));
                    iIOMetadataNode12.setAttribute("numFrameComponents", Integer.toString(this.numFrameComponents));
                    for (int i = 0; i < this.numFrameComponents; ++i) {
                        IIOMetadataNode iIOMetadataNode13 = new IIOMetadataNode("componentSpec");
                        iIOMetadataNode13.setAttribute("componentId", Integer.toString(this.componentId[i]));
                        iIOMetadataNode13.setAttribute("HsamplingFactor", Integer.toString(this.hSamplingFactor[i]));
                        iIOMetadataNode13.setAttribute("VsamplingFactor", Integer.toString(this.vSamplingFactor[i]));
                        iIOMetadataNode13.setAttribute("QtableSelector", Integer.toString(this.qtableSelector[i]));
                        iIOMetadataNode12.appendChild(iIOMetadataNode13);
                    }
                    iIOMetadataNode3.appendChild(iIOMetadataNode12);
                    break;
                }
                case 218: {
                    IIOMetadataNode iIOMetadataNode14 = new IIOMetadataNode("sos");
                    iIOMetadataNode14.setAttribute("numScanComponents", Integer.toString(this.numScanComponents));
                    iIOMetadataNode14.setAttribute("startSpectralSelection", Integer.toString(this.startSpectralSelection));
                    iIOMetadataNode14.setAttribute("endSpectralSelection", Integer.toString(this.endSpectralSelection));
                    iIOMetadataNode14.setAttribute("approxHigh", Integer.toString(this.approxHigh));
                    iIOMetadataNode14.setAttribute("approxLow", Integer.toString(this.approxLow));
                    for (int i = 0; i < this.numScanComponents; ++i) {
                        IIOMetadataNode iIOMetadataNode15 = new IIOMetadataNode("scanComponentSpec");
                        iIOMetadataNode15.setAttribute("componentSelector", Integer.toString(this.componentSelector[i]));
                        iIOMetadataNode15.setAttribute("dcHuffTable", Integer.toString(this.dcHuffTable[i]));
                        iIOMetadataNode15.setAttribute("acHuffTable", Integer.toString(this.acHuffTable[i]));
                        iIOMetadataNode14.appendChild(iIOMetadataNode15);
                    }
                    iIOMetadataNode3.appendChild(iIOMetadataNode14);
                }
            }
        }
        return iIOMetadataNode;
    }

    protected IIOMetadataNode getStandardChromaNode() {
        int n;
        int n2;
        if (!this.sofPresent) {
            return null;
        }
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Chroma");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("ColorSpaceType");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("NumChannels");
        iIOMetadataNode.appendChild(iIOMetadataNode3);
        iIOMetadataNode3.setAttribute("value", Integer.toString(this.numFrameComponents));
        if (this.app0JFIFPresent) {
            if (this.numFrameComponents == 1) {
                iIOMetadataNode2.setAttribute("name", "GRAY");
            } else {
                iIOMetadataNode2.setAttribute("name", "YCbCr");
            }
            return iIOMetadataNode;
        }
        if (this.app14AdobePresent) {
            switch (this.transform) {
                case 2: {
                    iIOMetadataNode2.setAttribute("name", "YCCK");
                    break;
                }
                case 1: {
                    iIOMetadataNode2.setAttribute("name", "YCbCr");
                    break;
                }
                case 0: {
                    if (this.numFrameComponents == 3) {
                        iIOMetadataNode2.setAttribute("name", "RGB");
                        break;
                    }
                    if (this.numFrameComponents != 4) break;
                    iIOMetadataNode2.setAttribute("name", "CMYK");
                }
            }
            return iIOMetadataNode;
        }
        this.hasAlpha = false;
        if (this.numFrameComponents < 3) {
            iIOMetadataNode2.setAttribute("name", "GRAY");
            if (this.numFrameComponents == 2) {
                this.hasAlpha = true;
            }
            return iIOMetadataNode;
        }
        boolean bl = true;
        for (n2 = 0; n2 < this.componentId.length; ++n2) {
            n = this.componentId[n2];
            if (n >= 1 && n < this.componentId.length) continue;
            bl = false;
        }
        if (bl) {
            iIOMetadataNode2.setAttribute("name", "YCbCr");
            if (this.numFrameComponents == 4) {
                this.hasAlpha = true;
            }
            return iIOMetadataNode;
        }
        if (this.componentId[0] == 82 && this.componentId[1] == 71 && this.componentId[2] == 66) {
            iIOMetadataNode2.setAttribute("name", "RGB");
            if (this.numFrameComponents == 4 && this.componentId[3] == 65) {
                this.hasAlpha = true;
            }
            return iIOMetadataNode;
        }
        if (this.componentId[0] == 89 && this.componentId[1] == 67 && this.componentId[2] == 99) {
            iIOMetadataNode2.setAttribute("name", "PhotoYCC");
            if (this.numFrameComponents == 4 && this.componentId[3] == 65) {
                this.hasAlpha = true;
            }
            return iIOMetadataNode;
        }
        n2 = 0;
        n = this.hSamplingFactor[0];
        int n3 = this.vSamplingFactor[0];
        for (int i = 1; i < this.componentId.length; ++i) {
            if (this.hSamplingFactor[i] == n && this.vSamplingFactor[i] == n3) continue;
            n2 = 1;
            break;
        }
        if (n2 != 0) {
            iIOMetadataNode2.setAttribute("name", "YCbCr");
            if (this.numFrameComponents == 4) {
                this.hasAlpha = true;
            }
            return iIOMetadataNode;
        }
        if (this.numFrameComponents == 3) {
            iIOMetadataNode2.setAttribute("name", "RGB");
        } else {
            iIOMetadataNode2.setAttribute("name", "CMYK");
        }
        return iIOMetadataNode;
    }

    protected IIOMetadataNode getStandardCompressionNode() {
        IIOMetadataNode iIOMetadataNode = null;
        if (this.sofPresent || this.sosPresent) {
            iIOMetadataNode = new IIOMetadataNode("Compression");
            if (this.sofPresent) {
                boolean bl = this.sofProcess == 3 || this.sofProcess == 7 || this.sofProcess == 11 || this.sofProcess == 15 || this.sofProcess == 55;
                IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("CompressionTypeName");
                String string = bl ? (this.sofProcess == 55 ? "JPEG-LS" : "JPEG-LOSSLESS") : "JPEG";
                iIOMetadataNode2.setAttribute("value", string);
                iIOMetadataNode.appendChild(iIOMetadataNode2);
                IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("Lossless");
                iIOMetadataNode3.setAttribute("value", bl ? "true" : "false");
                iIOMetadataNode.appendChild(iIOMetadataNode3);
            }
            if (this.sosPresent) {
                IIOMetadataNode iIOMetadataNode4 = new IIOMetadataNode("NumProgressiveScans");
                iIOMetadataNode4.setAttribute("value", "1");
                iIOMetadataNode.appendChild(iIOMetadataNode4);
            }
        }
        return iIOMetadataNode;
    }

    protected IIOMetadataNode getStandardDimensionNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Dimension");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("ImageOrientation");
        iIOMetadataNode2.setAttribute("value", "normal");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        if (this.app0JFIFPresent) {
            float f2 = this.resUnits == 0 ? (float)this.Xdensity / (float)this.Ydensity : (float)this.Ydensity / (float)this.Xdensity;
            IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("PixelAspectRatio");
            iIOMetadataNode3.setAttribute("value", Float.toString(f2));
            iIOMetadataNode.insertBefore(iIOMetadataNode3, iIOMetadataNode2);
            if (this.resUnits != 0) {
                float f3 = this.resUnits == 1 ? 25.4f : 10.0f;
                IIOMetadataNode iIOMetadataNode4 = new IIOMetadataNode("HorizontalPixelSize");
                iIOMetadataNode4.setAttribute("value", Float.toString(f3 / (float)this.Xdensity));
                iIOMetadataNode.appendChild(iIOMetadataNode4);
                IIOMetadataNode iIOMetadataNode5 = new IIOMetadataNode("VerticalPixelSize");
                iIOMetadataNode5.setAttribute("value", Float.toString(f3 / (float)this.Ydensity));
                iIOMetadataNode.appendChild(iIOMetadataNode5);
            }
        }
        return iIOMetadataNode;
    }

    protected IIOMetadataNode getStandardTextNode() {
        IIOMetadataNode iIOMetadataNode = null;
        if (this.comPresent) {
            iIOMetadataNode = new IIOMetadataNode("Text");
            Iterator iterator = this.comments.iterator();
            while (iterator.hasNext()) {
                IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("TextEntry");
                iIOMetadataNode2.setAttribute("keyword", "comment");
                byte[] byArray = (byte[])iterator.next();
                try {
                    iIOMetadataNode2.setAttribute("value", new String(byArray, "ISO-8859-1"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    iIOMetadataNode2.setAttribute("value", new String(byArray));
                }
                iIOMetadataNode.appendChild(iIOMetadataNode2);
            }
        }
        return iIOMetadataNode;
    }

    protected IIOMetadataNode getStandardTransparencyNode() {
        IIOMetadataNode iIOMetadataNode = null;
        if (this.hasAlpha) {
            iIOMetadataNode = new IIOMetadataNode("Transparency");
            IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("Alpha");
            iIOMetadataNode2.setAttribute("value", "nonpremultiplied");
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        return iIOMetadataNode;
    }

    private Node getTIFFTree() {
        int n;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Iterator iterator;
        Object object5;
        Object object6;
        TIFFField tIFFField;
        String string = TIFF_FORMAT;
        BaselineTIFFTagSet baselineTIFFTagSet = BaselineTIFFTagSet.getInstance();
        TIFFDirectory tIFFDirectory = new TIFFDirectory(new TIFFTagSet[]{baselineTIFFTagSet, EXIFParentTIFFTagSet.getInstance()}, null);
        if (this.sofPresent) {
            int n2 = 7;
            tIFFField = new TIFFField(baselineTIFFTagSet.getTag(259), n2);
            tIFFDirectory.addTIFFField(tIFFField);
            object6 = new char[this.numFrameComponents];
            Arrays.fill(object6, (char)(this.samplePrecision & 0xFF));
            object5 = new TIFFField(baselineTIFFTagSet.getTag(258), 3, ((Object)object6).length, object6);
            tIFFDirectory.addTIFFField((TIFFField)object5);
            iterator = new TIFFField(baselineTIFFTagSet.getTag(257), this.numLines);
            tIFFDirectory.addTIFFField((TIFFField)((Object)iterator));
            object4 = new TIFFField(baselineTIFFTagSet.getTag(256), this.samplesPerLine);
            tIFFDirectory.addTIFFField((TIFFField)object4);
            object3 = new TIFFField(baselineTIFFTagSet.getTag(277), this.numFrameComponents);
            tIFFDirectory.addTIFFField((TIFFField)object3);
            object2 = this.getStandardChromaNode();
            if (object2 != null) {
                Object object7;
                IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)((IIOMetadataNode)object2).getElementsByTagName("ColorSpaceType").item(0);
                object = iIOMetadataNode.getAttribute("name");
                n = -1;
                if (((String)object).equals("GRAY")) {
                    n = 1;
                } else if (((String)object).equals("YCbCr") || ((String)object).equals("PhotoYCC")) {
                    n = 6;
                } else if (((String)object).equals("RGB")) {
                    n = 2;
                } else if (((String)object).equals("CMYK") || ((String)object).equals("YCCK")) {
                    n = 5;
                }
                if (n != -1) {
                    object7 = new TIFFField(baselineTIFFTagSet.getTag(262), n);
                    tIFFDirectory.addTIFFField((TIFFField)object7);
                }
                if (this.hasAlpha) {
                    object7 = new char[]{'\u0001'};
                    TIFFField tIFFField2 = new TIFFField(baselineTIFFTagSet.getTag(338), 3, ((Object)object7).length, object7);
                    tIFFDirectory.addTIFFField(tIFFField2);
                }
            }
        }
        if (this.app0JFIFPresent) {
            long[][] lArrayArray = new long[][]{{this.Xdensity, 1L}};
            tIFFField = new TIFFField(baselineTIFFTagSet.getTag(282), 5, 1, lArrayArray);
            tIFFDirectory.addTIFFField(tIFFField);
            object6 = new long[][]{{this.Ydensity, 1L}};
            object5 = new TIFFField(baselineTIFFTagSet.getTag(283), 5, 1, object6);
            tIFFDirectory.addTIFFField((TIFFField)object5);
            int n3 = 1;
            switch (this.resUnits) {
                case 0: {
                    n3 = 1;
                }
                case 1: {
                    n3 = 2;
                    break;
                }
                case 2: {
                    n3 = 3;
                }
            }
            object4 = new TIFFField(baselineTIFFTagSet.getTag(296), n3);
            tIFFDirectory.addTIFFField((TIFFField)object4);
        }
        byte[] byArray = null;
        if (this.dqtPresent || this.dqtPresent) {
            int n4 = 2;
            if (this.dqtPresent) {
                object6 = this.qtables.iterator();
                while (object6.hasNext()) {
                    object5 = ((List)object6.next()).iterator();
                    while (object5.hasNext()) {
                        iterator = (QTable)object5.next();
                        n4 += 4 + ((QTable)((Object)iterator)).length;
                    }
                }
            }
            if (this.dhtPresent) {
                object6 = this.htables.iterator();
                while (object6.hasNext()) {
                    object5 = ((List)object6.next()).iterator();
                    while (object5.hasNext()) {
                        iterator = (HuffmanTable)object5.next();
                        n4 += 4 + ((HuffmanTable)((Object)iterator)).length;
                    }
                }
            }
            byArray = new byte[n4 += 2];
            byArray[0] = -1;
            byArray[1] = -40;
            int n5 = 2;
            if (this.dqtPresent) {
                object5 = this.qtables.iterator();
                while (object5.hasNext()) {
                    iterator = ((List)object5.next()).iterator();
                    while (iterator.hasNext()) {
                        byArray[n5++] = -1;
                        byArray[n5++] = -37;
                        object4 = (QTable)iterator.next();
                        int n6 = ((QTable)object4).length + 2;
                        byArray[n5++] = (byte)((n6 & 0xFF00) >> 8);
                        byArray[n5++] = (byte)(n6 & 0xFF);
                        byArray[n5++] = (byte)((((QTable)object4).elementPrecision & 0xF0) << 4 | ((QTable)object4).tableID & 0xF);
                        object2 = ((QTable)object4).table.getTable();
                        int n7 = ((Object)object2).length;
                        for (int i = 0; i < n7; ++i) {
                            byArray[n5 + CLibJPEGMetadata.zigzag[i]] = (byte)object2[i];
                        }
                        n5 += n7;
                    }
                }
            }
            if (this.dhtPresent) {
                object5 = this.htables.iterator();
                while (object5.hasNext()) {
                    iterator = ((List)object5.next()).iterator();
                    while (iterator.hasNext()) {
                        byArray[n5++] = -1;
                        byArray[n5++] = -60;
                        object4 = (HuffmanTable)iterator.next();
                        int n8 = ((HuffmanTable)object4).length + 2;
                        byArray[n5++] = (byte)((n8 & 0xFF00) >> 8);
                        byArray[n5++] = (byte)(n8 & 0xFF);
                        byArray[n5++] = (byte)((((HuffmanTable)object4).tableClass & 0xF) << 4 | ((HuffmanTable)object4).tableID & 0xF);
                        object2 = ((HuffmanTable)object4).table.getLengths();
                        int n9 = ((Object)object2).length;
                        for (int i = 0; i < n9; ++i) {
                            byArray[n5++] = (byte)object2[i];
                        }
                        object = ((HuffmanTable)object4).table.getValues();
                        n = ((Object)object).length;
                        for (int i = 0; i < n; ++i) {
                            byArray[n5++] = (byte)object[i];
                        }
                    }
                }
            }
            byArray[n5++] = -1;
            byArray[n5] = -39;
        }
        if (byArray != null) {
            TIFFField tIFFField3 = new TIFFField(baselineTIFFTagSet.getTag(347), 7, byArray.length, byArray);
            tIFFDirectory.addTIFFField(tIFFField3);
        }
        IIOMetadata iIOMetadata = tIFFDirectory.getAsMetadata();
        if (this.exifData != null) {
            try {
                Iterator<ImageReader> iterator2 = ImageIO.getImageReadersByFormatName("TIFF");
                if (iterator2 != null && iterator2.hasNext()) {
                    object5 = iterator2.next();
                    iterator = new ByteArrayInputStream(this.exifData);
                    object4 = new MemoryCacheImageInputStream((InputStream)((Object)iterator));
                    ((ImageReader)object5).setInput(object4);
                    object3 = ((ImageReader)object5).getImageMetadata(0);
                    iIOMetadata.mergeTree(string, ((IIOMetadata)object3).getAsTree(string));
                    ((ImageReader)object5).reset();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return iIOMetadata.getAsTree(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeThumbnails() {
        List list = this.thumbnails;
        synchronized (list) {
            if (!this.thumbnailsInitialized) {
                Object object;
                Object object2;
                if (this.app0JFIFPresent && this.jfifThumbnail != null) {
                    this.thumbnails.add(this.jfifThumbnail);
                }
                if (this.app0JFXXPresent && this.jfxxThumbnails != null) {
                    int n = this.jfxxThumbnails.size();
                    for (int i = 0; i < n; ++i) {
                        object2 = (IIOImage)this.jfxxThumbnails.get(i);
                        object = (BufferedImage)((IIOImage)object2).getRenderedImage();
                        this.thumbnails.add(object);
                    }
                }
                if (this.exifData != null) {
                    try {
                        Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName("TIFF");
                        if (iterator != null && iterator.hasNext()) {
                            ImageReader imageReader = iterator.next();
                            object2 = new ByteArrayInputStream(this.exifData);
                            object = new MemoryCacheImageInputStream((InputStream)object2);
                            imageReader.setInput(object);
                            if (imageReader.getNumImages(true) > 1) {
                                BufferedImage bufferedImage = imageReader.read(1, null);
                                this.thumbnails.add(bufferedImage);
                            }
                            imageReader.reset();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                this.thumbnailsInitialized = true;
            }
        }
    }

    int getNumThumbnails() throws IOException {
        this.initializeThumbnails();
        return this.thumbnails.size();
    }

    BufferedImage getThumbnail(int n) throws IOException {
        if (n < 0) {
            throw new IndexOutOfBoundsException("thumbnailIndex < 0!");
        }
        this.initializeThumbnails();
        if (n >= this.thumbnails.size()) {
            throw new IndexOutOfBoundsException("thumbnailIndex > getNumThumbnails()");
        }
        return (BufferedImage)this.thumbnails.get(n);
    }

    private class HuffmanTable {
        private static final int NUM_LENGTHS = 16;
        int tableClass;
        int tableID;
        JPEGHuffmanTable table;
        int length;

        HuffmanTable(ImageInputStream imageInputStream) throws IOException {
            int n;
            this.tableClass = (int)imageInputStream.readBits(4);
            this.tableID = (int)imageInputStream.readBits(4);
            short[] sArray = new short[16];
            for (n = 0; n < 16; ++n) {
                sArray[n] = (short)imageInputStream.read();
            }
            n = 0;
            for (int i = 0; i < 16; ++i) {
                n += sArray[i];
            }
            short[] sArray2 = new short[n];
            for (int i = 0; i < n; ++i) {
                sArray2[i] = (short)imageInputStream.read();
            }
            this.table = new JPEGHuffmanTable(sArray, sArray2);
            this.length = 17 + sArray2.length;
        }
    }

    private class QTable {
        private static final int QTABLE_SIZE = 64;
        int elementPrecision;
        int tableID;
        JPEGQTable table;
        int length;

        QTable(ImageInputStream imageInputStream) throws IOException {
            this.elementPrecision = (int)imageInputStream.readBits(4);
            this.tableID = (int)imageInputStream.readBits(4);
            byte[] byArray = new byte[64];
            imageInputStream.readFully(byArray);
            int[] nArray = new int[64];
            for (int i = 0; i < 64; ++i) {
                nArray[i] = byArray[zigzag[i]] & 0xFF;
            }
            this.table = new JPEGQTable(nArray);
            this.length = nArray.length + 1;
        }
    }
}

