/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import com.sun.media.imageio.plugins.jpeg2000.J2KImageReadParam;
import com.sun.media.imageioimpl.plugins.jpeg2000.I18N;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReadParamJava;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KMetadata;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KReadState;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KRenderedImage;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import jj2000.j2k.codestream.reader.HeaderDecoder;
import jj2000.j2k.util.FacilityManager;
import jj2000.j2k.util.MsgLogger;

public class J2KImageReader
extends ImageReader
implements MsgLogger {
    private ImageInputStream iis = null;
    private long streamPosition0;
    private boolean gotHeader = false;
    private int width;
    private int height;
    private J2KMetadata imageMetadata = null;
    private int imageMetadataIndex = -1;
    private HeaderDecoder hd;
    private J2KReadState readState = null;
    private boolean logJJ2000Msg = Boolean.getBoolean("jj2000.j2k.decoder.log");

    public static void computeRegionsWrapper(ImageReadParam imageReadParam, boolean bl, int n, int n2, BufferedImage bufferedImage, Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle == null) {
            throw new IllegalArgumentException(I18N.getString("J2KImageReader0"));
        }
        if (rectangle2 == null) {
            throw new IllegalArgumentException(I18N.getString("J2KImageReader1"));
        }
        int n3 = 1;
        int n4 = 1;
        int n5 = 0;
        int n6 = 0;
        if (imageReadParam != null) {
            Rectangle rectangle3 = imageReadParam.getSourceRegion();
            if (rectangle3 != null) {
                rectangle.setBounds(rectangle.intersection(rectangle3));
            }
            n3 = imageReadParam.getSourceXSubsampling();
            n4 = imageReadParam.getSourceYSubsampling();
            n5 = imageReadParam.getSubsamplingXOffset();
            n6 = imageReadParam.getSubsamplingYOffset();
            rectangle.translate(n5, n6);
            rectangle.width -= n5;
            rectangle.height -= n6;
            if (bl) {
                rectangle2.setLocation(imageReadParam.getDestinationOffset());
            } else {
                Point point = imageReadParam.getDestinationOffset();
                if (point.x != 0 || point.y != 0) {
                    rectangle2.setLocation(imageReadParam.getDestinationOffset());
                }
            }
        }
        if (rectangle2.x < 0) {
            int n7 = -rectangle2.x * n3;
            rectangle.x += n7;
            rectangle.width -= n7;
            rectangle2.x = 0;
        }
        if (rectangle2.y < 0) {
            int n8 = -rectangle2.y * n4;
            rectangle.y += n8;
            rectangle.height -= n8;
            rectangle2.y = 0;
        }
        int n9 = (rectangle.width + n3 - 1) / n3;
        int n10 = (rectangle.height + n4 - 1) / n4;
        rectangle2.width = n9;
        rectangle2.height = n10;
        if (bufferedImage != null) {
            int n11;
            Rectangle rectangle4 = new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
            rectangle2.setBounds(rectangle2.intersection(rectangle4));
            if (rectangle2.isEmpty()) {
                throw new IllegalArgumentException(I18N.getString("J2KImageReader2"));
            }
            int n12 = rectangle2.x + n9 - bufferedImage.getWidth();
            if (n12 > 0) {
                rectangle.width -= n12 * n3;
            }
            if ((n11 = rectangle2.y + n10 - bufferedImage.getHeight()) > 0) {
                rectangle.height -= n11 * n4;
            }
        }
        if (rectangle.isEmpty() || rectangle2.isEmpty()) {
            throw new IllegalArgumentException(I18N.getString("J2KImageReader3"));
        }
    }

    public static void checkReadParamBandSettingsWrapper(ImageReadParam imageReadParam, int n, int n2) {
        J2KImageReader.checkReadParamBandSettings(imageReadParam, n, n2);
    }

    static Rectangle getReducedRect(Rectangle rectangle, int n, int n2, int n3, int n4) {
        if (rectangle == null) {
            throw new IllegalArgumentException("r == null!");
        }
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("maxLevel < 0 || level < 0!");
        }
        if (n2 > n) {
            throw new IllegalArgumentException("level > maxLevel");
        }
        if (n2 == n && n3 == 1 && n4 == 1) {
            return rectangle;
        }
        int n5 = 1 << n - n2;
        int n6 = n5 * n3;
        int n7 = n5 * n4;
        int n8 = (rectangle.x + n6 - 1) / n6;
        int n9 = (rectangle.x + rectangle.width + n6 - 1) / n6;
        int n10 = (rectangle.y + n7 - 1) / n7;
        int n11 = (rectangle.y + rectangle.height + n7 - 1) / n7;
        return new Rectangle(n8, n10, n9 - n8, n11 - n10);
    }

    public void processImageUpdateWrapper(BufferedImage bufferedImage, int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        this.processImageUpdate(bufferedImage, n, n2, n3, n4, n5, n6, nArray);
    }

    public void processImageProgressWrapper(float f2) {
        this.processImageProgress(f2);
    }

    public J2KImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
        FacilityManager.registerMsgLogger(null, this);
    }

    public void setInput(Object object, boolean bl, boolean bl2) {
        super.setInput(object, bl, bl2);
        this.ignoreMetadata = bl2;
        this.iis = (ImageInputStream)object;
        this.imageMetadata = null;
        try {
            this.streamPosition0 = this.iis.getStreamPosition();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int getNumImages(boolean bl) throws IOException {
        return 1;
    }

    public int getWidth(int n) throws IOException {
        this.checkIndex(n);
        this.readHeader();
        return this.width;
    }

    public int getHeight(int n) throws IOException {
        this.checkIndex(n);
        this.readHeader();
        return this.height;
    }

    public int getTileGridXOffset(int n) throws IOException {
        this.checkIndex(n);
        this.readHeader();
        return this.hd.getTilingOrigin(null).x;
    }

    public int getTileGridYOffset(int n) throws IOException {
        this.checkIndex(n);
        this.readHeader();
        return this.hd.getTilingOrigin(null).y;
    }

    public int getTileWidth(int n) throws IOException {
        this.checkIndex(n);
        this.readHeader();
        return this.hd.getNomTileWidth();
    }

    public int getTileHeight(int n) throws IOException {
        this.checkIndex(n);
        this.readHeader();
        return this.hd.getNomTileHeight();
    }

    private void checkIndex(int n) {
        if (n != 0) {
            throw new IndexOutOfBoundsException(I18N.getString("J2KImageReader4"));
        }
    }

    public void readHeader() {
        if (this.gotHeader) {
            return;
        }
        if (this.readState == null) {
            try {
                this.iis.seek(this.streamPosition0);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.readState = new J2KReadState(this.iis, new J2KImageReadParamJava(this.getDefaultReadParam()), this);
        }
        this.hd = this.readState.getHeader();
        this.gotHeader = true;
        this.width = this.hd.getImgWidth();
        this.height = this.hd.getImgHeight();
    }

    public Iterator getImageTypes(int n) throws IOException {
        this.checkIndex(n);
        this.readHeader();
        if (this.readState != null) {
            ArrayList<ImageTypeSpecifier> arrayList = new ArrayList<ImageTypeSpecifier>();
            arrayList.add(new ImageTypeSpecifier(this.readState.getColorModel(), this.readState.getSampleModel()));
            return arrayList.iterator();
        }
        return null;
    }

    public ImageReadParam getDefaultReadParam() {
        return new J2KImageReadParam();
    }

    public IIOMetadata getImageMetadata(int n) throws IOException {
        this.checkIndex(n);
        if (this.ignoreMetadata) {
            return null;
        }
        if (this.imageMetadata == null) {
            this.iis.mark();
            this.imageMetadata = new J2KMetadata(this.iis, this);
            this.iis.reset();
        }
        return this.imageMetadata;
    }

    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        this.checkIndex(n);
        this.clearAbortRequest();
        this.processImageStarted(n);
        if (imageReadParam == null) {
            imageReadParam = this.getDefaultReadParam();
        }
        imageReadParam = new J2KImageReadParamJava(imageReadParam);
        if (!this.ignoreMetadata) {
            this.imageMetadata = new J2KMetadata();
            this.iis.seek(this.streamPosition0);
            this.readState = new J2KReadState(this.iis, (J2KImageReadParamJava)imageReadParam, this.imageMetadata, this);
        } else {
            this.iis.seek(this.streamPosition0);
            this.readState = new J2KReadState(this.iis, (J2KImageReadParamJava)imageReadParam, this);
        }
        BufferedImage bufferedImage = this.readState.readBufferedImage();
        if (this.abortRequested()) {
            this.processReadAborted();
        } else {
            this.processImageComplete();
        }
        return bufferedImage;
    }

    public void dispose() {
        this.readState = null;
        this.imageMetadata = null;
        this.hd = null;
        super.dispose();
    }

    public RenderedImage readAsRenderedImage(int n, ImageReadParam imageReadParam) throws IOException {
        this.checkIndex(n);
        J2KRenderedImage j2KRenderedImage = null;
        this.clearAbortRequest();
        this.processImageStarted(n);
        if (imageReadParam == null) {
            imageReadParam = this.getDefaultReadParam();
        }
        imageReadParam = new J2KImageReadParamJava(imageReadParam);
        if (!this.ignoreMetadata) {
            if (this.imageMetadata == null) {
                this.imageMetadata = new J2KMetadata();
            }
            j2KRenderedImage = new J2KRenderedImage(this.iis, (J2KImageReadParamJava)imageReadParam, this.imageMetadata, this);
        } else {
            j2KRenderedImage = new J2KRenderedImage(this.iis, (J2KImageReadParamJava)imageReadParam, this);
        }
        if (this.abortRequested()) {
            this.processReadAborted();
        } else {
            this.processImageComplete();
        }
        return j2KRenderedImage;
    }

    public boolean canReadRaster() {
        return true;
    }

    public boolean isRandomAccessEasy(int n) throws IOException {
        this.checkIndex(n);
        return false;
    }

    public Raster readRaster(int n, ImageReadParam imageReadParam) throws IOException {
        this.checkIndex(n);
        this.processImageStarted(n);
        imageReadParam = new J2KImageReadParamJava(imageReadParam);
        if (!this.ignoreMetadata) {
            this.imageMetadata = new J2KMetadata();
            this.iis.seek(this.streamPosition0);
            this.readState = new J2KReadState(this.iis, (J2KImageReadParamJava)imageReadParam, this.imageMetadata, this);
        } else {
            this.iis.seek(this.streamPosition0);
            this.readState = new J2KReadState(this.iis, (J2KImageReadParamJava)imageReadParam, this);
        }
        Raster raster = this.readState.readAsRaster();
        if (this.abortRequested()) {
            this.processReadAborted();
        } else {
            this.processImageComplete();
        }
        return raster;
    }

    public boolean isImageTiled(int n) {
        this.checkIndex(n);
        this.readHeader();
        if (this.readState != null) {
            J2KRenderedImage j2KRenderedImage = new J2KRenderedImage(this.readState);
            return j2KRenderedImage.getNumXTiles() * j2KRenderedImage.getNumYTiles() > 0;
        }
        return false;
    }

    public void reset() {
        super.reset();
        this.iis = null;
        this.gotHeader = false;
        this.imageMetadata = null;
        this.readState = null;
        System.gc();
    }

    public boolean getAbortRequest() {
        return this.abortRequested();
    }

    private ImageTypeSpecifier getImageType(int n) throws IOException {
        this.checkIndex(n);
        this.readHeader();
        if (this.readState != null) {
            return new ImageTypeSpecifier(this.readState.getColorModel(), this.readState.getSampleModel());
        }
        return null;
    }

    public void flush() {
    }

    public void println(String string, int n, int n2) {
        this.printmsg(1, string);
    }

    public void printmsg(int n, String string) {
        if (this.logJJ2000Msg) {
            String string2;
            switch (n) {
                case 3: {
                    string2 = "ERROR";
                    break;
                }
                case 1: {
                    string2 = "INFO";
                    break;
                }
                case 0: {
                    string2 = "LOG";
                    break;
                }
                default: {
                    string2 = "WARNING";
                }
            }
            this.processWarningOccurred("[JJ2000 " + string2 + "] " + string);
        }
    }
}

