/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.plugins.jpeg2000.ChannelDefinitionBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.I18N;
import com.sun.media.imageioimpl.plugins.jpeg2000.IISRandomAccessIO;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReadParamJava;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReader;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KMetadata;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.EOFException;
import java.io.IOException;
import java.util.Hashtable;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.stream.ImageInputStream;
import jj2000.j2k.codestream.HeaderInfo;
import jj2000.j2k.codestream.reader.BitstreamReaderAgent;
import jj2000.j2k.codestream.reader.HeaderDecoder;
import jj2000.j2k.decoder.DecoderSpecs;
import jj2000.j2k.entropy.decoder.EntropyDecoder;
import jj2000.j2k.fileformat.reader.FileFormatReader;
import jj2000.j2k.image.DataBlkInt;
import jj2000.j2k.image.ImgDataConverter;
import jj2000.j2k.image.invcomptransf.InvCompTransf;
import jj2000.j2k.io.RandomAccessIO;
import jj2000.j2k.quantization.dequantizer.Dequantizer;
import jj2000.j2k.roi.ROIDeScaler;
import jj2000.j2k.wavelet.synthesis.InverseWT;

public class J2KReadState {
    private ImageInputStream iis = null;
    private FileFormatReader ff;
    private HeaderInfo hi;
    private HeaderDecoder hd;
    private RandomAccessIO in;
    private BitstreamReaderAgent breader;
    private EntropyDecoder entdec;
    private ROIDeScaler roids;
    private Dequantizer deq;
    private InverseWT invWT;
    private InvCompTransf ictransf;
    private ImgDataConverter converter;
    private ImgDataConverter converter2;
    private DecoderSpecs decSpec = null;
    private J2KImageReadParamJava j2krparam = null;
    private int[] destinationBands = null;
    private int[] sourceBands = null;
    private int[] levelShift = null;
    private int[] minValues = null;
    private int[] maxValues = null;
    private int[] fracBits = null;
    private DataBlkInt[] dataBlocks = null;
    private int[] bandOffsets = null;
    private int maxDepth = 0;
    private boolean isSigned = false;
    private ColorModel colorModel = null;
    private SampleModel sampleModel = null;
    private int nComp = 0;
    private int tileWidth = 0;
    private int tileHeight = 0;
    private int scaleX;
    private int scaleY;
    private int xOffset;
    private int yOffset;
    private Rectangle destinationRegion = null;
    private Point sourceOrigin;
    private int tileXOffset;
    private int tileYOffset;
    private int width;
    private int height;
    private int[] pixbuf = null;
    private byte[] bytebuf = null;
    private int[] channelMap = null;
    private boolean noTransform = true;
    private int resolution;
    private int stepX;
    private int stepY;
    private int tileStepX;
    private int tileStepY;
    private J2KMetadata metadata;
    private BufferedImage destImage;
    private J2KImageReader reader;

    public J2KReadState(ImageInputStream imageInputStream, J2KImageReadParamJava j2KImageReadParamJava, J2KMetadata j2KMetadata, J2KImageReader j2KImageReader) {
        if (imageInputStream == null || j2KImageReadParamJava == null || j2KMetadata == null) {
            throw new IllegalArgumentException(I18N.getString("J2KReadState0"));
        }
        this.iis = imageInputStream;
        this.j2krparam = j2KImageReadParamJava;
        this.metadata = j2KMetadata;
        this.reader = j2KImageReader;
        this.initializeRead(0, j2KImageReadParamJava, j2KMetadata);
    }

    public J2KReadState(ImageInputStream imageInputStream, J2KImageReadParamJava j2KImageReadParamJava, J2KImageReader j2KImageReader) {
        if (imageInputStream == null || j2KImageReadParamJava == null) {
            throw new IllegalArgumentException(I18N.getString("J2KReadState0"));
        }
        this.iis = imageInputStream;
        this.j2krparam = j2KImageReadParamJava;
        this.reader = j2KImageReader;
        this.initializeRead(0, j2KImageReadParamJava, null);
    }

    public int getWidth() throws IOException {
        return this.width;
    }

    public int getHeight() throws IOException {
        return this.height;
    }

    public HeaderDecoder getHeader() {
        return this.hd;
    }

    public Raster getTile(int n, int n2, WritableRaster writableRaster) throws IOException {
        Point point = this.ictransf.getNumTiles(null);
        if (this.noTransform) {
            int n3;
            int n4;
            int n5;
            int n6;
            if (n >= point.x || n2 >= point.y) {
                throw new IllegalArgumentException(I18N.getString("J2KImageReader0"));
            }
            this.ictransf.setTile(n * this.tileStepX, n2 * this.tileStepY);
            if (writableRaster != null && this.resolution < this.hd.getDecoderSpecs().dls.getMin() || this.stepX != 1 || this.stepY != 1) {
                n6 = writableRaster.getMinX();
                n5 = writableRaster.getMinY();
                n4 = Math.min(writableRaster.getWidth(), this.ictransf.getTileWidth());
                n3 = Math.min(writableRaster.getHeight(), this.ictransf.getTileHeight());
            } else {
                n6 = this.ictransf.getCompULX(0) - (this.ictransf.getImgULX() + this.ictransf.getCompSubsX(0) - 1) / this.ictransf.getCompSubsX(0) + this.destinationRegion.x;
                n5 = this.ictransf.getCompULY(0) - (this.ictransf.getImgULY() + this.ictransf.getCompSubsY(0) - 1) / this.ictransf.getCompSubsY(0) + this.destinationRegion.y;
                n4 = this.ictransf.getTileWidth();
                n3 = this.ictransf.getTileHeight();
            }
            if (writableRaster == null) {
                writableRaster = Raster.createWritableRaster(this.sampleModel, new Point(n6, n5));
            }
            int n7 = this.sampleModel.getNumBands();
            if (n6 + n4 >= this.destinationRegion.width + this.destinationRegion.x) {
                n4 = this.destinationRegion.width + this.destinationRegion.x - n6;
            }
            if (n5 + n3 >= this.destinationRegion.height + this.destinationRegion.y) {
                n3 = this.destinationRegion.height + this.destinationRegion.y - n5;
            }
            if (this.pixbuf == null || this.pixbuf.length < n4 * n7) {
                this.pixbuf = new int[n4 * n7];
            }
            boolean bl = false;
            for (int i = 0; i < n3 && !this.reader.getAbortRequest(); ++i) {
                for (int j = 0; j < n7 && !this.reader.getAbortRequest(); ++j) {
                    int n8;
                    int n9;
                    DataBlkInt dataBlkInt = this.dataBlocks[j];
                    dataBlkInt.ulx = 0;
                    dataBlkInt.uly = i;
                    dataBlkInt.w = n4;
                    dataBlkInt.h = 1;
                    this.ictransf.getInternCompData(dataBlkInt, this.channelMap[this.sourceBands[j]]);
                    bl = bl || dataBlkInt.progressive;
                    int[] nArray = dataBlkInt.data;
                    int n10 = dataBlkInt.offset + n4 - 1;
                    int n11 = this.fracBits[j];
                    int n12 = this.levelShift[j];
                    int n13 = this.minValues[j];
                    int n14 = this.maxValues[j];
                    if (ImageUtil.isBinary(this.sampleModel)) {
                        n13 = 0;
                        n14 = 1;
                        if (this.bytebuf == null || this.bytebuf.length < n4 * n7) {
                            this.bytebuf = new byte[n4 * n7];
                        }
                        for (n9 = n4 - 1; n9 >= 0; --n9) {
                            this.bytebuf[n9] = (byte)((n8 = (nArray[n10--] >> n11) + n12) < n13 ? n13 : (n8 > n14 ? n14 : n8));
                        }
                        ImageUtil.setUnpackedBinaryData(this.bytebuf, writableRaster, new Rectangle(n6, n5 + i, n4, 1));
                        continue;
                    }
                    for (n9 = n4 - 1; n9 >= 0; --n9) {
                        this.pixbuf[n9] = (n8 = (nArray[n10--] >> n11) + n12) < n13 ? n13 : (n8 > n14 ? n14 : n8);
                    }
                    writableRaster.setSamples(n6, n5 + i, n4, 1, this.destinationBands[j], this.pixbuf);
                }
            }
        } else {
            this.readSubsampledRaster(writableRaster);
        }
        return writableRaster;
    }

    public Rectangle getDestinationRegion() {
        return this.destinationRegion;
    }

    public BufferedImage readBufferedImage() throws IOException {
        this.colorModel = this.getColorModel();
        this.sampleModel = this.getSampleModel();
        WritableRaster writableRaster = null;
        BufferedImage bufferedImage = this.j2krparam.getDestination();
        int n = this.destinationRegion.x;
        int n2 = this.destinationRegion.y;
        this.destinationRegion.setLocation(this.j2krparam.getDestinationOffset());
        if (bufferedImage == null) {
            ImageTypeSpecifier imageTypeSpecifier = this.j2krparam.getDestinationType();
            if (imageTypeSpecifier != null) {
                this.colorModel = imageTypeSpecifier.getColorModel();
            }
            writableRaster = Raster.createWritableRaster(this.sampleModel.createCompatibleSampleModel(this.destinationRegion.x + this.destinationRegion.width, this.destinationRegion.y + this.destinationRegion.height), new Point(0, 0));
            bufferedImage = new BufferedImage(this.colorModel, writableRaster, this.colorModel.isAlphaPremultiplied(), new Hashtable());
        } else {
            writableRaster = bufferedImage.getWritableTile(0, 0);
        }
        this.destImage = bufferedImage;
        this.readSubsampledRaster(writableRaster);
        this.destinationRegion.setLocation(n, n2);
        this.destImage = null;
        return bufferedImage;
    }

    public Raster readAsRaster() throws IOException {
        BufferedImage bufferedImage = this.j2krparam.getDestination();
        WritableRaster writableRaster = null;
        writableRaster = bufferedImage == null ? Raster.createWritableRaster(this.sampleModel.createCompatibleSampleModel(this.destinationRegion.x + this.destinationRegion.width, this.destinationRegion.y + this.destinationRegion.height), new Point(0, 0)) : bufferedImage.getWritableTile(0, 0);
        this.readSubsampledRaster(writableRaster);
        return writableRaster;
    }

    private void initializeRead(int n, J2KImageReadParamJava j2KImageReadParamJava, J2KMetadata j2KMetadata) {
        try {
            int n2;
            int n3;
            Object object;
            int n4;
            this.iis.mark();
            this.in = new IISRandomAccessIO(this.iis);
            this.ff = new FileFormatReader(this.in, j2KMetadata);
            this.ff.readFileFormat();
            this.in.seek(this.ff.getFirstCodeStreamPos());
            this.hi = new HeaderInfo();
            try {
                this.hd = new HeaderDecoder(this.in, this.j2krparam, this.hi);
            }
            catch (EOFException eOFException) {
                throw new RuntimeException(I18N.getString("J2KReadState2"));
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            this.width = this.hd.getImgWidth();
            this.height = this.hd.getImgHeight();
            Rectangle rectangle = j2KImageReadParamJava.getSourceRegion();
            this.sourceOrigin = new Point();
            rectangle = new Rectangle(this.hd.getImgULX(), this.hd.getImgULY(), this.width, this.height);
            boolean bl = true;
            this.stepX = this.hd.getCompSubsX(0);
            this.stepY = this.hd.getCompSubsY(0);
            for (n4 = 1; n4 < this.nComp; ++n4) {
                if (this.stepX == this.hd.getCompSubsX(n4) && this.stepY == this.hd.getCompSubsY(n4)) continue;
                throw new RuntimeException(I18N.getString("J2KReadState12"));
            }
            n4 = this.hd.getDecoderSpecs().dls.getMin();
            int n5 = this.resolution = j2KImageReadParamJava != null ? j2KImageReadParamJava.getResolution() : n4;
            if (this.resolution < 0 || this.resolution > n4) {
                this.resolution = n4;
            }
            if (this.resolution != n4 || this.stepX != 1 || this.stepY != 1) {
                rectangle = J2KImageReader.getReducedRect(rectangle, n4, this.resolution, this.stepX, this.stepY);
            }
            this.destinationRegion = (Rectangle)rectangle.clone();
            J2KImageReader.computeRegionsWrapper(j2KImageReadParamJava, false, this.width, this.height, j2KImageReadParamJava.getDestination(), rectangle, this.destinationRegion);
            this.sourceOrigin = new Point(rectangle.x, rectangle.y);
            this.scaleX = j2KImageReadParamJava.getSourceXSubsampling();
            this.scaleY = j2KImageReadParamJava.getSourceYSubsampling();
            this.xOffset = j2KImageReadParamJava.getSubsamplingXOffset();
            this.yOffset = j2KImageReadParamJava.getSubsamplingYOffset();
            this.width = this.destinationRegion.width;
            this.height = this.destinationRegion.height;
            Point point = this.hd.getTilingOrigin(null);
            this.tileWidth = this.hd.getNomTileWidth();
            this.tileHeight = this.hd.getNomTileHeight();
            if (this.resolution != n4 || this.stepX != 1 || this.stepY != 1) {
                object = new Rectangle(point);
                ((Rectangle)object).width = this.tileWidth;
                ((Rectangle)object).height = this.tileHeight;
                object = J2KImageReader.getReducedRect((Rectangle)object, n4, this.resolution, this.stepX, this.stepY);
                point = ((Rectangle)object).getLocation();
                this.tileWidth = ((Rectangle)object).width;
                this.tileHeight = ((Rectangle)object).height;
            }
            this.tileXOffset = point.x;
            this.tileYOffset = point.y;
            this.tileStepX = this.tileWidth * (1 << n4 - this.resolution) * this.stepX > this.hd.getNomTileWidth() ? (this.tileWidth * (1 << n4 - this.resolution) * this.stepX + this.hd.getNomTileWidth() - 1) / this.hd.getNomTileWidth() : 1;
            this.tileStepY = this.tileHeight * (1 << n4 - this.resolution) * this.stepY > this.hd.getNomTileHeight() ? (this.tileHeight * (1 << n4 - this.resolution) * this.stepY + this.hd.getNomTileHeight() - 1) / this.hd.getNomTileHeight() : 1;
            if (!this.destinationRegion.equals(rectangle)) {
                this.noTransform = false;
            }
            this.decSpec = this.hd.getDecoderSpecs();
            this.nComp = this.hd.getNumComps();
            object = new int[this.nComp];
            for (int i = 0; i < this.nComp; ++i) {
                object[i] = this.hd.getOriginalBitDepth(i);
            }
            ChannelDefinitionBox channelDefinitionBox = null;
            if (j2KMetadata != null) {
                channelDefinitionBox = (ChannelDefinitionBox)j2KMetadata.getElement("JPEG2000ChannelDefinitionBox");
            }
            this.channelMap = new int[this.nComp];
            if (channelDefinitionBox != null && j2KMetadata.getElement("JPEG2000PaletteBox") == null) {
                short[] sArray = channelDefinitionBox.getAssociation();
                short[] sArray2 = channelDefinitionBox.getTypes();
                short[] sArray3 = channelDefinitionBox.getChannel();
                for (n3 = 0; n3 < sArray2.length; ++n3) {
                    if (sArray2[n3] == 0) {
                        this.channelMap[sArray3[n3]] = sArray[n3] - 1;
                        continue;
                    }
                    if (sArray2[n3] != 1 && sArray2[n3] != 2) continue;
                    this.channelMap[sArray3[n3]] = sArray3[n3];
                }
            } else {
                for (int i = 0; i < this.nComp; ++i) {
                    this.channelMap[i] = i;
                }
            }
            try {
                n2 = Boolean.getBoolean("jj2000.j2k.decoder.log");
                this.breader = BitstreamReaderAgent.createInstance(this.in, this.hd, this.j2krparam, this.decSpec, n2 != 0, this.hi);
            }
            catch (IOException iOException) {
                throw new RuntimeException(I18N.getString("J2KReadState3") + " " + (iOException.getMessage() != null ? ":\n" + iOException.getMessage() : ""));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RuntimeException(I18N.getString("J2KReadState4") + " " + (illegalArgumentException.getMessage() != null ? ":\n" + illegalArgumentException.getMessage() : ""));
            }
            try {
                this.entdec = this.hd.createEntropyDecoder(this.breader, this.j2krparam);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RuntimeException(I18N.getString("J2KReadState5") + " " + (illegalArgumentException.getMessage() != null ? ":\n" + illegalArgumentException.getMessage() : ""));
            }
            try {
                this.roids = this.hd.createROIDeScaler(this.entdec, this.j2krparam, this.decSpec);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RuntimeException(I18N.getString("J2KReadState6") + " " + (illegalArgumentException.getMessage() != null ? ":\n" + illegalArgumentException.getMessage() : ""));
            }
            try {
                this.deq = this.hd.createDequantizer(this.roids, (int[])object, this.decSpec);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RuntimeException(I18N.getString("J2KReadState7") + " " + (illegalArgumentException.getMessage() != null ? ":\n" + illegalArgumentException.getMessage() : ""));
            }
            try {
                this.invWT = InverseWT.createInstance(this.deq, this.decSpec);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RuntimeException(I18N.getString("J2KReadState8") + " " + (illegalArgumentException.getMessage() != null ? ":\n" + illegalArgumentException.getMessage() : ""));
            }
            n2 = this.breader.getImgRes();
            int n6 = this.decSpec.dls.getMin();
            this.invWT.setImgResLevel(n2);
            this.converter = new ImgDataConverter(this.invWT, 0);
            this.ictransf = new InvCompTransf(this.converter, this.decSpec, (int[])object);
            this.sourceBands = this.j2krparam.getSourceBands();
            if (this.sourceBands == null) {
                this.sourceBands = new int[this.nComp];
                for (int i = 0; i < this.nComp; ++i) {
                    this.sourceBands[i] = i;
                }
            }
            this.nComp = this.sourceBands.length;
            this.destinationBands = this.j2krparam.getDestinationBands();
            if (this.destinationBands == null) {
                this.destinationBands = new int[this.nComp];
                for (int i = 0; i < this.nComp; ++i) {
                    this.destinationBands[i] = i;
                }
            }
            J2KImageReader.checkReadParamBandSettingsWrapper(j2KImageReadParamJava, this.hd.getNumComps(), this.destinationBands.length);
            this.levelShift = new int[this.nComp];
            this.minValues = new int[this.nComp];
            this.maxValues = new int[this.nComp];
            this.fracBits = new int[this.nComp];
            this.dataBlocks = new DataBlkInt[this.nComp];
            object = new int[this.nComp];
            this.bandOffsets = new int[this.nComp];
            this.maxDepth = 0;
            this.isSigned = false;
            for (int i = 0; i < this.nComp; ++i) {
                object[i] = this.hd.getOriginalBitDepth(this.sourceBands[i]);
                if (object[i] > this.maxDepth) {
                    this.maxDepth = (int)object[i];
                }
                this.dataBlocks[i] = new DataBlkInt();
                this.bandOffsets[i] = i;
                if (this.hd.isOriginalSigned(this.sourceBands[i])) {
                    this.isSigned = true;
                } else {
                    this.levelShift[i] = 1 << this.ictransf.getNomRangeBits(this.sourceBands[i]) - 1;
                }
                n3 = this.ictransf.getNomRangeBits(this.sourceBands[i]);
                this.maxValues[i] = (1 << (this.isSigned ? n3 - 1 : n3)) - 1;
                this.minValues[i] = this.isSigned ? -(this.maxValues[i] + 1) : 0;
                this.fracBits[i] = this.ictransf.getFixedPoint(this.sourceBands[i]);
            }
            this.iis.reset();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new RuntimeException(illegalArgumentException.getMessage(), illegalArgumentException);
        }
        catch (Error error) {
            if (error.getMessage() != null) {
                throw new RuntimeException(error.getMessage(), error);
            }
            throw new RuntimeException(I18N.getString("J2KReadState9"), error);
        }
        catch (RuntimeException runtimeException) {
            if (runtimeException.getMessage() != null) {
                throw new RuntimeException(I18N.getString("J2KReadState10") + " " + runtimeException.getMessage(), runtimeException);
            }
            throw new RuntimeException(I18N.getString("J2KReadState10"), runtimeException);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(I18N.getString("J2KReadState10"), throwable);
        }
    }

    private Raster readSubsampledRaster(WritableRaster writableRaster) throws IOException {
        if (writableRaster == null) {
            writableRaster = Raster.createWritableRaster(this.sampleModel.createCompatibleSampleModel(this.destinationRegion.x + this.destinationRegion.width, this.destinationRegion.y + this.destinationRegion.height), new Point(this.destinationRegion.x, this.destinationRegion.y));
        }
        int[] nArray = null;
        boolean bl = false;
        Point point = this.ictransf.getNumTiles(null);
        int n = this.sourceBands.length;
        Rectangle rectangle = writableRaster.getBounds().intersection(this.destinationRegion);
        int n2 = this.destinationRegion.x;
        int n3 = this.destinationRegion.y;
        int n4 = (rectangle.x - n2) * this.scaleX + this.sourceOrigin.x;
        int n5 = (rectangle.y - n3) * this.scaleY + this.sourceOrigin.y;
        int n6 = (rectangle.width - 1) * this.scaleX + n4;
        int n7 = (rectangle.height - 1) * this.scaleY + n5;
        int n8 = (n4 - this.tileXOffset) / this.tileWidth;
        int n9 = (n5 - this.tileYOffset) / this.tileHeight;
        int n10 = (n6 - this.tileXOffset) / this.tileWidth;
        int n11 = (n7 - this.tileYOffset) / this.tileHeight;
        n8 = this.clip(n8, 0, point.x - 1);
        n9 = this.clip(n9, 0, point.y - 1);
        n10 = this.clip(n10, 0, point.x - 1);
        n11 = this.clip(n11, 0, point.y - 1);
        int n12 = n10 - n8 + 1;
        int n13 = n11 - n9 + 1;
        int n14 = n12 * n13;
        for (int i = n9; i <= n11 && !this.reader.getAbortRequest(); ++i) {
            for (int j = n8; j <= n10 && !this.reader.getAbortRequest(); ++j) {
                float f2 = (j - n8 + (i - n9) * n12) / n14;
                this.ictransf.setTile(j * this.tileStepX, i * this.tileStepY);
                int n15 = this.hd.getCompSubsX(0);
                int n16 = (this.ictransf.getTileWidth() + n15 - 1) / n15;
                int n17 = this.hd.getCompSubsY(0);
                int n18 = (this.ictransf.getTileHeight() + n17 - 1) / n17;
                int n19 = 0;
                int n20 = 0;
                int n21 = this.tileXOffset + j * this.tileWidth;
                int n22 = this.tileYOffset + i * this.tileHeight;
                if (n4 > n21) {
                    if (n21 >= this.hd.getImgULX()) {
                        n19 = n4 - n21;
                        n16 -= n19;
                    }
                    n21 = n4;
                }
                if (n5 > n22) {
                    if (n22 >= this.hd.getImgULY()) {
                        n20 = n5 - n22;
                        n18 -= n20;
                    }
                    n22 = n5;
                }
                if (n6 < n21 + n16 - 1) {
                    n16 += n6 - n21 - n16 + 1;
                }
                if (n7 < n22 + n18 - 1) {
                    n18 += n7 - n22 - n18 + 1;
                }
                int n23 = (n21 + this.scaleX - 1 - this.sourceOrigin.x) / this.scaleX;
                int n24 = (n21 + this.scaleX - 1 + n16 - this.sourceOrigin.x) / this.scaleX;
                int n25 = n24 - n23;
                if (nArray == null || nArray.length < n25) {
                    nArray = new int[n25];
                }
                n24 = (n24 - 1) * this.scaleX + this.sourceOrigin.x - n21;
                int n26 = (n22 + this.scaleY - 1 - this.sourceOrigin.y) / this.scaleY;
                n23 += n2;
                int n27 = n20;
                int n28 = n26 += n3;
                while (n27 < n20 + n18 && !this.reader.getAbortRequest()) {
                    for (int k = 0; k < n; ++k) {
                        int n29;
                        int n30;
                        DataBlkInt dataBlkInt = this.dataBlocks[k];
                        dataBlkInt.ulx = n19;
                        dataBlkInt.uly = n27;
                        dataBlkInt.w = n16;
                        dataBlkInt.h = 1;
                        this.ictransf.getInternCompData(dataBlkInt, this.channelMap[this.sourceBands[k]]);
                        bl = bl || dataBlkInt.progressive;
                        int[] nArray2 = dataBlkInt.data;
                        int n31 = dataBlkInt.offset + n24;
                        int n32 = this.fracBits[k];
                        int n33 = this.levelShift[k];
                        int n34 = this.minValues[k];
                        int n35 = this.maxValues[k];
                        if (ImageUtil.isBinary(this.sampleModel)) {
                            n34 = 0;
                            n35 = 1;
                            if (this.bytebuf == null || this.bytebuf.length < n16 * n) {
                                this.bytebuf = new byte[n16 * n];
                            }
                            n30 = n25 - 1;
                            while (n30 >= 0) {
                                n29 = (nArray2[n31] >> n32) + n33;
                                this.bytebuf[n30] = (byte)(n29 < n34 ? n34 : (n29 > n35 ? n35 : n29));
                                --n30;
                                n31 -= this.scaleX;
                            }
                            ImageUtil.setUnpackedBinaryData(this.bytebuf, writableRaster, new Rectangle(n23, n28, n25, 1));
                            continue;
                        }
                        n30 = n25 - 1;
                        while (n30 >= 0) {
                            n29 = (nArray2[n31] >> n32) + n33;
                            nArray[n30] = n29 < n34 ? n34 : (n29 > n35 ? n35 : n29);
                            --n30;
                            n31 -= this.scaleX;
                        }
                        writableRaster.setSamples(n23, n28, n25, 1, this.destinationBands[k], nArray);
                    }
                    if (this.destImage != null) {
                        this.reader.processImageUpdateWrapper(this.destImage, n23, n28, n16, 1, 1, 1, this.destinationBands);
                    }
                    float f3 = f2 + ((float)(n27 - n20) + 1.0f) / (float)n18 / (float)n14;
                    this.reader.processImageProgressWrapper(100.0f * f3);
                    n27 += this.scaleY;
                    ++n28;
                }
            }
        }
        return writableRaster;
    }

    public ImageTypeSpecifier getImageType() throws IOException {
        this.getSampleModel();
        this.getColorModel();
        return new ImageTypeSpecifier(this.colorModel, this.sampleModel);
    }

    public SampleModel getSampleModel() {
        if (this.sampleModel != null) {
            return this.sampleModel;
        }
        if (this.nComp == 1 && (this.maxDepth == 1 || this.maxDepth == 2 || this.maxDepth == 4)) {
            this.sampleModel = new MultiPixelPackedSampleModel(0, this.tileWidth, this.tileHeight, this.maxDepth);
        } else if (this.maxDepth <= 8) {
            this.sampleModel = new PixelInterleavedSampleModel(0, this.tileWidth, this.tileHeight, this.nComp, this.tileWidth * this.nComp, this.bandOffsets);
        } else if (this.maxDepth <= 16) {
            this.sampleModel = new PixelInterleavedSampleModel(this.isSigned ? 2 : 1, this.tileWidth, this.tileHeight, this.nComp, this.tileWidth * this.nComp, this.bandOffsets);
        } else if (this.maxDepth <= 32) {
            this.sampleModel = new PixelInterleavedSampleModel(3, this.tileWidth, this.tileHeight, this.nComp, this.tileWidth * this.nComp, this.bandOffsets);
        } else {
            throw new IllegalArgumentException(I18N.getString("J2KReadState11") + " " + this.maxDepth);
        }
        return this.sampleModel;
    }

    public ColorModel getColorModel() {
        if (this.colorModel != null) {
            return this.colorModel;
        }
        this.colorModel = this.ff.getColorModel();
        if (this.colorModel != null) {
            return this.colorModel;
        }
        if (this.hi.siz.csiz <= 4) {
            int n;
            ColorSpace colorSpace = this.hi.siz.csiz > 2 ? ColorSpace.getInstance(1000) : ColorSpace.getInstance(1003);
            int[] nArray = new int[this.hi.siz.csiz];
            boolean bl = false;
            int n2 = -1;
            for (n = 0; n < this.hi.siz.csiz; n += 1) {
                nArray[n] = this.hi.siz.getOrigBitDepth(n);
                if (n2 < nArray[n]) {
                    n2 = nArray[n];
                }
                bl |= this.hi.siz.isOrigSigned(n);
            }
            n = this.hi.siz.csiz % 2 == 0 ? 1 : 0;
            int n3 = -1;
            if (n2 <= 8) {
                n3 = 0;
            } else if (n2 <= 16) {
                n3 = bl ? 2 : 1;
            } else if (n2 <= 32) {
                n3 = 3;
            }
            if (n3 != -1) {
                this.colorModel = this.hi.siz.csiz == 1 && (n2 == 1 || n2 == 2 || n2 == 4) ? ImageUtil.createColorModel(this.getSampleModel()) : new ComponentColorModel(colorSpace, nArray, n != 0, false, n != 0 ? 3 : 1, n3);
                return this.colorModel;
            }
        }
        if (this.sampleModel == null) {
            this.sampleModel = this.getSampleModel();
        }
        if (this.sampleModel == null) {
            return null;
        }
        return ImageUtil.createColorModel(null, this.sampleModel);
    }

    Rectangle getTile0Rect() {
        return new Rectangle(this.tileXOffset, this.tileYOffset, this.tileWidth, this.tileHeight);
    }

    private int clip(int n, int n2, int n3) {
        if (n < n2) {
            n = n2;
        }
        if (n > n3) {
            n = n3;
        }
        return n;
    }

    private void clipDestination(Rectangle rectangle) {
        Point point = this.j2krparam.getDestinationOffset();
        if (rectangle.x < point.x) {
            rectangle.width += rectangle.x - point.x;
            rectangle.x = point.x;
        }
        if (rectangle.y < point.y) {
            rectangle.height += rectangle.y - point.y;
            rectangle.y = point.y;
        }
    }
}

