/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import com.sun.media.imageioimpl.common.SimpleRenderedImage;
import com.sun.media.imageioimpl.plugins.jpeg2000.I18N;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReadParamJava;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReader;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KMetadata;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KReadState;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import jj2000.j2k.codestream.reader.HeaderDecoder;

public class J2KRenderedImage
extends SimpleRenderedImage {
    private Raster currentTile;
    private Point currentTileGrid;
    private J2KReadState readState;

    public J2KRenderedImage(ImageInputStream imageInputStream, J2KImageReadParamJava j2KImageReadParamJava, J2KMetadata j2KMetadata, J2KImageReader j2KImageReader) throws IOException {
        this(new J2KReadState(imageInputStream, j2KImageReadParamJava, j2KMetadata, j2KImageReader));
    }

    public J2KRenderedImage(ImageInputStream imageInputStream, J2KImageReadParamJava j2KImageReadParamJava, J2KImageReader j2KImageReader) throws IOException {
        this(new J2KReadState(imageInputStream, j2KImageReadParamJava, j2KImageReader));
    }

    public J2KRenderedImage(J2KReadState j2KReadState) {
        this.readState = j2KReadState;
        HeaderDecoder headerDecoder = j2KReadState.getHeader();
        Rectangle rectangle = j2KReadState.getDestinationRegion();
        this.width = rectangle.width;
        this.height = rectangle.height;
        this.minX = rectangle.x;
        this.minY = rectangle.y;
        Rectangle rectangle2 = j2KReadState.getTile0Rect();
        this.tileWidth = rectangle2.width;
        this.tileHeight = rectangle2.height;
        this.tileGridXOffset = rectangle2.x;
        this.tileGridYOffset = rectangle2.y;
        this.sampleModel = j2KReadState.getSampleModel();
        this.colorModel = j2KReadState.getColorModel();
    }

    public synchronized Raster getTile(int n, int n2) {
        if (this.currentTile != null && this.currentTileGrid.x == n && this.currentTileGrid.y == n2) {
            return this.currentTile;
        }
        if (n >= this.getNumXTiles() || n2 >= this.getNumYTiles()) {
            throw new IllegalArgumentException(I18N.getString("J2KReadState1"));
        }
        try {
            int n3 = this.tileXToX(n);
            int n4 = this.tileYToY(n2);
            this.currentTile = Raster.createWritableRaster(this.sampleModel, new Point(n3, n4));
            this.currentTile = this.readState.getTile(n, n2, (WritableRaster)this.currentTile);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        if (this.currentTileGrid == null) {
            this.currentTileGrid = new Point(n, n2);
        } else {
            this.currentTileGrid.x = n;
            this.currentTileGrid.y = n2;
        }
        return this.currentTile;
    }
}

