/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import com.sun.media.imageio.plugins.jpeg2000.J2KImageReadParam;
import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.common.SimpleRenderedImage;
import com.sun.media.imageioimpl.plugins.jpeg2000.BitsPerComponentBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.Box;
import com.sun.media.imageioimpl.plugins.jpeg2000.ChannelDefinitionBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.ColorSpecificationBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.ComponentMappingBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.HeaderBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.I18N;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReadParamJava;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReader;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReaderCodecLib;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KMetadata;
import com.sun.media.imageioimpl.plugins.jpeg2000.MediaLibAccessor;
import com.sun.media.imageioimpl.plugins.jpeg2000.PaletteBox;
import com.sun.medialib.codec.jiio.mediaLibImage;
import com.sun.medialib.codec.jp2k.CompParams;
import com.sun.medialib.codec.jp2k.Decoder;
import com.sun.medialib.codec.jp2k.Size;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.stream.ImageInputStream;

public class J2KRenderedImageCodecLib
extends SimpleRenderedImage {
    private SampleModel originalSampleModel;
    private Raster currentTile;
    private Point currentTileGrid;
    private J2KMetadata metadata;
    private ImageInputStream iis = null;
    private J2KImageReaderCodecLib reader;
    private J2KImageReadParam param = null;
    private Decoder decoder;
    private Size size;
    private CompParams compParam;
    private int xStep;
    private int yStep;
    Rectangle destinationRegion;
    Rectangle originalRegion;
    Point sourceOrigin;
    private int scaleX;
    private int scaleY;
    private int xOffset;
    private int yOffset;
    private int[] destinationBands = null;
    private int[] sourceBands = null;
    private int nComp;
    private int[] channelMap;
    private boolean noTransform = true;
    private WritableRaster rasForATile;
    private BufferedImage destImage;
    static /* synthetic */ Class array$B;

    public J2KRenderedImageCodecLib(ImageInputStream imageInputStream, J2KImageReaderCodecLib j2KImageReaderCodecLib, ImageReadParam imageReadParam) throws IOException {
        int n;
        this.iis = imageInputStream;
        this.reader = j2KImageReaderCodecLib;
        boolean bl = true;
        if (imageReadParam == null) {
            imageReadParam = (J2KImageReadParam)j2KImageReaderCodecLib.getDefaultReadParam();
            bl = false;
        } else if (!(imageReadParam instanceof J2KImageReadParam)) {
            imageReadParam = new J2KImageReadParamJava(imageReadParam);
            bl = false;
        }
        this.param = (J2KImageReadParam)imageReadParam;
        this.decoder = new Decoder(imageInputStream);
        this.decoder.setMode(2);
        int n2 = ((J2KImageReadParam)imageReadParam).getResolution();
        if (n2 != -1) {
            this.decoder.setMaxLevels(n2);
        }
        this.size = this.decoder.decodeSize(null);
        this.compParam = new CompParams();
        for (n = 0; n < this.size.csize; ++n) {
            this.decoder.decodeCompParams(this.compParam, n);
            if (n == 0) {
                this.xStep = this.compParam.xstep;
                this.yStep = this.compParam.ystep;
                continue;
            }
            if (this.compParam.xstep == this.xStep && this.compParam.ystep == this.yStep) continue;
            throw new IIOException("All components must have the same subsampling factors!");
        }
        this.sourceBands = imageReadParam.getSourceBands();
        if (this.sourceBands == null) {
            this.nComp = this.size.csize;
            this.sourceBands = new int[this.nComp];
            for (n = 0; n < this.nComp; ++n) {
                this.sourceBands[n] = n;
            }
        } else {
            for (n = 0; n < this.sourceBands.length; ++n) {
                if (this.sourceBands[n] >= 0 && this.sourceBands[n] < this.size.csize) continue;
                throw new IIOException("Source band out of range!");
            }
        }
        this.nComp = this.sourceBands.length;
        this.destinationBands = imageReadParam.getDestinationBands();
        if (this.destinationBands == null) {
            this.destinationBands = new int[this.nComp];
            for (n = 0; n < this.nComp; ++n) {
                this.destinationBands[n] = n;
            }
        } else {
            for (n = 0; n < this.destinationBands.length; ++n) {
                if (this.destinationBands[n] >= 0 && this.destinationBands[n] < this.size.csize) continue;
                throw new IIOException("Destination band out of range!");
            }
        }
        if (this.destinationBands.length != this.sourceBands.length) {
            throw new IIOException("Number of source and destination bands must be equal!");
        }
        this.width = (this.size.xosize + this.size.xsize + this.xStep - 1) / this.xStep;
        this.height = (this.size.yosize + this.size.ysize + this.yStep - 1) / this.yStep;
        Rectangle rectangle = new Rectangle(0, 0, this.width, this.height);
        this.originalRegion = (Rectangle)rectangle.clone();
        this.destinationRegion = (Rectangle)rectangle.clone();
        J2KImageReader.computeRegionsWrapper(imageReadParam, bl, this.width, this.height, imageReadParam.getDestination(), rectangle, this.destinationRegion);
        this.scaleX = imageReadParam.getSourceXSubsampling();
        this.scaleY = imageReadParam.getSourceYSubsampling();
        this.xOffset = imageReadParam.getSubsamplingXOffset();
        this.yOffset = imageReadParam.getSubsamplingYOffset();
        this.sourceOrigin = new Point(rectangle.x, rectangle.y);
        if (!this.destinationRegion.equals(this.originalRegion)) {
            this.noTransform = false;
        }
        this.tileWidth = (this.size.xtsize + this.xStep - 1) / this.xStep;
        this.tileHeight = (this.size.ytsize + this.yStep - 1) / this.yStep;
        this.tileGridXOffset = (this.size.xtosize + this.xStep - 1) / this.xStep - (this.size.xosize + this.xStep - 1) / this.xStep;
        this.tileGridYOffset = (this.size.ytosize + this.yStep - 1) / this.yStep - (this.size.yosize + this.yStep - 1) / this.yStep;
        this.width = this.destinationRegion.width;
        this.height = this.destinationRegion.height;
        this.minX = this.destinationRegion.x;
        this.minY = this.destinationRegion.y;
        this.originalSampleModel = this.createOriginalSampleModel();
        this.sampleModel = this.createSampleModel();
        this.colorModel = this.createColorModel();
        this.tileGridXOffset += (this.XToTileX(this.minX) - this.XToTileX(this.tileGridXOffset)) * this.tileWidth;
        this.tileGridYOffset += (this.YToTileY(this.minY) - this.YToTileY(this.tileGridYOffset)) * this.tileHeight;
        double d2 = ((J2KImageReadParam)imageReadParam).getDecodingRate();
        if (d2 != Double.MAX_VALUE) {
            this.decoder.setRate(d2 /= (double)ImageUtil.getElementSize(this.sampleModel), 0);
        }
    }

    public synchronized Raster getTile(int n, int n2) {
        if (this.currentTile != null && this.currentTileGrid.x == n && this.currentTileGrid.y == n2) {
            return this.currentTile;
        }
        if (n < this.getMinTileX() || n2 < this.getMinTileY() || n > this.getMaxTileX() || n2 > this.getMaxTileY()) {
            throw new IllegalArgumentException(I18N.getString("J2KReadState1"));
        }
        int n3 = this.tileXToX(n);
        int n4 = this.tileYToY(n2);
        this.currentTile = Raster.createWritableRaster(this.sampleModel, new Point(n3, n4));
        try {
            this.readAsRaster((WritableRaster)this.currentTile);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        if (this.currentTileGrid == null) {
            this.currentTileGrid = new Point(n, n2);
        } else {
            this.currentTileGrid.x = n;
            this.currentTileGrid.y = n2;
        }
        return this.currentTile;
    }

    synchronized WritableRaster readAsRaster(WritableRaster writableRaster) throws IOException {
        int n = writableRaster.getMinX();
        int n2 = writableRaster.getMinY();
        try {
            if (this.noTransform) {
                int n3 = (this.size.xosize + this.xStep - 1) / this.xStep;
                int n4 = (this.size.yosize + this.yStep - 1) / this.yStep;
                int n5 = ((n + n3) * this.xStep - this.size.xtosize) / this.size.xtsize;
                int n6 = ((n + writableRaster.getWidth() - 1 + n3) * this.xStep - this.size.xtosize) / this.size.xtsize;
                int n7 = ((n2 + n3) * this.yStep - this.size.ytosize) / this.size.ytsize;
                int n8 = ((n2 + writableRaster.getHeight() - 1 + n3) * this.yStep - this.size.ytosize) / this.size.ytsize;
                int n9 = MediaLibAccessor.findCompatibleTag(writableRaster);
                if (n5 == n6 && n7 == n8) {
                    MediaLibAccessor mediaLibAccessor = new MediaLibAccessor(writableRaster, writableRaster.getBounds().intersection(this.originalRegion), n9, true);
                    mediaLibImage[] mediaLibImageArray = mediaLibAccessor.getMediaLibImages();
                    int n10 = n5 + n7 * this.size.nxtiles;
                    this.decoder.decode(mediaLibImageArray, n10);
                    mediaLibAccessor.copyDataToRaster(this.channelMap);
                } else {
                    for (int i = n7; i <= n8; ++i) {
                        for (int j = n5; j <= n6; ++j) {
                            int n11 = (this.size.xtosize + j * this.size.xtsize + this.xStep - 1) / this.xStep - n3;
                            int n12 = (this.size.ytosize + i * this.size.ytsize + this.yStep - 1) / this.yStep - n4;
                            int n13 = (this.size.xtosize + (j + 1) * this.size.xtsize + this.xStep - 1) / this.xStep - n3;
                            int n14 = (this.size.ytosize + (i + 1) * this.size.ytsize + this.yStep - 1) / this.yStep - n4;
                            Rectangle rectangle = new Rectangle(n11, n12, n13 - n11, n14 - n12);
                            if (rectangle.isEmpty()) continue;
                            if (this.rasForATile == null) {
                                this.rasForATile = Raster.createWritableRaster(this.originalSampleModel, null);
                            }
                            WritableRaster writableRaster2 = this.rasForATile.createWritableChild(this.rasForATile.getMinX(), this.rasForATile.getMinY(), rectangle.width, rectangle.height, rectangle.x, rectangle.y, null);
                            MediaLibAccessor mediaLibAccessor = new MediaLibAccessor(writableRaster2, rectangle, n9, true);
                            mediaLibImage[] mediaLibImageArray = mediaLibAccessor.getMediaLibImages();
                            int n15 = j + i * this.size.nxtiles;
                            this.decoder.decode(mediaLibImageArray, n15);
                            mediaLibAccessor.copyDataToRaster(this.channelMap);
                            Rectangle rectangle2 = writableRaster.getBounds();
                            Rectangle rectangle3 = rectangle2.intersection(rectangle);
                            if (rectangle3.isEmpty()) continue;
                            Raster raster = writableRaster2.createChild(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, rectangle3.x, rectangle3.y, null);
                            writableRaster.setRect(raster);
                        }
                    }
                }
            } else {
                this.readSubsampledRaster(writableRaster);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return writableRaster;
    }

    private void readSubsampledRaster(WritableRaster writableRaster) throws IOException {
        int n = this.sourceBands.length;
        Rectangle rectangle = writableRaster.getBounds().intersection(this.destinationRegion);
        int n2 = this.destinationRegion.x;
        int n3 = this.destinationRegion.y;
        int n4 = (rectangle.x - n2) * this.scaleX + this.sourceOrigin.x;
        int n5 = (rectangle.y - n3) * this.scaleY + this.sourceOrigin.y;
        int n6 = (rectangle.width - 1) * this.scaleX + n4;
        int n7 = (rectangle.height - 1) * this.scaleY + n5;
        int n8 = (this.size.xosize + this.xStep - 1) / this.xStep;
        int n9 = (this.size.yosize + this.yStep - 1) / this.yStep;
        int n10 = ((n4 + n8) * this.xStep - this.size.xtosize) / this.size.xtsize;
        int n11 = ((n6 + n8) * this.xStep - this.size.xtosize) / this.size.xtsize;
        int n12 = ((n5 + n9) * this.yStep - this.size.ytosize) / this.size.ytsize;
        int n13 = ((n7 + n9) * this.yStep - this.size.ytosize) / this.size.ytsize;
        n10 = this.clip(n10, 0, this.size.nxtiles - 1);
        n12 = this.clip(n12, 0, this.size.nytiles - 1);
        n11 = this.clip(n11, 0, this.size.nxtiles - 1);
        n13 = this.clip(n13, 0, this.size.nytiles - 1);
        int n14 = n11 - n10 + 1;
        int n15 = n13 - n12 + 1;
        int n16 = n14 * n15;
        int[] nArray = null;
        for (int i = n12; i <= n13 && !this.reader.getAbortRequest(); ++i) {
            for (int j = n10; j <= n11 && !this.reader.getAbortRequest(); ++j) {
                int n17;
                int n18;
                int n19;
                float f2 = ((float)(j - n10) + 1.0f + (float)(i * n14)) / (float)n16;
                int n20 = (j * this.size.xtsize + this.size.xtosize + this.xStep - 1) / this.xStep - n8;
                int n21 = (i * this.size.ytsize + this.size.ytosize + this.yStep - 1) / this.yStep - n9;
                int n22 = ((j + 1) * this.size.xtsize + this.size.xtosize + this.xStep - 1) / this.xStep - n8;
                int n23 = ((i + 1) * this.size.ytsize + this.size.ytosize + this.yStep - 1) / this.yStep - n9;
                this.rasForATile = this.rasForATile == null ? Raster.createWritableRaster(this.originalSampleModel, new Point(n20, n21)) : this.rasForATile.createWritableTranslatedChild(n20, n21);
                int n24 = n22 - n20;
                int n25 = n23 - n21;
                WritableRaster writableRaster2 = n24 != this.tileWidth || n25 != this.tileHeight ? this.rasForATile.createWritableChild(n20, n21, n24, n25, n20, n21, null) : this.rasForATile;
                int n26 = MediaLibAccessor.findCompatibleTag(writableRaster2);
                MediaLibAccessor mediaLibAccessor = new MediaLibAccessor(writableRaster2, writableRaster2.getBounds().intersection(this.originalRegion), n26, true);
                mediaLibImage[] mediaLibImageArray = mediaLibAccessor.getMediaLibImages();
                this.decoder.decode(mediaLibImageArray, j + i * this.size.nxtiles);
                mediaLibAccessor.copyDataToRaster(this.channelMap);
                int n27 = n25;
                int n28 = n24;
                if (n21 + n27 >= this.originalRegion.height) {
                    n27 = this.originalRegion.height - n21;
                }
                if (n20 + n28 >= this.originalRegion.width) {
                    n28 = this.originalRegion.width - n20;
                }
                int n29 = n20;
                int n30 = n21;
                if (n4 > n20) {
                    n28 += n20 - n4;
                    n29 = n4;
                    n20 = n4;
                }
                if (n5 > n21) {
                    n27 += n21 - n5;
                    n30 = n5;
                    n21 = n5;
                }
                if (n6 < n20 + n28 - 1) {
                    n28 += n6 - n20 - n28 + 1;
                }
                if (n7 < n21 + n27 - 1) {
                    n27 += n7 - n21 - n27 + 1;
                }
                if ((n19 = (n18 = (n20 + this.scaleX - 1 + n28 - this.sourceOrigin.x) / this.scaleX) - (n17 = (n20 + this.scaleX - 1 - this.sourceOrigin.x) / this.scaleX)) <= 0) continue;
                n18 = (n18 - 1) * this.scaleX + this.sourceOrigin.x;
                int n31 = (n21 + this.scaleY - 1 - this.sourceOrigin.y) / this.scaleY;
                n21 = n31 * this.scaleY + this.sourceOrigin.y;
                n20 = n17 * this.scaleX + this.sourceOrigin.x;
                n17 += n2;
                n31 += n3;
                if (nArray == null || nArray.length < n19) {
                    nArray = new int[n19];
                }
                int n32 = n21;
                int n33 = n31;
                while (n32 < n30 + n27 && !this.reader.getAbortRequest()) {
                    for (int k = 0; k < n; ++k) {
                        int n34 = n19 - 1;
                        int n35 = n18;
                        while (n34 >= 0) {
                            nArray[n34] = writableRaster2.getSample(n35, n32, k);
                            --n34;
                            n35 -= this.scaleX;
                        }
                        writableRaster.setSamples(n17, n33, n19, 1, this.destinationBands[k], nArray);
                    }
                    if (this.destImage != null) {
                        this.reader.processImageUpdateWrapper(this.destImage, n17, n33, n28, 1, 1, 1, this.destinationBands);
                    }
                    this.reader.processImageProgressWrapper(f2 + ((float)(n32 - n21) + 1.0f) / (float)n27 / (float)n16);
                    n32 += this.scaleY;
                    ++n33;
                }
            }
        }
    }

    public void setDestImage(BufferedImage bufferedImage) {
        this.destImage = bufferedImage;
    }

    public void clearDestImage() {
        this.destImage = null;
    }

    private int getTileNum(int n, int n2) {
        int n3 = (n2 - this.getMinTileY()) * this.getNumXTiles() + n - this.getMinTileX();
        if (n3 < 0 || n3 >= this.getNumXTiles() * this.getNumYTiles()) {
            throw new IllegalArgumentException(I18N.getString("J2KReadState1"));
        }
        return n3;
    }

    private int clip(int n, int n2, int n3) {
        if (n < n2) {
            n = n2;
        }
        if (n > n3) {
            n = n3;
        }
        return n;
    }

    private SampleModel createSampleModel() throws IOException {
        int n;
        Object object;
        if (this.sampleModel != null) {
            return this.sampleModel;
        }
        if (this.metadata == null) {
            this.readImageMetadata();
        }
        HeaderBox headerBox = (HeaderBox)this.metadata.getElement("JPEG2000HeaderBox");
        int n2 = 0;
        boolean bl = false;
        if (headerBox != null) {
            n2 = headerBox.getBitDepth();
            bl = (n2 & 0x80) > 0;
            n2 = (n2 & 0x7F) + 1;
        } else {
            object = new CompParams();
            for (int i = 0; i < this.size.csize; ++i) {
                this.decoder.decodeCompParams((CompParams)object, i);
                n2 = (((CompParams)object).depth & 0x7F) + 1;
                bl = (((CompParams)object).depth & 0x80) > 0;
            }
        }
        object = (BitsPerComponentBox)this.metadata.getElement("JPEG2000BitsPerComponentBox");
        if (object != null) {
            byte[] byArray = ((BitsPerComponentBox)object).getBitDepth();
            n2 = (byArray[0] & 0x7F) + 1;
            bl = (byArray[0] & 0x80) > 0;
            for (n = 1; n < this.nComp; ++n) {
                if (n2 <= byArray[this.sourceBands[n]]) continue;
                n2 = (byArray[this.sourceBands[n]] & 0x7F) + 1;
            }
        }
        int[] nArray = new int[this.nComp];
        for (n = 0; n < this.nComp; ++n) {
            nArray[n] = n;
        }
        ChannelDefinitionBox channelDefinitionBox = (ChannelDefinitionBox)this.metadata.getElement("JPEG2000ChannelDefinitionBox");
        if (channelDefinitionBox != null && this.metadata.getElement("JPEG2000PaletteBox") == null) {
            short[] sArray = channelDefinitionBox.getAssociation();
            short[] sArray2 = channelDefinitionBox.getTypes();
            short[] sArray3 = channelDefinitionBox.getChannel();
            for (int i = 0; i < sArray2.length; ++i) {
                if (sArray2[i] == 0) {
                    nArray[this.sourceBands[sArray3[i]]] = sArray[i] - 1;
                    continue;
                }
                if (sArray2[i] != 1 && sArray2[i] != 2) continue;
                nArray[this.sourceBands[sArray3[i]]] = sArray3[i];
            }
        }
        return this.createSampleModel(this.nComp, n2, nArray, bl, this.tileWidth, this.tileHeight);
    }

    private SampleModel createOriginalSampleModel() throws IOException {
        int n;
        Object object;
        if (this.metadata == null) {
            this.readImageMetadata();
        }
        HeaderBox headerBox = (HeaderBox)this.metadata.getElement("JPEG2000HeaderBox");
        int n2 = 0;
        boolean bl = false;
        int n3 = this.size.csize;
        if (headerBox != null) {
            n2 = headerBox.getBitDepth();
            bl = (n2 & 0x80) > 0;
            n2 = (n2 & 0x7F) + 1;
        } else {
            object = new CompParams();
            for (int i = 0; i < this.size.csize; ++i) {
                this.decoder.decodeCompParams((CompParams)object, i);
                n2 = (((CompParams)object).depth & 0x7F) + 1;
                bl = (((CompParams)object).depth & 0x80) > 0;
            }
        }
        object = (BitsPerComponentBox)this.metadata.getElement("JPEG2000BitsPerComponentBox");
        if (object != null) {
            byte[] byArray = ((BitsPerComponentBox)object).getBitDepth();
            n2 = (byArray[0] & 0x7F) + 1;
            bl = (byArray[0] & 0x80) > 0;
            for (n = 1; n < n3; ++n) {
                if (n2 <= byArray[n]) continue;
                n2 = (byArray[n] & 0x7F) + 1;
            }
        }
        int[] nArray = new int[n3];
        for (n = 0; n < n3; ++n) {
            nArray[n] = n;
        }
        ChannelDefinitionBox channelDefinitionBox = (ChannelDefinitionBox)this.metadata.getElement("JPEG2000ChannelDefinitionBox");
        if (channelDefinitionBox != null && this.metadata.getElement("JPEG2000PaletteBox") == null) {
            short[] sArray = channelDefinitionBox.getAssociation();
            short[] sArray2 = channelDefinitionBox.getTypes();
            short[] sArray3 = channelDefinitionBox.getChannel();
            this.channelMap = new int[n3];
            for (int i = 0; i < sArray2.length; ++i) {
                if (sArray2[i] == 0) {
                    nArray[sArray3[i]] = sArray[i] - 1;
                    this.channelMap[sArray[i] - 1] = sArray3[i];
                    continue;
                }
                if (sArray2[i] != 1 && sArray2[i] != 2) continue;
                nArray[sArray3[i]] = sArray3[i];
                this.channelMap[sArray3[i]] = sArray3[i];
            }
        }
        return this.createSampleModel(n3, n2, nArray, bl, this.tileWidth, this.tileHeight);
    }

    private SampleModel createSampleModel(int n, int n2, int[] nArray, boolean bl, int n3, int n4) {
        SampleModel sampleModel = null;
        if (n == 1 && (n2 == 1 || n2 == 2 || n2 == 4)) {
            sampleModel = new MultiPixelPackedSampleModel(0, n3, n4, n2);
        } else if (n2 <= 8) {
            sampleModel = new PixelInterleavedSampleModel(0, n3, n4, n, n3 * n, nArray);
        } else if (n2 <= 16) {
            sampleModel = new PixelInterleavedSampleModel(bl ? 2 : 1, n3, n4, n, n3 * n, nArray);
        } else if (n2 <= 32) {
            sampleModel = new PixelInterleavedSampleModel(3, n3, n4, this.nComp, n3 * this.nComp, nArray);
        } else {
            throw new IllegalArgumentException(I18N.getString("J2KReadState11") + " " + n2);
        }
        return sampleModel;
    }

    private ColorModel createColorModel() throws IOException {
        Object[] objectArray;
        Object[] objectArray2;
        int n;
        Object object;
        if (this.colorModel != null) {
            return this.colorModel;
        }
        PaletteBox paletteBox = (PaletteBox)this.metadata.getElement("JPEG2000PaletteBox");
        ChannelDefinitionBox channelDefinitionBox = (ChannelDefinitionBox)this.metadata.getElement("JPEG2000ChannelDefinitionBox");
        if (paletteBox != null && this.nComp == 1) {
            object = paletteBox.getLUT();
            n = paletteBox.getNumComp();
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = i;
            }
            ComponentMappingBox componentMappingBox = (ComponentMappingBox)this.metadata.getElement("JPEG2000ComponentMappingBox");
            short[] sArray = null;
            objectArray2 = null;
            objectArray = null;
            if (componentMappingBox != null) {
                sArray = componentMappingBox.getComponent();
                objectArray2 = componentMappingBox.getComponentType();
                objectArray = componentMappingBox.getComponentAssociation();
            }
            if (sArray != null) {
                for (int i = 0; i < n; ++i) {
                    if (objectArray2[i] != 1) continue;
                    nArray[i] = objectArray[i];
                }
            }
            if (n == 3) {
                this.colorModel = new IndexColorModel(this.sampleModel.getSampleSize(0), ((Object)object[0]).length, (byte[])object[nArray[0]], (byte[])object[nArray[1]], (byte[])object[nArray[2]]);
            } else if (n == 4) {
                this.colorModel = new IndexColorModel(this.sampleModel.getSampleSize(0), ((Object)object[0]).length, (byte[])object[nArray[0]], (byte[])object[nArray[1]], (byte[])object[nArray[2]], (byte[])object[nArray[3]]);
            }
        } else if (channelDefinitionBox != null) {
            int n2;
            int n3;
            object = (HeaderBox)this.metadata.getElement("JPEG2000HeaderBox");
            n = ((HeaderBox)object).getNumComponents();
            byte by = ((HeaderBox)object).getBitDepth();
            boolean bl = false;
            int n4 = n - 1;
            objectArray2 = channelDefinitionBox.getChannel();
            objectArray = channelDefinitionBox.getTypes();
            short[] sArray = channelDefinitionBox.getAssociation();
            for (int i = 0; i < objectArray2.length; ++i) {
                if (objectArray[i] != 1 || objectArray2[i] != n4) continue;
                bl = true;
            }
            boolean[] blArray = new boolean[]{false};
            if (bl) {
                int n5;
                blArray = new boolean[n4];
                for (n5 = 0; n5 < n4; ++n5) {
                    blArray[n5] = false;
                }
                for (n5 = 0; n5 < objectArray2.length; ++n5) {
                    if (objectArray[n5] != 2) continue;
                    blArray[sArray[n5] - 1] = true;
                }
                for (n5 = 1; n5 < n4; ++n5) {
                    blArray[0] = blArray[0] & blArray[n5];
                }
            }
            ColorSpecificationBox colorSpecificationBox = (ColorSpecificationBox)this.metadata.getElement("JPEG2000ColorSpecificationBox");
            ICC_Profile iCC_Profile = null;
            int n6 = 0;
            if (colorSpecificationBox != null) {
                iCC_Profile = colorSpecificationBox.getICCProfile();
                n6 = colorSpecificationBox.getEnumeratedColorSpace();
            }
            ColorSpace colorSpace = null;
            if (iCC_Profile != null) {
                colorSpace = new ICC_ColorSpace(iCC_Profile);
            } else if (n6 == 16) {
                colorSpace = ColorSpace.getInstance(1000);
            } else if (n6 == 17) {
                colorSpace = ColorSpace.getInstance(1003);
            } else if (n6 == 18) {
                colorSpace = ColorSpace.getInstance(1002);
            }
            byte[] byArray = null;
            boolean bl2 = (by & 0x80) == 128;
            BitsPerComponentBox bitsPerComponentBox = (BitsPerComponentBox)this.metadata.getElement("JPEG2000BitsPerComponentBox");
            if (bitsPerComponentBox != null) {
                byArray = bitsPerComponentBox.getBitDepth();
            }
            int[] nArray = new int[n];
            for (n3 = 0; n3 < n; ++n3) {
                nArray[n3] = byArray != null ? (byArray[n3] & 0x7F) + 1 : (by & 0x7F) + 1;
            }
            n3 = 1 + (by & 0x7F);
            if (byArray != null) {
                for (n2 = 0; n2 < n; ++n2) {
                    if (nArray[n2] <= n3) continue;
                    n3 = nArray[n2];
                }
            }
            n2 = -1;
            if (n3 <= 8) {
                n2 = 0;
            } else if (n3 <= 16) {
                n2 = bl2 ? 2 : 1;
            } else if (n3 <= 32) {
                n2 = 3;
            }
            if (n2 == -1) {
                return null;
            }
            if (colorSpace != null) {
                this.colorModel = new ComponentColorModel(colorSpace, nArray, bl, blArray[0], bl ? 3 : 1, n2);
            }
        }
        if (this.colorModel != null) {
            return this.colorModel;
        }
        if (this.nComp <= 4) {
            int n7;
            object = this.nComp > 2 ? ColorSpace.getInstance(1000) : ColorSpace.getInstance(1003);
            int[] nArray = new int[this.nComp];
            boolean bl = false;
            int n8 = -1;
            for (n7 = 0; n7 < this.nComp; n7 += 1) {
                nArray[n7] = (this.compParam.depth & 0x7F) + 1;
                if (n8 < nArray[n7]) {
                    n8 = nArray[n7];
                }
                bl |= (this.compParam.depth & 0x80) != 0;
            }
            n7 = this.nComp % 2 == 0 ? 1 : 0;
            int n9 = -1;
            if (n8 <= 8) {
                n9 = 0;
            } else if (n8 <= 16) {
                n9 = bl ? 2 : 1;
            } else if (n8 <= 32) {
                n9 = 3;
            }
            if (n9 != -1) {
                this.colorModel = this.nComp == 1 && (n8 == 1 || n8 == 2 || n8 == 4) ? ImageUtil.createColorModel(this.getSampleModel()) : new ComponentColorModel((ColorSpace)object, nArray, n7 != 0, false, n7 != 0 ? 3 : 1, n9);
                return this.colorModel;
            }
        }
        return ImageUtil.createColorModel(null, this.getSampleModel());
    }

    public J2KMetadata readImageMetadata() throws IOException {
        if (this.metadata == null) {
            this.metadata = new J2KMetadata();
            com.sun.medialib.codec.jp2k.Box box = null;
            Box box2 = null;
            while ((box = this.decoder.decodeBox()) != null) {
                box2 = null;
                Class clazz = Box.getBoxClass(box.type);
                if (clazz != null) {
                    try {
                        Constructor constructor = clazz.getConstructor(array$B == null ? J2KRenderedImageCodecLib.class$("[B") : array$B);
                        if (constructor != null) {
                            box2 = (Box)constructor.newInstance(new Object[]{box.data});
                        }
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        try {
                            Constructor constructor = clazz.getConstructor(Integer.TYPE, array$B == null ? J2KRenderedImageCodecLib.class$("[B") : array$B);
                            if (constructor != null) {
                                box2 = (Box)constructor.newInstance(new Integer(box.type), box.data);
                            }
                        }
                        catch (NoSuchMethodException noSuchMethodException2) {
                            box2 = this.createUnknowBox(box);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            box2 = this.createUnknowBox(box);
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            box2 = this.createUnknowBox(box);
                        }
                        catch (InstantiationException instantiationException) {
                            box2 = this.createUnknowBox(box);
                        }
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        box2 = this.createUnknowBox(box);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        box2 = this.createUnknowBox(box);
                    }
                    catch (InstantiationException instantiationException) {
                        box2 = this.createUnknowBox(box);
                    }
                } else if (box.data != null) {
                    box2 = this.createUnknowBox(box);
                }
                if (box2 == null) continue;
                this.metadata.addNode(box2);
            }
        }
        return this.metadata;
    }

    private Box createUnknowBox(com.sun.medialib.codec.jp2k.Box box) {
        return new Box(8 + box.data.length, box.type, box.data);
    }
}

