/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.medialib.codec.jiio.Util;
import com.sun.medialib.codec.jiio.mediaLibImage;
import java.awt.Rectangle;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;

public class MediaLibAccessor {
    private static final int COPY_MASK_SHIFT = 7;
    private static final int COPY_MASK_SIZE = 1;
    public static final int COPY_MASK = 128;
    public static final int UNCOPIED = 0;
    public static final int COPIED = 128;
    public static final int DATATYPE_MASK = 127;
    private static final int BINARY_MASK_SHIFT = 8;
    private static final int BINARY_MASK_SIZE = 1;
    public static final int BINARY_MASK = 256;
    public static final int NONBINARY = 0;
    public static final int BINARY = 256;
    public static final int TAG_BYTE_UNCOPIED = 0;
    public static final int TAG_USHORT_UNCOPIED = 1;
    public static final int TAG_SHORT_UNCOPIED = 2;
    public static final int TAG_INT_UNCOPIED = 3;
    public static final int TAG_FLOAT_UNCOPIED = 4;
    public static final int TAG_DOUBLE_UNCOPIED = 5;
    public static final int TAG_BYTE_COPIED = 128;
    public static final int TAG_USHORT_COPIED = 129;
    public static final int TAG_SHORT_COPIED = 130;
    public static final int TAG_INT_COPIED = 131;
    public static final int TAG_FLOAT_COPIED = 132;
    public static final int TAG_DOUBLE_COPIED = 133;
    protected Raster raster;
    protected Rectangle rect;
    protected int numBands;
    protected int[] bandOffsets;
    protected int formatTag;
    protected mediaLibImage[] mlimages = null;
    private boolean areBinaryDataPacked = false;

    public static int findCompatibleTag(Raster raster) {
        SampleModel sampleModel = raster.getSampleModel();
        int n = sampleModel.getDataType();
        int n2 = sampleModel.getDataType();
        boolean bl = sampleModel instanceof ComponentSampleModel;
        boolean bl2 = ImageUtil.isBinary(sampleModel);
        if (bl2) {
            return 256;
        }
        if (!(bl || n2 != 0 && n2 != 1 && n2 != 2)) {
            n2 = 3;
        }
        int n3 = n2 | 0x80;
        if (!bl) {
            return n3;
        }
        if (MediaLibAccessor.isPixelSequential(sampleModel)) {
            return n | 0;
        }
        return n3;
    }

    public static boolean isPixelSequential(SampleModel sampleModel) {
        ComponentSampleModel componentSampleModel = null;
        if (!(sampleModel instanceof ComponentSampleModel)) {
            return false;
        }
        componentSampleModel = (ComponentSampleModel)sampleModel;
        int n = componentSampleModel.getPixelStride();
        int[] nArray = componentSampleModel.getBandOffsets();
        int[] nArray2 = componentSampleModel.getBankIndices();
        if (n != nArray.length) {
            return false;
        }
        if (n != sampleModel.getNumBands()) {
            return false;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] >= n || nArray2[i] != nArray2[0]) {
                return false;
            }
            for (int j = i + 1; j < nArray.length; ++j) {
                if (nArray[i] == nArray[j]) {
                    return false;
                }
                if (nArray[i] == i) continue;
                return false;
            }
        }
        return true;
    }

    public static int getMediaLibDataType(int n) {
        int n2 = n & 0x7F;
        switch (n2) {
            case 0: {
                return 1;
            }
            case 1: {
                return 6;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 5: {
                return 5;
            }
            case 4: {
                return 4;
            }
        }
        return -1;
    }

    public MediaLibAccessor(Raster raster, Rectangle rectangle, int n, boolean bl) {
        this.areBinaryDataPacked = bl;
        this.raster = raster;
        this.rect = new Rectangle(rectangle);
        this.formatTag = n;
        if (this.isBinary()) {
            byte[] byArray;
            int n2;
            int n3;
            this.numBands = 1;
            this.bandOffsets = new int[]{0};
            this.mlimages = new mediaLibImage[1];
            if (this.areBinaryDataPacked) {
                n3 = 0;
                n2 = (rectangle.width + 7) / 8;
                byArray = ImageUtil.getPackedBinaryData(raster, rectangle);
                this.formatTag = byArray == ((DataBufferByte)raster.getDataBuffer()).getData() ? (this.formatTag |= 0) : (this.formatTag |= 0x80);
            } else {
                n3 = 1;
                n2 = rectangle.width;
                byArray = ImageUtil.getUnpackedBinaryData(raster, rectangle);
                this.formatTag |= 0x80;
            }
            this.mlimages[0] = new mediaLibImage(n3, 1, rectangle.width, rectangle.height, n2, 0, (Object)byArray);
            return;
        }
        if ((n & 0x80) == 0) {
            ComponentSampleModel componentSampleModel = (ComponentSampleModel)raster.getSampleModel();
            this.numBands = componentSampleModel.getNumBands();
            this.bandOffsets = componentSampleModel.getBandOffsets();
            int n4 = raster.getDataBuffer().getOffset();
            n4 += (rectangle.y - raster.getSampleModelTranslateY()) * componentSampleModel.getScanlineStride() + (rectangle.x - raster.getSampleModelTranslateX()) * componentSampleModel.getPixelStride();
            int n5 = componentSampleModel.getScanlineStride();
            switch (n & 0x7F) {
                case 0: {
                    DataBufferByte dataBufferByte = (DataBufferByte)raster.getDataBuffer();
                    this.mlimages = new mediaLibImage[1];
                    this.mlimages[0] = new mediaLibImage(1, this.numBands, rectangle.width, rectangle.height, n5, n4, (Object)dataBufferByte.getData());
                    break;
                }
                case 1: {
                    DataBufferUShort dataBufferUShort = (DataBufferUShort)raster.getDataBuffer();
                    this.mlimages = new mediaLibImage[1];
                    this.mlimages[0] = new mediaLibImage(6, this.numBands, rectangle.width, rectangle.height, n5, n4, (Object)dataBufferUShort.getData());
                    break;
                }
                case 2: {
                    DataBufferShort dataBufferShort = (DataBufferShort)raster.getDataBuffer();
                    this.mlimages = new mediaLibImage[1];
                    this.mlimages[0] = new mediaLibImage(2, this.numBands, rectangle.width, rectangle.height, n5, n4, (Object)dataBufferShort.getData());
                    break;
                }
                case 3: {
                    DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
                    this.mlimages = new mediaLibImage[1];
                    this.mlimages[0] = new mediaLibImage(3, this.numBands, rectangle.width, rectangle.height, n5, n4, (Object)dataBufferInt.getData());
                    break;
                }
                case 4: {
                    DataBufferFloat dataBufferFloat = (DataBufferFloat)raster.getDataBuffer();
                    this.mlimages = new mediaLibImage[1];
                    this.mlimages[0] = new mediaLibImage(4, this.numBands, rectangle.width, rectangle.height, n5, n4, (Object)dataBufferFloat.getData());
                    break;
                }
                case 5: {
                    DataBufferDouble dataBufferDouble = (DataBufferDouble)raster.getDataBuffer();
                    this.mlimages = new mediaLibImage[1];
                    this.mlimages[0] = new mediaLibImage(5, this.numBands, rectangle.width, rectangle.height, n5, n4, (Object)dataBufferDouble.getData());
                    break;
                }
                default: {
                    throw new IllegalArgumentException((n & 0x7F) + "MediaLibAccessor does not recognize this datatype.");
                }
            }
        } else {
            int n6;
            this.numBands = raster.getNumBands();
            this.bandOffsets = new int[this.numBands];
            for (n6 = 0; n6 < this.numBands; ++n6) {
                this.bandOffsets[n6] = n6;
            }
            n6 = rectangle.width * this.numBands;
            switch (n & 0x7F) {
                case 0: {
                    byte[] byArray = new byte[rectangle.width * rectangle.height * this.numBands];
                    this.mlimages = new mediaLibImage[1];
                    this.mlimages[0] = new mediaLibImage(1, this.numBands, rectangle.width, rectangle.height, n6, 0, (Object)byArray);
                    break;
                }
                case 1: {
                    short[] sArray = new short[rectangle.width * rectangle.height * this.numBands];
                    this.mlimages = new mediaLibImage[1];
                    this.mlimages[0] = new mediaLibImage(6, this.numBands, rectangle.width, rectangle.height, n6, 0, (Object)sArray);
                    break;
                }
                case 2: {
                    short[] sArray = new short[rectangle.width * rectangle.height * this.numBands];
                    this.mlimages = new mediaLibImage[1];
                    this.mlimages[0] = new mediaLibImage(2, this.numBands, rectangle.width, rectangle.height, n6, 0, (Object)sArray);
                    break;
                }
                case 3: {
                    int[] nArray = new int[rectangle.width * rectangle.height * this.numBands];
                    this.mlimages = new mediaLibImage[1];
                    this.mlimages[0] = new mediaLibImage(3, this.numBands, rectangle.width, rectangle.height, n6, 0, (Object)nArray);
                    break;
                }
                case 4: {
                    float[] fArray = new float[rectangle.width * rectangle.height * this.numBands];
                    this.mlimages = new mediaLibImage[1];
                    this.mlimages[0] = new mediaLibImage(4, this.numBands, rectangle.width, rectangle.height, n6, 0, (Object)fArray);
                    break;
                }
                case 5: {
                    double[] dArray = new double[rectangle.width * rectangle.height * this.numBands];
                    this.mlimages = new mediaLibImage[1];
                    this.mlimages[0] = new mediaLibImage(5, this.numBands, rectangle.width, rectangle.height, n6, 0, (Object)dArray);
                    break;
                }
                default: {
                    throw new IllegalArgumentException((n & 0x7F) + "MediaLibAccessor does not recognize this datatype.");
                }
            }
            this.copyDataFromRaster();
        }
    }

    public boolean isBinary() {
        return (this.formatTag & 0x100) == 256;
    }

    public mediaLibImage[] getMediaLibImages() {
        return this.mlimages;
    }

    public int getDataType() {
        return this.formatTag & 0x7F;
    }

    public boolean isDataCopy() {
        return (this.formatTag & 0x80) == 128;
    }

    public int[] getBandOffsets() {
        return this.bandOffsets;
    }

    public int[] getIntParameters(int n, int[] nArray) {
        int[] nArray2 = new int[this.numBands];
        for (int i = 0; i < this.numBands; ++i) {
            nArray2[i] = nArray[this.bandOffsets[i + n]];
        }
        return nArray2;
    }

    public int[][] getIntArrayParameters(int n, int[][] nArray) {
        int[][] nArrayArray = new int[this.numBands][];
        for (int i = 0; i < this.numBands; ++i) {
            nArrayArray[i] = nArray[this.bandOffsets[i + n]];
        }
        return nArrayArray;
    }

    public double[] getDoubleParameters(int n, double[] dArray) {
        double[] dArray2 = new double[this.numBands];
        for (int i = 0; i < this.numBands; ++i) {
            dArray2[i] = dArray[this.bandOffsets[i + n]];
        }
        return dArray2;
    }

    private void copyDataFromRaster() {
        if (this.raster.getSampleModel() instanceof ComponentSampleModel) {
            int n;
            Object object;
            int n2;
            ComponentSampleModel componentSampleModel = (ComponentSampleModel)this.raster.getSampleModel();
            int n3 = componentSampleModel.getScanlineStride();
            int n4 = componentSampleModel.getPixelStride();
            int n5 = (this.rect.y - this.raster.getSampleModelTranslateY()) * n3 + (this.rect.x - this.raster.getSampleModelTranslateX()) * n4;
            int[] nArray = componentSampleModel.getBankIndices();
            int[] nArray2 = componentSampleModel.getBandOffsets();
            int[] nArray3 = this.raster.getDataBuffer().getOffsets();
            if (nArray3.length == 1) {
                n2 = 0;
                while (n2 < this.numBands) {
                    int n6 = n2++;
                    nArray2[n6] = nArray2[n6] + (nArray3[0] + n5);
                }
            } else if (nArray3.length == nArray2.length) {
                for (n2 = 0; n2 < this.numBands; ++n2) {
                    int n7 = n2;
                    nArray2[n7] = nArray2[n7] + (nArray3[n2] + n5);
                }
            }
            Object object2 = null;
            switch (this.getDataType()) {
                case 0: {
                    object = new byte[this.numBands][];
                    for (int i = 0; i < this.numBands; ++i) {
                        object[i] = this.mlimages[0].getByteData();
                    }
                    object2 = object;
                    break;
                }
                case 1: {
                    short[][] sArrayArray = new short[this.numBands][];
                    for (int i = 0; i < this.numBands; ++i) {
                        sArrayArray[i] = this.mlimages[0].getUShortData();
                    }
                    object2 = sArrayArray;
                    break;
                }
                case 2: {
                    short[][] sArrayArray = new short[this.numBands][];
                    for (n = 0; n < this.numBands; ++n) {
                        sArrayArray[n] = this.mlimages[0].getShortData();
                    }
                    object2 = sArrayArray;
                    break;
                }
                case 3: {
                    int[][] nArrayArray = new int[this.numBands][];
                    for (int i = 0; i < this.numBands; ++i) {
                        nArrayArray[i] = this.mlimages[0].getIntData();
                    }
                    object2 = nArrayArray;
                    break;
                }
                case 4: {
                    float[][] fArrayArray = new float[this.numBands][];
                    for (int i = 0; i < this.numBands; ++i) {
                        fArrayArray[i] = this.mlimages[0].getFloatData();
                    }
                    object2 = fArrayArray;
                    break;
                }
                case 5: {
                    double[][] dArrayArray = new double[this.numBands][];
                    for (int i = 0; i < this.numBands; ++i) {
                        dArrayArray[i] = this.mlimages[0].getDoubleData();
                    }
                    object2 = dArrayArray;
                }
            }
            object = null;
            switch (componentSampleModel.getDataType()) {
                case 0: {
                    DataBufferByte dataBufferByte = (DataBufferByte)this.raster.getDataBuffer();
                    byte[][] byArrayArray = new byte[this.numBands][];
                    for (n = 0; n < this.numBands; ++n) {
                        byArrayArray[n] = dataBufferByte.getData(nArray[n]);
                    }
                    object = byArrayArray;
                    break;
                }
                case 1: {
                    DataBufferUShort dataBufferUShort = (DataBufferUShort)this.raster.getDataBuffer();
                    short[][] sArrayArray = new short[this.numBands][];
                    for (n = 0; n < this.numBands; ++n) {
                        sArrayArray[n] = dataBufferUShort.getData(nArray[n]);
                    }
                    object = sArrayArray;
                    break;
                }
                case 2: {
                    DataBufferShort dataBufferShort = (DataBufferShort)this.raster.getDataBuffer();
                    short[][] sArrayArray = new short[this.numBands][];
                    for (n = 0; n < this.numBands; ++n) {
                        sArrayArray[n] = dataBufferShort.getData(nArray[n]);
                    }
                    object = sArrayArray;
                    break;
                }
                case 3: {
                    DataBufferInt dataBufferInt = (DataBufferInt)this.raster.getDataBuffer();
                    int[][] nArrayArray = new int[this.numBands][];
                    for (n = 0; n < this.numBands; ++n) {
                        nArrayArray[n] = dataBufferInt.getData(nArray[n]);
                    }
                    object = nArrayArray;
                    break;
                }
                case 4: {
                    DataBufferFloat dataBufferFloat = (DataBufferFloat)this.raster.getDataBuffer();
                    float[][] fArrayArray = new float[this.numBands][];
                    for (n = 0; n < this.numBands; ++n) {
                        fArrayArray[n] = dataBufferFloat.getData(nArray[n]);
                    }
                    object = fArrayArray;
                    break;
                }
                case 5: {
                    DataBufferDouble dataBufferDouble = (DataBufferDouble)this.raster.getDataBuffer();
                    double[][] dArrayArray = new double[this.numBands][];
                    for (n = 0; n < this.numBands; ++n) {
                        dArrayArray[n] = dataBufferDouble.getData(nArray[n]);
                    }
                    object = dArrayArray;
                }
            }
            Util.Reformat((Object)object2, (Object)object, (int)this.numBands, (int)this.rect.width, (int)this.rect.height, (int)MediaLibAccessor.getMediaLibDataType(this.getDataType()), (int[])this.bandOffsets, (int)(this.rect.width * this.numBands), (int)this.numBands, (int)MediaLibAccessor.getMediaLibDataType(componentSampleModel.getDataType()), (int[])nArray2, (int)n3, (int)n4);
        } else {
            switch (this.getDataType()) {
                case 3: {
                    this.raster.getPixels(this.rect.x, this.rect.y, this.rect.width, this.rect.height, this.mlimages[0].getIntData());
                    break;
                }
                case 4: {
                    this.raster.getPixels(this.rect.x, this.rect.y, this.rect.width, this.rect.height, this.mlimages[0].getFloatData());
                    break;
                }
                case 5: {
                    this.raster.getPixels(this.rect.x, this.rect.y, this.rect.width, this.rect.height, this.mlimages[0].getDoubleData());
                }
            }
        }
    }

    public void copyDataToRaster(int[] nArray) {
        if (this.isDataCopy()) {
            if (this.isBinary()) {
                if (this.areBinaryDataPacked) {
                    ImageUtil.setPackedBinaryData(this.mlimages[0].getBitData(), (WritableRaster)this.raster, this.rect);
                } else {
                    ImageUtil.setUnpackedBinaryData(this.mlimages[0].getByteData(), (WritableRaster)this.raster, this.rect);
                }
                return;
            }
            WritableRaster writableRaster = (WritableRaster)this.raster;
            if (writableRaster.getSampleModel() instanceof ComponentSampleModel) {
                int n;
                int n2;
                Object object;
                int n3;
                ComponentSampleModel componentSampleModel = (ComponentSampleModel)writableRaster.getSampleModel();
                int n4 = componentSampleModel.getScanlineStride();
                int n5 = componentSampleModel.getPixelStride();
                int n6 = (this.rect.y - this.raster.getSampleModelTranslateY()) * n4 + (this.rect.x - this.raster.getSampleModelTranslateX()) * n5;
                int[] nArray2 = componentSampleModel.getBankIndices();
                int[] nArray3 = componentSampleModel.getBandOffsets();
                int[] nArray4 = this.raster.getDataBuffer().getOffsets();
                if (nArray4.length == 1) {
                    n3 = 0;
                    while (n3 < this.numBands) {
                        int n7 = n3++;
                        nArray3[n7] = nArray3[n7] + (nArray4[0] + n6);
                    }
                } else if (nArray4.length == nArray3.length) {
                    for (n3 = 0; n3 < this.numBands; ++n3) {
                        int n8 = n3;
                        nArray3[n8] = nArray3[n8] + (nArray4[n3] + n6);
                    }
                }
                Object object2 = null;
                switch (this.getDataType()) {
                    case 0: {
                        object = new byte[this.numBands][];
                        for (int i = 0; i < this.numBands; ++i) {
                            object[i] = this.mlimages[0].getByteData();
                        }
                        object2 = object;
                        break;
                    }
                    case 1: {
                        short[][] sArrayArray = new short[this.numBands][];
                        for (int i = 0; i < this.numBands; ++i) {
                            sArrayArray[i] = this.mlimages[0].getUShortData();
                        }
                        object2 = sArrayArray;
                        break;
                    }
                    case 2: {
                        short[][] sArrayArray = new short[this.numBands][];
                        for (n2 = 0; n2 < this.numBands; ++n2) {
                            sArrayArray[n2] = this.mlimages[0].getShortData();
                        }
                        object2 = sArrayArray;
                        break;
                    }
                    case 3: {
                        int[][] nArrayArray = new int[this.numBands][];
                        for (n = 0; n < this.numBands; ++n) {
                            nArrayArray[n] = this.mlimages[0].getIntData();
                        }
                        object2 = nArrayArray;
                        break;
                    }
                    case 4: {
                        float[][] fArrayArray = new float[this.numBands][];
                        for (int i = 0; i < this.numBands; ++i) {
                            fArrayArray[i] = this.mlimages[0].getFloatData();
                        }
                        object2 = fArrayArray;
                        break;
                    }
                    case 5: {
                        double[][] dArrayArray = new double[this.numBands][];
                        for (int i = 0; i < this.numBands; ++i) {
                            dArrayArray[i] = this.mlimages[0].getDoubleData();
                        }
                        object2 = dArrayArray;
                    }
                }
                object = null;
                Object object3 = null;
                switch (componentSampleModel.getDataType()) {
                    case 0: {
                        DataBufferByte dataBufferByte = (DataBufferByte)this.raster.getDataBuffer();
                        byte[][] byArrayArray = new byte[this.numBands][];
                        for (n = 0; n < this.numBands; ++n) {
                            byArrayArray[n] = dataBufferByte.getData(nArray2[n]);
                        }
                        object = byArrayArray[0];
                        object3 = byArrayArray;
                        break;
                    }
                    case 1: {
                        DataBufferUShort dataBufferUShort = (DataBufferUShort)this.raster.getDataBuffer();
                        short[][] sArrayArray = new short[this.numBands][];
                        for (n = 0; n < this.numBands; ++n) {
                            sArrayArray[n] = dataBufferUShort.getData(nArray2[n]);
                        }
                        object3 = sArrayArray;
                        break;
                    }
                    case 2: {
                        DataBufferShort dataBufferShort = (DataBufferShort)this.raster.getDataBuffer();
                        short[][] sArrayArray = new short[this.numBands][];
                        for (n = 0; n < this.numBands; ++n) {
                            sArrayArray[n] = dataBufferShort.getData(nArray2[n]);
                        }
                        object3 = sArrayArray;
                        break;
                    }
                    case 3: {
                        DataBufferInt dataBufferInt = (DataBufferInt)this.raster.getDataBuffer();
                        int[][] nArrayArray = new int[this.numBands][];
                        for (n = 0; n < this.numBands; ++n) {
                            nArrayArray[n] = dataBufferInt.getData(nArray2[n]);
                        }
                        object3 = nArrayArray;
                        break;
                    }
                    case 4: {
                        DataBufferFloat dataBufferFloat = (DataBufferFloat)this.raster.getDataBuffer();
                        float[][] fArrayArray = new float[this.numBands][];
                        for (n = 0; n < this.numBands; ++n) {
                            fArrayArray[n] = dataBufferFloat.getData(nArray2[n]);
                        }
                        object3 = fArrayArray;
                        break;
                    }
                    case 5: {
                        DataBufferDouble dataBufferDouble = (DataBufferDouble)this.raster.getDataBuffer();
                        double[][] dArrayArray = new double[this.numBands][];
                        for (n = 0; n < this.numBands; ++n) {
                            dArrayArray[n] = dataBufferDouble.getData(nArray2[n]);
                        }
                        object3 = dArrayArray;
                    }
                }
                int[] nArray5 = (int[])this.bandOffsets.clone();
                if (nArray != null) {
                    for (n2 = 0; n2 < nArray5.length; ++n2) {
                        nArray5[n2] = nArray[nArray5[n2]];
                    }
                }
                Util.Reformat((Object)object3, (Object)object2, (int)this.numBands, (int)this.rect.width, (int)this.rect.height, (int)MediaLibAccessor.getMediaLibDataType(componentSampleModel.getDataType()), (int[])nArray3, (int)n4, (int)n5, (int)MediaLibAccessor.getMediaLibDataType(this.getDataType()), (int[])nArray5, (int)(this.rect.width * this.numBands), (int)this.numBands);
            } else {
                switch (this.getDataType()) {
                    case 3: {
                        writableRaster.setPixels(this.rect.x, this.rect.y, this.rect.width, this.rect.height, this.mlimages[0].getIntData());
                        break;
                    }
                    case 4: {
                        writableRaster.setPixels(this.rect.x, this.rect.y, this.rect.width, this.rect.height, this.mlimages[0].getFloatData());
                        break;
                    }
                    case 5: {
                        writableRaster.setPixels(this.rect.x, this.rect.y, this.rect.width, this.rect.height, this.mlimages[0].getDoubleData());
                    }
                }
            }
        }
    }

    public void clampDataArrays() {
        int n;
        if (!this.isDataCopy()) {
            return;
        }
        if (this.raster.getSampleModel() instanceof ComponentSampleModel) {
            return;
        }
        int[] nArray = this.raster.getSampleModel().getSampleSize();
        boolean bl = false;
        boolean bl2 = true;
        for (n = 0; n < nArray.length; ++n) {
            int n2 = nArray[0];
            if (nArray[n] < 32) {
                bl = true;
            }
            if (nArray[n] == n2) continue;
            bl2 = false;
        }
        if (!bl) {
            return;
        }
        n = this.raster.getDataBuffer().getDataType();
        double[] dArray = new double[nArray.length];
        double[] dArray2 = new double[nArray.length];
        if (n == 1 && bl2 && nArray[0] == 16) {
            for (int i = 0; i < nArray.length; ++i) {
                dArray[i] = 65535.0;
                dArray2[i] = 0.0;
            }
        } else if (n == 2 && bl2 && nArray[0] == 16) {
            for (int i = 0; i < nArray.length; ++i) {
                dArray[i] = 32767.0;
                dArray2[i] = -32768.0;
            }
        } else if (n == 3 && bl2 && nArray[0] == 32) {
            for (int i = 0; i < nArray.length; ++i) {
                dArray[i] = 2.147483647E9;
                dArray2[i] = -2.147483648E9;
            }
        } else {
            for (int i = 0; i < nArray.length; ++i) {
                dArray[i] = (1 << nArray[i]) - 1;
                dArray2[i] = 0.0;
            }
        }
        this.clampDataArray(dArray, dArray2);
    }

    private void clampDataArray(double[] dArray, double[] dArray2) {
        switch (this.getDataType()) {
            case 3: {
                this.clampIntArrays(this.toIntArray(dArray), this.toIntArray(dArray2));
                break;
            }
            case 4: {
                this.clampFloatArrays(this.toFloatArray(dArray), this.toFloatArray(dArray2));
                break;
            }
            case 5: {
                this.clampDoubleArrays(dArray, dArray2);
            }
        }
    }

    private int[] toIntArray(double[] dArray) {
        int[] nArray = new int[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            nArray[i] = (int)dArray[i];
        }
        return nArray;
    }

    private float[] toFloatArray(double[] dArray) {
        float[] fArray = new float[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            fArray[i] = (float)dArray[i];
        }
        return fArray;
    }

    private void clampIntArrays(int[] nArray, int[] nArray2) {
        int n = this.rect.width;
        int n2 = this.rect.height;
        int n3 = this.numBands * n;
        for (int i = 0; i < this.numBands; ++i) {
            int[] nArray3 = this.mlimages[0].getIntData();
            int n4 = i;
            int n5 = nArray[i];
            int n6 = nArray2[i];
            for (int j = 0; j < n2; ++j) {
                int n7 = n4;
                for (int k = 0; k < n; ++k) {
                    int n8 = nArray3[n7];
                    if (n8 < n6) {
                        nArray3[n7] = n6;
                    } else if (n8 > n5) {
                        nArray3[n7] = n5;
                    }
                    n7 += this.numBands;
                }
                n4 += n3;
            }
        }
    }

    private void clampFloatArrays(float[] fArray, float[] fArray2) {
        int n = this.rect.width;
        int n2 = this.rect.height;
        int n3 = this.numBands * n;
        for (int i = 0; i < this.numBands; ++i) {
            float[] fArray3 = this.mlimages[0].getFloatData();
            int n4 = i;
            float f2 = fArray[i];
            float f3 = fArray2[i];
            for (int j = 0; j < n2; ++j) {
                int n5 = n4;
                for (int k = 0; k < n; ++k) {
                    float f4 = fArray3[n5];
                    if (f4 < f3) {
                        fArray3[n5] = f3;
                    } else if (f4 > f2) {
                        fArray3[n5] = f2;
                    }
                    n5 += this.numBands;
                }
                n4 += n3;
            }
        }
    }

    private void clampDoubleArrays(double[] dArray, double[] dArray2) {
        int n = this.rect.width;
        int n2 = this.rect.height;
        int n3 = this.numBands * n;
        for (int i = 0; i < this.numBands; ++i) {
            double[] dArray3 = this.mlimages[0].getDoubleData();
            int n4 = i;
            double d2 = dArray[i];
            double d3 = dArray2[i];
            for (int j = 0; j < n2; ++j) {
                int n5 = n4;
                for (int k = 0; k < n; ++k) {
                    double d4 = dArray3[n5];
                    if (d4 < d3) {
                        dArray3[n5] = d3;
                    } else if (d4 > d2) {
                        dArray3[n5] = d2;
                    }
                    n5 += this.numBands;
                }
                n4 += n3;
            }
        }
    }
}

