/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.png;

import com.sun.media.imageioimpl.plugins.png.CLibPNGImageReader;
import com.sun.medialib.codec.jiio.mediaLibImage;
import com.sun.medialib.codec.png.Decoder;
import com.sun.medialib.codec.png.Encoder;
import com.sun.medialib.codec.png.PNGChunk;
import com.sun.medialib.codec.png.PNGTextualData;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.SampleModel;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.imageio.IIOException;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.w3c.dom.Node;

public class CLibPNGMetadata
extends IIOMetadata
implements Cloneable {
    public static final String nativeMetadataFormatName = "javax_imageio_png_1.0";
    protected static final String nativeMetadataFormatClassName = "com.sun.media.imageioimpl.plugins.png.CLibPNGMetadataFormat";
    public static final String[] IHDR_colorTypeNames = new String[]{"Grayscale", null, "RGB", "Palette", "GrayAlpha", null, "RGBAlpha"};
    public static final int[] IHDR_numChannels = new int[]{1, 0, 3, 3, 2, 0, 4};
    public static final String[] IHDR_bitDepths = new String[]{"1", "2", "4", "8", "16"};
    public static final String[] IHDR_compressionMethodNames = new String[]{"deflate"};
    public static final String[] IHDR_filterMethodNames = new String[]{"adaptive"};
    public static final String[] IHDR_interlaceMethodNames = new String[]{"none", "adam7"};
    public static final String[] iCCP_compressionMethodNames = new String[]{"deflate"};
    public static final String[] zTXt_compressionMethodNames = new String[]{"deflate"};
    public static final int PHYS_UNIT_UNKNOWN = 0;
    public static final int PHYS_UNIT_METER = 1;
    public static final String[] unitSpecifierNames = new String[]{"unknown", "meter"};
    public static final String[] renderingIntentNames = new String[]{"Perceptual", "Relative colorimetric", "Saturation", "Absolute colorimetric"};
    public static final String[] colorSpaceTypeNames = new String[]{"GRAY", null, "RGB", "RGB", "GRAY", null, "RGB"};
    static final int IHDR_TYPE = CLibPNGMetadata.chunkType("IHDR");
    static final int PLTE_TYPE = CLibPNGMetadata.chunkType("PLTE");
    static final int IDAT_TYPE = CLibPNGMetadata.chunkType("IDAT");
    static final int IEND_TYPE = CLibPNGMetadata.chunkType("IEND");
    static final int bKGD_TYPE = CLibPNGMetadata.chunkType("bKGD");
    static final int cHRM_TYPE = CLibPNGMetadata.chunkType("cHRM");
    static final int gAMA_TYPE = CLibPNGMetadata.chunkType("gAMA");
    static final int hIST_TYPE = CLibPNGMetadata.chunkType("hIST");
    static final int iCCP_TYPE = CLibPNGMetadata.chunkType("iCCP");
    static final int iTXt_TYPE = CLibPNGMetadata.chunkType("iTXt");
    static final int pHYs_TYPE = CLibPNGMetadata.chunkType("pHYs");
    static final int sBIT_TYPE = CLibPNGMetadata.chunkType("sBIT");
    static final int sPLT_TYPE = CLibPNGMetadata.chunkType("sPLT");
    static final int sRGB_TYPE = CLibPNGMetadata.chunkType("sRGB");
    static final int tEXt_TYPE = CLibPNGMetadata.chunkType("tEXt");
    static final int tIME_TYPE = CLibPNGMetadata.chunkType("tIME");
    static final int tRNS_TYPE = CLibPNGMetadata.chunkType("tRNS");
    static final int zTXt_TYPE = CLibPNGMetadata.chunkType("zTXt");
    static final int PNG_COLOR_GRAY = 0;
    static final int PNG_COLOR_RGB = 2;
    static final int PNG_COLOR_PALETTE = 3;
    static final int PNG_COLOR_GRAY_ALPHA = 4;
    static final int PNG_COLOR_RGB_ALPHA = 6;
    public boolean IHDR_present;
    public int IHDR_width;
    public int IHDR_height;
    public int IHDR_bitDepth;
    public int IHDR_colorType;
    public int IHDR_compressionMethod;
    public int IHDR_filterMethod;
    public int IHDR_interlaceMethod;
    public boolean PLTE_present;
    public byte[] PLTE_red;
    public byte[] PLTE_green;
    public byte[] PLTE_blue;
    public boolean bKGD_present;
    public int bKGD_colorType;
    public int bKGD_index;
    public int bKGD_gray;
    public int bKGD_red;
    public int bKGD_green;
    public int bKGD_blue;
    public boolean cHRM_present;
    public int cHRM_whitePointX;
    public int cHRM_whitePointY;
    public int cHRM_redX;
    public int cHRM_redY;
    public int cHRM_greenX;
    public int cHRM_greenY;
    public int cHRM_blueX;
    public int cHRM_blueY;
    public boolean gAMA_present;
    public int gAMA_gamma;
    public boolean hIST_present;
    public char[] hIST_histogram;
    public boolean iCCP_present;
    public String iCCP_profileName;
    public int iCCP_compressionMethod;
    public byte[] iCCP_compressedProfile;
    public ArrayList iTXt_keyword = new ArrayList();
    public ArrayList iTXt_compressionFlag = new ArrayList();
    public ArrayList iTXt_compressionMethod = new ArrayList();
    public ArrayList iTXt_languageTag = new ArrayList();
    public ArrayList iTXt_translatedKeyword = new ArrayList();
    public ArrayList iTXt_text = new ArrayList();
    public boolean pHYs_present;
    public int pHYs_pixelsPerUnitXAxis;
    public int pHYs_pixelsPerUnitYAxis;
    public int pHYs_unitSpecifier;
    public boolean sBIT_present;
    public int sBIT_colorType;
    public int sBIT_grayBits;
    public int sBIT_redBits;
    public int sBIT_greenBits;
    public int sBIT_blueBits;
    public int sBIT_alphaBits;
    public boolean sPLT_present;
    public String sPLT_paletteName;
    public int sPLT_sampleDepth;
    public int[] sPLT_red;
    public int[] sPLT_green;
    public int[] sPLT_blue;
    public int[] sPLT_alpha;
    public int[] sPLT_frequency;
    public boolean sRGB_present;
    public int sRGB_renderingIntent;
    public ArrayList tEXt_keyword = new ArrayList();
    public ArrayList tEXt_text = new ArrayList();
    public boolean tIME_present;
    public int tIME_year;
    public int tIME_month;
    public int tIME_day;
    public int tIME_hour;
    public int tIME_minute;
    public int tIME_second;
    public boolean tRNS_present;
    public int tRNS_colorType;
    public byte[] tRNS_alpha;
    public int tRNS_gray;
    public int tRNS_red;
    public int tRNS_green;
    public int tRNS_blue;
    public ArrayList zTXt_keyword = new ArrayList();
    public ArrayList zTXt_compressionMethod = new ArrayList();
    public ArrayList zTXt_text = new ArrayList();
    public ArrayList unknownChunkType = new ArrayList();
    public ArrayList unknownChunkData = new ArrayList();
    private boolean gotHeader = false;
    private boolean gotMetadata = false;
    private Decoder decoder = null;
    private CLibPNGImageReader reader = null;

    static String toPrintableLatin1(String string) {
        if (string == null) {
            return null;
        }
        byte[] byArray = null;
        try {
            byArray = string.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string.getBytes();
        }
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < byArray.length; ++i) {
            int n3 = byArray[i] & 0xFF;
            if (n2 == 32 && n3 == 32) continue;
            if (n3 > 32 && n3 <= 126 || n3 >= 161 && n3 <= 255 || n3 == 32 && n != 0) {
                byArray[n++] = (byte)n3;
            }
            n2 = n3;
        }
        if (n == 0) {
            return "";
        }
        if (byArray[n - 1] == 32) {
            --n;
        }
        return new String(byArray, 0, n);
    }

    public CLibPNGMetadata() {
        super(true, nativeMetadataFormatName, nativeMetadataFormatClassName, null, null);
    }

    public CLibPNGMetadata(IIOMetadata iIOMetadata) throws IIOInvalidTreeException {
        this();
        if (iIOMetadata != null) {
            List<String> list = Arrays.asList(iIOMetadata.getMetadataFormatNames());
            if (list.contains(nativeMetadataFormatName)) {
                String string = nativeMetadataFormatName;
                this.setFromTree(string, iIOMetadata.getAsTree(string));
            } else if (iIOMetadata.isStandardMetadataFormatSupported()) {
                String string = "javax_imageio_1.0";
                this.setFromTree(string, iIOMetadata.getAsTree(string));
            }
        }
    }

    public void initialize(ImageTypeSpecifier imageTypeSpecifier, int n, ImageWriteParam imageWriteParam, int n2) {
        ColorModel colorModel = imageTypeSpecifier.getColorModel();
        SampleModel sampleModel = imageTypeSpecifier.getSampleModel();
        this.IHDR_width = sampleModel.getWidth();
        this.IHDR_height = sampleModel.getHeight();
        int[] nArray = sampleModel.getSampleSize();
        int n3 = nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i] <= n3) continue;
            n3 = nArray[i];
        }
        if (nArray.length > 1 && n3 < 8) {
            n3 = 8;
        }
        if (n3 > 2 && n3 < 4) {
            n3 = 4;
        } else if (n3 > 4 && n3 < 8) {
            n3 = 8;
        } else if (n3 > 8 && n3 < 16) {
            n3 = 16;
        } else if (n3 > 16) {
            throw new RuntimeException("bitDepth > 16!");
        }
        this.IHDR_bitDepth = n3;
        if (colorModel instanceof IndexColorModel) {
            int n4;
            IndexColorModel indexColorModel = (IndexColorModel)colorModel;
            int n5 = indexColorModel.getMapSize();
            byte[] byArray = new byte[n5];
            indexColorModel.getReds(byArray);
            byte[] byArray2 = new byte[n5];
            indexColorModel.getGreens(byArray2);
            byte[] byArray3 = new byte[n5];
            indexColorModel.getBlues(byArray3);
            boolean bl = false;
            if (!this.IHDR_present || this.IHDR_colorType != 3) {
                bl = true;
                n4 = 255 / ((1 << this.IHDR_bitDepth) - 1);
                for (int i = 0; i < n5; ++i) {
                    byte by = byArray[i];
                    if (by == (byte)(i * n4) && by == byArray2[i] && by == byArray3[i]) continue;
                    bl = false;
                    break;
                }
            }
            n4 = colorModel.hasAlpha();
            byte[] byArray4 = null;
            if (n4 != 0) {
                byArray4 = new byte[n5];
                indexColorModel.getAlphas(byArray4);
            }
            if (bl && n4 != 0) {
                this.IHDR_colorType = 4;
            } else if (bl) {
                this.IHDR_colorType = 0;
            } else {
                this.IHDR_colorType = 3;
                this.PLTE_present = true;
                this.PLTE_red = (byte[])byArray.clone();
                this.PLTE_green = (byte[])byArray2.clone();
                this.PLTE_blue = (byte[])byArray3.clone();
                if (n4 != 0) {
                    this.tRNS_present = true;
                    this.tRNS_colorType = 3;
                    this.tRNS_alpha = (byte[])byArray4.clone();
                }
            }
        } else if (n == 1) {
            this.IHDR_colorType = 0;
        } else if (n == 2) {
            this.IHDR_colorType = 4;
        } else if (n == 3) {
            this.IHDR_colorType = 2;
        } else if (n == 4) {
            this.IHDR_colorType = 6;
        } else {
            throw new RuntimeException("Number of bands not 1-4!");
        }
        this.IHDR_filterMethod = 0;
        this.IHDR_compressionMethod = 0;
        this.IHDR_interlaceMethod = imageWriteParam != null && imageWriteParam.getProgressiveMode() == 0 ? 0 : (imageWriteParam != null && imageWriteParam.getProgressiveMode() == 1 ? 1 : n2);
        this.IHDR_present = true;
    }

    public boolean isReadOnly() {
        return false;
    }

    private ArrayList cloneBytesArrayList(ArrayList arrayList) {
        if (arrayList == null) {
            return null;
        }
        ArrayList<Object> arrayList2 = new ArrayList<Object>(arrayList.size());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (e2 == null) {
                arrayList2.add(null);
                continue;
            }
            arrayList2.add(((byte[])e2).clone());
        }
        return arrayList2;
    }

    public Object clone() {
        CLibPNGMetadata cLibPNGMetadata;
        try {
            cLibPNGMetadata = (CLibPNGMetadata)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        cLibPNGMetadata.unknownChunkData = this.cloneBytesArrayList(this.unknownChunkData);
        return cLibPNGMetadata;
    }

    public Node getAsTree(String string) {
        if (string.equals(nativeMetadataFormatName)) {
            return this.getNativeTree();
        }
        if (string.equals("javax_imageio_1.0")) {
            return this.getStandardTree();
        }
        throw new IllegalArgumentException("Not a recognized format!");
    }

    private Node getNativeTree() {
        IIOMetadataNode iIOMetadataNode;
        int n;
        int n2;
        IIOMetadataNode iIOMetadataNode2;
        IIOMetadataNode iIOMetadataNode3 = null;
        IIOMetadataNode iIOMetadataNode4 = new IIOMetadataNode(nativeMetadataFormatName);
        if (this.IHDR_present) {
            iIOMetadataNode2 = new IIOMetadataNode("IHDR");
            iIOMetadataNode2.setAttribute("width", Integer.toString(this.IHDR_width));
            iIOMetadataNode2.setAttribute("height", Integer.toString(this.IHDR_height));
            iIOMetadataNode2.setAttribute("bitDepth", Integer.toString(this.IHDR_bitDepth));
            iIOMetadataNode2.setAttribute("colorType", IHDR_colorTypeNames[this.IHDR_colorType]);
            iIOMetadataNode2.setAttribute("compressionMethod", IHDR_compressionMethodNames[this.IHDR_compressionMethod]);
            iIOMetadataNode2.setAttribute("filterMethod", IHDR_filterMethodNames[this.IHDR_filterMethod]);
            iIOMetadataNode2.setAttribute("interlaceMethod", IHDR_interlaceMethodNames[this.IHDR_interlaceMethod]);
            iIOMetadataNode4.appendChild(iIOMetadataNode2);
        }
        if (this.PLTE_present) {
            iIOMetadataNode2 = new IIOMetadataNode("PLTE");
            n2 = this.PLTE_red.length;
            for (n = 0; n < n2; ++n) {
                iIOMetadataNode = new IIOMetadataNode("PLTEEntry");
                iIOMetadataNode.setAttribute("index", Integer.toString(n));
                iIOMetadataNode.setAttribute("red", Integer.toString(this.PLTE_red[n] & 0xFF));
                iIOMetadataNode.setAttribute("green", Integer.toString(this.PLTE_green[n] & 0xFF));
                iIOMetadataNode.setAttribute("blue", Integer.toString(this.PLTE_blue[n] & 0xFF));
                iIOMetadataNode2.appendChild(iIOMetadataNode);
            }
            iIOMetadataNode4.appendChild(iIOMetadataNode2);
        }
        if (this.bKGD_present) {
            iIOMetadataNode2 = new IIOMetadataNode("bKGD");
            if (this.bKGD_colorType == 3) {
                iIOMetadataNode3 = new IIOMetadataNode("bKGD_Palette");
                iIOMetadataNode3.setAttribute("index", Integer.toString(this.bKGD_index));
            } else if (this.bKGD_colorType == 0) {
                iIOMetadataNode3 = new IIOMetadataNode("bKGD_Grayscale");
                iIOMetadataNode3.setAttribute("gray", Integer.toString(this.bKGD_gray));
            } else if (this.bKGD_colorType == 2) {
                iIOMetadataNode3 = new IIOMetadataNode("bKGD_RGB");
                iIOMetadataNode3.setAttribute("red", Integer.toString(this.bKGD_red));
                iIOMetadataNode3.setAttribute("green", Integer.toString(this.bKGD_green));
                iIOMetadataNode3.setAttribute("blue", Integer.toString(this.bKGD_blue));
            }
            iIOMetadataNode2.appendChild(iIOMetadataNode3);
            iIOMetadataNode4.appendChild(iIOMetadataNode2);
        }
        if (this.cHRM_present) {
            iIOMetadataNode2 = new IIOMetadataNode("cHRM");
            iIOMetadataNode2.setAttribute("whitePointX", Integer.toString(this.cHRM_whitePointX));
            iIOMetadataNode2.setAttribute("whitePointY", Integer.toString(this.cHRM_whitePointY));
            iIOMetadataNode2.setAttribute("redX", Integer.toString(this.cHRM_redX));
            iIOMetadataNode2.setAttribute("redY", Integer.toString(this.cHRM_redY));
            iIOMetadataNode2.setAttribute("greenX", Integer.toString(this.cHRM_greenX));
            iIOMetadataNode2.setAttribute("greenY", Integer.toString(this.cHRM_greenY));
            iIOMetadataNode2.setAttribute("blueX", Integer.toString(this.cHRM_blueX));
            iIOMetadataNode2.setAttribute("blueY", Integer.toString(this.cHRM_blueY));
            iIOMetadataNode4.appendChild(iIOMetadataNode2);
        }
        if (this.gAMA_present) {
            iIOMetadataNode2 = new IIOMetadataNode("gAMA");
            iIOMetadataNode2.setAttribute("value", Integer.toString(this.gAMA_gamma));
            iIOMetadataNode4.appendChild(iIOMetadataNode2);
        }
        if (this.hIST_present) {
            iIOMetadataNode2 = new IIOMetadataNode("hIST");
            for (n2 = 0; n2 < this.hIST_histogram.length; ++n2) {
                IIOMetadataNode iIOMetadataNode5 = new IIOMetadataNode("hISTEntry");
                iIOMetadataNode5.setAttribute("index", Integer.toString(n2));
                iIOMetadataNode5.setAttribute("value", Integer.toString(this.hIST_histogram[n2]));
                iIOMetadataNode2.appendChild(iIOMetadataNode5);
            }
            iIOMetadataNode4.appendChild(iIOMetadataNode2);
        }
        if (this.iCCP_present) {
            iIOMetadataNode2 = new IIOMetadataNode("iCCP");
            iIOMetadataNode2.setAttribute("profileName", this.iCCP_profileName);
            iIOMetadataNode2.setAttribute("compressionMethod", iCCP_compressionMethodNames[this.iCCP_compressionMethod]);
            Object object = this.iCCP_compressedProfile;
            if (object != null) {
                object = object.clone();
            }
            iIOMetadataNode2.setUserObject(object);
            iIOMetadataNode4.appendChild(iIOMetadataNode2);
        }
        if (this.iTXt_keyword.size() > 0) {
            iIOMetadataNode2 = new IIOMetadataNode("iTXt");
            for (int i = 0; i < this.iTXt_keyword.size(); ++i) {
                iIOMetadataNode = new IIOMetadataNode("iTXtEntry");
                iIOMetadataNode.setAttribute("keyword", (String)this.iTXt_keyword.get(i));
                Integer n3 = (Integer)this.iTXt_compressionFlag.get(i);
                iIOMetadataNode.setAttribute("compressionFlag", n3.toString());
                n3 = (Integer)this.iTXt_compressionMethod.get(i);
                iIOMetadataNode.setAttribute("compressionMethod", n3.toString());
                iIOMetadataNode.setAttribute("languageTag", (String)this.iTXt_languageTag.get(i));
                iIOMetadataNode.setAttribute("translatedKeyword", (String)this.iTXt_translatedKeyword.get(i));
                iIOMetadataNode.setAttribute("text", (String)this.iTXt_text.get(i));
                iIOMetadataNode2.appendChild(iIOMetadataNode);
            }
            iIOMetadataNode4.appendChild(iIOMetadataNode2);
        }
        if (this.pHYs_present) {
            iIOMetadataNode2 = new IIOMetadataNode("pHYs");
            iIOMetadataNode2.setAttribute("pixelsPerUnitXAxis", Integer.toString(this.pHYs_pixelsPerUnitXAxis));
            iIOMetadataNode2.setAttribute("pixelsPerUnitYAxis", Integer.toString(this.pHYs_pixelsPerUnitYAxis));
            iIOMetadataNode2.setAttribute("unitSpecifier", unitSpecifierNames[this.pHYs_unitSpecifier]);
            iIOMetadataNode4.appendChild(iIOMetadataNode2);
        }
        if (this.sBIT_present) {
            iIOMetadataNode2 = new IIOMetadataNode("sBIT");
            if (this.sBIT_colorType == 0) {
                iIOMetadataNode3 = new IIOMetadataNode("sBIT_Grayscale");
                iIOMetadataNode3.setAttribute("gray", Integer.toString(this.sBIT_grayBits));
            } else if (this.sBIT_colorType == 4) {
                iIOMetadataNode3 = new IIOMetadataNode("sBIT_GrayAlpha");
                iIOMetadataNode3.setAttribute("gray", Integer.toString(this.sBIT_grayBits));
                iIOMetadataNode3.setAttribute("alpha", Integer.toString(this.sBIT_alphaBits));
            } else if (this.sBIT_colorType == 2) {
                iIOMetadataNode3 = new IIOMetadataNode("sBIT_RGB");
                iIOMetadataNode3.setAttribute("red", Integer.toString(this.sBIT_redBits));
                iIOMetadataNode3.setAttribute("green", Integer.toString(this.sBIT_greenBits));
                iIOMetadataNode3.setAttribute("blue", Integer.toString(this.sBIT_blueBits));
            } else if (this.sBIT_colorType == 6) {
                iIOMetadataNode3 = new IIOMetadataNode("sBIT_RGBAlpha");
                iIOMetadataNode3.setAttribute("red", Integer.toString(this.sBIT_redBits));
                iIOMetadataNode3.setAttribute("green", Integer.toString(this.sBIT_greenBits));
                iIOMetadataNode3.setAttribute("blue", Integer.toString(this.sBIT_blueBits));
                iIOMetadataNode3.setAttribute("alpha", Integer.toString(this.sBIT_alphaBits));
            } else if (this.sBIT_colorType == 3) {
                iIOMetadataNode3 = new IIOMetadataNode("sBIT_Palette");
                iIOMetadataNode3.setAttribute("red", Integer.toString(this.sBIT_redBits));
                iIOMetadataNode3.setAttribute("green", Integer.toString(this.sBIT_greenBits));
                iIOMetadataNode3.setAttribute("blue", Integer.toString(this.sBIT_blueBits));
            }
            iIOMetadataNode2.appendChild(iIOMetadataNode3);
            iIOMetadataNode4.appendChild(iIOMetadataNode2);
        }
        if (this.sPLT_present) {
            iIOMetadataNode2 = new IIOMetadataNode("sPLT");
            iIOMetadataNode2.setAttribute("name", this.sPLT_paletteName);
            iIOMetadataNode2.setAttribute("sampleDepth", Integer.toString(this.sPLT_sampleDepth));
            int n4 = this.sPLT_red.length;
            for (n = 0; n < n4; ++n) {
                iIOMetadataNode = new IIOMetadataNode("sPLTEntry");
                iIOMetadataNode.setAttribute("index", Integer.toString(n));
                iIOMetadataNode.setAttribute("red", Integer.toString(this.sPLT_red[n]));
                iIOMetadataNode.setAttribute("green", Integer.toString(this.sPLT_green[n]));
                iIOMetadataNode.setAttribute("blue", Integer.toString(this.sPLT_blue[n]));
                iIOMetadataNode.setAttribute("alpha", Integer.toString(this.sPLT_alpha[n]));
                iIOMetadataNode.setAttribute("frequency", Integer.toString(this.sPLT_frequency[n]));
                iIOMetadataNode2.appendChild(iIOMetadataNode);
            }
            iIOMetadataNode4.appendChild(iIOMetadataNode2);
        }
        if (this.sRGB_present) {
            iIOMetadataNode2 = new IIOMetadataNode("sRGB");
            iIOMetadataNode2.setAttribute("renderingIntent", renderingIntentNames[this.sRGB_renderingIntent]);
            iIOMetadataNode4.appendChild(iIOMetadataNode2);
        }
        if (this.tEXt_keyword.size() > 0) {
            iIOMetadataNode2 = new IIOMetadataNode("tEXt");
            for (int i = 0; i < this.tEXt_keyword.size(); ++i) {
                IIOMetadataNode iIOMetadataNode6 = new IIOMetadataNode("tEXtEntry");
                iIOMetadataNode6.setAttribute("keyword", (String)this.tEXt_keyword.get(i));
                iIOMetadataNode6.setAttribute("value", (String)this.tEXt_text.get(i));
                iIOMetadataNode2.appendChild(iIOMetadataNode6);
            }
            iIOMetadataNode4.appendChild(iIOMetadataNode2);
        }
        if (this.tIME_present) {
            iIOMetadataNode2 = new IIOMetadataNode("tIME");
            iIOMetadataNode2.setAttribute("year", Integer.toString(this.tIME_year));
            iIOMetadataNode2.setAttribute("month", Integer.toString(this.tIME_month));
            iIOMetadataNode2.setAttribute("day", Integer.toString(this.tIME_day));
            iIOMetadataNode2.setAttribute("hour", Integer.toString(this.tIME_hour));
            iIOMetadataNode2.setAttribute("minute", Integer.toString(this.tIME_minute));
            iIOMetadataNode2.setAttribute("second", Integer.toString(this.tIME_second));
            iIOMetadataNode4.appendChild(iIOMetadataNode2);
        }
        if (this.tRNS_present) {
            iIOMetadataNode2 = new IIOMetadataNode("tRNS");
            if (this.tRNS_colorType == 3) {
                iIOMetadataNode3 = new IIOMetadataNode("tRNS_Palette");
                for (int i = 0; i < this.tRNS_alpha.length; ++i) {
                    IIOMetadataNode iIOMetadataNode7 = new IIOMetadataNode("tRNS_PaletteEntry");
                    iIOMetadataNode7.setAttribute("index", Integer.toString(i));
                    iIOMetadataNode7.setAttribute("alpha", Integer.toString(this.tRNS_alpha[i] & 0xFF));
                    iIOMetadataNode3.appendChild(iIOMetadataNode7);
                }
            } else if (this.tRNS_colorType == 0) {
                iIOMetadataNode3 = new IIOMetadataNode("tRNS_Grayscale");
                iIOMetadataNode3.setAttribute("gray", Integer.toString(this.tRNS_gray));
            } else if (this.tRNS_colorType == 2) {
                iIOMetadataNode3 = new IIOMetadataNode("tRNS_RGB");
                iIOMetadataNode3.setAttribute("red", Integer.toString(this.tRNS_red));
                iIOMetadataNode3.setAttribute("green", Integer.toString(this.tRNS_green));
                iIOMetadataNode3.setAttribute("blue", Integer.toString(this.tRNS_blue));
            }
            iIOMetadataNode2.appendChild(iIOMetadataNode3);
            iIOMetadataNode4.appendChild(iIOMetadataNode2);
        }
        if (this.zTXt_keyword.size() > 0) {
            iIOMetadataNode2 = new IIOMetadataNode("zTXt");
            for (int i = 0; i < this.zTXt_keyword.size(); ++i) {
                IIOMetadataNode iIOMetadataNode8 = new IIOMetadataNode("zTXtEntry");
                iIOMetadataNode8.setAttribute("keyword", (String)this.zTXt_keyword.get(i));
                int n5 = (Integer)this.zTXt_compressionMethod.get(i);
                iIOMetadataNode8.setAttribute("compressionMethod", zTXt_compressionMethodNames[n5]);
                iIOMetadataNode8.setAttribute("text", (String)this.zTXt_text.get(i));
                iIOMetadataNode2.appendChild(iIOMetadataNode8);
            }
            iIOMetadataNode4.appendChild(iIOMetadataNode2);
        }
        if (this.unknownChunkType.size() > 0) {
            iIOMetadataNode2 = new IIOMetadataNode("UnknownChunks");
            for (int i = 0; i < this.unknownChunkType.size(); ++i) {
                IIOMetadataNode iIOMetadataNode9 = new IIOMetadataNode("UnknownChunk");
                iIOMetadataNode9.setAttribute("type", (String)this.unknownChunkType.get(i));
                iIOMetadataNode9.setUserObject((byte[])this.unknownChunkData.get(i));
                iIOMetadataNode2.appendChild(iIOMetadataNode9);
            }
            iIOMetadataNode4.appendChild(iIOMetadataNode2);
        }
        return iIOMetadataNode4;
    }

    private int getNumChannels() {
        int n = IHDR_numChannels[this.IHDR_colorType];
        if (this.IHDR_colorType == 3 && this.tRNS_present && this.tRNS_colorType == this.IHDR_colorType) {
            n = 4;
        }
        return n;
    }

    public IIOMetadataNode getStandardChromaNode() {
        int n;
        int n2;
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Chroma");
        IIOMetadataNode iIOMetadataNode2 = null;
        iIOMetadataNode2 = new IIOMetadataNode("ColorSpaceType");
        iIOMetadataNode2.setAttribute("name", colorSpaceTypeNames[this.IHDR_colorType]);
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        iIOMetadataNode2 = new IIOMetadataNode("NumChannels");
        iIOMetadataNode2.setAttribute("value", Integer.toString(this.getNumChannels()));
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        if (this.gAMA_present) {
            iIOMetadataNode2 = new IIOMetadataNode("Gamma");
            iIOMetadataNode2.setAttribute("value", Float.toString((float)this.gAMA_gamma * 1.0E-5f));
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        iIOMetadataNode2 = new IIOMetadataNode("BlackIsZero");
        iIOMetadataNode2.setAttribute("value", "TRUE");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        if (this.PLTE_present) {
            n2 = this.tRNS_present && this.tRNS_colorType == 3 ? 1 : 0;
            iIOMetadataNode2 = new IIOMetadataNode("Palette");
            for (n = 0; n < this.PLTE_red.length; ++n) {
                IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("PaletteEntry");
                iIOMetadataNode3.setAttribute("index", Integer.toString(n));
                iIOMetadataNode3.setAttribute("red", Integer.toString(this.PLTE_red[n] & 0xFF));
                iIOMetadataNode3.setAttribute("green", Integer.toString(this.PLTE_green[n] & 0xFF));
                iIOMetadataNode3.setAttribute("blue", Integer.toString(this.PLTE_blue[n] & 0xFF));
                if (n2 != 0) {
                    int n3 = n < this.tRNS_alpha.length ? this.tRNS_alpha[n] & 0xFF : 255;
                    iIOMetadataNode3.setAttribute("alpha", Integer.toString(n3));
                }
                iIOMetadataNode2.appendChild(iIOMetadataNode3);
            }
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        if (this.bKGD_present) {
            if (this.bKGD_colorType == 3) {
                iIOMetadataNode2 = new IIOMetadataNode("BackgroundIndex");
                iIOMetadataNode2.setAttribute("value", Integer.toString(this.bKGD_index));
            } else {
                int n4;
                iIOMetadataNode2 = new IIOMetadataNode("BackgroundColor");
                if (this.bKGD_colorType == 0) {
                    n = n4 = this.bKGD_gray;
                    n2 = n4;
                } else {
                    n2 = this.bKGD_red;
                    n = this.bKGD_green;
                    n4 = this.bKGD_blue;
                }
                iIOMetadataNode2.setAttribute("red", Integer.toString(n2));
                iIOMetadataNode2.setAttribute("green", Integer.toString(n));
                iIOMetadataNode2.setAttribute("blue", Integer.toString(n4));
            }
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        return iIOMetadataNode;
    }

    public IIOMetadataNode getStandardCompressionNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Compression");
        IIOMetadataNode iIOMetadataNode2 = null;
        iIOMetadataNode2 = new IIOMetadataNode("CompressionTypeName");
        iIOMetadataNode2.setAttribute("value", "deflate");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        iIOMetadataNode2 = new IIOMetadataNode("Lossless");
        iIOMetadataNode2.setAttribute("value", "TRUE");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        iIOMetadataNode2 = new IIOMetadataNode("NumProgressiveScans");
        iIOMetadataNode2.setAttribute("value", this.IHDR_interlaceMethod == 0 ? "1" : "7");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode;
    }

    private String repeat(String string, int n) {
        if (n == 1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer((string.length() + 1) * n - 1);
        stringBuffer.append(string);
        for (int i = 1; i < n; ++i) {
            stringBuffer.append(" ");
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public IIOMetadataNode getStandardDataNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Data");
        IIOMetadataNode iIOMetadataNode2 = null;
        iIOMetadataNode2 = new IIOMetadataNode("PlanarConfiguration");
        iIOMetadataNode2.setAttribute("value", "PixelInterleaved");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        iIOMetadataNode2 = new IIOMetadataNode("SampleFormat");
        iIOMetadataNode2.setAttribute("value", this.IHDR_colorType == 3 ? "Index" : "UnsignedIntegral");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        String string = Integer.toString(this.IHDR_bitDepth);
        iIOMetadataNode2 = new IIOMetadataNode("BitsPerSample");
        iIOMetadataNode2.setAttribute("value", this.repeat(string, this.getNumChannels()));
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        if (this.sBIT_present) {
            iIOMetadataNode2 = new IIOMetadataNode("SignificantBitsPerSample");
            String string2 = this.sBIT_colorType == 0 || this.sBIT_colorType == 4 ? Integer.toString(this.sBIT_grayBits) : Integer.toString(this.sBIT_redBits) + " " + Integer.toString(this.sBIT_greenBits) + " " + Integer.toString(this.sBIT_blueBits);
            if (this.sBIT_colorType == 4 || this.sBIT_colorType == 6) {
                string2 = string2 + " " + Integer.toString(this.sBIT_alphaBits);
            }
            iIOMetadataNode2.setAttribute("value", string2);
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        return iIOMetadataNode;
    }

    public IIOMetadataNode getStandardDimensionNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Dimension");
        IIOMetadataNode iIOMetadataNode2 = null;
        iIOMetadataNode2 = new IIOMetadataNode("PixelAspectRatio");
        float f2 = this.pHYs_present ? (float)this.pHYs_pixelsPerUnitYAxis / (float)this.pHYs_pixelsPerUnitXAxis : 1.0f;
        iIOMetadataNode2.setAttribute("value", Float.toString(f2));
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        iIOMetadataNode2 = new IIOMetadataNode("ImageOrientation");
        iIOMetadataNode2.setAttribute("value", "Normal");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        if (this.pHYs_present && this.pHYs_unitSpecifier == 1) {
            iIOMetadataNode2 = new IIOMetadataNode("HorizontalPixelSize");
            iIOMetadataNode2.setAttribute("value", Float.toString(1000.0f / (float)this.pHYs_pixelsPerUnitXAxis));
            iIOMetadataNode.appendChild(iIOMetadataNode2);
            iIOMetadataNode2 = new IIOMetadataNode("VerticalPixelSize");
            iIOMetadataNode2.setAttribute("value", Float.toString(1000.0f / (float)this.pHYs_pixelsPerUnitYAxis));
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        return iIOMetadataNode;
    }

    public IIOMetadataNode getStandardDocumentNode() {
        if (!this.tIME_present) {
            return null;
        }
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Document");
        IIOMetadataNode iIOMetadataNode2 = null;
        iIOMetadataNode2 = new IIOMetadataNode("ImageModificationTime");
        iIOMetadataNode2.setAttribute("year", Integer.toString(this.tIME_year));
        iIOMetadataNode2.setAttribute("month", Integer.toString(this.tIME_month));
        iIOMetadataNode2.setAttribute("day", Integer.toString(this.tIME_day));
        iIOMetadataNode2.setAttribute("hour", Integer.toString(this.tIME_hour));
        iIOMetadataNode2.setAttribute("minute", Integer.toString(this.tIME_minute));
        iIOMetadataNode2.setAttribute("second", Integer.toString(this.tIME_second));
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode;
    }

    public IIOMetadataNode getStandardTextNode() {
        int n;
        int n2 = this.tEXt_keyword.size() + this.iTXt_keyword.size() + this.zTXt_keyword.size();
        if (n2 == 0) {
            return null;
        }
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Text");
        IIOMetadataNode iIOMetadataNode2 = null;
        for (n = 0; n < this.tEXt_keyword.size(); ++n) {
            iIOMetadataNode2 = new IIOMetadataNode("TextEntry");
            iIOMetadataNode2.setAttribute("keyword", (String)this.tEXt_keyword.get(n));
            iIOMetadataNode2.setAttribute("value", (String)this.tEXt_text.get(n));
            iIOMetadataNode2.setAttribute("encoding", "ISO-8859-1");
            iIOMetadataNode2.setAttribute("compression", "none");
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        for (n = 0; n < this.iTXt_keyword.size(); ++n) {
            iIOMetadataNode2 = new IIOMetadataNode("TextEntry");
            iIOMetadataNode2.setAttribute("keyword", (String)this.iTXt_keyword.get(n));
            iIOMetadataNode2.setAttribute("value", (String)this.iTXt_text.get(n));
            iIOMetadataNode2.setAttribute("language", (String)this.iTXt_languageTag.get(n));
            if ((Integer)this.iTXt_compressionFlag.get(n) == 1) {
                iIOMetadataNode2.setAttribute("compression", "deflate");
            } else {
                iIOMetadataNode2.setAttribute("compression", "none");
            }
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        for (n = 0; n < this.zTXt_keyword.size(); ++n) {
            iIOMetadataNode2 = new IIOMetadataNode("TextEntry");
            iIOMetadataNode2.setAttribute("keyword", (String)this.zTXt_keyword.get(n));
            iIOMetadataNode2.setAttribute("value", (String)this.zTXt_text.get(n));
            iIOMetadataNode2.setAttribute("compression", "deflate");
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        return iIOMetadataNode;
    }

    public IIOMetadataNode getStandardTransparencyNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Transparency");
        IIOMetadataNode iIOMetadataNode2 = null;
        iIOMetadataNode2 = new IIOMetadataNode("Alpha");
        boolean bl = this.IHDR_colorType == 6 || this.IHDR_colorType == 4 || this.IHDR_colorType == 3 && this.tRNS_present && this.tRNS_colorType == this.IHDR_colorType && this.tRNS_alpha != null;
        iIOMetadataNode2.setAttribute("value", bl ? "nonpremultiplied" : "none");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        if (this.tRNS_present && (this.tRNS_colorType == 2 || this.tRNS_colorType == 0)) {
            iIOMetadataNode2 = new IIOMetadataNode("TransparentColor");
            if (this.tRNS_colorType == 2) {
                iIOMetadataNode2.setAttribute("value", Integer.toString(this.tRNS_red) + " " + Integer.toString(this.tRNS_green) + " " + Integer.toString(this.tRNS_blue));
            } else if (this.tRNS_colorType == 0) {
                iIOMetadataNode2.setAttribute("value", Integer.toString(this.tRNS_gray));
            }
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        return iIOMetadataNode;
    }

    private void fatal(Node node, String string) throws IIOInvalidTreeException {
        throw new IIOInvalidTreeException(string, node);
    }

    private int getIntAttribute(Node node, String string, int n, boolean bl) throws IIOInvalidTreeException {
        String string2 = this.getAttribute(node, string, null, bl);
        if (string2 == null) {
            return n;
        }
        return Integer.parseInt(string2);
    }

    private float getFloatAttribute(Node node, String string, float f2, boolean bl) throws IIOInvalidTreeException {
        String string2 = this.getAttribute(node, string, null, bl);
        if (string2 == null) {
            return f2;
        }
        return Float.parseFloat(string2);
    }

    private int getIntAttribute(Node node, String string) throws IIOInvalidTreeException {
        return this.getIntAttribute(node, string, -1, true);
    }

    private float getFloatAttribute(Node node, String string) throws IIOInvalidTreeException {
        return this.getFloatAttribute(node, string, -1.0f, true);
    }

    private boolean getBooleanAttribute(Node node, String string, boolean bl, boolean bl2) throws IIOInvalidTreeException {
        String string2;
        Node node2 = node.getAttributes().getNamedItem(string);
        if (node2 == null) {
            if (!bl2) {
                return bl;
            }
            this.fatal(node, "Required attribute " + string + " not present!");
        }
        if ((string2 = node2.getNodeValue()).equalsIgnoreCase("true")) {
            return true;
        }
        if (string2.equalsIgnoreCase("false")) {
            return false;
        }
        this.fatal(node, "Attribute " + string + " must be 'true' or 'false'!");
        return false;
    }

    private boolean getBooleanAttribute(Node node, String string) throws IIOInvalidTreeException {
        return this.getBooleanAttribute(node, string, false, true);
    }

    private int getEnumeratedAttribute(Node node, String string, String[] stringArray, int n, boolean bl) throws IIOInvalidTreeException {
        Node node2 = node.getAttributes().getNamedItem(string);
        if (node2 == null) {
            if (!bl) {
                return n;
            }
            this.fatal(node, "Required attribute " + string + " not present!");
        }
        String string2 = node2.getNodeValue();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string2.equals(stringArray[i])) continue;
            return i;
        }
        this.fatal(node, "Illegal value for attribute " + string + "!");
        return -1;
    }

    private int getEnumeratedAttribute(Node node, String string, String[] stringArray) throws IIOInvalidTreeException {
        return this.getEnumeratedAttribute(node, string, stringArray, -1, true);
    }

    private String getAttribute(Node node, String string, String string2, boolean bl) throws IIOInvalidTreeException {
        Node node2 = node.getAttributes().getNamedItem(string);
        if (node2 == null) {
            if (!bl) {
                return string2;
            }
            this.fatal(node, "Required attribute " + string + " not present!");
        }
        return node2.getNodeValue();
    }

    private String getAttribute(Node node, String string) throws IIOInvalidTreeException {
        return this.getAttribute(node, string, null, true);
    }

    public void mergeTree(String string, Node node) throws IIOInvalidTreeException {
        if (string.equals(nativeMetadataFormatName)) {
            if (node == null) {
                throw new IllegalArgumentException("root == null!");
            }
            this.mergeNativeTree(node);
        } else if (string.equals("javax_imageio_1.0")) {
            if (node == null) {
                throw new IllegalArgumentException("root == null!");
            }
            this.mergeStandardTree(node);
        } else {
            throw new IllegalArgumentException("Not a recognized format!");
        }
    }

    private void mergeNativeTree(Node node) throws IIOInvalidTreeException {
        Node node2 = node;
        if (!node2.getNodeName().equals(nativeMetadataFormatName)) {
            this.fatal(node2, "Root must be javax_imageio_png_1.0");
        }
        for (node2 = node2.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            String string = node2.getNodeName();
            if (string.equals("IHDR")) {
                this.IHDR_width = this.getIntAttribute(node2, "width");
                this.IHDR_height = this.getIntAttribute(node2, "height");
                this.IHDR_bitDepth = this.getEnumeratedAttribute(node2, "bitDepth", IHDR_bitDepths);
                this.IHDR_colorType = this.getEnumeratedAttribute(node2, "colorType", IHDR_colorTypeNames);
                this.IHDR_compressionMethod = this.getEnumeratedAttribute(node2, "compressionMethod", IHDR_compressionMethodNames);
                this.IHDR_filterMethod = this.getEnumeratedAttribute(node2, "filterMethod", IHDR_filterMethodNames);
                this.IHDR_interlaceMethod = this.getEnumeratedAttribute(node2, "interlaceMethod", IHDR_interlaceMethodNames);
                this.IHDR_present = true;
                continue;
            }
            if (string.equals("PLTE")) {
                int n;
                object4 = new byte[256];
                byte[] byArray = new byte[256];
                object3 = new byte[256];
                int n2 = -1;
                object2 = node2.getFirstChild();
                if (object2 == null) {
                    this.fatal(node2, "Palette has no entries!");
                }
                while (object2 != null) {
                    if (!object2.getNodeName().equals("PLTEEntry")) {
                        this.fatal(node2, "Only a PLTEEntry may be a child of a PLTE!");
                    }
                    if ((n = this.getIntAttribute((Node)object2, "index")) < 0 || n > 255) {
                        this.fatal(node2, "Bad value for PLTEEntry attribute index!");
                    }
                    if (n > n2) {
                        n2 = n;
                    }
                    object4[n] = (byte)this.getIntAttribute((Node)object2, "red");
                    byArray[n] = (byte)this.getIntAttribute((Node)object2, "green");
                    object3[n] = (byte)this.getIntAttribute((Node)object2, "blue");
                    object2 = object2.getNextSibling();
                }
                n = n2 + 1;
                this.PLTE_red = new byte[n];
                this.PLTE_green = new byte[n];
                this.PLTE_blue = new byte[n];
                System.arraycopy(object4, 0, this.PLTE_red, 0, n);
                System.arraycopy(byArray, 0, this.PLTE_green, 0, n);
                System.arraycopy(object3, 0, this.PLTE_blue, 0, n);
                this.PLTE_present = true;
                continue;
            }
            if (string.equals("bKGD")) {
                String string2;
                this.bKGD_present = false;
                object4 = node2.getFirstChild();
                if (object4 == null) {
                    this.fatal(node2, "bKGD node has no children!");
                }
                if ((string2 = object4.getNodeName()).equals("bKGD_Palette")) {
                    this.bKGD_index = this.getIntAttribute((Node)object4, "index");
                    this.bKGD_colorType = 3;
                } else if (string2.equals("bKGD_Grayscale")) {
                    this.bKGD_gray = this.getIntAttribute((Node)object4, "gray");
                    this.bKGD_colorType = 0;
                } else if (string2.equals("bKGD_RGB")) {
                    this.bKGD_red = this.getIntAttribute((Node)object4, "red");
                    this.bKGD_green = this.getIntAttribute((Node)object4, "green");
                    this.bKGD_blue = this.getIntAttribute((Node)object4, "blue");
                    this.bKGD_colorType = 2;
                } else {
                    this.fatal(node2, "Bad child of a bKGD node!");
                }
                if (object4.getNextSibling() != null) {
                    this.fatal(node2, "bKGD node has more than one child!");
                }
                this.bKGD_present = true;
                continue;
            }
            if (string.equals("cHRM")) {
                this.cHRM_whitePointX = this.getIntAttribute(node2, "whitePointX");
                this.cHRM_whitePointY = this.getIntAttribute(node2, "whitePointY");
                this.cHRM_redX = this.getIntAttribute(node2, "redX");
                this.cHRM_redY = this.getIntAttribute(node2, "redY");
                this.cHRM_greenX = this.getIntAttribute(node2, "greenX");
                this.cHRM_greenY = this.getIntAttribute(node2, "greenY");
                this.cHRM_blueX = this.getIntAttribute(node2, "blueX");
                this.cHRM_blueY = this.getIntAttribute(node2, "blueY");
                this.cHRM_present = true;
                continue;
            }
            if (string.equals("gAMA")) {
                this.gAMA_gamma = this.getIntAttribute(node2, "value");
                this.gAMA_present = true;
                continue;
            }
            if (string.equals("hIST")) {
                object4 = new char[256];
                int n = -1;
                object3 = node2.getFirstChild();
                if (object3 == null) {
                    this.fatal(node2, "hIST node has no children!");
                }
                while (object3 != null) {
                    int n3;
                    if (!object3.getNodeName().equals("hISTEntry")) {
                        this.fatal(node2, "Only a hISTEntry may be a child of a hIST!");
                    }
                    if ((n3 = this.getIntAttribute((Node)object3, "index")) < 0 || n3 > 255) {
                        this.fatal(node2, "Bad value for histEntry attribute index!");
                    }
                    if (n3 > n) {
                        n = n3;
                    }
                    object4[n3] = (char)this.getIntAttribute((Node)object3, "value");
                    object3 = object3.getNextSibling();
                }
                int n4 = n + 1;
                this.hIST_histogram = new char[n4];
                System.arraycopy(object4, 0, this.hIST_histogram, 0, n4);
                this.hIST_present = true;
                continue;
            }
            if (string.equals("iCCP")) {
                this.iCCP_profileName = CLibPNGMetadata.toPrintableLatin1(this.getAttribute(node2, "profileName"));
                this.iCCP_compressionMethod = this.getEnumeratedAttribute(node2, "compressionMethod", iCCP_compressionMethodNames);
                object4 = ((IIOMetadataNode)node2).getUserObject();
                if (object4 == null) {
                    this.fatal(node2, "No ICCP profile present in user object!");
                }
                if (!(object4 instanceof byte[])) {
                    this.fatal(node2, "User object not a byte array!");
                }
                this.iCCP_compressedProfile = (byte[])((byte[])object4).clone();
                this.iCCP_present = true;
                continue;
            }
            if (string.equals("iTXt")) {
                for (object4 = (Object)node2.getFirstChild(); object4 != null; object4 = object4.getNextSibling()) {
                    if (!object4.getNodeName().equals("iTXtEntry")) {
                        this.fatal(node2, "Only an iTXtEntry may be a child of an iTXt!");
                    }
                    String string3 = CLibPNGMetadata.toPrintableLatin1(this.getAttribute((Node)object4, "keyword"));
                    this.iTXt_keyword.add(string3);
                    boolean bl = this.getBooleanAttribute((Node)object4, "compressionFlag");
                    this.iTXt_compressionFlag.add(new Boolean(bl));
                    String string4 = this.getAttribute((Node)object4, "compressionMethod");
                    this.iTXt_compressionMethod.add(string4);
                    object2 = this.getAttribute((Node)object4, "languageTag");
                    this.iTXt_languageTag.add(object2);
                    String string5 = this.getAttribute((Node)object4, "translatedKeyword");
                    this.iTXt_translatedKeyword.add(string5);
                    object = this.getAttribute((Node)object4, "text");
                    this.iTXt_text.add(object);
                }
                continue;
            }
            if (string.equals("pHYs")) {
                this.pHYs_pixelsPerUnitXAxis = this.getIntAttribute(node2, "pixelsPerUnitXAxis");
                this.pHYs_pixelsPerUnitYAxis = this.getIntAttribute(node2, "pixelsPerUnitYAxis");
                this.pHYs_unitSpecifier = this.getEnumeratedAttribute(node2, "unitSpecifier", unitSpecifierNames);
                this.pHYs_present = true;
                continue;
            }
            if (string.equals("sBIT")) {
                String string6;
                this.sBIT_present = false;
                object4 = node2.getFirstChild();
                if (object4 == null) {
                    this.fatal(node2, "sBIT node has no children!");
                }
                if ((string6 = object4.getNodeName()).equals("sBIT_Grayscale")) {
                    this.sBIT_grayBits = this.getIntAttribute((Node)object4, "gray");
                    this.sBIT_colorType = 0;
                } else if (string6.equals("sBIT_GrayAlpha")) {
                    this.sBIT_grayBits = this.getIntAttribute((Node)object4, "gray");
                    this.sBIT_alphaBits = this.getIntAttribute((Node)object4, "alpha");
                    this.sBIT_colorType = 4;
                } else if (string6.equals("sBIT_RGB")) {
                    this.sBIT_redBits = this.getIntAttribute((Node)object4, "red");
                    this.sBIT_greenBits = this.getIntAttribute((Node)object4, "green");
                    this.sBIT_blueBits = this.getIntAttribute((Node)object4, "blue");
                    this.sBIT_colorType = 2;
                } else if (string6.equals("sBIT_RGBAlpha")) {
                    this.sBIT_redBits = this.getIntAttribute((Node)object4, "red");
                    this.sBIT_greenBits = this.getIntAttribute((Node)object4, "green");
                    this.sBIT_blueBits = this.getIntAttribute((Node)object4, "blue");
                    this.sBIT_alphaBits = this.getIntAttribute((Node)object4, "alpha");
                    this.sBIT_colorType = 6;
                } else if (string6.equals("sBIT_Palette")) {
                    this.sBIT_redBits = this.getIntAttribute((Node)object4, "red");
                    this.sBIT_greenBits = this.getIntAttribute((Node)object4, "green");
                    this.sBIT_blueBits = this.getIntAttribute((Node)object4, "blue");
                    this.sBIT_colorType = 3;
                } else {
                    this.fatal(node2, "Bad child of an sBIT node!");
                }
                if (object4.getNextSibling() != null) {
                    this.fatal(node2, "sBIT node has more than one child!");
                }
                this.sBIT_present = true;
                continue;
            }
            if (string.equals("sPLT")) {
                int n;
                this.sPLT_paletteName = CLibPNGMetadata.toPrintableLatin1(this.getAttribute(node2, "name"));
                this.sPLT_sampleDepth = this.getIntAttribute(node2, "sampleDepth");
                object4 = new int[256];
                int[] nArray = new int[256];
                object3 = new int[256];
                int[] nArray2 = new int[256];
                object2 = new int[256];
                int n5 = -1;
                object = node2.getFirstChild();
                if (object == null) {
                    this.fatal(node2, "sPLT node has no children!");
                }
                while (object != null) {
                    if (!object.getNodeName().equals("sPLTEntry")) {
                        this.fatal(node2, "Only an sPLTEntry may be a child of an sPLT!");
                    }
                    if ((n = this.getIntAttribute((Node)object, "index")) < 0 || n > 255) {
                        this.fatal(node2, "Bad value for PLTEEntry attribute index!");
                    }
                    if (n > n5) {
                        n5 = n;
                    }
                    object4[n] = this.getIntAttribute((Node)object, "red");
                    nArray[n] = this.getIntAttribute((Node)object, "green");
                    object3[n] = this.getIntAttribute((Node)object, "blue");
                    nArray2[n] = this.getIntAttribute((Node)object, "alpha");
                    object2[n] = this.getIntAttribute((Node)object, "frequency");
                    object = object.getNextSibling();
                }
                n = n5 + 1;
                this.sPLT_red = new int[n];
                this.sPLT_green = new int[n];
                this.sPLT_blue = new int[n];
                this.sPLT_alpha = new int[n];
                this.sPLT_frequency = new int[n];
                System.arraycopy(object4, 0, this.sPLT_red, 0, n);
                System.arraycopy(nArray, 0, this.sPLT_green, 0, n);
                System.arraycopy(object3, 0, this.sPLT_blue, 0, n);
                System.arraycopy(nArray2, 0, this.sPLT_alpha, 0, n);
                System.arraycopy(object2, 0, this.sPLT_frequency, 0, n);
                this.sPLT_present = true;
                continue;
            }
            if (string.equals("sRGB")) {
                this.sRGB_renderingIntent = this.getEnumeratedAttribute(node2, "renderingIntent", renderingIntentNames);
                this.sRGB_present = true;
                continue;
            }
            if (string.equals("tEXt")) {
                for (object4 = node2.getFirstChild(); object4 != null; object4 = object4.getNextSibling()) {
                    if (!object4.getNodeName().equals("tEXtEntry")) {
                        this.fatal(node2, "Only an tEXtEntry may be a child of an tEXt!");
                    }
                    String string7 = CLibPNGMetadata.toPrintableLatin1(this.getAttribute((Node)object4, "keyword"));
                    this.tEXt_keyword.add(string7);
                    object3 = this.getAttribute((Node)object4, "value");
                    this.tEXt_text.add(object3);
                }
                continue;
            }
            if (string.equals("tIME")) {
                this.tIME_year = this.getIntAttribute(node2, "year");
                this.tIME_month = this.getIntAttribute(node2, "month");
                this.tIME_day = this.getIntAttribute(node2, "day");
                this.tIME_hour = this.getIntAttribute(node2, "hour");
                this.tIME_minute = this.getIntAttribute(node2, "minute");
                this.tIME_second = this.getIntAttribute(node2, "second");
                this.tIME_present = true;
                continue;
            }
            if (string.equals("tRNS")) {
                String string8;
                this.tRNS_present = false;
                object4 = node2.getFirstChild();
                if (object4 == null) {
                    this.fatal(node2, "tRNS node has no children!");
                }
                if ((string8 = object4.getNodeName()).equals("tRNS_Palette")) {
                    int n;
                    object3 = new byte[256];
                    int n6 = -1;
                    object2 = object4.getFirstChild();
                    if (object2 == null) {
                        this.fatal(node2, "tRNS_Palette node has no children!");
                    }
                    while (object2 != null) {
                        if (!object2.getNodeName().equals("tRNS_PaletteEntry")) {
                            this.fatal(node2, "Only a tRNS_PaletteEntry may be a child of a tRNS_Palette!");
                        }
                        if ((n = this.getIntAttribute((Node)object2, "index")) < 0 || n > 255) {
                            this.fatal(node2, "Bad value for tRNS_PaletteEntry attribute index!");
                        }
                        if (n > n6) {
                            n6 = n;
                        }
                        object3[n] = (byte)this.getIntAttribute((Node)object2, "alpha");
                        object2 = object2.getNextSibling();
                    }
                    n = n6 + 1;
                    this.tRNS_alpha = new byte[n];
                    this.tRNS_colorType = 3;
                    System.arraycopy(object3, 0, this.tRNS_alpha, 0, n);
                } else if (string8.equals("tRNS_Grayscale")) {
                    this.tRNS_gray = this.getIntAttribute((Node)object4, "gray");
                    this.tRNS_colorType = 0;
                } else if (string8.equals("tRNS_RGB")) {
                    this.tRNS_red = this.getIntAttribute((Node)object4, "red");
                    this.tRNS_green = this.getIntAttribute((Node)object4, "green");
                    this.tRNS_blue = this.getIntAttribute((Node)object4, "blue");
                    this.tRNS_colorType = 2;
                } else {
                    this.fatal(node2, "Bad child of a tRNS node!");
                }
                if (object4.getNextSibling() != null) {
                    this.fatal(node2, "tRNS node has more than one child!");
                }
                this.tRNS_present = true;
                continue;
            }
            if (string.equals("zTXt")) {
                for (object4 = (Object)node2.getFirstChild(); object4 != null; object4 = object4.getNextSibling()) {
                    if (!object4.getNodeName().equals("zTXtEntry")) {
                        this.fatal(node2, "Only an zTXtEntry may be a child of an zTXt!");
                    }
                    String string9 = CLibPNGMetadata.toPrintableLatin1(this.getAttribute((Node)object4, "keyword"));
                    this.zTXt_keyword.add(string9);
                    int n = this.getEnumeratedAttribute((Node)object4, "compressionMethod", zTXt_compressionMethodNames);
                    this.zTXt_compressionMethod.add(new Integer(n));
                    String string10 = this.getAttribute((Node)object4, "text");
                    this.zTXt_text.add(string10);
                }
                continue;
            }
            if (string.equals("UnknownChunks")) {
                for (object4 = node2.getFirstChild(); object4 != null; object4 = object4.getNextSibling()) {
                    if (!object4.getNodeName().equals("UnknownChunk")) {
                        this.fatal(node2, "Only an UnknownChunk may be a child of an UnknownChunks!");
                    }
                    String string11 = this.getAttribute((Node)object4, "type");
                    object3 = ((IIOMetadataNode)object4).getUserObject();
                    if (string11.length() != 4) {
                        this.fatal((Node)object4, "Chunk type must be 4 characters!");
                    }
                    if (object3 == null) {
                        this.fatal((Node)object4, "No chunk data present in user object!");
                    }
                    if (!(object3 instanceof byte[])) {
                        this.fatal((Node)object4, "User object not a byte array!");
                    }
                    this.unknownChunkType.add(string11);
                    this.unknownChunkData.add(object3.clone());
                }
                continue;
            }
            this.fatal(node2, "Unknown child of root node!");
        }
    }

    private boolean isISOLatin(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) <= '\u00ff') continue;
            return false;
        }
        return true;
    }

    private void mergeStandardTree(Node node) throws IIOInvalidTreeException {
        Node node2 = node;
        if (!node2.getNodeName().equals("javax_imageio_1.0")) {
            this.fatal(node2, "Root must be javax_imageio_1.0");
        }
        for (node2 = node2.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            int n;
            Object object;
            String string = node2.getNodeName();
            if (string.equals("Chroma")) {
                for (Node node3 = node2.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                    String string2 = node3.getNodeName();
                    if (string2.equals("Gamma")) {
                        float f2 = this.getFloatAttribute(node3, "value");
                        this.gAMA_present = true;
                        this.gAMA_gamma = (int)((double)(f2 * 100000.0f) + 0.5);
                        continue;
                    }
                    if (string2.equals("Palette")) {
                        byte[] byArray = new byte[256];
                        byte[] byArray2 = new byte[256];
                        byte[] byArray3 = new byte[256];
                        int n2 = -1;
                        for (object = node3.getFirstChild(); object != null; object = object.getNextSibling()) {
                            String string3 = object.getNodeName();
                            if (!string3.equals("PaletteEntry") || (n = this.getIntAttribute((Node)object, "index")) < 0 || n > 255) continue;
                            byArray[n] = (byte)this.getIntAttribute((Node)object, "red");
                            byArray2[n] = (byte)this.getIntAttribute((Node)object, "green");
                            byArray3[n] = (byte)this.getIntAttribute((Node)object, "blue");
                            if (n <= n2) continue;
                            n2 = n;
                        }
                        int n3 = n2 + 1;
                        this.PLTE_red = new byte[n3];
                        this.PLTE_green = new byte[n3];
                        this.PLTE_blue = new byte[n3];
                        System.arraycopy(byArray, 0, this.PLTE_red, 0, n3);
                        System.arraycopy(byArray2, 0, this.PLTE_green, 0, n3);
                        System.arraycopy(byArray3, 0, this.PLTE_blue, 0, n3);
                        this.PLTE_present = true;
                        continue;
                    }
                    if (string2.equals("BackgroundIndex")) {
                        this.bKGD_present = true;
                        this.bKGD_colorType = 3;
                        this.bKGD_index = this.getIntAttribute(node3, "value");
                        continue;
                    }
                    if (!string2.equals("BackgroundColor")) continue;
                    int n4 = this.getIntAttribute(node3, "red");
                    int n5 = this.getIntAttribute(node3, "green");
                    int n6 = this.getIntAttribute(node3, "blue");
                    if (n4 == n5 && n4 == n6) {
                        this.bKGD_colorType = 0;
                        this.bKGD_gray = n4;
                    } else {
                        this.bKGD_colorType = 2;
                        this.bKGD_red = n4;
                        this.bKGD_green = n5;
                        this.bKGD_blue = n6;
                    }
                    this.bKGD_present = true;
                }
                continue;
            }
            if (string.equals("Compression")) {
                for (Node node4 = node2.getFirstChild(); node4 != null; node4 = node4.getNextSibling()) {
                    String string4 = node4.getNodeName();
                    if (!string4.equals("NumProgressiveScans")) continue;
                    int n7 = this.getIntAttribute(node4, "value");
                    this.IHDR_interlaceMethod = n7 > 1 ? 1 : 0;
                }
                continue;
            }
            if (string.equals("Data")) {
                for (Node node5 = node2.getFirstChild(); node5 != null; node5 = node5.getNextSibling()) {
                    int n8;
                    StringTokenizer stringTokenizer;
                    String string5;
                    String string6 = node5.getNodeName();
                    if (string6.equals("BitsPerSample")) {
                        string5 = this.getAttribute(node5, "value");
                        stringTokenizer = new StringTokenizer(string5);
                        n8 = -1;
                        while (stringTokenizer.hasMoreTokens()) {
                            int n9 = Integer.parseInt(stringTokenizer.nextToken());
                            if (n9 <= n8) continue;
                            n8 = n9;
                        }
                        if (n8 < 1) {
                            n8 = 1;
                        } else if (n8 == 3) {
                            n8 = 4;
                        } else if (n8 > 4 && n8 < 8) {
                            n8 = 8;
                        } else if (n8 > 8) {
                            n8 = 16;
                        }
                        this.IHDR_bitDepth = n8;
                        continue;
                    }
                    if (!string6.equals("SignificantBitsPerSample")) continue;
                    string5 = this.getAttribute(node5, "value");
                    stringTokenizer = new StringTokenizer(string5);
                    n8 = stringTokenizer.countTokens();
                    if (n8 == 1) {
                        this.sBIT_colorType = 0;
                        this.sBIT_grayBits = Integer.parseInt(stringTokenizer.nextToken());
                    } else if (n8 == 2) {
                        this.sBIT_colorType = 4;
                        this.sBIT_grayBits = Integer.parseInt(stringTokenizer.nextToken());
                        this.sBIT_alphaBits = Integer.parseInt(stringTokenizer.nextToken());
                    } else if (n8 == 3) {
                        this.sBIT_colorType = 2;
                        this.sBIT_redBits = Integer.parseInt(stringTokenizer.nextToken());
                        this.sBIT_greenBits = Integer.parseInt(stringTokenizer.nextToken());
                        this.sBIT_blueBits = Integer.parseInt(stringTokenizer.nextToken());
                    } else if (n8 == 4) {
                        this.sBIT_colorType = 6;
                        this.sBIT_redBits = Integer.parseInt(stringTokenizer.nextToken());
                        this.sBIT_greenBits = Integer.parseInt(stringTokenizer.nextToken());
                        this.sBIT_blueBits = Integer.parseInt(stringTokenizer.nextToken());
                        this.sBIT_alphaBits = Integer.parseInt(stringTokenizer.nextToken());
                    }
                    if (n8 < 1 || n8 > 4) continue;
                    this.sBIT_present = true;
                }
                continue;
            }
            if (string.equals("Dimension")) {
                int n10;
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                float f3 = -1.0f;
                float f4 = -1.0f;
                float f5 = -1.0f;
                for (object = node2.getFirstChild(); object != null; object = object.getNextSibling()) {
                    String string7 = object.getNodeName();
                    if (string7.equals("PixelAspectRatio")) {
                        f5 = this.getFloatAttribute((Node)object, "value");
                        bl3 = true;
                        continue;
                    }
                    if (string7.equals("HorizontalPixelSize")) {
                        f3 = this.getFloatAttribute((Node)object, "value");
                        bl = true;
                        continue;
                    }
                    if (!string7.equals("VerticalPixelSize")) continue;
                    f4 = this.getFloatAttribute((Node)object, "value");
                    bl2 = true;
                }
                if (bl && bl2) {
                    this.pHYs_present = true;
                    this.pHYs_unitSpecifier = 1;
                    this.pHYs_pixelsPerUnitXAxis = (int)(1000.0f / f3 + 0.5f);
                    this.pHYs_pixelsPerUnitYAxis = (int)(1000.0f / f4 + 0.5f);
                    continue;
                }
                if (!bl3) continue;
                this.pHYs_present = true;
                this.pHYs_unitSpecifier = 0;
                for (n10 = 1; n10 < 100 && !((double)Math.abs((float)((n = (int)(f5 * (float)n10)) / n10) - f5) < 0.001); ++n10) {
                }
                this.pHYs_pixelsPerUnitXAxis = (int)(f5 * (float)n10);
                this.pHYs_pixelsPerUnitYAxis = n10;
                continue;
            }
            if (string.equals("Document")) {
                for (Node node6 = node2.getFirstChild(); node6 != null; node6 = node6.getNextSibling()) {
                    String string8 = node6.getNodeName();
                    if (!string8.equals("ImageModificationTime")) continue;
                    this.tIME_present = true;
                    this.tIME_year = this.getIntAttribute(node6, "year");
                    this.tIME_month = this.getIntAttribute(node6, "month");
                    this.tIME_day = this.getIntAttribute(node6, "day");
                    this.tIME_hour = this.getIntAttribute(node6, "hour", 0, false);
                    this.tIME_minute = this.getIntAttribute(node6, "minute", 0, false);
                    this.tIME_second = this.getIntAttribute(node6, "second", 0, false);
                }
                continue;
            }
            if (!string.equals("Text")) continue;
            for (Node node7 = node2.getFirstChild(); node7 != null; node7 = node7.getNextSibling()) {
                String string9 = node7.getNodeName();
                if (!string9.equals("TextEntry")) continue;
                String string10 = this.getAttribute(node7, "keyword", "text", false);
                String string11 = this.getAttribute(node7, "value");
                String string12 = this.getAttribute(node7, "encoding", "unknown", false);
                String string13 = this.getAttribute(node7, "language", "unknown", false);
                object = this.getAttribute(node7, "compression", "other", false);
                if (this.isISOLatin(string11)) {
                    if (((String)object).equals("zip")) {
                        this.zTXt_keyword.add(CLibPNGMetadata.toPrintableLatin1(string10));
                        this.zTXt_text.add(string11);
                        this.zTXt_compressionMethod.add(new Integer(0));
                        continue;
                    }
                    this.tEXt_keyword.add(CLibPNGMetadata.toPrintableLatin1(string10));
                    this.tEXt_text.add(string11);
                    continue;
                }
                int n11 = ((String)object).equals("zip") ? 1 : 0;
                this.iTXt_keyword.add(CLibPNGMetadata.toPrintableLatin1(string10));
                this.iTXt_compressionFlag.add(new Integer(n11));
                this.iTXt_compressionMethod.add(new Integer(0));
                this.iTXt_languageTag.add(string13);
                this.iTXt_translatedKeyword.add(string10);
                this.iTXt_text.add(string11);
            }
        }
    }

    public void reset() {
        this.IHDR_present = false;
        this.PLTE_present = false;
        this.bKGD_present = false;
        this.cHRM_present = false;
        this.gAMA_present = false;
        this.hIST_present = false;
        this.iCCP_present = false;
        this.iTXt_keyword = new ArrayList();
        this.iTXt_compressionFlag = new ArrayList();
        this.iTXt_compressionMethod = new ArrayList();
        this.iTXt_languageTag = new ArrayList();
        this.iTXt_translatedKeyword = new ArrayList();
        this.iTXt_text = new ArrayList();
        this.pHYs_present = false;
        this.sBIT_present = false;
        this.sPLT_present = false;
        this.sRGB_present = false;
        this.tEXt_keyword = new ArrayList();
        this.tEXt_text = new ArrayList();
        this.tIME_present = false;
        this.tRNS_present = false;
        this.zTXt_keyword = new ArrayList();
        this.zTXt_compressionMethod = new ArrayList();
        this.zTXt_text = new ArrayList();
        this.unknownChunkType = new ArrayList();
        this.unknownChunkData = new ArrayList();
    }

    private static int chunkType(String string) {
        char c2 = string.charAt(0);
        char c3 = string.charAt(1);
        char c4 = string.charAt(2);
        char c5 = string.charAt(3);
        int n = c2 << 24 | c3 << 16 | c4 << 8 | c5;
        return n;
    }

    private String readNullTerminatedString(ImageInputStream imageInputStream) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = imageInputStream.read()) != 0) {
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }

    private void readHeader() throws IIOException {
        if (this.gotHeader) {
            return;
        }
        try {
            int n;
            mediaLibImage mediaLibImage2 = this.decoder.getImage();
            int n2 = mediaLibImage2.getWidth();
            int n3 = mediaLibImage2.getHeight();
            int n4 = this.decoder.getBitDepth();
            switch (mediaLibImage2.getChannels()) {
                case 1: {
                    n = this.decoder.getPalette() == null ? 0 : 3;
                    break;
                }
                case 2: {
                    n = 4;
                    break;
                }
                case 3: {
                    n = 2;
                    break;
                }
                case 4: {
                    n = 6;
                    break;
                }
                default: {
                    throw new IIOException("Unsupported image type.");
                }
            }
            int n5 = 0;
            int n6 = 0;
            int n7 = this.decoder.getInterlaceMethod();
            if (n2 == 0) {
                throw new IIOException("Image width == 0!");
            }
            if (n3 == 0) {
                throw new IIOException("Image height == 0!");
            }
            if (n4 != 1 && n4 != 2 && n4 != 4 && n4 != 8 && n4 != 16) {
                throw new IIOException("Bit depth must be 1, 2, 4, 8, or 16!");
            }
            if (n != 0 && n != 2 && n != 3 && n != 4 && n != 6) {
                throw new IIOException("Color type must be 0, 2, 3, 4, or 6!");
            }
            if (n == 3 && n4 == 16) {
                throw new IIOException("Bad color type/bit depth combination!");
            }
            if ((n == 2 || n == 6 || n == 4) && n4 != 8 && n4 != 16) {
                throw new IIOException("Bad color type/bit depth combination!");
            }
            if (n5 != 0) {
                throw new IIOException("Unknown compression method (not 0)!");
            }
            if (n6 != 0) {
                throw new IIOException("Unknown filter method (not 0)!");
            }
            if (n7 != 0 && n7 != 1) {
                throw new IIOException("Unknown interlace method (not 0 or 1)!");
            }
            this.IHDR_present = true;
            this.IHDR_width = n2;
            this.IHDR_height = n3;
            this.IHDR_bitDepth = n4;
            this.IHDR_colorType = n;
            this.IHDR_compressionMethod = n5;
            this.IHDR_filterMethod = n6;
            this.IHDR_interlaceMethod = n7;
            this.gotHeader = true;
        }
        catch (IOException iOException) {
            throw new IIOException("I/O error reading PNG header!", iOException);
        }
    }

    private void parse_PLTE_chunk() throws IOException {
        if (this.PLTE_present) {
            this.processWarningOccurred("A PNG image may not contain more than one PLTE chunk.\nThe chunk will be ignored.");
            return;
        }
        if (this.IHDR_colorType == 0 || this.IHDR_colorType == 4) {
            this.processWarningOccurred("A PNG gray or gray alpha image cannot have a PLTE chunk.\nThe chunk will be ignored.");
            return;
        }
        byte[] byArray = this.decoder.getPalette();
        if (byArray != null) {
            int n;
            int n2 = byArray.length / 3;
            if (this.IHDR_colorType == 3 && n2 > (n = 1 << this.IHDR_bitDepth)) {
                this.processWarningOccurred("PLTE chunk contains too many entries for bit depth, ignoring extras.");
                n2 = n;
            }
            n = n2 > 16 ? 256 : (n2 > 4 ? 16 : (n2 > 2 ? 4 : 2));
            this.PLTE_present = true;
            this.PLTE_red = new byte[n];
            this.PLTE_green = new byte[n];
            this.PLTE_blue = new byte[n];
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                this.PLTE_red[i] = byArray[n3++];
                this.PLTE_green[i] = byArray[n3++];
                this.PLTE_blue[i] = byArray[n3++];
            }
        }
    }

    private void parse_bKGD_chunk() throws IOException {
        int[] nArray = this.decoder.getBackground();
        if (nArray != null) {
            if (this.IHDR_colorType == 3) {
                this.bKGD_colorType = 3;
                this.bKGD_index = nArray[0];
            } else if (this.IHDR_colorType == 0 || this.IHDR_colorType == 4) {
                this.bKGD_colorType = 0;
                this.bKGD_gray = nArray[0];
            } else {
                this.bKGD_colorType = 2;
                this.bKGD_red = nArray[0];
                this.bKGD_green = nArray[1];
                this.bKGD_blue = nArray[2];
            }
            this.bKGD_present = true;
        }
    }

    private void parse_cHRM_chunk() throws IOException {
        int[] nArray = this.decoder.getAllPrimaryChromaticities();
        if (nArray != null) {
            int n = 0;
            this.cHRM_whitePointX = nArray[n++];
            this.cHRM_whitePointY = nArray[n++];
            this.cHRM_redX = nArray[n++];
            this.cHRM_redY = nArray[n++];
            this.cHRM_greenX = nArray[n++];
            this.cHRM_greenY = nArray[n++];
            this.cHRM_blueX = nArray[n++];
            this.cHRM_blueY = nArray[n++];
            this.cHRM_present = true;
        }
    }

    private void parse_gAMA_chunk() throws IOException {
        int n = this.decoder.getImageGamma();
        if (n != -1) {
            this.gAMA_gamma = n;
            this.gAMA_present = true;
        }
    }

    private void parse_hIST_chunk() throws IOException, IIOException {
        short[] sArray = this.decoder.getHistogram();
        if (sArray != null) {
            if (!this.PLTE_present) {
                throw new IIOException("hIST chunk without prior PLTE chunk!");
            }
            int n = Math.min(this.PLTE_red.length, sArray.length);
            this.hIST_histogram = new char[n];
            for (int i = 0; i < n; ++i) {
                this.hIST_histogram[i] = (char)sArray[i];
            }
            this.hIST_present = true;
        }
    }

    private void parse_iCCP_chunk() throws IOException {
        String string = this.decoder.getEmbeddedICCProfileName();
        if (string != null) {
            int n;
            this.iCCP_profileName = string;
            byte[] byArray = this.decoder.getEmbeddedICCProfile();
            Deflater deflater = new Deflater(9);
            deflater.setInput(byArray);
            deflater.finish();
            int n2 = 0;
            int n3 = byArray.length;
            byte[] byArray2 = new byte[byArray.length];
            do {
                n = deflater.deflate(byArray2, n2, n3);
                n2 += n;
                n3 -= n;
            } while (!deflater.finished());
            n = n2;
            this.iCCP_compressedProfile = new byte[n];
            System.arraycopy(byArray2, 0, this.iCCP_compressedProfile, 0, n);
            this.iCCP_present = true;
        }
    }

    private void parse_pHYs_chunk() throws IOException {
        int n = this.decoder.getPhysicalPixelDimensions(2);
        if (n != -1) {
            this.pHYs_pixelsPerUnitXAxis = this.decoder.getPhysicalPixelDimensions(0);
            this.pHYs_pixelsPerUnitYAxis = this.decoder.getPhysicalPixelDimensions(1);
            this.pHYs_unitSpecifier = n;
            this.pHYs_present = true;
        }
    }

    private void parse_sBIT_chunk() throws IOException {
        byte[] byArray = this.decoder.getSignificantBits();
        if (byArray != null) {
            int n = 0;
            int n2 = this.IHDR_colorType;
            if (n2 == 0 || n2 == 4) {
                this.sBIT_grayBits = byArray[n++];
            } else if (n2 == 2 || n2 == 3 || n2 == 6) {
                this.sBIT_redBits = byArray[n++];
                this.sBIT_greenBits = byArray[n++];
                this.sBIT_blueBits = byArray[n++];
            }
            if (n2 == 4 || n2 == 6) {
                this.sBIT_alphaBits = byArray[n++];
            }
            this.sBIT_colorType = n2;
            this.sBIT_present = true;
        }
    }

    private void parse_sPLT_chunk() throws IOException, IIOException {
        PNGChunk[] pNGChunkArray = this.decoder.getSuggestedPalette();
        if (pNGChunkArray != null && pNGChunkArray.length > 0 && pNGChunkArray[0] != null) {
            int n;
            PNGChunk pNGChunk = pNGChunkArray[0];
            byte[] byArray = pNGChunk.getData();
            int n2 = byArray.length;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(pNGChunk.getData());
            MemoryCacheImageInputStream memoryCacheImageInputStream = new MemoryCacheImageInputStream(byteArrayInputStream);
            this.sPLT_paletteName = this.readNullTerminatedString(memoryCacheImageInputStream);
            this.sPLT_sampleDepth = n = memoryCacheImageInputStream.readUnsignedByte();
            int n3 = (n2 -= this.sPLT_paletteName.length() + 1) / (4 * (n / 8) + 2);
            this.sPLT_red = new int[n3];
            this.sPLT_green = new int[n3];
            this.sPLT_blue = new int[n3];
            this.sPLT_alpha = new int[n3];
            this.sPLT_frequency = new int[n3];
            if (n == 8) {
                for (int i = 0; i < n3; ++i) {
                    this.sPLT_red[i] = memoryCacheImageInputStream.readUnsignedByte();
                    this.sPLT_green[i] = memoryCacheImageInputStream.readUnsignedByte();
                    this.sPLT_blue[i] = memoryCacheImageInputStream.readUnsignedByte();
                    this.sPLT_alpha[i] = memoryCacheImageInputStream.readUnsignedByte();
                    this.sPLT_frequency[i] = memoryCacheImageInputStream.readUnsignedShort();
                }
            } else if (n == 16) {
                for (int i = 0; i < n3; ++i) {
                    this.sPLT_red[i] = memoryCacheImageInputStream.readUnsignedShort();
                    this.sPLT_green[i] = memoryCacheImageInputStream.readUnsignedShort();
                    this.sPLT_blue[i] = memoryCacheImageInputStream.readUnsignedShort();
                    this.sPLT_alpha[i] = memoryCacheImageInputStream.readUnsignedShort();
                    this.sPLT_frequency[i] = memoryCacheImageInputStream.readUnsignedShort();
                }
            } else {
                throw new IIOException("sPLT sample depth not 8 or 16!");
            }
            this.sPLT_present = true;
        }
    }

    private void parse_sRGB_chunk() throws IOException {
        int n = this.decoder.getStandardRGB();
        if (n != -1) {
            this.sRGB_renderingIntent = n;
            this.sRGB_present = true;
        }
    }

    private void parse_tIME_chunk() throws IOException {
        Calendar calendar = this.decoder.getLastModificationTime();
        if (calendar != null) {
            this.tIME_year = calendar.get(1);
            this.tIME_month = calendar.get(2) + 1;
            this.tIME_day = calendar.get(5);
            this.tIME_hour = calendar.get(11);
            this.tIME_minute = calendar.get(12);
            this.tIME_second = calendar.get(13);
            this.tIME_present = true;
        }
    }

    private void parse_tRNS_chunk() throws IOException {
        int[] nArray = this.decoder.getTransparency();
        if (nArray == null) {
            return;
        }
        int n = this.IHDR_colorType;
        if (n == 3) {
            if (!this.PLTE_present) {
                this.processWarningOccurred("tRNS chunk without prior PLTE chunk, ignoring it.");
                return;
            }
            int n2 = nArray.length;
            int n3 = this.PLTE_red.length;
            if (n2 > n3) {
                this.processWarningOccurred("tRNS chunk has more entries than prior PLTE chunk, ignoring extras.");
                n2 = n3;
            }
            this.tRNS_alpha = new byte[n2];
            this.tRNS_colorType = 3;
            for (int i = 0; i < n2; ++i) {
                this.tRNS_alpha[i] = (byte)nArray[i];
            }
        } else if (n == 0) {
            if (nArray.length != 1) {
                this.processWarningOccurred("tRNS chunk for gray image must have length 2, ignoring chunk.");
                return;
            }
            this.tRNS_gray = nArray[0];
            this.tRNS_colorType = 0;
        } else if (n == 2) {
            if (nArray.length != 3) {
                this.processWarningOccurred("tRNS chunk for RGB image must have length 6, ignoring chunk.");
                return;
            }
            this.tRNS_red = nArray[0];
            this.tRNS_green = nArray[1];
            this.tRNS_blue = nArray[2];
            this.tRNS_colorType = 2;
        } else {
            this.processWarningOccurred("Gray+Alpha and RGBA images may not have a tRNS chunk, ignoring it.");
            return;
        }
        this.tRNS_present = true;
    }

    private void parseTextChunk() throws IOException {
        PNGTextualData[] pNGTextualDataArray = this.decoder.getTextualData();
        if (pNGTextualDataArray != null) {
            for (int i = 0; i < pNGTextualDataArray.length; ++i) {
                PNGTextualData pNGTextualData = pNGTextualDataArray[i];
                String string = pNGTextualData.getKeyword();
                String string2 = pNGTextualData.getText();
                String string3 = pNGTextualData.getTranslatedKeyword();
                if (string.equals(string3)) {
                    this.tEXt_keyword.add(string);
                    this.tEXt_text.add(string2);
                    continue;
                }
                this.iTXt_keyword.add(string);
                this.iTXt_text.add(string2);
                this.iTXt_translatedKeyword.add(string3);
                int n = 0;
                this.iTXt_compressionFlag.add(new Integer(n));
                int n2 = 0;
                this.iTXt_compressionMethod.add(new Integer(n2));
                String string4 = pNGTextualData.getEncoding();
                this.iTXt_languageTag.add(string4);
            }
        }
    }

    synchronized void readMetadata(CLibPNGImageReader cLibPNGImageReader, Decoder decoder) throws IIOException {
        if (this.gotMetadata) {
            return;
        }
        this.reader = cLibPNGImageReader;
        this.decoder = decoder;
        this.readHeader();
        try {
            this.parse_PLTE_chunk();
            this.parse_bKGD_chunk();
            this.parse_cHRM_chunk();
            this.parse_gAMA_chunk();
            this.parse_hIST_chunk();
            this.parse_iCCP_chunk();
            this.parse_pHYs_chunk();
            this.parse_sBIT_chunk();
            this.parse_sPLT_chunk();
            this.parse_sRGB_chunk();
            this.parse_tIME_chunk();
            this.parse_tRNS_chunk();
            this.parseTextChunk();
            PNGChunk[] pNGChunkArray = decoder.getUserData();
            if (pNGChunkArray != null) {
                for (int i = 0; i < pNGChunkArray.length; ++i) {
                    PNGChunk pNGChunk = pNGChunkArray[i];
                    int n = pNGChunk.getID();
                    byte[] byArray = pNGChunk.getData();
                    StringBuffer stringBuffer = new StringBuffer(4);
                    stringBuffer.append((char)(n >>> 24));
                    stringBuffer.append((char)(n >> 16 & 0xFF));
                    stringBuffer.append((char)(n >> 8 & 0xFF));
                    stringBuffer.append((char)(n & 0xFF));
                    int n2 = n >>> 28;
                    if (n2 == 0) {
                        this.processWarningOccurred("Encountered unknown chunk with critical bit set!");
                    }
                    this.unknownChunkType.add(stringBuffer.toString());
                    this.unknownChunkData.add(byArray);
                }
            }
        }
        catch (IOException iOException) {
            throw new IIOException("Error reading PNG metadata", iOException);
        }
        finally {
            this.reader = null;
            this.decoder = null;
        }
        this.gotMetadata = true;
    }

    void processWarningOccurred(String string) {
        if (this.reader != null) {
            this.reader.forwardWarningMessage(string);
        }
    }

    synchronized void writeMetadata(Encoder encoder) throws IIOException {
        Object object;
        int n;
        Object[] objectArray;
        int n2;
        if (this.IHDR_present) {
            encoder.setBitDepth(this.IHDR_bitDepth);
            encoder.setInterlaceMethod(this.IHDR_interlaceMethod == 0 ? 0 : 1);
        }
        if (this.PLTE_present) {
            n2 = this.PLTE_red.length;
            objectArray = new byte[3 * n2];
            int n3 = 0;
            for (n = 0; n < n2; ++n) {
                objectArray[n3++] = this.PLTE_red[n];
                objectArray[n3++] = this.PLTE_green[n];
                objectArray[n3++] = this.PLTE_blue[n];
            }
            encoder.setPalette(objectArray);
        }
        if (this.bKGD_present) {
            int[] nArray;
            switch (this.bKGD_colorType) {
                case 0: {
                    nArray = new int[]{this.bKGD_gray};
                    break;
                }
                case 3: {
                    nArray = new int[]{this.bKGD_index};
                    break;
                }
                default: {
                    nArray = new int[]{this.bKGD_red, this.bKGD_green, this.bKGD_blue};
                }
            }
            encoder.setBackground(nArray);
        }
        if (this.cHRM_present) {
            encoder.setPrimaryChromaticities(this.cHRM_whitePointX, this.cHRM_whitePointY, this.cHRM_redX, this.cHRM_redY, this.cHRM_greenX, this.cHRM_greenY, this.cHRM_blueX, this.cHRM_blueY);
        }
        if (this.gAMA_present) {
            encoder.setImageGamma(this.gAMA_gamma);
        }
        if (this.hIST_present) {
            n2 = this.hIST_histogram.length;
            objectArray = new short[n2];
            for (n = 0; n < n2; ++n) {
                objectArray[n] = (short)this.hIST_histogram[n];
            }
            encoder.setHistogram((short[])objectArray);
        }
        if (this.iCCP_present) {
            Inflater inflater = new Inflater();
            inflater.setInput(this.iCCP_compressedProfile);
            objectArray = new byte[2 * inflater.getRemaining()];
            n = 0;
            try {
                Object[] objectArray2;
                do {
                    if ((n += inflater.inflate((byte[])objectArray, n, objectArray.length - n)) != objectArray.length || inflater.finished()) continue;
                    byte[] byArray = new byte[2 * objectArray.length];
                    System.arraycopy(objectArray, 0, byArray, 0, objectArray.length);
                    objectArray = byArray;
                } while (!inflater.finished());
                inflater.end();
                if (n == objectArray.length) {
                    objectArray2 = objectArray;
                } else {
                    objectArray2 = new byte[n];
                    System.arraycopy(objectArray, 0, objectArray2, 0, n);
                }
                object = CLibPNGMetadata.toPrintableLatin1(this.iCCP_profileName);
                encoder.setEmbeddedICCProfile((String)object, objectArray2);
            }
            catch (DataFormatException dataFormatException) {
                // empty catch block
            }
        }
        if (this.iTXt_keyword.size() > 0) {
            n2 = this.iTXt_keyword.size();
            for (int i = 0; i < n2; ++i) {
                Integer n4 = Integer.valueOf((String)this.iTXt_compressionFlag.get(i));
                encoder.setUnicodeTextualData((String)this.iTXt_keyword.get(i), (String)this.iTXt_translatedKeyword.get(i), (String)this.iTXt_languageTag.get(i), (String)this.iTXt_text.get(i), n4 == 1);
            }
        }
        if (this.pHYs_present) {
            encoder.setPhysicalPixelDimensions(this.pHYs_pixelsPerUnitXAxis, this.pHYs_pixelsPerUnitYAxis, this.pHYs_unitSpecifier);
        }
        if (this.sBIT_present) {
            byte[] byArray;
            switch (this.sBIT_colorType) {
                case 0: {
                    byArray = new byte[]{(byte)(this.sBIT_grayBits & 0xFF)};
                    break;
                }
                case 4: {
                    byArray = new byte[]{(byte)(this.sBIT_grayBits & 0xFF), (byte)(this.sBIT_alphaBits & 0xFF)};
                    break;
                }
                case 6: {
                    byArray = new byte[]{(byte)(this.sBIT_redBits & 0xFF), (byte)(this.sBIT_greenBits & 0xFF), (byte)(this.sBIT_blueBits & 0xFF), (byte)(this.sBIT_alphaBits & 0xFF)};
                    break;
                }
                default: {
                    byArray = new byte[]{(byte)(this.sBIT_redBits & 0xFF), (byte)(this.sBIT_greenBits & 0xFF), (byte)(this.sBIT_blueBits & 0xFF)};
                }
            }
            encoder.setSignificantBits(byArray);
        }
        if (this.sPLT_present) {
            String string;
            int n5;
            if (this.sPLT_sampleDepth == 8) {
                byte[] byArray = new byte[this.sPLT_red.length];
                byte[] byArray2 = new byte[this.sPLT_green.length];
                byte[] byArray3 = new byte[this.sPLT_blue.length];
                byte[] byArray4 = new byte[this.sPLT_alpha.length];
                object = new short[this.sPLT_frequency.length];
                n5 = byArray.length;
                for (int i = 0; i < n5; ++i) {
                    byArray[i] = (byte)(this.sPLT_red[i] & 0xFF);
                    byArray2[i] = (byte)(this.sPLT_green[i] & 0xFF);
                    byArray3[i] = (byte)(this.sPLT_blue[i] & 0xFF);
                    byArray4[i] = (byte)(this.sPLT_alpha[i] & 0xFF);
                    object[i] = (short)(this.sPLT_frequency[i] & 0xFFFF);
                }
                string = CLibPNGMetadata.toPrintableLatin1(this.sPLT_paletteName);
                encoder.setSuggestedPalette(string, byArray, byArray2, byArray3, byArray4, object);
            } else {
                short[] sArray = new short[this.sPLT_red.length];
                short[] sArray2 = new short[this.sPLT_green.length];
                short[] sArray3 = new short[this.sPLT_blue.length];
                short[] sArray4 = new short[this.sPLT_alpha.length];
                object = new short[this.sPLT_frequency.length];
                n5 = sArray.length;
                for (int i = 0; i < n5; ++i) {
                    sArray[i] = (short)(this.sPLT_red[i] & 0xFFFF);
                    sArray2[i] = (short)(this.sPLT_green[i] & 0xFFFF);
                    sArray3[i] = (short)(this.sPLT_blue[i] & 0xFFFF);
                    sArray4[i] = (short)(this.sPLT_alpha[i] & 0xFFFF);
                    object[i] = (short)(this.sPLT_frequency[i] & 0xFFFF);
                }
                string = CLibPNGMetadata.toPrintableLatin1(this.sPLT_paletteName);
                encoder.setSuggestedPalette(string, sArray, sArray2, sArray3, sArray4, object);
            }
        }
        if (this.sRGB_present) {
            encoder.setStandardRGB(this.sRGB_renderingIntent);
        }
        if (this.tEXt_keyword.size() > 0) {
            int n6 = this.tEXt_keyword.size();
            for (int i = 0; i < n6; ++i) {
                encoder.setTextualData((String)this.tEXt_keyword.get(i), (String)this.tEXt_text.get(i), false);
            }
        }
        if (this.tIME_present) {
            encoder.setLastModificationTime(new GregorianCalendar(this.tIME_year, this.tIME_month - 1, this.tIME_day, this.tIME_hour, this.tIME_minute, this.tIME_second));
        }
        if (this.tRNS_present) {
            if (this.tRNS_colorType == 0) {
                encoder.setTransparency(this.tRNS_gray, this.tRNS_gray, this.tRNS_gray);
            } else if (this.tRNS_colorType == 3) {
                int n7 = this.tRNS_alpha.length;
                int[] nArray = new int[n7];
                for (int i = 0; i < n7; ++i) {
                    nArray[i] = this.tRNS_alpha[i] & 0xFF;
                }
                encoder.setTransparency(nArray);
            } else {
                encoder.setTransparency(this.tRNS_red, this.tRNS_green, this.tRNS_blue);
            }
        }
        if (this.zTXt_keyword.size() > 0) {
            int n8 = this.zTXt_keyword.size();
            for (int i = 0; i < n8; ++i) {
                encoder.setTextualData((String)this.zTXt_keyword.get(i), (String)this.zTXt_text.get(i), true);
            }
        }
        if (this.unknownChunkType.size() > 0) {
            int n9 = this.unknownChunkType.size();
            for (int i = 0; i < n9; ++i) {
                encoder.setUserData((String)this.unknownChunkType.get(i), (byte[])this.unknownChunkData.get(i), 0);
            }
        }
    }
}

