/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.raw;

import com.sun.media.imageioimpl.common.ImageUtil;
import com.sun.media.imageioimpl.plugins.raw.I18N;
import com.sun.media.imageioimpl.plugins.raw.RawImageWriteParam;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BandedSampleModel;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;

public class RawImageWriter
extends ImageWriter {
    private ImageOutputStream stream = null;
    private int imageIndex;
    private int tileWidth;
    private int tileHeight;
    private int tileXOffset;
    private int tileYOffset;
    private int scaleX;
    private int scaleY;
    private int xOffset;
    private int yOffset;
    private int[] sourceBands = null;
    private int numBands;
    private RenderedImage input;
    private Raster inputRaster;
    private Rectangle destinationRegion = null;
    private SampleModel sampleModel;
    private boolean noTransform = true;
    private boolean noSubband = true;
    private boolean writeRaster = false;
    private boolean optimal = false;
    private int pxlStride;
    private int lineStride;
    private int bandStride;

    public RawImageWriter(ImageWriterSpi imageWriterSpi) {
        super(imageWriterSpi);
    }

    public void setOutput(Object object) {
        super.setOutput(object);
        if (object != null) {
            if (!(object instanceof ImageOutputStream)) {
                throw new IllegalArgumentException(I18N.getString("RawImageWriter0"));
            }
            this.stream = (ImageOutputStream)object;
        } else {
            this.stream = null;
        }
    }

    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata convertStreamMetadata(IIOMetadata iIOMetadata, ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata convertImageMetadata(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return null;
    }

    public boolean canWriteRasters() {
        return true;
    }

    public ImageWriteParam getDefaultWriteParam() {
        return new RawImageWriteParam(this.getLocale());
    }

    public void write(IIOMetadata iIOMetadata, IIOImage iIOImage, ImageWriteParam imageWriteParam) throws IOException {
        int n;
        this.clearAbortRequest();
        this.processImageStarted(this.imageIndex++);
        if (imageWriteParam == null) {
            imageWriteParam = this.getDefaultWriteParam();
        }
        this.writeRaster = iIOImage.hasRaster();
        Rectangle rectangle = imageWriteParam.getSourceRegion();
        ColorModel colorModel = null;
        Rectangle rectangle2 = null;
        if (this.writeRaster) {
            this.inputRaster = iIOImage.getRaster();
            this.sampleModel = this.inputRaster.getSampleModel();
            rectangle2 = this.inputRaster.getBounds();
        } else {
            this.input = iIOImage.getRenderedImage();
            this.sampleModel = this.input.getSampleModel();
            rectangle2 = new Rectangle(this.input.getMinX(), this.input.getMinY(), this.input.getWidth(), this.input.getHeight());
            colorModel = this.input.getColorModel();
        }
        rectangle = rectangle == null ? (Rectangle)rectangle2.clone() : rectangle.intersection(rectangle2);
        if (rectangle.isEmpty()) {
            throw new RuntimeException(I18N.getString("RawImageWriter1"));
        }
        this.scaleX = imageWriteParam.getSourceXSubsampling();
        this.scaleY = imageWriteParam.getSourceYSubsampling();
        this.xOffset = imageWriteParam.getSubsamplingXOffset();
        this.yOffset = imageWriteParam.getSubsamplingYOffset();
        rectangle.translate(this.xOffset, this.yOffset);
        rectangle.width -= this.xOffset;
        rectangle.height -= this.yOffset;
        this.xOffset = rectangle.x % this.scaleX;
        this.yOffset = rectangle.y % this.scaleY;
        int n2 = rectangle.x / this.scaleX;
        int n3 = rectangle.y / this.scaleY;
        int n4 = (rectangle.width + this.scaleX - 1) / this.scaleX;
        int n5 = (rectangle.height + this.scaleY - 1) / this.scaleY;
        this.destinationRegion = new Rectangle(n2, n3, n4, n5);
        this.noTransform = this.destinationRegion.equals(rectangle2);
        this.tileHeight = this.sampleModel.getHeight();
        this.tileWidth = this.sampleModel.getWidth();
        if (this.noTransform) {
            if (this.writeRaster) {
                this.tileXOffset = this.inputRaster.getMinX();
                this.tileYOffset = this.inputRaster.getMinY();
            } else {
                this.tileXOffset = this.input.getTileGridXOffset();
                this.tileYOffset = this.input.getTileGridYOffset();
            }
        } else {
            this.tileXOffset = this.destinationRegion.x;
            this.tileYOffset = this.destinationRegion.y;
        }
        this.sourceBands = imageWriteParam.getSourceBands();
        boolean bl = true;
        this.numBands = this.sampleModel.getNumBands();
        if (this.sourceBands != null) {
            this.sampleModel = this.sampleModel.createSubsetSampleModel(this.sourceBands);
            colorModel = null;
            bl = false;
            this.numBands = this.sampleModel.getNumBands();
        } else {
            this.sourceBands = new int[this.numBands];
            for (int i = 0; i < this.numBands; ++i) {
                this.sourceBands[i] = i;
            }
        }
        if (this.sampleModel instanceof ComponentSampleModel) {
            ComponentSampleModel componentSampleModel = (ComponentSampleModel)this.sampleModel;
            int[] nArray = componentSampleModel.getBandOffsets();
            this.bandStride = nArray[0];
            for (int i = 1; i < nArray.length; ++i) {
                if (this.bandStride <= nArray[i]) continue;
                this.bandStride = nArray[i];
            }
            int[] nArray2 = componentSampleModel.getBankIndices();
            n = nArray2[0];
            for (int i = 1; i < nArray2.length; ++i) {
                if (n <= nArray2[i]) continue;
                n = nArray2[i];
            }
            this.pxlStride = componentSampleModel.getPixelStride();
            this.lineStride = componentSampleModel.getScanlineStride();
            this.optimal = this.bandStride == 0 || this.pxlStride < this.lineStride && this.pxlStride == this.numBands || this.lineStride < this.pxlStride && this.lineStride == this.numBands || this.pxlStride < this.lineStride && this.lineStride == this.numBands * componentSampleModel.getWidth() || this.lineStride < this.pxlStride && this.pxlStride == this.numBands * componentSampleModel.getHeight() || componentSampleModel instanceof BandedSampleModel;
        } else if (this.sampleModel instanceof SinglePixelPackedSampleModel || this.sampleModel instanceof MultiPixelPackedSampleModel) {
            this.optimal = true;
        }
        int n6 = this.getMaxTileX() - this.getMinTileX() + 1;
        int n7 = n6 * (this.getMaxTileY() - this.getMinTileY() + 1);
        for (int i = this.getMinTileY(); i <= this.getMaxTileY(); ++i) {
            for (n = this.getMinTileX(); n <= this.getMaxTileX(); ++n) {
                this.writeRaster(this.getTile(n, i));
                float f2 = ((float)(n + i * n6) + 1.0f) / (float)n7;
                this.processImageProgress(f2 * 100.0f);
            }
        }
        this.stream.flush();
        if (this.abortRequested()) {
            this.processWriteAborted();
        } else {
            this.processImageComplete();
        }
    }

    public int getWidth() {
        return this.destinationRegion.width;
    }

    public int getHeight() {
        return this.destinationRegion.height;
    }

    private void writeRaster(Raster object) throws IOException {
        Object object2;
        Object object3;
        int n = 0;
        int n2 = 0;
        int[] nArray = null;
        int[] nArray2 = null;
        int n3 = 0;
        int n4 = this.sampleModel.getNumBands();
        int n5 = this.sampleModel.getDataType();
        if (this.sampleModel instanceof ComponentSampleModel) {
            int n6;
            object3 = (ComponentSampleModel)this.sampleModel;
            nArray2 = ((ComponentSampleModel)object3).getBandOffsets();
            for (n6 = 0; n6 < n4; ++n6) {
                if (n2 >= nArray2[n6]) continue;
                n2 = nArray2[n6];
            }
            nArray = ((ComponentSampleModel)object3).getBankIndices();
            for (n6 = 0; n6 < n4; ++n6) {
                if (n >= nArray[n6]) continue;
                n = nArray[n6];
            }
            n3 = (int)ImageUtil.getBandSize(this.sampleModel);
        }
        object3 = null;
        short[] sArray = null;
        int[] nArray3 = null;
        float[] fArray = null;
        double[] dArray = null;
        if (((Raster)object).getParent() != null && !this.sampleModel.equals(((Raster)object).getParent().getSampleModel())) {
            object2 = Raster.createWritableRaster(this.sampleModel, new Point(((Raster)object).getMinX(), ((Raster)object).getMinY()));
            ((WritableRaster)object2).setRect((Raster)object);
            object = object2;
        }
        object2 = ((Raster)object).getDataBuffer();
        if (this.optimal) {
            if (n > 0) {
                block61: for (int i = 0; i < this.numBands; ++i) {
                    int n7 = nArray[this.sourceBands[i]];
                    switch (n5) {
                        case 0: {
                            object3 = ((DataBufferByte)object2).getData(n7);
                            this.stream.write((byte[])object3, 0, ((Object)object3).length);
                            continue block61;
                        }
                        case 2: {
                            sArray = ((DataBufferShort)object2).getData(n7);
                            this.stream.writeShorts(sArray, 0, sArray.length);
                            continue block61;
                        }
                        case 1: {
                            sArray = ((DataBufferUShort)object2).getData(n7);
                            this.stream.writeShorts(sArray, 0, sArray.length);
                            continue block61;
                        }
                        case 3: {
                            nArray3 = ((DataBufferInt)object2).getData(n7);
                            this.stream.writeInts(nArray3, 0, nArray3.length);
                            continue block61;
                        }
                        case 4: {
                            fArray = ((DataBufferFloat)object2).getData(n7);
                            this.stream.writeFloats(fArray, 0, fArray.length);
                            continue block61;
                        }
                        case 5: {
                            dArray = ((DataBufferDouble)object2).getData(n7);
                            this.stream.writeDoubles(dArray, 0, dArray.length);
                        }
                    }
                }
            } else {
                switch (n5) {
                    case 0: {
                        object3 = ((DataBufferByte)object2).getData();
                        break;
                    }
                    case 2: {
                        sArray = ((DataBufferShort)object2).getData();
                        break;
                    }
                    case 1: {
                        sArray = ((DataBufferUShort)object2).getData();
                        break;
                    }
                    case 3: {
                        nArray3 = ((DataBufferInt)object2).getData();
                        break;
                    }
                    case 4: {
                        fArray = ((DataBufferFloat)object2).getData();
                        break;
                    }
                    case 5: {
                        dArray = ((DataBufferDouble)object2).getData();
                    }
                }
                if (!this.noSubband && n2 >= ((Raster)object).getWidth() * ((Raster)object).getHeight() * (this.numBands - 1)) {
                    block62: for (int i = 0; i < this.numBands; ++i) {
                        int n8 = nArray2[this.sourceBands[i]];
                        switch (n5) {
                            case 0: {
                                this.stream.write((byte[])object3, n8, n3);
                                continue block62;
                            }
                            case 1: 
                            case 2: {
                                this.stream.writeShorts(sArray, n8, n3);
                                continue block62;
                            }
                            case 3: {
                                this.stream.writeInts(nArray3, n8, n3);
                                continue block62;
                            }
                            case 4: {
                                this.stream.writeFloats(fArray, n8, n3);
                                continue block62;
                            }
                            case 5: {
                                this.stream.writeDoubles(dArray, n8, n3);
                            }
                        }
                    }
                } else {
                    switch (n5) {
                        case 0: {
                            this.stream.write((byte[])object3, 0, ((Object)object3).length);
                            break;
                        }
                        case 1: 
                        case 2: {
                            this.stream.writeShorts(sArray, 0, sArray.length);
                            break;
                        }
                        case 3: {
                            this.stream.writeInts(nArray3, 0, nArray3.length);
                            break;
                        }
                        case 4: {
                            this.stream.writeFloats(fArray, 0, fArray.length);
                            break;
                        }
                        case 5: {
                            this.stream.writeDoubles(dArray, 0, dArray.length);
                        }
                    }
                }
            }
        } else if (this.sampleModel instanceof ComponentSampleModel) {
            switch (n5) {
                case 0: {
                    object3 = ((DataBufferByte)object2).getData();
                    break;
                }
                case 2: {
                    sArray = ((DataBufferShort)object2).getData();
                    break;
                }
                case 1: {
                    sArray = ((DataBufferUShort)object2).getData();
                    break;
                }
                case 3: {
                    nArray3 = ((DataBufferInt)object2).getData();
                    break;
                }
                case 4: {
                    fArray = ((DataBufferFloat)object2).getData();
                    break;
                }
                case 5: {
                    dArray = ((DataBufferDouble)object2).getData();
                }
            }
            ComponentSampleModel componentSampleModel = (ComponentSampleModel)this.sampleModel;
            int n9 = componentSampleModel.getOffset(((Raster)object).getMinX() - ((Raster)object).getSampleModelTranslateX(), ((Raster)object).getMinY() - ((Raster)object).getSampleModelTranslateY()) - nArray2[0];
            int n10 = this.pxlStride;
            int n11 = 1;
            int n12 = this.pxlStride;
            int n13 = ((Raster)object).getWidth();
            int n14 = ((Raster)object).getHeight();
            int n15 = n13;
            int n16 = n14;
            if (n10 < this.lineStride) {
                if (n2 > this.pxlStride) {
                    n11 = n13;
                }
                n10 = this.lineStride;
            } else {
                if (n2 > this.lineStride) {
                    n11 = n14;
                }
                n12 = this.lineStride;
                n15 = n14;
                n16 = n13;
            }
            int n17 = n15 * this.numBands;
            byte[] byArray = null;
            short[] sArray2 = null;
            int[] nArray4 = null;
            float[] fArray2 = null;
            double[] dArray2 = null;
            Object object4 = null;
            Object[] objectArray = null;
            switch (n5) {
                case 0: {
                    object4 = object3;
                    objectArray = byArray = new byte[n17];
                    break;
                }
                case 1: 
                case 2: {
                    object4 = sArray;
                    sArray2 = new short[n17];
                    objectArray = sArray2;
                    break;
                }
                case 3: {
                    object4 = nArray3;
                    nArray4 = new int[n17];
                    objectArray = nArray4;
                    break;
                }
                case 4: {
                    object4 = fArray;
                    fArray2 = new float[n17];
                    objectArray = fArray2;
                    break;
                }
                case 5: {
                    object4 = dArray;
                    dArray2 = new double[n17];
                    objectArray = dArray2;
                }
            }
            if (n11 > 1) {
                for (int i = 0; i < n16; ++i) {
                    for (int j = 0; j < this.numBands; ++j) {
                        int n18 = nArray2[j];
                        System.arraycopy(object4, n9 + n18, objectArray, j * n15, n15);
                    }
                    switch (n5) {
                        case 0: {
                            this.stream.write((byte[])objectArray, 0, n17);
                            break;
                        }
                        case 1: 
                        case 2: {
                            this.stream.writeShorts((short[])objectArray, 0, n17);
                            break;
                        }
                        case 3: {
                            this.stream.writeInts((int[])objectArray, 0, n17);
                            break;
                        }
                        case 4: {
                            this.stream.writeFloats((float[])objectArray, 0, n17);
                            break;
                        }
                        case 5: {
                            this.stream.writeDoubles((double[])objectArray, 0, n17);
                        }
                    }
                    n9 += n10;
                }
            } else {
                switch (n5) {
                    case 0: {
                        for (int i = 0; i < n16; ++i) {
                            int n19 = 0;
                            for (int j = 0; j < this.numBands; ++j) {
                                int n20 = nArray2[j];
                                int n21 = 0;
                                int n22 = n9;
                                while (n21 < n15) {
                                    byArray[n19++] = (byte)object3[n22 + n20];
                                    ++n21;
                                    n22 += n12;
                                }
                            }
                            this.stream.write(byArray, 0, n17);
                            n9 += n10;
                        }
                        break;
                    }
                    case 1: 
                    case 2: {
                        for (int i = 0; i < n16; ++i) {
                            int n23 = 0;
                            for (int j = 0; j < this.numBands; ++j) {
                                int n24 = nArray2[j];
                                int n25 = 0;
                                int n26 = n9;
                                while (n25 < n15) {
                                    sArray2[n23++] = sArray[n26 + n24];
                                    ++n25;
                                    n26 += n12;
                                }
                            }
                            this.stream.writeShorts(sArray2, 0, n17);
                            n9 += n10;
                        }
                        break;
                    }
                    case 3: {
                        for (int i = 0; i < n16; ++i) {
                            int n27 = 0;
                            for (int j = 0; j < this.numBands; ++j) {
                                int n28 = nArray2[j];
                                int n29 = 0;
                                int n30 = n9;
                                while (n29 < n15) {
                                    nArray4[n27++] = nArray3[n30 + n28];
                                    ++n29;
                                    n30 += n12;
                                }
                            }
                            this.stream.writeInts(nArray4, 0, n17);
                            n9 += n10;
                        }
                        break;
                    }
                    case 4: {
                        for (int i = 0; i < n16; ++i) {
                            int n31 = 0;
                            for (int j = 0; j < this.numBands; ++j) {
                                int n32 = nArray2[j];
                                int n33 = 0;
                                int n34 = n9;
                                while (n33 < n15) {
                                    fArray2[n31++] = fArray[n34 + n32];
                                    ++n33;
                                    n34 += n12;
                                }
                            }
                            this.stream.writeFloats(fArray2, 0, n17);
                            n9 += n10;
                        }
                        break;
                    }
                    case 5: {
                        for (int i = 0; i < n16; ++i) {
                            int n35 = 0;
                            for (int j = 0; j < this.numBands; ++j) {
                                int n36 = nArray2[j];
                                int n37 = 0;
                                int n38 = n9;
                                while (n37 < n15) {
                                    dArray2[n35++] = dArray[n38 + n36];
                                    ++n37;
                                    n38 += n12;
                                }
                            }
                            this.stream.writeDoubles(dArray2, 0, n17);
                            n9 += n10;
                        }
                        break;
                    }
                }
            }
        }
    }

    private Raster getTile(int n, int n2) {
        int n3 = this.tileXOffset + n * this.tileWidth;
        int n4 = this.tileYOffset + n2 * this.tileHeight;
        Rectangle rectangle = new Rectangle(n3, n4, this.tileWidth, this.tileHeight);
        if (this.writeRaster) {
            rectangle = rectangle.intersection(this.destinationRegion);
            if (this.noTransform) {
                return this.inputRaster.createChild(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle.x, rectangle.y, this.sourceBands);
            }
            n3 = rectangle.x;
            n4 = rectangle.y;
            WritableRaster writableRaster = Raster.createWritableRaster(this.sampleModel, new Point(n3, n4));
            int n5 = this.mapToSourceX(n3);
            int n6 = this.mapToSourceY(n4);
            int n7 = this.inputRaster.getMinY();
            int n8 = this.inputRaster.getMinY() + this.inputRaster.getHeight();
            int n9 = rectangle.width;
            int n10 = (n9 - 1) * this.scaleX + 1;
            int n11 = 0;
            while (n11 < rectangle.height) {
                if (n6 >= n7 && n6 < n8) {
                    Raster raster = this.inputRaster.createChild(n5, n6, n10, 1, n5, n6, null);
                    int n12 = n3;
                    int n13 = 0;
                    int n14 = n5;
                    while (n13 < n9) {
                        for (int i = 0; i < this.numBands; ++i) {
                            int n15 = raster.getSample(n14, n6, this.sourceBands[i]);
                            writableRaster.setSample(n12, n4, i, n15);
                        }
                        ++n13;
                        ++n12;
                        n14 += this.scaleX;
                    }
                }
                ++n11;
                ++n4;
                n6 += this.scaleY;
            }
            return writableRaster;
        }
        if (this.noTransform) {
            Raster raster = this.input.getTile(n, n2);
            if (this.destinationRegion.contains(rectangle) && this.noSubband) {
                return raster;
            }
            rectangle = rectangle.intersection(this.destinationRegion);
            return raster.createChild(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle.x, rectangle.y, this.sourceBands);
        }
        rectangle = rectangle.intersection(this.destinationRegion);
        n3 = rectangle.x;
        n4 = rectangle.y;
        WritableRaster writableRaster = Raster.createWritableRaster(this.sampleModel, new Point(n3, n4));
        int n16 = this.mapToSourceX(n3);
        int n17 = this.mapToSourceY(n4);
        int n18 = this.input.getMinY();
        int n19 = this.input.getMinY() + this.input.getHeight();
        int n20 = rectangle.width;
        int n21 = (n20 - 1) * this.scaleX + 1;
        int n22 = 0;
        while (n22 < rectangle.height) {
            if (n17 >= n18 && n17 < n19) {
                Raster raster = this.input.getData(new Rectangle(n16, n17, n21, 1));
                int n23 = n3;
                int n24 = 0;
                int n25 = n16;
                while (n24 < n20) {
                    for (int i = 0; i < this.numBands; ++i) {
                        int n26 = raster.getSample(n25, n17, this.sourceBands[i]);
                        writableRaster.setSample(n23, n4, i, n26);
                    }
                    ++n24;
                    ++n23;
                    n25 += this.scaleX;
                }
            }
            ++n22;
            ++n4;
            n17 += this.scaleY;
        }
        return writableRaster;
    }

    private int mapToSourceX(int n) {
        return n * this.scaleX + this.xOffset;
    }

    private int mapToSourceY(int n) {
        return n * this.scaleY + this.yOffset;
    }

    private int getMinTileX() {
        return RawImageWriter.ToTile(this.destinationRegion.x, this.tileXOffset, this.tileWidth);
    }

    private int getMaxTileX() {
        return RawImageWriter.ToTile(this.destinationRegion.x + this.destinationRegion.width - 1, this.tileXOffset, this.tileWidth);
    }

    private int getMinTileY() {
        return RawImageWriter.ToTile(this.destinationRegion.y, this.tileYOffset, this.tileHeight);
    }

    private int getMaxTileY() {
        return RawImageWriter.ToTile(this.destinationRegion.y + this.destinationRegion.height - 1, this.tileYOffset, this.tileHeight);
    }

    private static int ToTile(int n, int n2, int n3) {
        if ((n -= n2) < 0) {
            n += 1 - n3;
        }
        return n / n3;
    }

    public void reset() {
        super.reset();
        this.stream = null;
        this.optimal = false;
        this.sourceBands = null;
        this.destinationRegion = null;
        this.noTransform = true;
        this.noSubband = true;
        this.writeRaster = false;
    }
}

