/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.TIFFColorConverter;
import com.sun.media.imageio.plugins.tiff.TIFFField;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageMetadata;

public class TIFFYCbCrColorConverter
extends TIFFColorConverter {
    private float LumaRed = 0.299f;
    private float LumaGreen = 0.587f;
    private float LumaBlue = 0.114f;
    private float referenceBlackY = 0.0f;
    private float referenceWhiteY = 255.0f;
    private float referenceBlackCb = 128.0f;
    private float referenceWhiteCb = 255.0f;
    private float referenceBlackCr = 128.0f;
    private float referenceWhiteCr = 255.0f;
    private float codingRangeY = 255.0f;
    private float codingRangeCbCr = 127.0f;

    public TIFFYCbCrColorConverter(TIFFImageMetadata tIFFImageMetadata) {
        TIFFImageMetadata tIFFImageMetadata2 = tIFFImageMetadata;
        TIFFField tIFFField = tIFFImageMetadata2.getTIFFField(529);
        if (tIFFField != null && tIFFField.getCount() == 3) {
            this.LumaRed = tIFFField.getAsFloat(0);
            this.LumaGreen = tIFFField.getAsFloat(1);
            this.LumaBlue = tIFFField.getAsFloat(2);
        }
        if ((tIFFField = tIFFImageMetadata2.getTIFFField(532)) != null && tIFFField.getCount() == 6) {
            this.referenceBlackY = tIFFField.getAsFloat(0);
            this.referenceWhiteY = tIFFField.getAsFloat(1);
            this.referenceBlackCb = tIFFField.getAsFloat(2);
            this.referenceWhiteCb = tIFFField.getAsFloat(3);
            this.referenceBlackCr = tIFFField.getAsFloat(4);
            this.referenceWhiteCr = tIFFField.getAsFloat(5);
        }
    }

    public void fromRGB(float f2, float f3, float f4, float[] fArray) {
        float f5 = this.LumaRed * f2 + this.LumaGreen * f3 + this.LumaBlue * f4;
        float f6 = (f4 - f5) / (2.0f - 2.0f * this.LumaBlue);
        float f7 = (f2 - f5) / (2.0f - 2.0f * this.LumaRed);
        fArray[0] = f5 * (this.referenceWhiteY - this.referenceBlackY) / this.codingRangeY + this.referenceBlackY;
        fArray[1] = f6 * (this.referenceWhiteCb - this.referenceBlackCb) / this.codingRangeCbCr + this.referenceBlackCb;
        fArray[2] = f7 * (this.referenceWhiteCr - this.referenceBlackCr) / this.codingRangeCbCr + this.referenceBlackCr;
    }

    public void toRGB(float f2, float f3, float f4, float[] fArray) {
        float f5 = (f2 - this.referenceBlackY) * this.codingRangeY / (this.referenceWhiteY - this.referenceBlackY);
        float f6 = (f3 - this.referenceBlackCb) * this.codingRangeCbCr / (this.referenceWhiteCb - this.referenceBlackCb);
        float f7 = (f4 - this.referenceBlackCr) * this.codingRangeCbCr / (this.referenceWhiteCr - this.referenceBlackCr);
        fArray[0] = f7 * (2.0f - 2.0f * this.LumaRed) + f5;
        fArray[2] = f6 * (2.0f - 2.0f * this.LumaBlue) + f5;
        fArray[1] = (f5 - this.LumaBlue * fArray[2] - this.LumaRed * fArray[0]) / this.LumaGreen;
    }
}

