/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageio.plugins.tiff.TIFFDecompressor;
import com.sun.media.imageio.plugins.tiff.TIFFField;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageMetadata;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageReader;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;

public class TIFFYCbCrDecompressor
extends TIFFDecompressor {
    private static final boolean debug = false;
    private static final int FRAC_BITS = 16;
    private static final float FRAC_SCALE = 65536.0f;
    private float LumaRed = 0.299f;
    private float LumaGreen = 0.587f;
    private float LumaBlue = 0.114f;
    private float referenceBlackY = 0.0f;
    private float referenceWhiteY = 255.0f;
    private float referenceBlackCb = 128.0f;
    private float referenceWhiteCb = 255.0f;
    private float referenceBlackCr = 128.0f;
    private float referenceWhiteCr = 255.0f;
    private float codingRangeY = 255.0f;
    private int[] iYTab = new int[256];
    private int[] iCbTab = new int[256];
    private int[] iCrTab = new int[256];
    private int[] iGYTab = new int[256];
    private int[] iGCbTab = new int[256];
    private int[] iGCrTab = new int[256];
    private int chromaSubsampleH = 2;
    private int chromaSubsampleV = 2;
    private boolean colorConvert;
    private TIFFDecompressor decompressor;
    private BufferedImage tmpImage;

    public TIFFYCbCrDecompressor(TIFFDecompressor tIFFDecompressor, boolean bl) {
        this.decompressor = tIFFDecompressor;
        this.colorConvert = bl;
    }

    private void warning(String string) {
        if (this.reader instanceof TIFFImageReader) {
            ((TIFFImageReader)this.reader).forwardWarningMessage(string);
        }
    }

    public void setReader(ImageReader imageReader) {
        if (this.decompressor != null) {
            this.decompressor.setReader(imageReader);
        }
        super.setReader(imageReader);
    }

    public void setMetadata(IIOMetadata iIOMetadata) {
        if (this.decompressor != null) {
            this.decompressor.setMetadata(iIOMetadata);
        }
        super.setMetadata(iIOMetadata);
    }

    public void setPhotometricInterpretation(int n) {
        if (this.decompressor != null) {
            this.decompressor.setPhotometricInterpretation(n);
        }
        super.setPhotometricInterpretation(n);
    }

    public void setCompression(int n) {
        if (this.decompressor != null) {
            this.decompressor.setCompression(n);
        }
        super.setCompression(n);
    }

    public void setPlanar(boolean bl) {
        if (this.decompressor != null) {
            this.decompressor.setPlanar(bl);
        }
        super.setPlanar(bl);
    }

    public void setSamplesPerPixel(int n) {
        if (this.decompressor != null) {
            this.decompressor.setSamplesPerPixel(n);
        }
        super.setSamplesPerPixel(n);
    }

    public void setBitsPerSample(int[] nArray) {
        if (this.decompressor != null) {
            this.decompressor.setBitsPerSample(nArray);
        }
        super.setBitsPerSample(nArray);
    }

    public void setSampleFormat(int[] nArray) {
        if (this.decompressor != null) {
            this.decompressor.setSampleFormat(nArray);
        }
        super.setSampleFormat(nArray);
    }

    public void setExtraSamples(int[] nArray) {
        if (this.decompressor != null) {
            this.decompressor.setExtraSamples(nArray);
        }
        super.setExtraSamples(nArray);
    }

    public void setColorMap(char[] cArray) {
        if (this.decompressor != null) {
            this.decompressor.setColorMap(cArray);
        }
        super.setColorMap(cArray);
    }

    public void setStream(ImageInputStream imageInputStream) {
        if (this.decompressor != null) {
            this.decompressor.setStream(imageInputStream);
        } else {
            super.setStream(imageInputStream);
        }
    }

    public void setOffset(long l) {
        if (this.decompressor != null) {
            this.decompressor.setOffset(l);
        }
        super.setOffset(l);
    }

    public void setByteCount(int n) {
        if (this.decompressor != null) {
            this.decompressor.setByteCount(n);
        }
        super.setByteCount(n);
    }

    public void setSrcMinX(int n) {
        if (this.decompressor != null) {
            this.decompressor.setSrcMinX(n);
        }
        super.setSrcMinX(n);
    }

    public void setSrcMinY(int n) {
        if (this.decompressor != null) {
            this.decompressor.setSrcMinY(n);
        }
        super.setSrcMinY(n);
    }

    public void setSrcWidth(int n) {
        if (this.decompressor != null) {
            this.decompressor.setSrcWidth(n);
        }
        super.setSrcWidth(n);
    }

    public void setSrcHeight(int n) {
        if (this.decompressor != null) {
            this.decompressor.setSrcHeight(n);
        }
        super.setSrcHeight(n);
    }

    public void setSourceXOffset(int n) {
        if (this.decompressor != null) {
            this.decompressor.setSourceXOffset(n);
        }
        super.setSourceXOffset(n);
    }

    public void setDstXOffset(int n) {
        if (this.decompressor != null) {
            this.decompressor.setDstXOffset(n);
        }
        super.setDstXOffset(n);
    }

    public void setSourceYOffset(int n) {
        if (this.decompressor != null) {
            this.decompressor.setSourceYOffset(n);
        }
        super.setSourceYOffset(n);
    }

    public void setDstYOffset(int n) {
        if (this.decompressor != null) {
            this.decompressor.setDstYOffset(n);
        }
        super.setDstYOffset(n);
    }

    public void setSourceBands(int[] nArray) {
        if (this.decompressor != null) {
            this.decompressor.setSourceBands(nArray);
        }
        super.setSourceBands(nArray);
    }

    public void setDestinationBands(int[] nArray) {
        if (this.decompressor != null) {
            this.decompressor.setDestinationBands(nArray);
        }
        super.setDestinationBands(nArray);
    }

    public void setImage(BufferedImage bufferedImage) {
        if (this.decompressor != null) {
            ColorModel colorModel = bufferedImage.getColorModel();
            this.tmpImage = new BufferedImage(colorModel, bufferedImage.getRaster().createCompatibleWritableRaster(1, 1), colorModel.isAlphaPremultiplied(), null);
            this.decompressor.setImage(this.tmpImage);
        }
        super.setImage(bufferedImage);
    }

    public void setDstMinX(int n) {
        if (this.decompressor != null) {
            this.decompressor.setDstMinX(n);
        }
        super.setDstMinX(n);
    }

    public void setDstMinY(int n) {
        if (this.decompressor != null) {
            this.decompressor.setDstMinY(n);
        }
        super.setDstMinY(n);
    }

    public void setDstWidth(int n) {
        if (this.decompressor != null) {
            this.decompressor.setDstWidth(n);
        }
        super.setDstWidth(n);
    }

    public void setDstHeight(int n) {
        if (this.decompressor != null) {
            this.decompressor.setDstHeight(n);
        }
        super.setDstHeight(n);
    }

    public void setActiveSrcMinX(int n) {
        if (this.decompressor != null) {
            this.decompressor.setActiveSrcMinX(n);
        }
        super.setActiveSrcMinX(n);
    }

    public void setActiveSrcMinY(int n) {
        if (this.decompressor != null) {
            this.decompressor.setActiveSrcMinY(n);
        }
        super.setActiveSrcMinY(n);
    }

    public void setActiveSrcWidth(int n) {
        if (this.decompressor != null) {
            this.decompressor.setActiveSrcWidth(n);
        }
        super.setActiveSrcWidth(n);
    }

    public void setActiveSrcHeight(int n) {
        if (this.decompressor != null) {
            this.decompressor.setActiveSrcHeight(n);
        }
        super.setActiveSrcHeight(n);
    }

    private byte clamp(int n) {
        if (n < 0) {
            return 0;
        }
        if (n > 0xFF0000) {
            return -1;
        }
        return (byte)(n >> 16);
    }

    public void beginDecoding() {
        TIFFImageMetadata tIFFImageMetadata;
        TIFFField tIFFField;
        if (this.decompressor != null) {
            this.decompressor.beginDecoding();
        }
        if ((tIFFField = (tIFFImageMetadata = (TIFFImageMetadata)this.metadata).getTIFFField(530)) != null) {
            if (tIFFField.getCount() == 2) {
                this.chromaSubsampleH = tIFFField.getAsInt(0);
                this.chromaSubsampleV = tIFFField.getAsInt(1);
                if (this.chromaSubsampleH != 1 && this.chromaSubsampleH != 2 && this.chromaSubsampleH != 4) {
                    this.warning("Y_CB_CR_SUBSAMPLING[0] has illegal value " + this.chromaSubsampleH + " (should be 1, 2, or 4), setting to 1");
                    this.chromaSubsampleH = 1;
                }
                if (this.chromaSubsampleV != 1 && this.chromaSubsampleV != 2 && this.chromaSubsampleV != 4) {
                    this.warning("Y_CB_CR_SUBSAMPLING[1] has illegal value " + this.chromaSubsampleV + " (should be 1, 2, or 4), setting to 1");
                    this.chromaSubsampleV = 1;
                }
            } else {
                this.warning("Y_CB_CR_SUBSAMPLING count != 2, assuming no subsampling");
            }
        }
        if ((tIFFField = tIFFImageMetadata.getTIFFField(529)) != null) {
            if (tIFFField.getCount() == 3) {
                this.LumaRed = tIFFField.getAsFloat(0);
                this.LumaGreen = tIFFField.getAsFloat(1);
                this.LumaBlue = tIFFField.getAsFloat(2);
            } else {
                this.warning("Y_CB_CR_COEFFICIENTS count != 3, assuming default values for CCIR 601-1");
            }
        }
        if ((tIFFField = tIFFImageMetadata.getTIFFField(532)) != null) {
            if (tIFFField.getCount() == 6) {
                this.referenceBlackY = tIFFField.getAsFloat(0);
                this.referenceWhiteY = tIFFField.getAsFloat(1);
                this.referenceBlackCb = tIFFField.getAsFloat(2);
                this.referenceWhiteCb = tIFFField.getAsFloat(3);
                this.referenceBlackCr = tIFFField.getAsFloat(4);
                this.referenceWhiteCr = tIFFField.getAsFloat(5);
            } else {
                this.warning("REFERENCE_BLACK_WHITE count != 6, ignoring it");
            }
        } else {
            this.warning("REFERENCE_BLACK_WHITE not found, assuming 0-255/128-255/128-255");
        }
        this.colorConvert = true;
        float f2 = 2.0f - 2.0f * this.LumaBlue;
        float f3 = 2.0f - 2.0f * this.LumaRed;
        float f4 = (1.0f - this.LumaBlue - this.LumaRed) / this.LumaGreen;
        float f5 = 2.0f * this.LumaBlue * (this.LumaBlue - 1.0f) / this.LumaGreen;
        float f6 = 2.0f * this.LumaRed * (this.LumaRed - 1.0f) / this.LumaGreen;
        for (int i = 0; i < 256; ++i) {
            float f7 = ((float)i - this.referenceBlackY) * this.codingRangeY / (this.referenceWhiteY - this.referenceBlackY);
            float f8 = ((float)i - this.referenceBlackCb) * 127.0f / (this.referenceWhiteCb - this.referenceBlackCb);
            float f9 = ((float)i - this.referenceBlackCr) * 127.0f / (this.referenceWhiteCr - this.referenceBlackCr);
            this.iYTab[i] = (int)(f7 * 65536.0f);
            this.iCbTab[i] = (int)(f8 * f2 * 65536.0f);
            this.iCrTab[i] = (int)(f9 * f3 * 65536.0f);
            this.iGYTab[i] = (int)(f7 * f4 * 65536.0f);
            this.iGCbTab[i] = (int)(f8 * f5 * 65536.0f);
            this.iGCrTab[i] = (int)(f9 * f6 * 65536.0f);
        }
    }

    public void decodeRaw(byte[] byArray, int n, int n2, int n3) throws IOException {
        int n4;
        byte[] byArray2 = new byte[3 * this.srcWidth * this.chromaSubsampleV];
        int n5 = this.chromaSubsampleH * this.chromaSubsampleV + 2;
        byte[] byArray3 = new byte[n5];
        if (this.decompressor != null) {
            n4 = 3 * this.srcWidth;
            byte[] byArray4 = new byte[n4 * this.srcHeight];
            this.decompressor.decodeRaw(byArray4, n, n2, n4);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray4);
            this.stream = new MemoryCacheImageInputStream(byteArrayInputStream);
        } else {
            this.stream.seek(this.offset);
        }
        for (n4 = this.srcMinY; n4 < this.srcMinY + this.srcHeight; n4 += this.chromaSubsampleV) {
            block3: for (int i = this.srcMinX; i < this.srcMinX + this.srcWidth; i += this.chromaSubsampleH) {
                int n6;
                int n7;
                try {
                    this.stream.readFully(byArray3);
                }
                catch (EOFException eOFException) {
                    System.out.println("e = " + eOFException);
                    return;
                }
                byte by = byArray3[n5 - 2];
                byte by2 = byArray3[n5 - 1];
                int n8 = 0;
                int n9 = 0;
                int n10 = 0;
                int n11 = 0;
                if (this.colorConvert) {
                    n7 = by & 0xFF;
                    n6 = by2 & 0xFF;
                    n8 = this.iCbTab[n7];
                    n9 = this.iCrTab[n6];
                    n10 = this.iGCbTab[n7];
                    n11 = this.iGCrTab[n6];
                }
                n7 = 0;
                for (n6 = 0; n6 < this.chromaSubsampleV; ++n6) {
                    int n12 = n + 3 * (i - this.srcMinX) + n3 * (n4 - this.srcMinY + n6);
                    if (n4 + n6 >= this.srcMinY + this.srcHeight) continue block3;
                    for (int j = 0; j < this.chromaSubsampleH && i + j < this.srcMinX + this.srcWidth; ++j) {
                        byte by3 = byArray3[n7++];
                        if (this.colorConvert) {
                            int n13 = by3 & 0xFF;
                            int n14 = this.iYTab[n13];
                            int n15 = this.iGYTab[n13];
                            int n16 = n14 + n9;
                            int n17 = n15 + n10 + n11;
                            int n18 = n14 + n8;
                            byte by4 = this.clamp(n16);
                            byte by5 = this.clamp(n17);
                            byte by6 = this.clamp(n18);
                            byArray[n12] = by4;
                            byArray[n12 + 1] = by5;
                            byArray[n12 + 2] = by6;
                        } else {
                            byArray[n12] = by3;
                            byArray[n12 + 1] = by;
                            byArray[n12 + 2] = by2;
                        }
                        n12 += 3;
                    }
                }
            }
        }
    }
}

