/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGQTable;
import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.ImageEncoderImpl;
import com.sun.media.jai.codec.JPEGEncodeParam;
import com.sun.media.jai.codecimpl.CodecUtils;
import com.sun.media.jai.codecimpl.ImagingListenerProxy;
import com.sun.media.jai.codecimpl.JaiI18N;
import com.sun.media.jai.codecimpl.util.ImagingException;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.OutputStream;

public class JPEGImageEncoder
extends ImageEncoderImpl {
    private JPEGEncodeParam jaiEP = null;

    public JPEGImageEncoder(OutputStream outputStream, ImageEncodeParam imageEncodeParam) {
        super(outputStream, imageEncodeParam);
        if (imageEncodeParam != null) {
            this.jaiEP = (JPEGEncodeParam)imageEncodeParam;
        }
    }

    static void modifyEncodeParam(JPEGEncodeParam jPEGEncodeParam, com.sun.image.codec.jpeg.JPEGEncodeParam jPEGEncodeParam2, int n) {
        int n2;
        int n3 = 0;
        while (n3 < n) {
            n2 = jPEGEncodeParam.getHorizontalSubsampling(n3);
            jPEGEncodeParam2.setHorizontalSubsampling(n3, n2);
            n2 = jPEGEncodeParam.getVerticalSubsampling(n3);
            jPEGEncodeParam2.setVerticalSubsampling(n3, n2);
            if (jPEGEncodeParam.isQTableSet(n3)) {
                int[] nArray = jPEGEncodeParam.getQTable(n3);
                n2 = jPEGEncodeParam.getQTableSlot(n3);
                jPEGEncodeParam2.setQTableComponentMapping(n3, n2);
                jPEGEncodeParam2.setQTable(n2, new JPEGQTable(nArray));
            }
            ++n3;
        }
        if (jPEGEncodeParam.isQualitySet()) {
            float f2 = jPEGEncodeParam.getQuality();
            jPEGEncodeParam2.setQuality(f2, true);
        }
        n2 = jPEGEncodeParam.getRestartInterval();
        jPEGEncodeParam2.setRestartInterval(n2);
        if (jPEGEncodeParam.getWriteTablesOnly()) {
            jPEGEncodeParam2.setImageInfoValid(false);
            jPEGEncodeParam2.setTableInfoValid(true);
        }
        if (jPEGEncodeParam.getWriteImageOnly()) {
            jPEGEncodeParam2.setTableInfoValid(false);
            jPEGEncodeParam2.setImageInfoValid(true);
        }
        if (!jPEGEncodeParam.getWriteJFIFHeader()) {
            jPEGEncodeParam2.setMarkerData(224, null);
        }
    }

    public void encode(RenderedImage renderedImage) throws IOException {
        BufferedImage bufferedImage;
        IndexColorModel indexColorModel;
        SampleModel sampleModel = renderedImage.getSampleModel();
        ColorModel colorModel = renderedImage.getColorModel();
        int n = colorModel.getNumColorComponents();
        int n2 = sampleModel.getTransferType();
        if (n2 != 0 && !CodecUtils.isPackedByteImage(renderedImage) || n != 1 && n != 3) {
            throw new RuntimeException(JaiI18N.getString("JPEGImageEncoder0"));
        }
        int n3 = colorModel.getColorSpace().getType();
        if (n3 != 6 && n3 != 5) {
            throw new Error(JaiI18N.getString("JPEGImageEncoder1"));
        }
        Raster raster = renderedImage.getData();
        WritableRaster writableRaster = raster instanceof WritableRaster ? (WritableRaster)raster : Raster.createWritableRaster(raster.getSampleModel(), raster.getDataBuffer(), new Point(raster.getSampleModelTranslateX(), raster.getSampleModelTranslateY()));
        if (writableRaster.getMinX() != 0 || writableRaster.getMinY() != 0) {
            writableRaster = writableRaster.createWritableTranslatedChild(0, 0);
        }
        com.sun.image.codec.jpeg.JPEGEncodeParam jPEGEncodeParam = null;
        if (colorModel instanceof IndexColorModel) {
            indexColorModel = (IndexColorModel)colorModel;
            bufferedImage = indexColorModel.convertToIntDiscrete(writableRaster, false);
            jPEGEncodeParam = JPEGCodec.getDefaultJPEGEncodeParam((BufferedImage)bufferedImage);
        } else {
            bufferedImage = new BufferedImage(colorModel, writableRaster, false, null);
            jPEGEncodeParam = JPEGCodec.getDefaultJPEGEncodeParam((BufferedImage)bufferedImage);
        }
        if (this.jaiEP != null) {
            JPEGImageEncoder.modifyEncodeParam(this.jaiEP, jPEGEncodeParam, n);
        }
        indexColorModel = JPEGCodec.createJPEGEncoder((OutputStream)this.output, (com.sun.image.codec.jpeg.JPEGEncodeParam)jPEGEncodeParam);
        try {
            indexColorModel.encode(bufferedImage);
        }
        catch (IOException iOException) {
            String string = JaiI18N.getString("JPEGImageEncoder2");
            ImagingListenerProxy.errorOccurred(string, new ImagingException(string, iOException), this, false);
        }
    }
}

