/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl.util;

import com.sun.media.jai.codecimpl.util.ComponentSampleModelJAI;
import com.sun.media.jai.codecimpl.util.JaiI18N;
import com.sun.media.jai.codecimpl.util.RasterFactory;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;

public class FloatDoubleColorModel
extends ComponentColorModel {
    protected ColorSpace colorSpace;
    protected int colorSpaceType;
    protected int numColorComponents;
    protected int numComponents;
    protected int transparency;
    protected boolean hasAlpha;
    protected boolean isAlphaPremultiplied;

    private static int[] bitsHelper(int n, ColorSpace colorSpace, boolean bl) {
        int n2 = n == 4 ? 32 : 64;
        int n3 = colorSpace.getNumComponents();
        if (bl) {
            ++n3;
        }
        int[] nArray = new int[n3];
        int n4 = 0;
        while (n4 < n3) {
            nArray[n4] = n2;
            ++n4;
        }
        return nArray;
    }

    public FloatDoubleColorModel(ColorSpace colorSpace, boolean bl, boolean bl2, int n, int n2) {
        super(colorSpace, FloatDoubleColorModel.bitsHelper(n2, colorSpace, bl), bl, bl2, n, n2);
        if (n2 != 4 && n2 != 5) {
            throw new IllegalArgumentException(JaiI18N.getString("FloatDoubleColorModel0"));
        }
        this.colorSpace = colorSpace;
        this.colorSpaceType = colorSpace.getType();
        this.numComponents = this.numColorComponents = colorSpace.getNumComponents();
        if (bl) {
            ++this.numComponents;
        }
        this.transparency = n;
        this.hasAlpha = bl;
        this.isAlphaPremultiplied = bl2;
    }

    public int getRed(int n) {
        throw new IllegalArgumentException(JaiI18N.getString("FloatDoubleColorModel1"));
    }

    public int getGreen(int n) {
        throw new IllegalArgumentException(JaiI18N.getString("FloatDoubleColorModel2"));
    }

    public int getBlue(int n) {
        throw new IllegalArgumentException(JaiI18N.getString("FloatDoubleColorModel3"));
    }

    public int getAlpha(int n) {
        throw new IllegalArgumentException(JaiI18N.getString("FloatDoubleColorModel4"));
    }

    public int getRGB(int n) {
        throw new IllegalArgumentException(JaiI18N.getString("FloatDoubleColorModel5"));
    }

    private final int clamp(float f2) {
        return f2 >= 0.0f ? (f2 > 255.0f ? 255 : (int)f2) : 0;
    }

    private final int clamp(double d2) {
        return d2 >= 0.0 ? (d2 > 255.0 ? 255 : (int)d2) : 0;
    }

    private int getSample(Object object, int n) {
        float[] fArray;
        boolean bl = this.hasAlpha && this.isAlphaPremultiplied;
        int n2 = this.colorSpaceType;
        boolean bl2 = this.colorSpace.isCS_sRGB();
        if (n2 == 6) {
            n = 0;
            bl2 = true;
        }
        if (bl2) {
            if (this.transferType == 4) {
                float[] fArray2 = (float[])object;
                float f2 = fArray2[n] * 255.0f;
                if (bl) {
                    float f3 = fArray2[this.numColorComponents];
                    if ((double)f3 == 0.0) {
                        return 0;
                    }
                    return this.clamp(f2 / f3);
                }
                return this.clamp(f2);
            }
            double[] dArray = (double[])object;
            double d2 = dArray[n] * 255.0;
            if (bl) {
                double d3 = dArray[this.numColorComponents];
                if (d3 == 0.0) {
                    return 0;
                }
                return this.clamp(d2 / d3);
            }
            return this.clamp(d2);
        }
        if (this.transferType == 4) {
            float[] fArray3;
            float[] fArray4 = (float[])object;
            if (bl) {
                float f4 = fArray4[this.numColorComponents];
                if ((double)f4 == 0.0) {
                    return 0;
                }
                float[] fArray5 = new float[this.numColorComponents];
                int n3 = 0;
                while (n3 < this.numColorComponents) {
                    fArray5[n3] = fArray4[n3] / f4;
                    ++n3;
                }
                fArray3 = this.colorSpace.toRGB(fArray5);
            } else {
                fArray3 = this.colorSpace.toRGB(fArray4);
            }
            return (int)(fArray3[n] * 255.0f);
        }
        double[] dArray = (double[])object;
        float[] fArray6 = new float[this.numColorComponents];
        if (bl) {
            double d4 = dArray[this.numColorComponents];
            if (d4 == 0.0) {
                return 0;
            }
            int n4 = 0;
            while (n4 < this.numColorComponents) {
                fArray6[n4] = (float)(dArray[n4] / d4);
                ++n4;
            }
            fArray = this.colorSpace.toRGB(fArray6);
        } else {
            int n5 = 0;
            while (n5 < this.numColorComponents) {
                fArray6[n5] = (float)dArray[n5];
                ++n5;
            }
            fArray = this.colorSpace.toRGB(fArray6);
        }
        return (int)(fArray[n] * 255.0f);
    }

    public int getRed(Object object) {
        return this.getSample(object, 0);
    }

    public int getGreen(Object object) {
        return this.getSample(object, 1);
    }

    public int getBlue(Object object) {
        return this.getSample(object, 2);
    }

    public int getAlpha(Object object) {
        if (object == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (!this.hasAlpha) {
            return 255;
        }
        if (this.transferType == 4) {
            float[] fArray = (float[])object;
            return (int)(fArray[this.numColorComponents] * 255.0f);
        }
        double[] dArray = (double[])object;
        return (int)(dArray[this.numColorComponents] * 255.0);
    }

    public int getRGB(Object object) {
        int n;
        int n2;
        int n3;
        boolean bl = this.hasAlpha && this.isAlphaPremultiplied;
        int n4 = 255;
        if (this.colorSpace.isCS_sRGB()) {
            if (this.transferType == 4) {
                float[] fArray = (float[])object;
                float f2 = fArray[0];
                float f3 = fArray[1];
                float f4 = fArray[2];
                float f5 = 255.0f;
                if (bl) {
                    float f6 = fArray[3];
                    f5 /= f6;
                    n4 = this.clamp(255.0f * f6);
                }
                n3 = this.clamp(f2 * f5);
                n2 = this.clamp(f3 * f5);
                n = this.clamp(f4 * f5);
            } else {
                double[] dArray = (double[])object;
                double d2 = dArray[0];
                double d3 = dArray[1];
                double d4 = dArray[2];
                double d5 = 255.0;
                if (bl) {
                    double d6 = dArray[3];
                    d5 /= d6;
                    n4 = this.clamp(255.0 * d6);
                }
                n3 = this.clamp(d2 * d5);
                n2 = this.clamp(d3 * d5);
                n = this.clamp(d4 * d5);
            }
        } else if (this.colorSpaceType == 6) {
            if (this.transferType == 4) {
                float[] fArray = (float[])object;
                float f7 = fArray[0];
                if (bl) {
                    float f8 = fArray[1];
                    n2 = n = this.clamp(f7 * 255.0f / f8);
                    n3 = n;
                    n4 = this.clamp(255.0f * f8);
                } else {
                    n2 = n = this.clamp(f7 * 255.0f);
                    n3 = n;
                }
            } else {
                double[] dArray = (double[])object;
                double d7 = dArray[0];
                if (bl) {
                    double d8 = dArray[1];
                    n2 = n = this.clamp(d7 * 255.0 / d8);
                    n3 = n;
                    n4 = this.clamp(255.0 * d8);
                } else {
                    n2 = n = this.clamp(d7 * 255.0);
                    n3 = n;
                }
            }
        } else {
            float[] fArray;
            if (this.transferType == 4) {
                float[] fArray2 = (float[])object;
                if (bl) {
                    float f9 = fArray2[this.numColorComponents];
                    float f10 = 1.0f / f9;
                    fArray = new float[this.numColorComponents];
                    int n5 = 0;
                    while (n5 < this.numColorComponents) {
                        fArray[n5] = fArray2[n5] * f10;
                        ++n5;
                    }
                    n4 = this.clamp(255.0f * f9);
                } else {
                    fArray = fArray2;
                }
            } else {
                double[] dArray = (double[])object;
                fArray = new float[this.numColorComponents];
                if (bl) {
                    double d9 = dArray[this.numColorComponents];
                    double d10 = 1.0 / d9;
                    int n6 = 0;
                    while (n6 < this.numColorComponents) {
                        fArray[n6] = (float)(dArray[n6] * d10);
                        ++n6;
                    }
                    n4 = this.clamp(255.0 * d9);
                } else {
                    int n7 = 0;
                    while (n7 < this.numColorComponents) {
                        fArray[n7] = (float)dArray[n7];
                        ++n7;
                    }
                }
            }
            float[] fArray3 = this.colorSpace.toRGB(fArray);
            n3 = this.clamp(fArray3[0] * 255.0f);
            n2 = this.clamp(fArray3[1] * 255.0f);
            n = this.clamp(fArray3[2] * 255.0f);
        }
        return n4 << 24 | n3 << 16 | n2 << 8 | n;
    }

    public Object getDataElements(int n, Object object) {
        double[] dArray;
        if (this.transferType == 4) {
            float[] fArray;
            if (object == null) {
                fArray = new float[this.numComponents];
            } else {
                if (!(object instanceof float[])) {
                    throw new ClassCastException(JaiI18N.getString("FloatDoubleColorModel7"));
                }
                fArray = (float[])object;
                if (fArray.length < this.numComponents) {
                    throw new ArrayIndexOutOfBoundsException(JaiI18N.getString("FloatDoubleColorModel8"));
                }
            }
            float f2 = 0.003921569f;
            if (this.colorSpace.isCS_sRGB()) {
                int n2 = n >> 24 & 0xFF;
                int n3 = n >> 16 & 0xFF;
                int n4 = n >> 8 & 0xFF;
                int n5 = n & 0xFF;
                float f3 = f2;
                if (this.isAlphaPremultiplied) {
                    f3 *= (float)n2;
                }
                fArray[0] = (float)n3 * f3;
                fArray[1] = (float)n4 * f3;
                fArray[2] = (float)n5 * f3;
                if (this.hasAlpha) {
                    fArray[3] = (float)n2 * f2;
                }
            } else if (this.colorSpaceType == 6) {
                float f4;
                fArray[0] = f4 = (float)(n >> 16 & 0xFF) * (0.299f * f2) + (float)(n >> 8 & 0xFF) * (0.587f * f2) + (float)(n & 0xFF) * (0.114f * f2);
                if (this.hasAlpha) {
                    int n6 = n >> 24 & 0xFF;
                    fArray[1] = (float)n6 * f2;
                }
            } else {
                float[] fArray2 = new float[]{(float)(n >> 16 & 0xFF) * f2, (float)(n >> 8 & 0xFF) * f2, (float)(n & 0xFF) * f2};
                fArray2 = this.colorSpace.fromRGB(fArray2);
                int n7 = 0;
                while (n7 < this.numColorComponents) {
                    fArray[n7] = fArray2[n7];
                    ++n7;
                }
                if (this.hasAlpha) {
                    int n8 = n >> 24 & 0xFF;
                    fArray[this.numColorComponents] = (float)n8 * f2;
                }
            }
            return fArray;
        }
        if (object == null) {
            dArray = new double[this.numComponents];
        } else {
            if (!(object instanceof double[])) {
                throw new ClassCastException(JaiI18N.getString("FloatDoubleColorModel7"));
            }
            dArray = (double[])object;
            if (dArray.length < this.numComponents) {
                throw new ArrayIndexOutOfBoundsException(JaiI18N.getString("FloatDoubleColorModel8"));
            }
        }
        double d2 = 0.00392156862745098;
        if (this.colorSpace.isCS_sRGB()) {
            int n9 = n >> 24 & 0xFF;
            int n10 = n >> 16 & 0xFF;
            int n11 = n >> 8 & 0xFF;
            int n12 = n & 0xFF;
            double d3 = d2;
            if (this.isAlphaPremultiplied) {
                d3 *= (double)n9;
            }
            dArray[0] = (double)n10 * d3;
            dArray[1] = (double)n11 * d3;
            dArray[2] = (double)n12 * d3;
            if (this.hasAlpha) {
                dArray[3] = (double)n9 * d2;
            }
        } else if (this.colorSpaceType == 6) {
            double d4;
            dArray[0] = d4 = (double)(n >> 16 & 0xFF) * (0.299 * d2) + (double)(n >> 8 & 0xFF) * (0.587 * d2) + (double)(n & 0xFF) * (0.114 * d2);
            if (this.hasAlpha) {
                int n13 = n >> 24 & 0xFF;
                dArray[1] = (double)n13 * d2;
            }
        } else {
            float f5 = 0.003921569f;
            float[] fArray = new float[]{(float)(n >> 16 & 0xFF) * f5, (float)(n >> 8 & 0xFF) * f5, (float)(n & 0xFF) * f5};
            fArray = this.colorSpace.fromRGB(fArray);
            int n14 = 0;
            while (n14 < this.numColorComponents) {
                dArray[n14] = fArray[n14];
                ++n14;
            }
            if (this.hasAlpha) {
                int n15 = n >> 24 & 0xFF;
                dArray[this.numColorComponents] = (double)n15 * d2;
            }
        }
        return dArray;
    }

    public int[] getComponents(int n, int[] nArray, int n2) {
        throw new IllegalArgumentException(JaiI18N.getString("FloatDoubleColorModel9"));
    }

    public int[] getComponents(Object object, int[] nArray, int n) {
        throw new IllegalArgumentException(JaiI18N.getString("FloatDoubleColorModel9"));
    }

    public int getDataElement(int[] nArray, int n) {
        throw new IllegalArgumentException(JaiI18N.getString("FloatDoubleColorModel9"));
    }

    public Object getDataElements(int[] nArray, int n, Object object) {
        if (nArray.length - n < this.numComponents) {
            throw new IllegalArgumentException(this.numComponents + " " + JaiI18N.getString("FloatDoubleColorModel10"));
        }
        if (this.transferType == 4) {
            float[] fArray = object == null ? new float[nArray.length] : (float[])object;
            int n2 = 0;
            while (n2 < this.numComponents) {
                fArray[n2] = nArray[n + n2];
                ++n2;
            }
            return fArray;
        }
        double[] dArray = object == null ? new double[nArray.length] : (double[])object;
        int n3 = 0;
        while (n3 < this.numComponents) {
            dArray[n3] = nArray[n + n3];
            ++n3;
        }
        return dArray;
    }

    public ColorModel coerceData(WritableRaster writableRaster, boolean bl) {
        if (!this.hasAlpha || this.isAlphaPremultiplied == bl) {
            return this;
        }
        int n = writableRaster.getWidth();
        int n2 = writableRaster.getHeight();
        int n3 = writableRaster.getNumBands() - 1;
        int n4 = writableRaster.getMinX();
        int n5 = writableRaster.getMinY();
        if (writableRaster.getTransferType() != this.transferType) {
            throw new IllegalArgumentException(JaiI18N.getString("FloatDoubleColorModel6"));
        }
        if (bl) {
            switch (this.transferType) {
                case 4: {
                    float[] fArray = null;
                    int n6 = 0;
                    while (n6 < n2) {
                        int n7 = n4;
                        int n8 = 0;
                        while (n8 < n) {
                            float f2 = (fArray = (float[])writableRaster.getDataElements(n7, n5, fArray))[n3];
                            if (f2 != 0.0f) {
                                int n9 = 0;
                                while (n9 < n3) {
                                    int n10 = n9++;
                                    fArray[n10] = fArray[n10] * f2;
                                }
                                writableRaster.setDataElements(n7, n5, fArray);
                            }
                            ++n8;
                            ++n7;
                        }
                        ++n6;
                        ++n5;
                    }
                    break;
                }
                case 5: {
                    double[] dArray = null;
                    int n11 = 0;
                    while (n11 < n2) {
                        int n12 = n4;
                        int n13 = 0;
                        while (n13 < n) {
                            double d2 = (dArray = (double[])writableRaster.getDataElements(n12, n5, dArray))[n3];
                            if (d2 != 0.0) {
                                int n14 = 0;
                                while (n14 < n3) {
                                    int n15 = n14++;
                                    dArray[n15] = dArray[n15] * d2;
                                }
                                writableRaster.setDataElements(n12, n5, dArray);
                            }
                            ++n13;
                            ++n12;
                        }
                        ++n11;
                        ++n5;
                    }
                    break;
                }
                default: {
                    throw new RuntimeException(JaiI18N.getString("FloatDoubleColorModel0"));
                }
            }
            if (bl) {
                // empty if block
            }
        } else {
            switch (this.transferType) {
                case 4: {
                    int n16 = 0;
                    while (n16 < n2) {
                        int n17 = n4;
                        int n18 = 0;
                        while (n18 < n) {
                            float[] fArray = null;
                            float f3 = (fArray = (float[])writableRaster.getDataElements(n17, n5, fArray))[n3];
                            if (f3 != 0.0f) {
                                float f4 = 1.0f / f3;
                                int n19 = 0;
                                while (n19 < n3) {
                                    int n20 = n19++;
                                    fArray[n20] = fArray[n20] * f4;
                                }
                            }
                            writableRaster.setDataElements(n17, n5, fArray);
                            ++n18;
                            ++n17;
                        }
                        ++n16;
                        ++n5;
                    }
                    break;
                }
                case 5: {
                    int n21 = 0;
                    while (n21 < n2) {
                        int n22 = n4;
                        int n23 = 0;
                        while (n23 < n) {
                            double[] dArray = null;
                            double d3 = (dArray = (double[])writableRaster.getDataElements(n22, n5, dArray))[n3];
                            if (d3 != 0.0) {
                                double d4 = 1.0 / d3;
                                int n24 = 0;
                                while (n24 < n3) {
                                    int n25 = n24++;
                                    dArray[n25] = dArray[n25] * d4;
                                }
                            }
                            writableRaster.setDataElements(n22, n5, dArray);
                            ++n23;
                            ++n22;
                        }
                        ++n21;
                        ++n5;
                    }
                    break;
                }
                default: {
                    throw new RuntimeException(JaiI18N.getString("FloatDoubleColorModel0"));
                }
            }
        }
        return new FloatDoubleColorModel(this.colorSpace, this.hasAlpha, bl, this.transparency, this.transferType);
    }

    public boolean isCompatibleRaster(Raster raster) {
        SampleModel sampleModel = raster.getSampleModel();
        return this.isCompatibleSampleModel(sampleModel);
    }

    public WritableRaster createCompatibleWritableRaster(int n, int n2) {
        SampleModel sampleModel = this.createCompatibleSampleModel(n, n2);
        return RasterFactory.createWritableRaster(sampleModel, new Point(0, 0));
    }

    public SampleModel createCompatibleSampleModel(int n, int n2) {
        int[] nArray = new int[this.numComponents];
        int n3 = 0;
        while (n3 < this.numComponents) {
            nArray[n3] = n3;
            ++n3;
        }
        return new ComponentSampleModelJAI(this.transferType, n, n2, this.numComponents, n * this.numComponents, nArray);
    }

    public boolean isCompatibleSampleModel(SampleModel sampleModel) {
        if (sampleModel instanceof ComponentSampleModel) {
            if (sampleModel.getNumBands() != this.getNumComponents()) {
                return false;
            }
            return sampleModel.getDataType() == this.transferType;
        }
        return false;
    }

    public String toString() {
        return "FloatDoubleColorModel: " + super.toString();
    }
}

