/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.mlib;

import com.sun.media.jai.mlib.JaiI18N;
import com.sun.media.jai.mlib.MediaLibAccessor;
import com.sun.media.jai.mlib.MlibUtils;
import com.sun.medialib.mlib.Image;
import com.sun.medialib.mlib.mediaLibImage;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;

final class MlibRescaleOpImage
extends PointOpImage {
    private double[] constants;
    private double[] offsets;

    private static ImageLayout layoutHelper(ImageLayout imageLayout) {
        if (imageLayout == null) {
            return null;
        }
        return (ImageLayout)imageLayout.clone();
    }

    public MlibRescaleOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, double[] dArray, double[] dArray2) {
        super(renderedImage, MlibRescaleOpImage.layoutHelper(imageLayout), map, true);
        int n = this.getSampleModel().getNumBands();
        this.constants = MlibUtils.initConstants(dArray, n);
        this.offsets = MlibUtils.initConstants(dArray2, n);
        this.permitInPlaceOperation();
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        int n = MediaLibAccessor.findCompatibleTag(rasterArray, writableRaster);
        MediaLibAccessor mediaLibAccessor = new MediaLibAccessor(raster, rectangle2, n);
        MediaLibAccessor mediaLibAccessor2 = new MediaLibAccessor(writableRaster, rectangle, n);
        mediaLibImage[] mediaLibImageArray = mediaLibAccessor.getMediaLibImages();
        mediaLibImage[] mediaLibImageArray2 = mediaLibAccessor2.getMediaLibImages();
        switch (mediaLibAccessor2.getDataType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                int n2 = 0;
                while (n2 < mediaLibImageArray2.length) {
                    double[] dArray = mediaLibAccessor2.getDoubleParameters(n2, this.constants);
                    double[] dArray2 = mediaLibAccessor2.getDoubleParameters(n2, this.offsets);
                    Image.Scale2(mediaLibImageArray2[n2], mediaLibImageArray[n2], dArray, dArray2);
                    ++n2;
                }
                break;
            }
            case 4: 
            case 5: {
                int n3 = 0;
                while (n3 < mediaLibImageArray2.length) {
                    double[] dArray = mediaLibAccessor2.getDoubleParameters(n3, this.constants);
                    double[] dArray3 = mediaLibAccessor2.getDoubleParameters(n3, this.offsets);
                    Image.Scale_Fp(mediaLibImageArray2[n3], mediaLibImageArray[n3], dArray, dArray3);
                    ++n3;
                }
                break;
            }
            default: {
                String string = this.getClass().getName();
                throw new RuntimeException(string + JaiI18N.getString("Generic2"));
            }
        }
        if (mediaLibAccessor2.isDataCopy()) {
            mediaLibAccessor2.clampDataArrays();
            mediaLibAccessor2.copyDataToRaster();
        }
    }
}

