/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.AffineNearestOpImage;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.util.Range;

final class AffineNearestBinaryOpImage
extends AffineNearestOpImage {
    private int black = 0;

    private static Map configHelper(Map map) {
        Map map2;
        if (map == null) {
            map2 = new RenderingHints(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE);
        } else {
            map2 = map;
            if (!map2.containsKey(JAI.KEY_REPLACE_INDEX_COLOR_MODEL)) {
                RenderingHints renderingHints = (RenderingHints)map;
                map2 = (RenderingHints)renderingHints.clone();
                map2.put(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE);
            }
        }
        return map2;
    }

    public AffineNearestBinaryOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, AffineTransform affineTransform, Interpolation interpolation, double[] dArray) {
        super(renderedImage, borderExtender, AffineNearestBinaryOpImage.configHelper(map), imageLayout, affineTransform, interpolation, dArray);
        this.colorModel = imageLayout != null ? imageLayout.getColorModel(renderedImage) : renderedImage.getColorModel();
        this.sampleModel = renderedImage.getSampleModel().createCompatibleSampleModel(this.tileWidth, this.tileHeight);
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        Raster raster = rasterArray[0];
        switch (raster.getSampleModel().getDataType()) {
            case 0: {
                this.byteLoop(raster, writableRaster, rectangle);
                break;
            }
            case 3: {
                this.intLoop(raster, writableRaster, rectangle);
                break;
            }
            case 1: 
            case 2: {
                this.shortLoop(raster, writableRaster, rectangle);
            }
        }
    }

    private void byteLoop(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
        float f2 = raster.getMinX();
        float f3 = raster.getMinY();
        float f4 = f2 + (float)raster.getWidth();
        float f5 = f3 + (float)raster.getHeight();
        MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)raster.getSampleModel();
        DataBufferByte dataBufferByte = (DataBufferByte)raster.getDataBuffer();
        int n = raster.getSampleModelTranslateX();
        int n2 = raster.getSampleModelTranslateY();
        int n3 = multiPixelPackedSampleModel.getDataBitOffset();
        int n4 = multiPixelPackedSampleModel.getScanlineStride();
        MultiPixelPackedSampleModel multiPixelPackedSampleModel2 = (MultiPixelPackedSampleModel)writableRaster.getSampleModel();
        DataBufferByte dataBufferByte2 = (DataBufferByte)writableRaster.getDataBuffer();
        int n5 = writableRaster.getMinX();
        int n6 = writableRaster.getMinY();
        int n7 = writableRaster.getSampleModelTranslateX();
        int n8 = writableRaster.getSampleModelTranslateY();
        int n9 = multiPixelPackedSampleModel2.getDataBitOffset();
        int n10 = multiPixelPackedSampleModel2.getScanlineStride();
        byte[] byArray = dataBufferByte.getData();
        int n11 = dataBufferByte.getOffset();
        byte[] byArray2 = dataBufferByte2.getData();
        int n12 = dataBufferByte2.getOffset();
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        int n13 = rectangle.x;
        int n14 = rectangle.y;
        int n15 = rectangle.x + rectangle.width;
        int n16 = rectangle.y + rectangle.height;
        int n17 = this.incy * n4;
        int n18 = this.incy1 * n4;
        this.black = (int)this.backgroundValues[0] & 1;
        int n19 = n14;
        while (n19 < n16) {
            ((Point2D)float_).setLocation((double)n13 + 0.5, (double)n19 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f6 = (float)((Point2D)float_2).getX();
            float f7 = (float)((Point2D)float_2).getY();
            int n20 = (int)Math.floor(f6);
            int n21 = (int)Math.floor(f7);
            double d2 = (double)f6 - (double)n20;
            double d3 = (double)f7 - (double)n21;
            int n22 = (int)Math.floor(d2 * 1048576.0);
            int n23 = (int)Math.floor(d3 * 1048576.0);
            int n24 = n20;
            int n25 = n21;
            int n26 = n22;
            int n27 = n23;
            Range range = this.performScanlineClipping(f2, f3, f4, f5, n20, n21, n22, n23, n13, n15, 0, 0, 0, 0);
            int n28 = (Integer)range.getMinValue();
            int n29 = (Integer)range.getMaxValue();
            if (n28 <= n29) {
                int n30;
                int n31;
                int n32;
                int n33;
                int n34;
                int n35 = (n19 - n8) * n10 + n12;
                int n36 = n9 + (n13 - n7);
                int n37 = (n21 - n2) * n4 + n11;
                int n38 = n20 - n + n3;
                int n39 = n13;
                while (n39 < n28) {
                    if (this.setBackground) {
                        n34 = n35 + (n36 >> 3);
                        n33 = 7 - (n36 & 7);
                        n32 = byArray2[n34];
                        byArray2[n34] = (byte)(n32 |= this.black << n33);
                    }
                    if (n22 < this.ifracdx1) {
                        n20 += this.incx;
                        n22 += this.ifracdx;
                        n38 += this.incx;
                    } else {
                        n20 += this.incx1;
                        n22 -= this.ifracdx1;
                        n38 += this.incx1;
                    }
                    if (n23 < this.ifracdy1) {
                        n21 += this.incy;
                        n23 += this.ifracdy;
                        n37 += n17;
                    } else {
                        n21 += this.incy1;
                        n23 -= this.ifracdy1;
                        n37 += n18;
                    }
                    ++n36;
                    ++n39;
                }
                n34 = n28;
                while (n34 < n29) {
                    n33 = n37 + (n38 >> 3);
                    n32 = byArray[n33];
                    n31 = n32 >> 7 - (n38 & 7) & 1;
                    n30 = n35 + (n36 >> 3);
                    int n40 = 7 - (n36 & 7);
                    int n41 = byArray2[n30];
                    byArray2[n30] = (byte)(n41 |= n31 << n40);
                    if (n22 < this.ifracdx1) {
                        n20 += this.incx;
                        n22 += this.ifracdx;
                        n38 += this.incx;
                    } else {
                        n20 += this.incx1;
                        n22 -= this.ifracdx1;
                        n38 += this.incx1;
                    }
                    if (n23 < this.ifracdy1) {
                        n21 += this.incy;
                        n23 += this.ifracdy;
                        n37 += n17;
                    } else {
                        n21 += this.incy1;
                        n23 -= this.ifracdy1;
                        n37 += n18;
                    }
                    ++n36;
                    ++n34;
                }
                n33 = n29;
                while (n33 < n15) {
                    if (this.setBackground) {
                        n32 = n35 + (n36 >> 3);
                        n31 = 7 - (n36 & 7);
                        n30 = byArray2[n32];
                        byArray2[n32] = (byte)(n30 |= this.black << n31);
                    }
                    if (n22 < this.ifracdx1) {
                        n20 += this.incx;
                        n22 += this.ifracdx;
                        n38 += this.incx;
                    } else {
                        n20 += this.incx1;
                        n22 -= this.ifracdx1;
                        n38 += this.incx1;
                    }
                    if (n23 < this.ifracdy1) {
                        n21 += this.incy;
                        n23 += this.ifracdy;
                        n37 += n17;
                    } else {
                        n21 += this.incy1;
                        n23 -= this.ifracdy1;
                        n37 += n18;
                    }
                    ++n36;
                    ++n33;
                }
            }
            ++n19;
        }
    }

    private void shortLoop(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
        float f2 = raster.getMinX();
        float f3 = raster.getMinY();
        float f4 = f2 + (float)raster.getWidth();
        float f5 = f3 + (float)raster.getHeight();
        MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)raster.getSampleModel();
        DataBufferShort dataBufferShort = (DataBufferShort)raster.getDataBuffer();
        int n = raster.getSampleModelTranslateX();
        int n2 = raster.getSampleModelTranslateY();
        int n3 = multiPixelPackedSampleModel.getDataBitOffset();
        int n4 = multiPixelPackedSampleModel.getScanlineStride();
        MultiPixelPackedSampleModel multiPixelPackedSampleModel2 = (MultiPixelPackedSampleModel)writableRaster.getSampleModel();
        DataBufferShort dataBufferShort2 = (DataBufferShort)writableRaster.getDataBuffer();
        int n5 = writableRaster.getMinX();
        int n6 = writableRaster.getMinY();
        int n7 = writableRaster.getSampleModelTranslateX();
        int n8 = writableRaster.getSampleModelTranslateY();
        int n9 = multiPixelPackedSampleModel2.getDataBitOffset();
        int n10 = multiPixelPackedSampleModel2.getScanlineStride();
        short[] sArray = dataBufferShort.getData();
        int n11 = dataBufferShort.getOffset();
        short[] sArray2 = dataBufferShort2.getData();
        int n12 = dataBufferShort2.getOffset();
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        int n13 = rectangle.x;
        int n14 = rectangle.y;
        int n15 = rectangle.x + rectangle.width;
        int n16 = rectangle.y + rectangle.height;
        int n17 = this.incy * n4;
        int n18 = this.incy1 * n4;
        this.black = (int)this.backgroundValues[0] & 1;
        int n19 = n14;
        while (n19 < n16) {
            ((Point2D)float_).setLocation((double)n13 + 0.5, (double)n19 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f6 = (float)((Point2D)float_2).getX();
            float f7 = (float)((Point2D)float_2).getY();
            int n20 = (int)Math.floor(f6);
            int n21 = (int)Math.floor(f7);
            double d2 = (double)f6 - (double)n20;
            double d3 = (double)f7 - (double)n21;
            int n22 = (int)Math.floor(d2 * 1048576.0);
            int n23 = (int)Math.floor(d3 * 1048576.0);
            int n24 = n20;
            int n25 = n21;
            int n26 = n22;
            int n27 = n23;
            Range range = this.performScanlineClipping(f2, f3, f4, f5, n20, n21, n22, n23, n13, n15, 0, 0, 0, 0);
            int n28 = (Integer)range.getMinValue();
            int n29 = (Integer)range.getMaxValue();
            if (n28 <= n29) {
                int n30;
                int n31;
                int n32;
                int n33;
                int n34;
                int n35 = (n19 - n8) * n10 + n12;
                int n36 = n9 + (n13 - n7);
                int n37 = (n21 - n2) * n4 + n11;
                int n38 = n20 - n + n3;
                int n39 = n13;
                while (n39 < n28) {
                    if (this.setBackground) {
                        n34 = n35 + (n36 >> 4);
                        n33 = 15 - (n36 & 0xF);
                        n32 = sArray2[n34];
                        sArray2[n34] = (short)(n32 |= this.black << n33);
                    }
                    if (n22 < this.ifracdx1) {
                        n20 += this.incx;
                        n22 += this.ifracdx;
                        n38 += this.incx;
                    } else {
                        n20 += this.incx1;
                        n22 -= this.ifracdx1;
                        n38 += this.incx1;
                    }
                    if (n23 < this.ifracdy1) {
                        n21 += this.incy;
                        n23 += this.ifracdy;
                        n37 += n17;
                    } else {
                        n21 += this.incy1;
                        n23 -= this.ifracdy1;
                        n37 += n18;
                    }
                    ++n36;
                    ++n39;
                }
                n34 = n28;
                while (n34 < n29) {
                    n33 = n37 + (n38 >> 4);
                    n32 = sArray[n33];
                    n31 = n32 >> 15 - (n38 & 0xF) & 1;
                    n30 = n35 + (n36 >> 4);
                    int n40 = 15 - (n36 & 0xF);
                    int n41 = sArray2[n30];
                    sArray2[n30] = (short)(n41 |= n31 << n40);
                    if (n22 < this.ifracdx1) {
                        n20 += this.incx;
                        n22 += this.ifracdx;
                        n38 += this.incx;
                    } else {
                        n20 += this.incx1;
                        n22 -= this.ifracdx1;
                        n38 += this.incx1;
                    }
                    if (n23 < this.ifracdy1) {
                        n21 += this.incy;
                        n23 += this.ifracdy;
                        n37 += n17;
                    } else {
                        n21 += this.incy1;
                        n23 -= this.ifracdy1;
                        n37 += n18;
                    }
                    ++n36;
                    ++n34;
                }
                n33 = n29;
                while (n33 < n15) {
                    if (this.setBackground) {
                        n32 = n35 + (n36 >> 4);
                        n31 = 15 - (n36 & 0xF);
                        n30 = sArray2[n32];
                        sArray2[n32] = (short)(n30 |= this.black << n31);
                    }
                    if (n22 < this.ifracdx1) {
                        n20 += this.incx;
                        n22 += this.ifracdx;
                        n38 += this.incx;
                    } else {
                        n20 += this.incx1;
                        n22 -= this.ifracdx1;
                        n38 += this.incx1;
                    }
                    if (n23 < this.ifracdy1) {
                        n21 += this.incy;
                        n23 += this.ifracdy;
                        n37 += n17;
                    } else {
                        n21 += this.incy1;
                        n23 -= this.ifracdy1;
                        n37 += n18;
                    }
                    ++n36;
                    ++n33;
                }
            }
            ++n19;
        }
    }

    private void intLoop(Raster raster, WritableRaster writableRaster, Rectangle rectangle) {
        float f2 = raster.getMinX();
        float f3 = raster.getMinY();
        float f4 = f2 + (float)raster.getWidth();
        float f5 = f3 + (float)raster.getHeight();
        MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)raster.getSampleModel();
        DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
        int n = raster.getSampleModelTranslateX();
        int n2 = raster.getSampleModelTranslateY();
        int n3 = multiPixelPackedSampleModel.getDataBitOffset();
        int n4 = multiPixelPackedSampleModel.getScanlineStride();
        MultiPixelPackedSampleModel multiPixelPackedSampleModel2 = (MultiPixelPackedSampleModel)writableRaster.getSampleModel();
        DataBufferInt dataBufferInt2 = (DataBufferInt)writableRaster.getDataBuffer();
        int n5 = writableRaster.getMinX();
        int n6 = writableRaster.getMinY();
        int n7 = writableRaster.getSampleModelTranslateX();
        int n8 = writableRaster.getSampleModelTranslateY();
        int n9 = multiPixelPackedSampleModel2.getDataBitOffset();
        int n10 = multiPixelPackedSampleModel2.getScanlineStride();
        int[] nArray = dataBufferInt.getData();
        int n11 = dataBufferInt.getOffset();
        int[] nArray2 = dataBufferInt2.getData();
        int n12 = dataBufferInt2.getOffset();
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        int n13 = rectangle.x;
        int n14 = rectangle.y;
        int n15 = rectangle.x + rectangle.width;
        int n16 = rectangle.y + rectangle.height;
        int n17 = this.incy * n4;
        int n18 = this.incy1 * n4;
        this.black = (int)this.backgroundValues[0] & 1;
        int n19 = n14;
        while (n19 < n16) {
            ((Point2D)float_).setLocation((double)n13 + 0.5, (double)n19 + 0.5);
            this.mapDestPoint((Point2D)float_, float_2);
            float f6 = (float)((Point2D)float_2).getX();
            float f7 = (float)((Point2D)float_2).getY();
            int n20 = (int)Math.floor(f6);
            int n21 = (int)Math.floor(f7);
            double d2 = (double)f6 - (double)n20;
            double d3 = (double)f7 - (double)n21;
            int n22 = (int)Math.floor(d2 * 1048576.0);
            int n23 = (int)Math.floor(d3 * 1048576.0);
            int n24 = n20;
            int n25 = n21;
            int n26 = n22;
            int n27 = n23;
            Range range = this.performScanlineClipping(f2, f3, f4, f5, n20, n21, n22, n23, n13, n15, 0, 0, 0, 0);
            int n28 = (Integer)range.getMinValue();
            int n29 = (Integer)range.getMaxValue();
            if (n28 <= n29) {
                int n30;
                int n31;
                int n32;
                int n33;
                int n34;
                int n35 = (n19 - n8) * n10 + n12;
                int n36 = n9 + (n13 - n7);
                int n37 = (n21 - n2) * n4 + n11;
                int n38 = n20 - n + n3;
                int n39 = n13;
                while (n39 < n28) {
                    if (this.setBackground) {
                        n34 = n35 + (n36 >> 5);
                        n33 = 31 - (n36 & 0x1F);
                        n32 = nArray2[n34];
                        nArray2[n34] = n32 |= this.black << n33;
                    }
                    if (n22 < this.ifracdx1) {
                        n20 += this.incx;
                        n22 += this.ifracdx;
                        n38 += this.incx;
                    } else {
                        n20 += this.incx1;
                        n22 -= this.ifracdx1;
                        n38 += this.incx1;
                    }
                    if (n23 < this.ifracdy1) {
                        n21 += this.incy;
                        n23 += this.ifracdy;
                        n37 += n17;
                    } else {
                        n21 += this.incy1;
                        n23 -= this.ifracdy1;
                        n37 += n18;
                    }
                    ++n36;
                    ++n39;
                }
                n34 = n28;
                while (n34 < n29) {
                    n33 = n37 + (n38 >> 5);
                    n32 = nArray[n33];
                    n31 = n32 >> 31 - (n38 & 0x1F) & 1;
                    n30 = n35 + (n36 >> 5);
                    int n40 = 31 - (n36 & 0x1F);
                    int n41 = nArray2[n30];
                    nArray2[n30] = n41 |= n31 << n40;
                    if (n22 < this.ifracdx1) {
                        n20 += this.incx;
                        n22 += this.ifracdx;
                        n38 += this.incx;
                    } else {
                        n20 += this.incx1;
                        n22 -= this.ifracdx1;
                        n38 += this.incx1;
                    }
                    if (n23 < this.ifracdy1) {
                        n21 += this.incy;
                        n23 += this.ifracdy;
                        n37 += n17;
                    } else {
                        n21 += this.incy1;
                        n23 -= this.ifracdy1;
                        n37 += n18;
                    }
                    ++n36;
                    ++n34;
                }
                n33 = n29;
                while (n33 < n15) {
                    if (this.setBackground) {
                        n32 = n35 + (n36 >> 5);
                        n31 = 31 - (n36 & 0x1F);
                        n30 = nArray2[n32];
                        nArray2[n32] = n30 |= this.black << n31;
                    }
                    if (n22 < this.ifracdx1) {
                        n20 += this.incx;
                        n22 += this.ifracdx;
                        n38 += this.incx;
                    } else {
                        n20 += this.incx1;
                        n22 -= this.ifracdx1;
                        n38 += this.incx1;
                    }
                    if (n23 < this.ifracdy1) {
                        n21 += this.incy;
                        n23 += this.ifracdy;
                        n37 += n17;
                    } else {
                        n21 += this.incy1;
                        n23 -= this.ifracdy1;
                        n37 += n18;
                    }
                    ++n36;
                    ++n33;
                }
            }
            ++n19;
        }
    }
}

