/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFactory;
import javax.media.jai.RasterFormatTag;

final class ComplexArithmeticOpImage
extends PointOpImage {
    protected boolean isDivision = false;
    private int[] s1r;
    private int[] s1i;
    private int[] s2r;
    private int[] s2i;

    private static ImageLayout layoutHelper(ImageLayout imageLayout, RenderedImage renderedImage) {
        SampleModel sampleModel;
        int n;
        ImageLayout imageLayout2 = imageLayout == null ? new ImageLayout() : (ImageLayout)imageLayout.clone();
        if (imageLayout2.isValid(256) && (n = (sampleModel = imageLayout2.getSampleModel(null)).getNumBands()) % 2 != 0) {
            sampleModel = RasterFactory.createComponentSampleModel(sampleModel, sampleModel.getTransferType(), sampleModel.getWidth(), sampleModel.getHeight(), ++n);
            imageLayout2.setSampleModel(sampleModel);
            ColorModel colorModel = imageLayout.getColorModel(null);
            if (colorModel != null && !JDKWorkarounds.areCompatibleDataModels(sampleModel, colorModel)) {
                imageLayout2.unsetValid(512);
            }
        }
        return imageLayout2;
    }

    public ComplexArithmeticOpImage(RenderedImage renderedImage, RenderedImage renderedImage2, Map map, ImageLayout imageLayout, boolean bl) {
        super(renderedImage, renderedImage2, ComplexArithmeticOpImage.layoutHelper(imageLayout, renderedImage), map, true);
        this.isDivision = bl;
        int n = renderedImage.getSampleModel().getNumBands();
        int n2 = renderedImage2.getSampleModel().getNumBands();
        int n3 = Math.min(n, n2);
        int n4 = 0;
        if (imageLayout != null) {
            n4 = imageLayout.getSampleModel(null).getNumBands();
        }
        if (imageLayout != null && imageLayout.isValid(256) && (n == 2 && n2 > 2 || n2 == 2 && n > 2 || n >= n4 && n2 >= n4 && n4 > 0) && n4 % 2 == 0) {
            n3 = n4;
            n3 = Math.min(Math.max(n, n2), n3);
        }
        if (n3 != this.sampleModel.getNumBands()) {
            this.sampleModel = RasterFactory.createComponentSampleModel(this.sampleModel, this.sampleModel.getTransferType(), this.sampleModel.getWidth(), this.sampleModel.getHeight(), n3);
            if (this.colorModel != null && !JDKWorkarounds.areCompatibleDataModels(this.sampleModel, this.colorModel)) {
                this.colorModel = ImageUtil.getCompatibleColorModel(this.sampleModel, map);
            }
        }
        int n5 = this.sampleModel.getNumBands() / 2;
        this.s1r = new int[n5];
        this.s1i = new int[n5];
        this.s2r = new int[n5];
        this.s2i = new int[n5];
        int n6 = n > 2 ? 2 : 0;
        int n7 = n2 > 2 ? 2 : 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        while (n10 < n5) {
            this.s1r[n10] = n8;
            this.s1i[n10] = n8 + 1;
            this.s2r[n10] = n9;
            this.s2i[n10] = n9 + 1;
            n8 += n6;
            n9 += n7;
            ++n10;
        }
        this.permitInPlaceOperation();
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        RasterAccessor rasterAccessor = new RasterAccessor(rasterArray[0], rectangle, rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(rasterArray[1], rectangle, rasterFormatTagArray[1], this.getSourceImage(1).getColorModel());
        RasterAccessor rasterAccessor3 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[2], this.getColorModel());
        switch (rasterAccessor3.getDataType()) {
            case 0: {
                this.computeRectByte(rasterAccessor, rasterAccessor2, rasterAccessor3);
                break;
            }
            case 2: {
                this.computeRectShort(rasterAccessor, rasterAccessor2, rasterAccessor3);
                break;
            }
            case 1: {
                this.computeRectUShort(rasterAccessor, rasterAccessor2, rasterAccessor3);
                break;
            }
            case 3: {
                this.computeRectInt(rasterAccessor, rasterAccessor2, rasterAccessor3);
                break;
            }
            case 4: {
                this.computeRectFloat(rasterAccessor, rasterAccessor2, rasterAccessor3);
                break;
            }
            case 5: {
                this.computeRectDouble(rasterAccessor, rasterAccessor2, rasterAccessor3);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("ComplexArithmeticOpImage0"));
            }
        }
        if (rasterAccessor3.needsClamping()) {
            rasterAccessor3.clampDataArrays();
        }
        rasterAccessor3.copyDataToRaster();
    }

    private void computeRectDouble(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3) {
        int n = rasterAccessor3.getHeight();
        int n2 = rasterAccessor3.getWidth();
        int n3 = rasterAccessor.getPixelStride();
        int n4 = rasterAccessor.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = rasterAccessor3.getPixelStride();
        int n8 = rasterAccessor3.getScanlineStride();
        int n9 = this.sampleModel.getNumBands() / 2;
        int n10 = 0;
        while (n10 < n9) {
            int n11 = 2 * n10;
            int n12 = n11 + 1;
            double[] dArray = rasterAccessor.getDoubleDataArray(this.s1r[n10]);
            double[] dArray2 = rasterAccessor.getDoubleDataArray(this.s1i[n10]);
            double[] dArray3 = rasterAccessor2.getDoubleDataArray(this.s2r[n10]);
            double[] dArray4 = rasterAccessor2.getDoubleDataArray(this.s2i[n10]);
            double[] dArray5 = rasterAccessor3.getDoubleDataArray(n11);
            double[] dArray6 = rasterAccessor3.getDoubleDataArray(n12);
            int n13 = rasterAccessor.getBandOffset(this.s1r[n10]);
            int n14 = rasterAccessor.getBandOffset(this.s1i[n10]);
            int n15 = rasterAccessor2.getBandOffset(this.s2r[n10]);
            int n16 = rasterAccessor2.getBandOffset(this.s2i[n10]);
            int n17 = rasterAccessor3.getBandOffset(n11);
            int n18 = rasterAccessor3.getBandOffset(n12);
            int n19 = n13;
            int n20 = n14;
            int n21 = n15;
            int n22 = n16;
            int n23 = n17;
            int n24 = n18;
            int n25 = 0;
            while (n25 < n) {
                double d2;
                double d3;
                double d4;
                double d5;
                int n26;
                int n27 = n19;
                int n28 = n20;
                int n29 = n21;
                int n30 = n22;
                int n31 = n23;
                int n32 = n24;
                if (this.isDivision) {
                    n26 = 0;
                    while (n26 < n2) {
                        d5 = dArray[n27];
                        d4 = dArray2[n28];
                        d3 = dArray3[n29];
                        d2 = dArray4[n30];
                        double d6 = d3 * d3 + d2 * d2;
                        dArray5[n31] = (d5 * d3 + d4 * d2) / d6;
                        dArray6[n32] = (d4 * d3 - d5 * d2) / d6;
                        n27 += n3;
                        n28 += n3;
                        n29 += n5;
                        n30 += n5;
                        n31 += n7;
                        n32 += n7;
                        ++n26;
                    }
                } else {
                    n26 = 0;
                    while (n26 < n2) {
                        d5 = dArray[n27];
                        d4 = dArray2[n28];
                        d3 = dArray3[n29];
                        d2 = dArray4[n30];
                        dArray5[n31] = d5 * d3 - d4 * d2;
                        dArray6[n32] = d5 * d2 + d4 * d3;
                        n27 += n3;
                        n28 += n3;
                        n29 += n5;
                        n30 += n5;
                        n31 += n7;
                        n32 += n7;
                        ++n26;
                    }
                }
                n19 += n4;
                n20 += n4;
                n21 += n6;
                n22 += n6;
                n23 += n8;
                n24 += n8;
                ++n25;
            }
            ++n10;
        }
    }

    private void computeRectFloat(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3) {
        int n = rasterAccessor3.getHeight();
        int n2 = rasterAccessor3.getWidth();
        int n3 = rasterAccessor.getPixelStride();
        int n4 = rasterAccessor.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = rasterAccessor3.getPixelStride();
        int n8 = rasterAccessor3.getScanlineStride();
        int n9 = this.sampleModel.getNumBands() / 2;
        int n10 = 0;
        while (n10 < n9) {
            int n11 = 2 * n10;
            int n12 = n11 + 1;
            float[] fArray = rasterAccessor.getFloatDataArray(this.s1r[n10]);
            float[] fArray2 = rasterAccessor.getFloatDataArray(this.s1i[n10]);
            float[] fArray3 = rasterAccessor2.getFloatDataArray(this.s2r[n10]);
            float[] fArray4 = rasterAccessor2.getFloatDataArray(this.s2i[n10]);
            float[] fArray5 = rasterAccessor3.getFloatDataArray(n11);
            float[] fArray6 = rasterAccessor3.getFloatDataArray(n12);
            int n13 = rasterAccessor.getBandOffset(this.s1r[n10]);
            int n14 = rasterAccessor.getBandOffset(this.s1i[n10]);
            int n15 = rasterAccessor2.getBandOffset(this.s2r[n10]);
            int n16 = rasterAccessor2.getBandOffset(this.s2i[n10]);
            int n17 = rasterAccessor3.getBandOffset(n11);
            int n18 = rasterAccessor3.getBandOffset(n12);
            int n19 = n13;
            int n20 = n14;
            int n21 = n15;
            int n22 = n16;
            int n23 = n17;
            int n24 = n18;
            int n25 = 0;
            while (n25 < n) {
                float f2;
                float f3;
                float f4;
                float f5;
                int n26;
                int n27 = n19;
                int n28 = n20;
                int n29 = n21;
                int n30 = n22;
                int n31 = n23;
                int n32 = n24;
                if (this.isDivision) {
                    n26 = 0;
                    while (n26 < n2) {
                        f5 = fArray[n27];
                        f4 = fArray2[n28];
                        f3 = fArray3[n29];
                        f2 = fArray4[n30];
                        float f6 = f3 * f3 + f2 * f2;
                        fArray5[n31] = (f5 * f3 + f4 * f2) / f6;
                        fArray6[n32] = (f4 * f3 - f5 * f2) / f6;
                        n27 += n3;
                        n28 += n3;
                        n29 += n5;
                        n30 += n5;
                        n31 += n7;
                        n32 += n7;
                        ++n26;
                    }
                } else {
                    n26 = 0;
                    while (n26 < n2) {
                        f5 = fArray[n27];
                        f4 = fArray2[n28];
                        f3 = fArray3[n29];
                        f2 = fArray4[n30];
                        fArray5[n31] = f5 * f3 - f4 * f2;
                        fArray6[n32] = f5 * f2 + f4 * f3;
                        n27 += n3;
                        n28 += n3;
                        n29 += n5;
                        n30 += n5;
                        n31 += n7;
                        n32 += n7;
                        ++n26;
                    }
                }
                n19 += n4;
                n20 += n4;
                n21 += n6;
                n22 += n6;
                n23 += n8;
                n24 += n8;
                ++n25;
            }
            ++n10;
        }
    }

    private void computeRectInt(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3) {
        int n = rasterAccessor3.getHeight();
        int n2 = rasterAccessor3.getWidth();
        int n3 = rasterAccessor.getPixelStride();
        int n4 = rasterAccessor.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = rasterAccessor3.getPixelStride();
        int n8 = rasterAccessor3.getScanlineStride();
        int n9 = this.sampleModel.getNumBands() / 2;
        int n10 = 0;
        while (n10 < n9) {
            int n11 = 2 * n10;
            int n12 = n11 + 1;
            int[] nArray = rasterAccessor.getIntDataArray(this.s1r[n10]);
            int[] nArray2 = rasterAccessor.getIntDataArray(this.s1i[n10]);
            int[] nArray3 = rasterAccessor2.getIntDataArray(this.s2r[n10]);
            int[] nArray4 = rasterAccessor2.getIntDataArray(this.s2i[n10]);
            int[] nArray5 = rasterAccessor3.getIntDataArray(n11);
            int[] nArray6 = rasterAccessor3.getIntDataArray(n12);
            int n13 = rasterAccessor.getBandOffset(this.s1r[n10]);
            int n14 = rasterAccessor.getBandOffset(this.s1i[n10]);
            int n15 = rasterAccessor2.getBandOffset(this.s2r[n10]);
            int n16 = rasterAccessor2.getBandOffset(this.s2i[n10]);
            int n17 = rasterAccessor3.getBandOffset(n11);
            int n18 = rasterAccessor3.getBandOffset(n12);
            int n19 = n13;
            int n20 = n14;
            int n21 = n15;
            int n22 = n16;
            int n23 = n17;
            int n24 = n18;
            int n25 = 0;
            while (n25 < n) {
                int n26;
                int n27 = n19;
                int n28 = n20;
                int n29 = n21;
                int n30 = n22;
                int n31 = n23;
                int n32 = n24;
                if (this.isDivision) {
                    n26 = 0;
                    while (n26 < n2) {
                        int n33 = nArray[n27];
                        int n34 = nArray2[n28];
                        int n35 = nArray3[n29];
                        int n36 = nArray4[n30];
                        float f2 = n35 * n35 + n36 * n36;
                        nArray5[n31] = ImageUtil.clampRoundInt((float)(n33 * n35 + n34 * n36) / f2);
                        nArray6[n32] = ImageUtil.clampRoundInt((float)(n34 * n35 - n33 * n36) / f2);
                        n27 += n3;
                        n28 += n3;
                        n29 += n5;
                        n30 += n5;
                        n31 += n7;
                        n32 += n7;
                        ++n26;
                    }
                } else {
                    n26 = 0;
                    while (n26 < n2) {
                        long l = nArray[n27];
                        long l2 = nArray2[n28];
                        long l3 = nArray3[n29];
                        long l4 = nArray4[n30];
                        nArray5[n31] = ImageUtil.clampInt(l * l3 - l2 * l4);
                        nArray6[n32] = ImageUtil.clampInt(l * l4 + l2 * l3);
                        n27 += n3;
                        n28 += n3;
                        n29 += n5;
                        n30 += n5;
                        n31 += n7;
                        n32 += n7;
                        ++n26;
                    }
                }
                n19 += n4;
                n20 += n4;
                n21 += n6;
                n22 += n6;
                n23 += n8;
                n24 += n8;
                ++n25;
            }
            ++n10;
        }
    }

    private void computeRectUShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3) {
        int n = rasterAccessor3.getHeight();
        int n2 = rasterAccessor3.getWidth();
        int n3 = rasterAccessor.getPixelStride();
        int n4 = rasterAccessor.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = rasterAccessor3.getPixelStride();
        int n8 = rasterAccessor3.getScanlineStride();
        int n9 = this.sampleModel.getNumBands() / 2;
        int n10 = 0;
        while (n10 < n9) {
            int n11 = 2 * n10;
            int n12 = n11 + 1;
            short[] sArray = rasterAccessor.getShortDataArray(this.s1r[n10]);
            short[] sArray2 = rasterAccessor.getShortDataArray(this.s1i[n10]);
            short[] sArray3 = rasterAccessor2.getShortDataArray(this.s2r[n10]);
            short[] sArray4 = rasterAccessor2.getShortDataArray(this.s2i[n10]);
            short[] sArray5 = rasterAccessor3.getShortDataArray(n11);
            short[] sArray6 = rasterAccessor3.getShortDataArray(n12);
            int n13 = rasterAccessor.getBandOffset(this.s1r[n10]);
            int n14 = rasterAccessor.getBandOffset(this.s1i[n10]);
            int n15 = rasterAccessor2.getBandOffset(this.s2r[n10]);
            int n16 = rasterAccessor2.getBandOffset(this.s2i[n10]);
            int n17 = rasterAccessor3.getBandOffset(n11);
            int n18 = rasterAccessor3.getBandOffset(n12);
            int n19 = n13;
            int n20 = n14;
            int n21 = n15;
            int n22 = n16;
            int n23 = n17;
            int n24 = n18;
            int n25 = 0;
            while (n25 < n) {
                int n26;
                int n27;
                int n28;
                int n29;
                int n30;
                int n31 = n19;
                int n32 = n20;
                int n33 = n21;
                int n34 = n22;
                int n35 = n23;
                int n36 = n24;
                if (this.isDivision) {
                    n30 = 0;
                    while (n30 < n2) {
                        n29 = sArray[n31] & 0xFFFF;
                        n28 = sArray2[n32] & 0xFFFF;
                        n27 = sArray3[n33] & 0xFFFF;
                        n26 = sArray4[n34] & 0xFFFF;
                        int n37 = n27 * n27 + n26 * n26;
                        sArray5[n35] = ImageUtil.clampUShort((n29 * n27 + n28 * n26) / n37);
                        sArray6[n36] = ImageUtil.clampUShort((n28 * n27 - n29 * n26) / n37);
                        n31 += n3;
                        n32 += n3;
                        n33 += n5;
                        n34 += n5;
                        n35 += n7;
                        n36 += n7;
                        ++n30;
                    }
                } else {
                    n30 = 0;
                    while (n30 < n2) {
                        n29 = sArray[n31] & 0xFFFF;
                        n28 = sArray2[n32] & 0xFFFF;
                        n27 = sArray3[n33] & 0xFFFF;
                        n26 = sArray4[n34] & 0xFFFF;
                        sArray5[n35] = ImageUtil.clampUShort(n29 * n27 - n28 * n26);
                        sArray6[n36] = ImageUtil.clampUShort(n29 * n26 + n28 * n27);
                        n31 += n3;
                        n32 += n3;
                        n33 += n5;
                        n34 += n5;
                        n35 += n7;
                        n36 += n7;
                        ++n30;
                    }
                }
                n19 += n4;
                n20 += n4;
                n21 += n6;
                n22 += n6;
                n23 += n8;
                n24 += n8;
                ++n25;
            }
            ++n10;
        }
    }

    private void computeRectShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3) {
        int n = rasterAccessor3.getHeight();
        int n2 = rasterAccessor3.getWidth();
        int n3 = rasterAccessor.getPixelStride();
        int n4 = rasterAccessor.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = rasterAccessor3.getPixelStride();
        int n8 = rasterAccessor3.getScanlineStride();
        int n9 = this.sampleModel.getNumBands() / 2;
        int n10 = 0;
        while (n10 < n9) {
            int n11 = 2 * n10;
            int n12 = n11 + 1;
            short[] sArray = rasterAccessor.getShortDataArray(this.s1r[n10]);
            short[] sArray2 = rasterAccessor.getShortDataArray(this.s1i[n10]);
            short[] sArray3 = rasterAccessor2.getShortDataArray(this.s2r[n10]);
            short[] sArray4 = rasterAccessor2.getShortDataArray(this.s2i[n10]);
            short[] sArray5 = rasterAccessor3.getShortDataArray(n11);
            short[] sArray6 = rasterAccessor3.getShortDataArray(n12);
            int n13 = rasterAccessor.getBandOffset(this.s1r[n10]);
            int n14 = rasterAccessor.getBandOffset(this.s1i[n10]);
            int n15 = rasterAccessor2.getBandOffset(this.s2r[n10]);
            int n16 = rasterAccessor2.getBandOffset(this.s2i[n10]);
            int n17 = rasterAccessor3.getBandOffset(n11);
            int n18 = rasterAccessor3.getBandOffset(n12);
            int n19 = n13;
            int n20 = n14;
            int n21 = n15;
            int n22 = n16;
            int n23 = n17;
            int n24 = n18;
            int n25 = 0;
            while (n25 < n) {
                short s;
                short s2;
                short s3;
                short s4;
                int n26;
                int n27 = n19;
                int n28 = n20;
                int n29 = n21;
                int n30 = n22;
                int n31 = n23;
                int n32 = n24;
                if (this.isDivision) {
                    n26 = 0;
                    while (n26 < n2) {
                        s4 = sArray[n27];
                        s3 = sArray2[n28];
                        s2 = sArray3[n29];
                        s = sArray4[n30];
                        int n33 = s2 * s2 + s * s;
                        sArray5[n31] = ImageUtil.clampShort((s4 * s2 + s3 * s) / n33);
                        sArray6[n32] = ImageUtil.clampShort((s3 * s2 - s4 * s) / n33);
                        n27 += n3;
                        n28 += n3;
                        n29 += n5;
                        n30 += n5;
                        n31 += n7;
                        n32 += n7;
                        ++n26;
                    }
                } else {
                    n26 = 0;
                    while (n26 < n2) {
                        s4 = sArray[n27];
                        s3 = sArray2[n28];
                        s2 = sArray3[n29];
                        s = sArray4[n30];
                        sArray5[n31] = ImageUtil.clampShort(s4 * s2 - s3 * s);
                        sArray6[n32] = ImageUtil.clampShort(s4 * s + s3 * s2);
                        n27 += n3;
                        n28 += n3;
                        n29 += n5;
                        n30 += n5;
                        n31 += n7;
                        n32 += n7;
                        ++n26;
                    }
                }
                n19 += n4;
                n20 += n4;
                n21 += n6;
                n22 += n6;
                n23 += n8;
                n24 += n8;
                ++n25;
            }
            ++n10;
        }
    }

    private void computeRectByte(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3) {
        int n = rasterAccessor3.getHeight();
        int n2 = rasterAccessor3.getWidth();
        int n3 = rasterAccessor.getPixelStride();
        int n4 = rasterAccessor.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = rasterAccessor3.getPixelStride();
        int n8 = rasterAccessor3.getScanlineStride();
        int n9 = this.sampleModel.getNumBands() / 2;
        int n10 = 0;
        while (n10 < n9) {
            int n11 = 2 * n10;
            int n12 = n11 + 1;
            byte[] byArray = rasterAccessor.getByteDataArray(this.s1r[n10]);
            byte[] byArray2 = rasterAccessor.getByteDataArray(this.s1i[n10]);
            byte[] byArray3 = rasterAccessor2.getByteDataArray(this.s2r[n10]);
            byte[] byArray4 = rasterAccessor2.getByteDataArray(this.s2i[n10]);
            byte[] byArray5 = rasterAccessor3.getByteDataArray(n11);
            byte[] byArray6 = rasterAccessor3.getByteDataArray(n12);
            int n13 = rasterAccessor.getBandOffset(this.s1r[n10]);
            int n14 = rasterAccessor.getBandOffset(this.s1i[n10]);
            int n15 = rasterAccessor2.getBandOffset(this.s2r[n10]);
            int n16 = rasterAccessor2.getBandOffset(this.s2i[n10]);
            int n17 = rasterAccessor3.getBandOffset(n11);
            int n18 = rasterAccessor3.getBandOffset(n12);
            int n19 = n13;
            int n20 = n14;
            int n21 = n15;
            int n22 = n16;
            int n23 = n17;
            int n24 = n18;
            int n25 = 0;
            while (n25 < n) {
                int n26;
                int n27;
                int n28;
                int n29;
                int n30;
                int n31 = n19;
                int n32 = n20;
                int n33 = n21;
                int n34 = n22;
                int n35 = n23;
                int n36 = n24;
                if (this.isDivision) {
                    n30 = 0;
                    while (n30 < n2) {
                        n29 = byArray[n31] & 0xFF;
                        n28 = byArray2[n32] & 0xFF;
                        n27 = byArray3[n33] & 0xFF;
                        n26 = byArray4[n34] & 0xFF;
                        int n37 = n27 * n27 + n26 * n26;
                        byArray5[n35] = ImageUtil.clampByte((n29 * n27 + n28 * n26) / n37);
                        byArray6[n36] = ImageUtil.clampByte((n28 * n27 - n29 * n26) / n37);
                        n31 += n3;
                        n32 += n3;
                        n33 += n5;
                        n34 += n5;
                        n35 += n7;
                        n36 += n7;
                        ++n30;
                    }
                } else {
                    n30 = 0;
                    while (n30 < n2) {
                        n29 = byArray[n31] & 0xFF;
                        n28 = byArray2[n32] & 0xFF;
                        n27 = byArray3[n33] & 0xFF;
                        n26 = byArray4[n34] & 0xFF;
                        byArray5[n35] = ImageUtil.clampByte(n29 * n27 - n28 * n26);
                        byArray6[n36] = ImageUtil.clampByte(n29 * n26 + n28 * n27);
                        n31 += n3;
                        n32 += n3;
                        n33 += n5;
                        n34 += n5;
                        n35 += n7;
                        n36 += n7;
                        ++n30;
                    }
                }
                n19 += n4;
                n20 += n4;
                n21 += n6;
                n22 += n6;
                n23 += n8;
                n24 += n8;
                ++n25;
            }
            ++n10;
        }
    }
}

