/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFactory;
import javax.media.jai.RasterFormatTag;

final class DivideOpImage
extends PointOpImage {
    private byte[][] divideTableByte;
    private int s1bd = 1;
    private int s2bd = 1;

    public DivideOpImage(RenderedImage renderedImage, RenderedImage renderedImage2, Map map, ImageLayout imageLayout) {
        super(renderedImage, renderedImage2, imageLayout, map, true);
        SampleModel sampleModel;
        int n;
        int n2 = renderedImage.getSampleModel().getNumBands();
        int n3 = renderedImage2.getSampleModel().getNumBands();
        if (imageLayout != null && imageLayout.isValid(256) && (n = (sampleModel = imageLayout.getSampleModel(null)).getNumBands()) > 1 && (n2 > 1 && n3 == 1 || n2 == 1 && n3 > 1)) {
            n = Math.min(Math.max(n2, n3), n);
            if (n != this.sampleModel.getNumBands()) {
                this.sampleModel = RasterFactory.createComponentSampleModel(sampleModel, this.sampleModel.getTransferType(), this.sampleModel.getWidth(), this.sampleModel.getHeight(), n);
                if (this.colorModel != null && !JDKWorkarounds.areCompatibleDataModels(this.sampleModel, this.colorModel)) {
                    this.colorModel = ImageUtil.getCompatibleColorModel(this.sampleModel, map);
                }
            }
            this.s1bd = n2 == 1 ? 0 : 1;
            int n4 = this.s2bd = n3 == 1 ? 0 : 1;
        }
        if (this.sampleModel.getTransferType() == 0) {
            this.divideTableByte = new byte[256][256];
            int n5 = 0;
            while (n5 < 256) {
                byte[] byArray = this.divideTableByte[n5];
                byArray[0] = n5 > 0 ? -1 : 0;
                int n6 = 1;
                while (n6 < 256) {
                    byArray[n6] = ImageUtil.clampRoundByte((float)n5 / (float)n6);
                    ++n6;
                }
                ++n5;
            }
        }
        this.permitInPlaceOperation();
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        RasterAccessor rasterAccessor = new RasterAccessor(rasterArray[0], rectangle, rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(rasterArray[1], rectangle, rasterFormatTagArray[1], this.getSourceImage(1).getColorModel());
        RasterAccessor rasterAccessor3 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[2], this.getColorModel());
        if (rasterAccessor3.isBinary()) {
            byte[] byArray = rasterAccessor3.getBinaryDataArray();
            System.arraycopy(rasterAccessor.getBinaryDataArray(), 0, byArray, 0, byArray.length);
            rasterAccessor3.copyBinaryDataToRaster();
            return;
        }
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        int n3 = rasterAccessor2.getScanlineStride();
        int n4 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        int n5 = rasterAccessor3.getNumBands();
        int n6 = rasterAccessor3.getWidth();
        int n7 = rasterAccessor3.getHeight();
        int n8 = rasterAccessor3.getScanlineStride();
        int n9 = rasterAccessor3.getPixelStride();
        int[] nArray3 = rasterAccessor3.getBandOffsets();
        switch (rasterAccessor3.getDataType()) {
            case 0: {
                this.byteLoop(n5, n6, n7, n, n2, nArray, rasterAccessor.getByteDataArrays(), n3, n4, nArray2, rasterAccessor2.getByteDataArrays(), n8, n9, nArray3, rasterAccessor3.getByteDataArrays());
                break;
            }
            case 1: {
                this.ushortLoop(n5, n6, n7, n, n2, nArray, rasterAccessor.getShortDataArrays(), n3, n4, nArray2, rasterAccessor2.getShortDataArrays(), n8, n9, nArray3, rasterAccessor3.getShortDataArrays());
                break;
            }
            case 2: {
                this.shortLoop(n5, n6, n7, n, n2, nArray, rasterAccessor.getShortDataArrays(), n3, n4, nArray2, rasterAccessor2.getShortDataArrays(), n8, n9, nArray3, rasterAccessor3.getShortDataArrays());
                break;
            }
            case 3: {
                this.intLoop(n5, n6, n7, n, n2, nArray, rasterAccessor.getIntDataArrays(), n3, n4, nArray2, rasterAccessor2.getIntDataArrays(), n8, n9, nArray3, rasterAccessor3.getIntDataArrays());
                break;
            }
            case 4: {
                this.floatLoop(n5, n6, n7, n, n2, nArray, rasterAccessor.getFloatDataArrays(), n3, n4, nArray2, rasterAccessor2.getFloatDataArrays(), n8, n9, nArray3, rasterAccessor3.getFloatDataArrays());
                break;
            }
            case 5: {
                this.doubleLoop(n5, n6, n7, n, n2, nArray, rasterAccessor.getDoubleDataArrays(), n3, n4, nArray2, rasterAccessor2.getDoubleDataArrays(), n8, n9, nArray3, rasterAccessor3.getDoubleDataArrays());
            }
        }
        if (rasterAccessor3.needsClamping()) {
            rasterAccessor3.clampDataArrays();
        }
        rasterAccessor3.copyDataToRaster();
    }

    private void byteLoop(int n, int n2, int n3, int n4, int n5, int[] nArray, byte[][] byArray, int n6, int n7, int[] nArray2, byte[][] byArray2, int n8, int n9, int[] nArray3, byte[][] byArray3) {
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        while (n10 < n) {
            byte[] byArray4 = byArray[n11];
            byte[] byArray5 = byArray2[n12];
            byte[] byArray6 = byArray3[n10];
            int n13 = nArray[n11];
            int n14 = nArray2[n12];
            int n15 = nArray3[n10];
            int n16 = 0;
            while (n16 < n3) {
                int n17 = n13;
                int n18 = n14;
                int n19 = n15;
                n13 += n4;
                n14 += n6;
                n15 += n8;
                int n20 = 0;
                while (n20 < n2) {
                    byArray6[n19] = this.divideTableByte[byArray4[n17] & 0xFF][byArray5[n18] & 0xFF];
                    n17 += n5;
                    n18 += n7;
                    n19 += n9;
                    ++n20;
                }
                ++n16;
            }
            ++n10;
            n11 += this.s1bd;
            n12 += this.s2bd;
        }
    }

    private void ushortLoop(int n, int n2, int n3, int n4, int n5, int[] nArray, short[][] sArray, int n6, int n7, int[] nArray2, short[][] sArray2, int n8, int n9, int[] nArray3, short[][] sArray3) {
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        while (n10 < n) {
            short[] sArray4 = sArray[n11];
            short[] sArray5 = sArray2[n12];
            short[] sArray6 = sArray3[n10];
            int n13 = nArray[n11];
            int n14 = nArray2[n12];
            int n15 = nArray3[n10];
            int n16 = 0;
            while (n16 < n3) {
                int n17 = n13;
                int n18 = n14;
                int n19 = n15;
                n13 += n4;
                n14 += n6;
                n15 += n8;
                int n20 = 0;
                while (n20 < n2) {
                    float f2 = sArray4[n17] & 0xFFFF;
                    float f3 = sArray5[n18] & 0xFFFF;
                    sArray6[n19] = f2 == 0.0f ? 0 : (f3 == 0.0f ? -1 : ImageUtil.clampRoundUShort(f2 / f3));
                    n17 += n5;
                    n18 += n7;
                    n19 += n9;
                    ++n20;
                }
                ++n16;
            }
            ++n10;
            n11 += this.s1bd;
            n12 += this.s2bd;
        }
    }

    private void shortLoop(int n, int n2, int n3, int n4, int n5, int[] nArray, short[][] sArray, int n6, int n7, int[] nArray2, short[][] sArray2, int n8, int n9, int[] nArray3, short[][] sArray3) {
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        while (n10 < n) {
            short[] sArray4 = sArray[n11];
            short[] sArray5 = sArray2[n12];
            short[] sArray6 = sArray3[n10];
            int n13 = nArray[n11];
            int n14 = nArray2[n12];
            int n15 = nArray3[n10];
            int n16 = 0;
            while (n16 < n3) {
                int n17 = n13;
                int n18 = n14;
                int n19 = n15;
                n13 += n4;
                n14 += n6;
                n15 += n8;
                int n20 = 0;
                while (n20 < n2) {
                    float f2 = sArray4[n17];
                    float f3 = sArray5[n18];
                    sArray6[n19] = f2 == 0.0f ? 0 : (f3 == 0.0f ? (f2 < 0.0f ? Short.MIN_VALUE : Short.MAX_VALUE) : ImageUtil.clampRoundShort(f2 / f3));
                    n17 += n5;
                    n18 += n7;
                    n19 += n9;
                    ++n20;
                }
                ++n16;
            }
            ++n10;
            n11 += this.s1bd;
            n12 += this.s2bd;
        }
    }

    private void intLoop(int n, int n2, int n3, int n4, int n5, int[] nArray, int[][] nArray2, int n6, int n7, int[] nArray3, int[][] nArray4, int n8, int n9, int[] nArray5, int[][] nArray6) {
        switch (this.sampleModel.getTransferType()) {
            case 0: {
                int n10 = 0;
                int n11 = 0;
                int n12 = 0;
                while (n10 < n) {
                    int[] nArray7 = nArray2[n11];
                    int[] nArray8 = nArray4[n12];
                    int[] nArray9 = nArray6[n10];
                    int n13 = nArray[n11];
                    int n14 = nArray3[n12];
                    int n15 = nArray5[n10];
                    int n16 = 0;
                    while (n16 < n3) {
                        int n17 = n13;
                        int n18 = n14;
                        int n19 = n15;
                        n13 += n4;
                        n14 += n6;
                        n15 += n8;
                        int n20 = 0;
                        while (n20 < n2) {
                            float f2 = nArray7[n17] & 0xFF;
                            float f3 = nArray8[n18] & 0xFF;
                            nArray9[n19] = f2 == 0.0f ? 0 : (f3 == 0.0f ? 255 : (int)ImageUtil.clampRoundByte(f2 / f3));
                            n17 += n5;
                            n18 += n7;
                            n19 += n9;
                            ++n20;
                        }
                        ++n16;
                    }
                    ++n10;
                    n11 += this.s1bd;
                    n12 += this.s2bd;
                }
                break;
            }
            case 1: {
                int n21 = 0;
                int n22 = 0;
                int n23 = 0;
                while (n21 < n) {
                    int[] nArray10 = nArray2[n22];
                    int[] nArray11 = nArray4[n23];
                    int[] nArray12 = nArray6[n21];
                    int n24 = nArray[n22];
                    int n25 = nArray3[n23];
                    int n26 = nArray5[n21];
                    int n27 = 0;
                    while (n27 < n3) {
                        int n28 = n24;
                        int n29 = n25;
                        int n30 = n26;
                        n24 += n4;
                        n25 += n6;
                        n26 += n8;
                        int n31 = 0;
                        while (n31 < n2) {
                            float f4 = nArray10[n28] & 0xFFFF;
                            float f5 = nArray11[n29] & 0xFFFF;
                            nArray12[n30] = f4 == 0.0f ? 0 : (f5 == 0.0f ? -1 : (int)ImageUtil.clampRoundUShort(f4 / f5));
                            n28 += n5;
                            n29 += n7;
                            n30 += n9;
                            ++n31;
                        }
                        ++n27;
                    }
                    ++n21;
                    n22 += this.s1bd;
                    n23 += this.s2bd;
                }
                break;
            }
            case 2: {
                int n32 = 0;
                int n33 = 0;
                int n34 = 0;
                while (n32 < n) {
                    int[] nArray13 = nArray2[n33];
                    int[] nArray14 = nArray4[n34];
                    int[] nArray15 = nArray6[n32];
                    int n35 = nArray[n33];
                    int n36 = nArray3[n34];
                    int n37 = nArray5[n32];
                    int n38 = 0;
                    while (n38 < n3) {
                        int n39 = n35;
                        int n40 = n36;
                        int n41 = n37;
                        n35 += n4;
                        n36 += n6;
                        n37 += n8;
                        int n42 = 0;
                        while (n42 < n2) {
                            float f6 = nArray13[n39];
                            float f7 = nArray14[n40];
                            nArray15[n41] = f6 == 0.0f ? 0 : (f7 == 0.0f ? (f6 < 0.0f ? Short.MIN_VALUE : Short.MAX_VALUE) : (int)ImageUtil.clampRoundShort(f6 / f7));
                            n39 += n5;
                            n40 += n7;
                            n41 += n9;
                            ++n42;
                        }
                        ++n38;
                    }
                    ++n32;
                    n33 += this.s1bd;
                    n34 += this.s2bd;
                }
                break;
            }
            case 3: {
                int n43 = 0;
                int n44 = 0;
                int n45 = 0;
                while (n43 < n) {
                    int[] nArray16 = nArray2[n44];
                    int[] nArray17 = nArray4[n45];
                    int[] nArray18 = nArray6[n43];
                    int n46 = nArray[n44];
                    int n47 = nArray3[n45];
                    int n48 = nArray5[n43];
                    int n49 = 0;
                    while (n49 < n3) {
                        int n50 = n46;
                        int n51 = n47;
                        int n52 = n48;
                        n46 += n4;
                        n47 += n6;
                        n48 += n8;
                        int n53 = 0;
                        while (n53 < n2) {
                            float f8 = nArray16[n50];
                            float f9 = nArray17[n51];
                            nArray18[n52] = f8 == 0.0f ? 0 : (f9 == 0.0f ? (f8 < 0.0f ? Integer.MIN_VALUE : Integer.MAX_VALUE) : ImageUtil.clampRoundInt(f8 / f9));
                            n50 += n5;
                            n51 += n7;
                            n52 += n9;
                            ++n53;
                        }
                        ++n49;
                    }
                    ++n43;
                    n44 += this.s1bd;
                    n45 += this.s2bd;
                }
                break;
            }
        }
    }

    private void floatLoop(int n, int n2, int n3, int n4, int n5, int[] nArray, float[][] fArray, int n6, int n7, int[] nArray2, float[][] fArray2, int n8, int n9, int[] nArray3, float[][] fArray3) {
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        while (n10 < n) {
            float[] fArray4 = fArray[n11];
            float[] fArray5 = fArray2[n12];
            float[] fArray6 = fArray3[n10];
            int n13 = nArray[n11];
            int n14 = nArray2[n12];
            int n15 = nArray3[n10];
            int n16 = 0;
            while (n16 < n3) {
                int n17 = n13;
                int n18 = n14;
                int n19 = n15;
                n13 += n4;
                n14 += n6;
                n15 += n8;
                int n20 = 0;
                while (n20 < n2) {
                    fArray6[n19] = fArray4[n17] / fArray5[n18];
                    n17 += n5;
                    n18 += n7;
                    n19 += n9;
                    ++n20;
                }
                ++n16;
            }
            ++n10;
            n11 += this.s1bd;
            n12 += this.s2bd;
        }
    }

    private void doubleLoop(int n, int n2, int n3, int n4, int n5, int[] nArray, double[][] dArray, int n6, int n7, int[] nArray2, double[][] dArray2, int n8, int n9, int[] nArray3, double[][] dArray3) {
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        while (n10 < n) {
            double[] dArray4 = dArray[n11];
            double[] dArray5 = dArray2[n12];
            double[] dArray6 = dArray3[n10];
            int n13 = nArray[n11];
            int n14 = nArray2[n12];
            int n15 = nArray3[n10];
            int n16 = 0;
            while (n16 < n3) {
                int n17 = n13;
                int n18 = n14;
                int n19 = n15;
                n13 += n4;
                n14 += n6;
                n15 += n8;
                int n20 = 0;
                while (n20 < n2) {
                    dArray6[n19] = dArray4[n17] / dArray5[n18];
                    n17 += n5;
                    n18 += n7;
                    n19 += n9;
                    ++n20;
                }
                ++n16;
            }
            ++n10;
            n11 += this.s1bd;
            n12 += this.s2bd;
        }
    }
}

