/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.media.jai.PixelAccessor;
import javax.media.jai.ROI;
import javax.media.jai.StatisticsOpImage;
import javax.media.jai.UnpackedImageData;

public class ExtremaOpImage
extends StatisticsOpImage {
    protected double[][] extrema = null;
    protected ArrayList[] minLocations;
    protected ArrayList[] maxLocations;
    protected int[] minCounts;
    protected int[] maxCounts;
    protected boolean saveLocations;
    protected int maxRuns;
    protected int numMinLocations = 0;
    protected int numMaxLocations = 0;
    private boolean isInitialized = false;
    private PixelAccessor srcPA;
    private int srcSampleType;

    private final boolean tileIntersectsROI(int n, int n2) {
        if (this.roi == null) {
            return true;
        }
        return this.roi.intersects(this.tileXToX(n), this.tileYToY(n2), this.tileWidth, this.tileHeight);
    }

    public ExtremaOpImage(RenderedImage renderedImage, ROI rOI, int n, int n2, int n3, int n4, boolean bl, int n5) {
        super(renderedImage, rOI, n, n2, n3, n4);
        this.saveLocations = bl;
        this.maxRuns = n5;
    }

    public Object getProperty(String string) {
        int n = this.sampleModel.getNumBands();
        if (this.extrema == null) {
            return super.getProperty(string);
        }
        if (string.equalsIgnoreCase("extrema")) {
            double[][] dArray = new double[2][n];
            int n2 = 0;
            while (n2 < n) {
                dArray[0][n2] = this.extrema[0][n2];
                dArray[1][n2] = this.extrema[1][n2];
                ++n2;
            }
            return dArray;
        }
        if (string.equalsIgnoreCase("minimum")) {
            double[] dArray = new double[n];
            int n3 = 0;
            while (n3 < n) {
                dArray[n3] = this.extrema[0][n3];
                ++n3;
            }
            return dArray;
        }
        if (string.equalsIgnoreCase("maximum")) {
            double[] dArray = new double[n];
            int n4 = 0;
            while (n4 < n) {
                dArray[n4] = this.extrema[1][n4];
                ++n4;
            }
            return dArray;
        }
        if (this.saveLocations && string.equalsIgnoreCase("minLocations")) {
            return this.minLocations;
        }
        if (this.saveLocations && string.equalsIgnoreCase("maxLocations")) {
            return this.maxLocations;
        }
        return Image.UndefinedProperty;
    }

    protected String[] getStatisticsNames() {
        return new String[]{"extrema", "maximum", "minimum", "maxLocations", "minLocations"};
    }

    protected Object createStatistics(String string) {
        int n = this.sampleModel.getNumBands();
        Object object = null;
        object = string.equalsIgnoreCase("extrema") ? new double[2][n] : (string.equalsIgnoreCase("minimum") || string.equalsIgnoreCase("maximum") ? (Object)new double[n] : (this.saveLocations && (string.equalsIgnoreCase("minLocations") || string.equalsIgnoreCase("maxLocations")) ? (Object)new ArrayList[n] : (Object)Image.UndefinedProperty));
        return object;
    }

    private final int startPosition(int n, int n2, int n3) {
        int n4 = (n - n2) % n3;
        return n4 == 0 ? n : n + (n3 - n4);
    }

    protected void accumulateStatistics(String string, Raster raster, Object object) {
        block19: {
            int n;
            ArrayList[] arrayListArray;
            block22: {
                block21: {
                    block20: {
                        block18: {
                            LinkedList linkedList;
                            if (!this.isInitialized) {
                                this.srcPA = new PixelAccessor(this.getSourceImage(0));
                                this.srcSampleType = this.srcPA.sampleType == -1 ? 0 : this.srcPA.sampleType;
                                this.isInitialized = true;
                            }
                            Rectangle rectangle = this.getSourceImage(0).getBounds().intersection(raster.getBounds());
                            if (this.roi == null) {
                                linkedList = new LinkedList();
                                linkedList.addLast(rectangle);
                            } else {
                                linkedList = this.roi.getAsRectangleList(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                                if (linkedList == null) {
                                    return;
                                }
                            }
                            ListIterator listIterator = linkedList.listIterator(0);
                            while (listIterator.hasNext()) {
                                arrayListArray = rectangle.intersection((Rectangle)listIterator.next());
                                n = arrayListArray.x;
                                int n2 = arrayListArray.y;
                                arrayListArray.x = this.startPosition(n, this.xStart, this.xPeriod);
                                arrayListArray.y = this.startPosition(n2, this.yStart, this.yPeriod);
                                arrayListArray.width = n + arrayListArray.width - arrayListArray.x;
                                arrayListArray.height = n2 + arrayListArray.height - arrayListArray.y;
                                if (arrayListArray.isEmpty()) continue;
                                this.initializeState(raster);
                                UnpackedImageData unpackedImageData = this.srcPA.getPixels(raster, (Rectangle)arrayListArray, this.srcSampleType, false);
                                switch (unpackedImageData.type) {
                                    case 0: {
                                        this.accumulateStatisticsByte(unpackedImageData);
                                        break;
                                    }
                                    case 1: {
                                        this.accumulateStatisticsUShort(unpackedImageData);
                                        break;
                                    }
                                    case 2: {
                                        this.accumulateStatisticsShort(unpackedImageData);
                                        break;
                                    }
                                    case 3: {
                                        this.accumulateStatisticsInt(unpackedImageData);
                                        break;
                                    }
                                    case 4: {
                                        this.accumulateStatisticsFloat(unpackedImageData);
                                        break;
                                    }
                                    case 5: {
                                        this.accumulateStatisticsDouble(unpackedImageData);
                                    }
                                }
                            }
                            if (!string.equalsIgnoreCase("extrema")) break block18;
                            arrayListArray = (ArrayList[])((double[][])object);
                            n = 0;
                            while (n < this.srcPA.numBands) {
                                arrayListArray[0][n] = this.extrema[0][n];
                                arrayListArray[1][n] = (ArrayList)this.extrema[1][n];
                                ++n;
                            }
                            break block19;
                        }
                        if (!string.equalsIgnoreCase("minimum")) break block20;
                        arrayListArray = (ArrayList[])((double[])object);
                        n = 0;
                        while (n < this.srcPA.numBands) {
                            arrayListArray[n] = (ArrayList)this.extrema[0][n];
                            ++n;
                        }
                        break block19;
                    }
                    if (!string.equalsIgnoreCase("maximum")) break block21;
                    arrayListArray = (ArrayList[])((double[])object);
                    n = 0;
                    while (n < this.srcPA.numBands) {
                        arrayListArray[n] = (ArrayList)this.extrema[1][n];
                        ++n;
                    }
                    break block19;
                }
                if (!string.equalsIgnoreCase("minLocations")) break block22;
                arrayListArray = (ArrayList[])object;
                n = 0;
                while (n < this.srcPA.numBands) {
                    arrayListArray[n] = this.minLocations[n];
                    ++n;
                }
                break block19;
            }
            if (!string.equalsIgnoreCase("maxLocations")) break block19;
            arrayListArray = (ArrayList[])object;
            n = 0;
            while (n < this.srcPA.numBands) {
                arrayListArray[n] = this.maxLocations[n];
                ++n;
            }
        }
    }

    private void accumulateStatisticsByte(UnpackedImageData unpackedImageData) {
        Rectangle rectangle = unpackedImageData.rect;
        byte[][] byArray = unpackedImageData.getByteData();
        int n = unpackedImageData.lineStride;
        int n2 = unpackedImageData.pixelStride;
        int n3 = n * this.yPeriod;
        int n4 = n2 * this.xPeriod;
        if (!this.saveLocations) {
            int n5 = 0;
            while (n5 < this.srcPA.numBands) {
                int n6 = (int)this.extrema[0][n5];
                int n7 = (int)this.extrema[1][n5];
                byte[] byArray2 = byArray[n5];
                int n8 = unpackedImageData.bandOffsets[n5] + rectangle.height * n;
                int n9 = unpackedImageData.bandOffsets[n5];
                while (n9 < n8) {
                    int n10 = n9 + rectangle.width * n2;
                    int n11 = n9;
                    while (n11 < n10) {
                        int n12 = byArray2[n11] & 0xFF;
                        if (n12 < n6) {
                            n6 = n12;
                        } else if (n12 > n7) {
                            n7 = n12;
                        }
                        n11 += n4;
                    }
                    n9 += n3;
                }
                this.extrema[0][n5] = n6;
                this.extrema[1][n5] = n7;
                ++n5;
            }
        } else {
            int n13 = 0;
            while (n13 < this.srcPA.numBands) {
                int n14 = (int)this.extrema[0][n13];
                int n15 = (int)this.extrema[1][n13];
                ArrayList arrayList = this.minLocations[n13];
                ArrayList arrayList2 = this.maxLocations[n13];
                int n16 = this.minCounts[n13];
                int n17 = this.maxCounts[n13];
                byte[] byArray3 = byArray[n13];
                int n18 = unpackedImageData.bandOffsets[n13] + rectangle.height * n;
                int n19 = unpackedImageData.bandOffsets[n13];
                int n20 = rectangle.y;
                while (n19 < n18) {
                    int n21 = n19 + rectangle.width * n2;
                    int n22 = 0;
                    int n23 = 0;
                    int n24 = 0;
                    int n25 = 0;
                    int n26 = n19;
                    int n27 = rectangle.x;
                    while (n26 < n21) {
                        int n28 = byArray3[n26] & 0xFF;
                        if (n28 < n14) {
                            n14 = n28;
                            n22 = n27;
                            n24 = 1;
                            arrayList.clear();
                            n16 = 0;
                        } else if (n28 > n15) {
                            n15 = n28;
                            n23 = n27;
                            n25 = 1;
                            arrayList2.clear();
                            n17 = 0;
                        } else {
                            if (n28 == n14) {
                                if (n24 == 0) {
                                    n22 = n27;
                                }
                                ++n24;
                            } else if (n24 > 0 && n16 < this.maxRuns) {
                                arrayList.add(new int[]{n22, n20, n24});
                                ++n16;
                                n24 = 0;
                            }
                            if (n28 == n15) {
                                if (n25 == 0) {
                                    n23 = n27;
                                }
                                ++n25;
                            } else if (n25 > 0 && n17 < this.maxRuns) {
                                arrayList2.add(new int[]{n23, n20, n25});
                                ++n17;
                                n25 = 0;
                            }
                        }
                        n26 += n4;
                        n27 += this.xPeriod;
                    }
                    if (n25 > 0 && n17 < this.maxRuns) {
                        arrayList2.add(new int[]{n23, n20, n25});
                        ++n17;
                    }
                    if (n24 > 0 && n16 < this.maxRuns) {
                        arrayList.add(new int[]{n22, n20, n24});
                        ++n16;
                    }
                    n19 += n3;
                    n20 += this.yPeriod;
                }
                this.extrema[0][n13] = n14;
                this.extrema[1][n13] = n15;
                this.minCounts[n13] = n16;
                this.maxCounts[n13] = n17;
                ++n13;
            }
        }
    }

    private void accumulateStatisticsUShort(UnpackedImageData unpackedImageData) {
        Rectangle rectangle = unpackedImageData.rect;
        short[][] sArray = unpackedImageData.getShortData();
        int n = unpackedImageData.lineStride;
        int n2 = unpackedImageData.pixelStride;
        int n3 = n * this.yPeriod;
        int n4 = n2 * this.xPeriod;
        if (!this.saveLocations) {
            int n5 = 0;
            while (n5 < this.srcPA.numBands) {
                int n6 = (int)this.extrema[0][n5];
                int n7 = (int)this.extrema[1][n5];
                short[] sArray2 = sArray[n5];
                int n8 = unpackedImageData.bandOffsets[n5] + rectangle.height * n;
                int n9 = unpackedImageData.bandOffsets[n5];
                while (n9 < n8) {
                    int n10 = n9 + rectangle.width * n2;
                    int n11 = n9;
                    while (n11 < n10) {
                        int n12 = sArray2[n11] & 0xFFFF;
                        if (n12 < n6) {
                            n6 = n12;
                        } else if (n12 > n7) {
                            n7 = n12;
                        }
                        n11 += n4;
                    }
                    n9 += n3;
                }
                this.extrema[0][n5] = n6;
                this.extrema[1][n5] = n7;
                ++n5;
            }
        } else {
            int n13 = 0;
            while (n13 < this.srcPA.numBands) {
                int n14 = (int)this.extrema[0][n13];
                int n15 = (int)this.extrema[1][n13];
                ArrayList arrayList = this.minLocations[n13];
                ArrayList arrayList2 = this.maxLocations[n13];
                int n16 = this.minCounts[n13];
                int n17 = this.maxCounts[n13];
                short[] sArray3 = sArray[n13];
                int n18 = unpackedImageData.bandOffsets[n13] + rectangle.height * n;
                int n19 = unpackedImageData.bandOffsets[n13];
                int n20 = rectangle.y;
                while (n19 < n18) {
                    int n21 = n19 + rectangle.width * n2;
                    int n22 = 0;
                    int n23 = 0;
                    int n24 = 0;
                    int n25 = 0;
                    int n26 = n19;
                    int n27 = rectangle.x;
                    while (n26 < n21) {
                        int n28 = sArray3[n26] & 0xFFFF;
                        if (n28 < n14) {
                            n14 = n28;
                            n22 = n27;
                            n24 = 1;
                            arrayList.clear();
                            n16 = 0;
                        } else if (n28 > n15) {
                            n15 = n28;
                            n23 = n27;
                            n25 = 1;
                            arrayList2.clear();
                            n17 = 0;
                        } else {
                            if (n28 == n14) {
                                if (n24 == 0) {
                                    n22 = n27;
                                }
                                ++n24;
                            } else if (n24 > 0 && n16 < this.maxRuns) {
                                arrayList.add(new int[]{n22, n20, n24});
                                ++n16;
                                n24 = 0;
                            }
                            if (n28 == n15) {
                                if (n25 == 0) {
                                    n23 = n27;
                                }
                                ++n25;
                            } else if (n25 > 0 && n17 < this.maxRuns) {
                                arrayList2.add(new int[]{n23, n20, n25});
                                ++n17;
                                n25 = 0;
                            }
                        }
                        n26 += n4;
                        n27 += this.xPeriod;
                    }
                    if (n25 > 0 && n17 < this.maxRuns) {
                        arrayList2.add(new int[]{n23, n20, n25});
                        ++n17;
                    }
                    if (n24 > 0 && n16 < this.maxRuns) {
                        arrayList.add(new int[]{n22, n20, n24});
                        ++n16;
                    }
                    n19 += n3;
                    n20 += this.yPeriod;
                }
                this.extrema[0][n13] = n14;
                this.extrema[1][n13] = n15;
                this.minCounts[n13] = n16;
                this.maxCounts[n13] = n17;
                ++n13;
            }
        }
    }

    private void accumulateStatisticsShort(UnpackedImageData unpackedImageData) {
        Rectangle rectangle = unpackedImageData.rect;
        short[][] sArray = unpackedImageData.getShortData();
        int n = unpackedImageData.lineStride;
        int n2 = unpackedImageData.pixelStride;
        int n3 = n * this.yPeriod;
        int n4 = n2 * this.xPeriod;
        if (!this.saveLocations) {
            int n5 = 0;
            while (n5 < this.srcPA.numBands) {
                int n6 = (int)this.extrema[0][n5];
                int n7 = (int)this.extrema[1][n5];
                short[] sArray2 = sArray[n5];
                int n8 = unpackedImageData.bandOffsets[n5] + rectangle.height * n;
                int n9 = unpackedImageData.bandOffsets[n5];
                while (n9 < n8) {
                    int n10 = n9 + rectangle.width * n2;
                    int n11 = n9;
                    while (n11 < n10) {
                        int n12 = sArray2[n11];
                        if (n12 < n6) {
                            n6 = n12;
                        } else if (n12 > n7) {
                            n7 = n12;
                        }
                        n11 += n4;
                    }
                    n9 += n3;
                }
                this.extrema[0][n5] = n6;
                this.extrema[1][n5] = n7;
                ++n5;
            }
        } else {
            int n13 = 0;
            while (n13 < this.srcPA.numBands) {
                int n14 = (int)this.extrema[0][n13];
                int n15 = (int)this.extrema[1][n13];
                ArrayList arrayList = this.minLocations[n13];
                ArrayList arrayList2 = this.maxLocations[n13];
                int n16 = this.minCounts[n13];
                int n17 = this.maxCounts[n13];
                short[] sArray3 = sArray[n13];
                int n18 = unpackedImageData.bandOffsets[n13] + rectangle.height * n;
                int n19 = unpackedImageData.bandOffsets[n13];
                int n20 = rectangle.y;
                while (n19 < n18) {
                    int n21 = n19 + rectangle.width * n2;
                    int n22 = 0;
                    int n23 = 0;
                    int n24 = 0;
                    int n25 = 0;
                    int n26 = n19;
                    int n27 = rectangle.x;
                    while (n26 < n21) {
                        int n28 = sArray3[n26];
                        if (n28 < n14) {
                            n14 = n28;
                            n22 = n27;
                            n24 = 1;
                            arrayList.clear();
                            n16 = 0;
                        } else if (n28 > n15) {
                            n15 = n28;
                            n23 = n27;
                            n25 = 1;
                            arrayList2.clear();
                            n17 = 0;
                        } else {
                            if (n28 == n14) {
                                if (n24 == 0) {
                                    n22 = n27;
                                }
                                ++n24;
                            } else if (n24 > 0 && n16 < this.maxRuns) {
                                arrayList.add(new int[]{n22, n20, n24});
                                ++n16;
                                n24 = 0;
                            }
                            if (n28 == n15) {
                                if (n25 == 0) {
                                    n23 = n27;
                                }
                                ++n25;
                            } else if (n25 > 0 && n17 < this.maxRuns) {
                                arrayList2.add(new int[]{n23, n20, n25});
                                ++n17;
                                n25 = 0;
                            }
                        }
                        n26 += n4;
                        n27 += this.xPeriod;
                    }
                    if (n25 > 0 && n17 < this.maxRuns) {
                        arrayList2.add(new int[]{n23, n20, n25});
                        ++n17;
                    }
                    if (n24 > 0 && n16 < this.maxRuns) {
                        arrayList.add(new int[]{n22, n20, n24});
                        ++n16;
                    }
                    n19 += n3;
                    n20 += this.yPeriod;
                }
                this.extrema[0][n13] = n14;
                this.extrema[1][n13] = n15;
                this.minCounts[n13] = n16;
                this.maxCounts[n13] = n17;
                ++n13;
            }
        }
    }

    private void accumulateStatisticsInt(UnpackedImageData unpackedImageData) {
        Rectangle rectangle = unpackedImageData.rect;
        int[][] nArray = unpackedImageData.getIntData();
        int n = unpackedImageData.lineStride;
        int n2 = unpackedImageData.pixelStride;
        int n3 = n * this.yPeriod;
        int n4 = n2 * this.xPeriod;
        if (!this.saveLocations) {
            int n5 = 0;
            while (n5 < this.srcPA.numBands) {
                int n6 = (int)this.extrema[0][n5];
                int n7 = (int)this.extrema[1][n5];
                int[] nArray2 = nArray[n5];
                int n8 = unpackedImageData.bandOffsets[n5] + rectangle.height * n;
                int n9 = unpackedImageData.bandOffsets[n5];
                while (n9 < n8) {
                    int n10 = n9 + rectangle.width * n2;
                    int n11 = n9;
                    while (n11 < n10) {
                        int n12 = nArray2[n11];
                        if (n12 < n6) {
                            n6 = n12;
                        } else if (n12 > n7) {
                            n7 = n12;
                        }
                        n11 += n4;
                    }
                    n9 += n3;
                }
                this.extrema[0][n5] = n6;
                this.extrema[1][n5] = n7;
                ++n5;
            }
        } else {
            int n13 = 0;
            while (n13 < this.srcPA.numBands) {
                int n14 = (int)this.extrema[0][n13];
                int n15 = (int)this.extrema[1][n13];
                ArrayList arrayList = this.minLocations[n13];
                ArrayList arrayList2 = this.maxLocations[n13];
                int n16 = this.minCounts[n13];
                int n17 = this.maxCounts[n13];
                int[] nArray3 = nArray[n13];
                int n18 = unpackedImageData.bandOffsets[n13] + rectangle.height * n;
                int n19 = unpackedImageData.bandOffsets[n13];
                int n20 = rectangle.y;
                while (n19 < n18) {
                    int n21 = n19 + rectangle.width * n2;
                    int n22 = 0;
                    int n23 = 0;
                    int n24 = 0;
                    int n25 = 0;
                    int n26 = n19;
                    int n27 = rectangle.x;
                    while (n26 < n21) {
                        int n28 = nArray3[n26];
                        if (n28 < n14) {
                            n14 = n28;
                            n22 = n27;
                            n24 = 1;
                            arrayList.clear();
                            n16 = 0;
                        } else if (n28 > n15) {
                            n15 = n28;
                            n23 = n27;
                            n25 = 1;
                            arrayList2.clear();
                            n17 = 0;
                        } else {
                            if (n28 == n14) {
                                if (n24 == 0) {
                                    n22 = n27;
                                }
                                ++n24;
                            } else if (n24 > 0 && n16 < this.maxRuns) {
                                arrayList.add(new int[]{n22, n20, n24});
                                ++n16;
                                n24 = 0;
                            }
                            if (n28 == n15) {
                                if (n25 == 0) {
                                    n23 = n27;
                                }
                                ++n25;
                            } else if (n25 > 0 && n17 < this.maxRuns) {
                                arrayList2.add(new int[]{n23, n20, n25});
                                ++n17;
                                n25 = 0;
                            }
                        }
                        n26 += n4;
                        n27 += this.xPeriod;
                    }
                    if (n25 > 0 && n17 < this.maxRuns) {
                        arrayList2.add(new int[]{n23, n20, n25});
                        ++n17;
                    }
                    if (n24 > 0 && n16 < this.maxRuns) {
                        arrayList.add(new int[]{n22, n20, n24});
                        ++n16;
                    }
                    n19 += n3;
                    n20 += this.yPeriod;
                }
                this.extrema[0][n13] = n14;
                this.extrema[1][n13] = n15;
                this.minCounts[n13] = n16;
                this.maxCounts[n13] = n17;
                ++n13;
            }
        }
    }

    private void accumulateStatisticsFloat(UnpackedImageData unpackedImageData) {
        Rectangle rectangle = unpackedImageData.rect;
        float[][] fArray = unpackedImageData.getFloatData();
        int n = unpackedImageData.lineStride;
        int n2 = unpackedImageData.pixelStride;
        int n3 = n * this.yPeriod;
        int n4 = n2 * this.xPeriod;
        if (!this.saveLocations) {
            int n5 = 0;
            while (n5 < this.srcPA.numBands) {
                float f2 = (float)this.extrema[0][n5];
                float f3 = (float)this.extrema[1][n5];
                float[] fArray2 = fArray[n5];
                int n6 = unpackedImageData.bandOffsets[n5] + rectangle.height * n;
                int n7 = unpackedImageData.bandOffsets[n5];
                while (n7 < n6) {
                    int n8 = n7 + rectangle.width * n2;
                    int n9 = n7;
                    while (n9 < n8) {
                        float f4 = fArray2[n9];
                        if (f4 < f2) {
                            f2 = f4;
                        } else if (f4 > f3) {
                            f3 = f4;
                        }
                        n9 += n4;
                    }
                    n7 += n3;
                }
                this.extrema[0][n5] = f2;
                this.extrema[1][n5] = f3;
                ++n5;
            }
        } else {
            int n10 = 0;
            while (n10 < this.srcPA.numBands) {
                float f5 = (float)this.extrema[0][n10];
                float f6 = (float)this.extrema[1][n10];
                ArrayList arrayList = this.minLocations[n10];
                ArrayList arrayList2 = this.maxLocations[n10];
                int n11 = this.minCounts[n10];
                int n12 = this.maxCounts[n10];
                float[] fArray3 = fArray[n10];
                int n13 = unpackedImageData.bandOffsets[n10] + rectangle.height * n;
                int n14 = unpackedImageData.bandOffsets[n10];
                int n15 = rectangle.y;
                while (n14 < n13) {
                    int n16 = n14 + rectangle.width * n2;
                    int n17 = 0;
                    int n18 = 0;
                    int n19 = 0;
                    int n20 = 0;
                    int n21 = n14;
                    int n22 = rectangle.x;
                    while (n21 < n16) {
                        float f7 = fArray3[n21];
                        if (f7 < f5) {
                            f5 = f7;
                            n17 = n22;
                            n19 = 1;
                            arrayList.clear();
                            n11 = 0;
                        } else if (f7 > f6) {
                            f6 = f7;
                            n18 = n22;
                            n20 = 1;
                            arrayList2.clear();
                            n12 = 0;
                        } else {
                            if (f7 == f5) {
                                if (n19 == 0) {
                                    n17 = n22;
                                }
                                ++n19;
                            } else if (n19 > 0 && n11 < this.maxRuns) {
                                arrayList.add(new int[]{n17, n15, n19});
                                ++n11;
                                n19 = 0;
                            }
                            if (f7 == f6) {
                                if (n20 == 0) {
                                    n18 = n22;
                                }
                                ++n20;
                            } else if (n20 > 0 && n12 < this.maxRuns) {
                                arrayList2.add(new int[]{n18, n15, n20});
                                ++n12;
                                n20 = 0;
                            }
                        }
                        n21 += n4;
                        n22 += this.xPeriod;
                    }
                    if (n20 > 0 && n12 < this.maxRuns) {
                        arrayList2.add(new int[]{n18, n15, n20});
                        ++n12;
                    }
                    if (n19 > 0 && n11 < this.maxRuns) {
                        arrayList.add(new int[]{n17, n15, n19});
                        ++n11;
                    }
                    n14 += n3;
                    n15 += this.yPeriod;
                }
                this.extrema[0][n10] = f5;
                this.extrema[1][n10] = f6;
                this.minCounts[n10] = n11;
                this.maxCounts[n10] = n12;
                ++n10;
            }
        }
    }

    private void accumulateStatisticsDouble(UnpackedImageData unpackedImageData) {
        Rectangle rectangle = unpackedImageData.rect;
        double[][] dArray = unpackedImageData.getDoubleData();
        int n = unpackedImageData.lineStride;
        int n2 = unpackedImageData.pixelStride;
        int n3 = n * this.yPeriod;
        int n4 = n2 * this.xPeriod;
        if (!this.saveLocations) {
            int n5 = 0;
            while (n5 < this.srcPA.numBands) {
                double d2 = this.extrema[0][n5];
                double d3 = this.extrema[1][n5];
                double[] dArray2 = dArray[n5];
                int n6 = unpackedImageData.bandOffsets[n5] + rectangle.height * n;
                int n7 = unpackedImageData.bandOffsets[n5];
                while (n7 < n6) {
                    int n8 = n7 + rectangle.width * n2;
                    int n9 = n7;
                    while (n9 < n8) {
                        double d4 = dArray2[n9];
                        if (d4 < d2) {
                            d2 = d4;
                        } else if (d4 > d3) {
                            d3 = d4;
                        }
                        n9 += n4;
                    }
                    n7 += n3;
                }
                this.extrema[0][n5] = d2;
                this.extrema[1][n5] = d3;
                ++n5;
            }
        } else {
            int n10 = 0;
            while (n10 < this.srcPA.numBands) {
                double d5 = this.extrema[0][n10];
                double d6 = this.extrema[1][n10];
                ArrayList arrayList = this.minLocations[n10];
                ArrayList arrayList2 = this.maxLocations[n10];
                int n11 = this.minCounts[n10];
                int n12 = this.maxCounts[n10];
                double[] dArray3 = dArray[n10];
                int n13 = unpackedImageData.bandOffsets[n10] + rectangle.height * n;
                int n14 = unpackedImageData.bandOffsets[n10];
                int n15 = rectangle.y;
                while (n14 < n13) {
                    int n16 = n14 + rectangle.width * n2;
                    int n17 = 0;
                    int n18 = 0;
                    int n19 = 0;
                    int n20 = 0;
                    int n21 = n14;
                    int n22 = rectangle.x;
                    while (n21 < n16) {
                        double d7 = dArray3[n21];
                        if (d7 < d5) {
                            d5 = d7;
                            n17 = n22;
                            n19 = 1;
                            arrayList.clear();
                            n11 = 0;
                        } else if (d7 > d6) {
                            d6 = d7;
                            n18 = n22;
                            n20 = 1;
                            arrayList2.clear();
                            n12 = 0;
                        } else {
                            if (d7 == d5) {
                                if (n19 == 0) {
                                    n17 = n22;
                                }
                                ++n19;
                            } else if (n19 > 0 && n11 < this.maxRuns) {
                                arrayList.add(new int[]{n17, n15, n19});
                                ++n11;
                                n19 = 0;
                            }
                            if (d7 == d6) {
                                if (n20 == 0) {
                                    n18 = n22;
                                }
                                ++n20;
                            } else if (n20 > 0 && n12 < this.maxRuns) {
                                arrayList2.add(new int[]{n18, n15, n20});
                                ++n12;
                                n20 = 0;
                            }
                        }
                        n21 += n4;
                        n22 += this.xPeriod;
                    }
                    if (n20 > 0 && n12 < this.maxRuns) {
                        arrayList2.add(new int[]{n18, n15, n20});
                        ++n12;
                    }
                    if (n19 > 0 && n11 < this.maxRuns) {
                        arrayList.add(new int[]{n17, n15, n19});
                        ++n11;
                    }
                    n14 += n3;
                    n15 += this.yPeriod;
                }
                this.extrema[0][n10] = d5;
                this.extrema[1][n10] = d6;
                this.minCounts[n10] = n11;
                this.maxCounts[n10] = n12;
                ++n10;
            }
        }
    }

    protected void initializeState(Raster raster) {
        if (this.extrema == null) {
            int n = this.sampleModel.getNumBands();
            this.extrema = new double[2][n];
            Rectangle rectangle = raster.getBounds();
            if (this.roi != null) {
                LinkedList linkedList = this.roi.getAsRectangleList(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                if (linkedList == null) {
                    return;
                }
                ListIterator listIterator = linkedList.listIterator(0);
                if (listIterator.hasNext()) {
                    rectangle = rectangle.intersection((Rectangle)listIterator.next());
                }
            }
            rectangle.x = this.startPosition(rectangle.x, this.xStart, this.xPeriod);
            rectangle.y = this.startPosition(rectangle.y, this.yStart, this.yPeriod);
            raster.getPixel(rectangle.x, rectangle.y, this.extrema[0]);
            int n2 = 0;
            while (n2 < n) {
                this.extrema[1][n2] = this.extrema[0][n2];
                ++n2;
            }
            if (this.saveLocations) {
                this.minLocations = new ArrayList[n];
                this.maxLocations = new ArrayList[n];
                this.minCounts = new int[n];
                this.maxCounts = new int[n];
                int n3 = 0;
                while (n3 < n) {
                    this.minLocations[n3] = new ArrayList();
                    this.maxLocations[n3] = new ArrayList();
                    this.maxCounts[n3] = 0;
                    this.minCounts[n3] = 0;
                    ++n3;
                }
            }
        }
    }
}

