/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageDecoder;
import com.sun.media.jai.codec.MemoryCacheSeekableStream;
import com.sun.media.jai.opimage.FilterCRIF;
import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.util.ImageUtil;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.awt.image.renderable.RenderableImageOp;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Vector;
import javax.media.jai.CRIFImpl;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.MultiResolutionRenderableImage;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RenderableOp;
import javax.media.jai.RenderedOp;
import javax.media.jai.TiledImage;
import javax.media.jai.operator.TransposeDescriptor;
import javax.media.jai.util.ImagingException;
import javax.media.jai.util.ImagingListener;

public class IIPCRIF
extends CRIFImpl {
    private static final int MASK_FILTER = 1;
    private static final int MASK_COLOR_TWIST = 2;
    private static final int MASK_CONTRAST = 4;
    private static final int MASK_ROI_SOURCE = 8;
    private static final int MASK_TRANSFORM = 16;
    private static final int MASK_ASPECT_RATIO = 32;
    private static final int MASK_ROI_DESTINATION = 64;
    private static final int MASK_ROTATION = 128;
    private static final int MASK_MIRROR_AXIS = 256;
    private static final int MASK_ICC_PROFILE = 512;
    private static final int MASK_JPEG_QUALITY = 1024;
    private static final int MASK_JPEG_TABLE = 2048;
    private static final int VENDOR_HP = 0;
    private static final int VENDOR_LIVE_PICTURE = 1;
    private static final int VENDOR_KODAK = 2;
    private static final int VENDOR_UNREGISTERED = 255;
    private static final int VENDOR_EXPERIMENTAL = 999;
    private static final int SERVER_CVT_JPEG = 1;
    private static final int SERVER_CVT_FPX = 2;
    private static final int SERVER_CVT_MJPEG = 4;
    private static final int SERVER_CVT_MFPX = 8;
    private static final int SERVER_CVT_M2JPEG = 16;
    private static final int SERVER_CVT_M2FPX = 32;
    private static final int SERVER_CVT_JTL = 64;
    private static final int SERVER_JPEG_PARTIAL = 5;
    private static final int SERVER_JPEG_FULL = 21;
    private static final int SERVER_FPX_PARTIAL = 10;
    private static final int SERVER_FPX_FULL = 42;
    private static final double[][] YCCA_TO_RGBA = new double[][]{{1.3584, 0.0, 1.8215, 0.0}, {1.3584, -0.4303, -0.9271, 0.0}, {1.3584, 2.2179, 0.0, 0.0}, {0.0, 0.0, 0.0, 1.0}};
    private static final double[][] YCCA_TO_RGBA_CONST = new double[][]{{-249.55}, {194.14}, {-345.99}, {0.0}};
    private static final double[][] RGBA_TO_YCCA = new double[][]{{0.220018, 0.432276, 0.083867, 0.0}, {-0.134755, -0.264756, 0.399511, 0.0}, {0.384918, -0.322373, -0.062544, 0.0}, {0.0, 0.0, 0.0, 1.0}};
    private static final double[][] RGBA_TO_YCCA_CONST = new double[][]{{5.726E-4}, {155.9984}, {137.0022}, {0.0}};
    private static final double[][] YCC_TO_RGB = new double[][]{{1.3584, 0.0, 1.8215}, {1.3584, -0.4303, -0.9271}, {1.3584, 2.2179, 0.0}};
    private static final double[][] YCC_TO_RGB_CONST = new double[][]{{-249.55}, {194.14}, {-345.99}};
    private static final double[][] RGB_TO_YCC = new double[][]{{0.220018, 0.432276, 0.083867}, {-0.134755, -0.264756, 0.399511}, {0.384918, -0.322373, -0.062544}};
    private static final double[][] RGB_TO_YCC_CONST = new double[][]{{5.726E-4}, {155.9984}, {137.0022}};

    private static final int getOperationMask(ParameterBlock parameterBlock) {
        AffineTransform affineTransform;
        int n = 0;
        if (parameterBlock.getFloatParameter(2) != 0.0f) {
            n |= 1;
        }
        if (parameterBlock.getObjectParameter(3) != null) {
            n |= 2;
        }
        if (Math.abs(parameterBlock.getFloatParameter(4) - 1.0f) > 0.01f) {
            n |= 4;
        }
        if (parameterBlock.getObjectParameter(5) != null) {
            n |= 8;
        }
        if (!(affineTransform = (AffineTransform)parameterBlock.getObjectParameter(6)).isIdentity()) {
            n |= 0x10;
        }
        if (parameterBlock.getObjectParameter(7) != null) {
            n |= 0x20;
        }
        if (parameterBlock.getObjectParameter(8) != null) {
            n |= 0x40;
        }
        if (parameterBlock.getIntParameter(9) != 0) {
            n |= 0x80;
        }
        if (parameterBlock.getObjectParameter(10) != null) {
            n |= 0x100;
        }
        if (parameterBlock.getObjectParameter(11) != null) {
            n |= 0x200;
        }
        if (parameterBlock.getObjectParameter(12) != null) {
            n |= 0x400;
        }
        if (parameterBlock.getObjectParameter(13) != null) {
            n |= 0x800;
        }
        return n;
    }

    private static final int getServerCapabilityMask(String string, RenderedImage renderedImage) {
        Object object;
        int n = 255;
        int n2 = 0;
        if (renderedImage.getProperty("iip-server") != null && renderedImage.getProperty("iip-server") != Image.UndefinedProperty) {
            object = (String)renderedImage.getProperty("iip-server");
            int n3 = ((String)object).indexOf(".");
            n = Integer.valueOf(((String)object).substring(0, n3));
            n2 = Integer.valueOf(((String)object).substring(n3 + 1));
        }
        if (n2 != 127 && n != 0 && n != 1 && n != 2) {
            object = (int[])renderedImage.getProperty("max-size");
            String string2 = "&RGN=0.0,0.0," + 64.0f / (float)object[0] + "," + 64.0f / (float)object[1];
            if (IIPCRIF.canDecode(string, "&CNT=0.9&WID=64&CVT=JPEG", "JPEG")) {
                n2 = 21;
            } else if (IIPCRIF.canDecode(string, "&CNT=0.9&WID=64&CVT=FPX", "FPX")) {
                n2 = 42;
            } else if (IIPCRIF.canDecode(string, string2 + "&CVT=JPEG", "JPEG")) {
                n2 = 5;
            } else if (IIPCRIF.canDecode(string, string2 + "&CVT=FPX", "FPX")) {
                n2 = 10;
            }
        }
        return n2;
    }

    private static boolean canDecode(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(string);
        URL uRL = null;
        InputStream inputStream = null;
        RenderedImage renderedImage = null;
        boolean bl = false;
        try {
            stringBuffer.append(string2);
            uRL = new URL(stringBuffer.toString());
            inputStream = uRL.openStream();
            ImageDecoder imageDecoder = ImageCodec.createImageDecoder(string3, inputStream, null);
            renderedImage = imageDecoder.decodeAsRenderedImage();
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    private static final double[][] matrixMultiply(double[][] dArray, double[][] dArray2) {
        if (dArray[0].length != dArray2.length) {
            throw new RuntimeException(JaiI18N.getString("IIPCRIF0"));
        }
        int n = dArray.length;
        int n2 = dArray2[0].length;
        double[][] dArray3 = new double[n][n2];
        int n3 = dArray[0].length;
        int n4 = 0;
        while (n4 < n) {
            int n5 = 0;
            while (n5 < n2) {
                dArray3[n4][n5] = 0.0;
                int n6 = 0;
                while (n6 < n3) {
                    double[] dArray4 = dArray3[n4];
                    int n7 = n5;
                    dArray4[n7] = dArray4[n7] + dArray[n4][n6] * dArray2[n6][n5];
                    ++n6;
                }
                ++n5;
            }
            ++n4;
        }
        return dArray3;
    }

    private static final double[][] composeMatrices(double[][] dArray, double[][] dArray2) {
        int n = dArray.length;
        if (n != dArray2.length) {
            throw new RuntimeException(JaiI18N.getString("IIPCRIF1"));
        }
        if (dArray2[0].length != 1) {
            throw new RuntimeException(JaiI18N.getString("IIPCRIF2"));
        }
        int n2 = dArray[0].length;
        double[][] dArray3 = new double[n][n2 + 1];
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                dArray3[n3][n4] = dArray[n3][n4];
                ++n4;
            }
            dArray3[n3][n2] = dArray2[n3][0];
            ++n3;
        }
        return dArray3;
    }

    private static final double[][] getColorTwistMatrix(ColorModel colorModel, ParameterBlock parameterBlock) {
        float[] fArray = (float[])parameterBlock.getObjectParameter(3);
        double[][] dArray = new double[4][4];
        int n = 0;
        int n2 = 0;
        while (n2 < 4) {
            int n3 = 0;
            while (n3 < 4) {
                dArray[n2][n3] = fArray[n++];
                ++n3;
            }
            ++n2;
        }
        double[][] dArray2 = null;
        Object object = null;
        int n4 = colorModel.getColorSpace().getType();
        if (n4 == 6 || n4 == 5) {
            dArray2 = IIPCRIF.matrixMultiply(IIPCRIF.matrixMultiply(YCCA_TO_RGBA, dArray), RGBA_TO_YCCA);
            object = YCCA_TO_RGBA_CONST;
        } else {
            dArray2 = dArray;
            object = new double[][]{{0.0}, {0.0}, {0.0}, {0.0}};
        }
        double[][] dArrayArray = null;
        double[][] dArrayArray2 = null;
        if (n4 == 6) {
            if (colorModel.hasAlpha()) {
                dArrayArray = new double[][]{{1.0, 0.0}, {1.0, 0.0}, {1.0, 0.0}, {0.0, 1.0}};
                dArrayArray2 = new double[][]{{0.0}, {0.0}, {0.0}, {0.0}};
            } else {
                dArrayArray = new double[][]{{1.0}, {1.0}, {1.0}, {0.0}};
                dArrayArray2 = new double[][]{{0.0}, {0.0}, {0.0}, {255.0}};
            }
        } else if (!colorModel.hasAlpha()) {
            dArrayArray = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}, {0.0, 0.0, 0.0}};
            dArrayArray2 = new double[][]{{0.0}, {0.0}, {0.0}, {255.0}};
        } else {
            dArrayArray = new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}};
            dArrayArray2 = new double[][]{{0.0}, {0.0}, {0.0}, {0.0}};
        }
        boolean bl = false;
        if (n4 == 6 && fArray[4] == 0.0f && fArray[7] == 0.0f && fArray[8] == 0.0f && fArray[11] == 0.0f) {
            bl = true;
        }
        boolean bl2 = false;
        if (!colorModel.hasAlpha() && fArray[15] == 1.0f) {
            bl2 = true;
        }
        double[][] dArrayArray3 = null;
        dArrayArray3 = bl2 && bl ? new double[][]{{1.0, 0.0, 0.0, 0.0}} : (bl ? new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 1.0}} : (bl2 ? new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}} : new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}}));
        double[][] dArray3 = IIPCRIF.matrixMultiply(dArrayArray3, dArray2);
        double[][] dArray4 = IIPCRIF.matrixMultiply(dArray3, dArrayArray);
        double[][] dArray5 = IIPCRIF.matrixMultiply(dArray3, dArrayArray2);
        double[][] dArray6 = IIPCRIF.matrixMultiply(dArray3, object);
        double[][] dArray7 = IIPCRIF.matrixMultiply(dArrayArray3, object);
        int n5 = 0;
        while (n5 < dArray5.length) {
            int n6 = 0;
            while (n6 < dArray5[n5].length) {
                double[] dArray8 = dArray5[n5];
                int n7 = n6;
                dArray8[n7] = dArray8[n7] + (dArray7[n5][n6] - dArray6[n5][n6]);
                ++n6;
            }
            ++n5;
        }
        return IIPCRIF.composeMatrices(dArray4, dArray5);
    }

    private static final LookupTableJAI createContrastLUT(float f2, int n) {
        byte[] byArray = new byte[256];
        double d2 = 0.43f;
        int n2 = 0;
        while (n2 < 256) {
            float f3 = ((float)n2 - 127.5f) / 255.0f;
            float f4 = 0.0f;
            if (f3 < 0.0f) {
                f4 = (float)(-d2 * Math.pow((double)(-f3) / d2, f2));
            } else if (f3 > 0.0f) {
                f4 = (float)(d2 * Math.pow((double)f3 / d2, f2));
            }
            int n3 = (int)(f4 * 255.0f + 127.5f);
            byArray[n2] = n3 < 0 ? 0 : (n3 > 255 ? -1 : (byte)(n3 & 0xFF));
            ++n2;
        }
        byte[][] byArrayArray = new byte[n][];
        if (n % 2 == 1) {
            int n4 = 0;
            while (n4 < n) {
                byArrayArray[n4] = byArray;
                ++n4;
            }
        } else {
            int n5 = 0;
            while (n5 < n - 1) {
                byArrayArray[n5] = byArray;
                ++n5;
            }
            byArrayArray[n - 1] = new byte[256];
            byte[] byArray2 = byArrayArray[n - 1];
            int n6 = 0;
            while (n6 < 256) {
                byArray2[n6] = (byte)n6;
                ++n6;
            }
        }
        return new LookupTableJAI(byArrayArray);
    }

    public IIPCRIF() {
        super("IIP");
    }

    private RenderedImage serverProc(int n, RenderContext renderContext, ParameterBlock parameterBlock, int n2, RenderedImage renderedImage) {
        Object object;
        Serializable serializable;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        if ((n & 0x15) != 21 && (n & 0x2A) != 42 && (n & 5) != 5 && (n & 0xA) != 10) {
            return null;
        }
        ImagingListener imagingListener = ImageUtil.getImagingListener(renderContext);
        boolean bl = false;
        boolean bl2 = false;
        if ((n & 0x15) == 21) {
            bl2 = true;
            bl = true;
        } else if ((n & 0x2A) == 42) {
            bl = false;
            bl2 = true;
        } else if ((n & 5) == 5) {
            bl = true;
            bl2 = false;
        }
        StringBuffer stringBuffer = new StringBuffer((String)parameterBlock.getObjectParameter(0));
        if ((n2 & 1) != 0) {
            stringBuffer.append("&FTR=" + parameterBlock.getFloatParameter(2));
        }
        if ((n2 & 2) != 0) {
            stringBuffer.append("&CTW=");
            object5 = (float[])parameterBlock.getObjectParameter(3);
            int n3 = 0;
            while (n3 < ((float[])object5).length) {
                stringBuffer.append(object5[n3]);
                if (n3 != ((Object)object5).length - 1) {
                    stringBuffer.append(",");
                }
                ++n3;
            }
        }
        if ((n2 & 4) != 0) {
            stringBuffer.append("&CNT=" + parameterBlock.getFloatParameter(4));
        }
        if ((n2 & 8) != 0) {
            object5 = (Rectangle2D)parameterBlock.getObjectParameter(5);
            stringBuffer.append("&ROI=" + ((RectangularShape)object5).getX() + "," + ((RectangularShape)object5).getY() + "," + ((RectangularShape)object5).getWidth() + "," + ((RectangularShape)object5).getHeight());
        }
        object5 = new AffineTransform();
        AffineTransform affineTransform = (AffineTransform)renderContext.getTransform().clone();
        if (affineTransform.getTranslateX() != 0.0 || affineTransform.getTranslateY() != 0.0) {
            ((AffineTransform)object5).setToTranslation(affineTransform.getTranslateX(), affineTransform.getTranslateY());
            object4 = new double[6];
            affineTransform.getMatrix((double[])object4);
            affineTransform.setTransform(object4[0], object4[1], object4[2], object4[3], 0.0, 0.0);
        }
        object4 = null;
        if ((n2 & 0x40) != 0) {
            object4 = (Rectangle2D)parameterBlock.getObjectParameter(8);
        } else {
            float f2 = 1.0f;
            f2 = (n2 & 0x20) != 0 ? parameterBlock.getFloatParameter(7) : ((Float)renderedImage.getProperty("aspect-ratio")).floatValue();
            object4 = new Rectangle2D.Float(0.0f, 0.0f, f2, 1.0f);
        }
        Rectangle rectangle = affineTransform.createTransformedShape((Shape)object4).getBounds();
        AffineTransform affineTransform2 = AffineTransform.getScaleInstance(rectangle.getWidth() / ((RectangularShape)object4).getWidth(), rectangle.getHeight() / ((RectangularShape)object4).getHeight());
        try {
            affineTransform.preConcatenate(affineTransform2.createInverse());
        }
        catch (Exception exception) {
            object3 = JaiI18N.getString("IIPCRIF6");
            imagingListener.errorOccurred((String)object3, new ImagingException((String)object3, exception), this, false);
        }
        AffineTransform affineTransform3 = (AffineTransform)parameterBlock.getObjectParameter(6);
        try {
            affineTransform3.preConcatenate(affineTransform.createInverse());
        }
        catch (Exception exception) {
            object2 = JaiI18N.getString("IIPCRIF6");
            imagingListener.errorOccurred((String)object2, new ImagingException((String)object2, exception), this, false);
        }
        if (bl2) {
            stringBuffer.append("&WID=" + rectangle.width + "&HEI=" + rectangle.height);
        }
        object3 = new double[6];
        affineTransform3.getMatrix((double[])object3);
        stringBuffer.append("&AFN=" + (double)object3[0] + "," + (double)object3[2] + ",0," + (double)object3[4] + "," + (double)object3[1] + "," + (double)object3[3] + ",0," + (double)object3[5] + ",0,0,1,0,0,0,0,1");
        if ((n2 & 0x20) != 0) {
            stringBuffer.append("&RAR=" + parameterBlock.getFloatParameter(7));
        }
        if ((n2 & 0x40) != 0) {
            object2 = (Rectangle2D)parameterBlock.getObjectParameter(8);
            stringBuffer.append("&RGN=" + ((RectangularShape)object2).getX() + "," + ((RectangularShape)object2).getY() + "," + ((RectangularShape)object2).getWidth() + "," + ((RectangularShape)object2).getHeight());
        }
        if (bl2 && ((n2 & 0x80) != 0 || (n2 & 0x100) != 0)) {
            stringBuffer.append("&RFM=" + parameterBlock.getIntParameter(9));
            if ((n2 & 0x100) != 0) {
                object2 = (String)parameterBlock.getObjectParameter(10);
                if (((String)object2).equalsIgnoreCase("x")) {
                    stringBuffer.append(",0");
                } else {
                    stringBuffer.append(",90");
                }
            }
        }
        if ((n2 & 0x200) != 0) {
            // empty if block
        }
        if (bl) {
            if ((n2 & 0x400) != 0) {
                stringBuffer.append("&QLT=" + parameterBlock.getIntParameter(12));
            }
            if ((n2 & 0x800) != 0) {
                stringBuffer.append("&CIN=" + parameterBlock.getIntParameter(13));
            }
        }
        object2 = bl ? "JPEG" : "FPX";
        stringBuffer.append("&CVT=" + (String)object2);
        InputStream inputStream = null;
        RenderedOp renderedOp = null;
        try {
            serializable = new URL(stringBuffer.toString());
            inputStream = serializable.openStream();
            object = new MemoryCacheSeekableStream(inputStream);
            renderedOp = JAI.create((String)object2, object);
        }
        catch (Exception exception) {
            object = JaiI18N.getString("IIPCRIF7") + " " + stringBuffer.toString();
            imagingListener.errorOccurred((String)object, new ImagingException((String)object, exception), this, false);
        }
        if (!bl2) {
            ((AffineTransform)object5).scale(rectangle.getWidth() / (double)renderedOp.getWidth(), rectangle.getHeight() / (double)renderedOp.getHeight());
        }
        if (!((AffineTransform)object5).isIdentity()) {
            serializable = Interpolation.getInstance(0);
            object = renderContext.getRenderingHints();
            if (object != null && ((RenderingHints)object).containsKey(JAI.KEY_INTERPOLATION)) {
                serializable = (Interpolation)((RenderingHints)object).get(JAI.KEY_INTERPOLATION);
            }
            renderedOp = JAI.create("affine", (RenderedImage)renderedOp, object5, (Object)serializable);
        }
        return renderedOp;
    }

    private RenderedImage clientProc(RenderContext renderContext, ParameterBlock parameterBlock, int n, RenderedImage renderedImage) {
        Object object;
        int n2;
        int n3;
        int n4;
        Cloneable cloneable;
        AffineTransform affineTransform = renderContext.getTransform();
        RenderingHints renderingHints = renderContext.getRenderingHints();
        ImagingListener imagingListener = ImageUtil.getImagingListener(renderContext);
        int[] nArray = (int[])renderedImage.getProperty("max-size");
        int n5 = nArray[0];
        int n6 = nArray[1];
        int n7 = (Integer)renderedImage.getProperty("resolution-number");
        float f2 = (float)n5 / (float)n6;
        float f3 = (n & 0x20) != 0 ? parameterBlock.getFloatParameter(7) : f2;
        Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, 0.0f, f3, 1.0f);
        if (affineTransform.isIdentity()) {
            cloneable = (AffineTransform)parameterBlock.getObjectParameter(6);
            Rectangle2D rectangle2D = ((AffineTransform)cloneable).createTransformedShape(float_).getBounds2D();
            double d2 = (double)n6 * rectangle2D.getHeight();
            double d3 = (double)n6 * rectangle2D.getWidth();
            double d4 = Math.max(d2, d3 / (double)f2);
            n4 = (int)(d4 + 0.5);
            n3 = (int)((double)f2 * d4 + 0.5);
            affineTransform = AffineTransform.getScaleInstance(n3, n4);
            renderContext = (RenderContext)renderContext.clone();
            renderContext.setTransform(affineTransform);
        } else {
            cloneable = affineTransform.createTransformedShape(float_).getBounds();
            n3 = ((Rectangle)cloneable).width;
            n4 = ((Rectangle)cloneable).height;
        }
        int n8 = n7 - 1;
        int n9 = n6;
        while (n8 > 0) {
            if ((n9 = (int)(((float)n9 + 1.0f) / 2.0f)) < n4) break;
            --n8;
        }
        int[] nArray2 = (int[])parameterBlock.getObjectParameter(1);
        int n10 = n2 = nArray2.length < n8 + 1 ? 0 : nArray2[n8];
        if (n2 < 0) {
            n2 = 0;
        }
        ParameterBlock parameterBlock2 = new ParameterBlock();
        parameterBlock2.add(parameterBlock.getObjectParameter(0)).add(n8).add(n2);
        RenderedOp renderedOp = JAI.create("iipresolution", parameterBlock2);
        Vector<RenderedOp> vector = new Vector<RenderedOp>(1);
        vector.add(renderedOp);
        RenderableImage renderableImage = new MultiResolutionRenderableImage(vector, 0.0f, 0.0f, 1.0f);
        if ((n & 1) != 0) {
            float f4 = parameterBlock.getFloatParameter(2);
            parameterBlock2 = new ParameterBlock().addSource(renderableImage).add(f4);
            renderableImage = new RenderableImageOp(new FilterCRIF(), parameterBlock2);
        }
        int n11 = renderedOp.getSampleModel().getNumBands();
        if ((n & 2) != 0) {
            object = IIPCRIF.getColorTwistMatrix(renderedOp.getColorModel(), parameterBlock);
            parameterBlock2 = new ParameterBlock().addSource(renderableImage).add(object);
            renderableImage = JAI.createRenderable("bandcombine", parameterBlock2);
            n11 = ((double[][])object).length;
        }
        if ((n & 4) != 0) {
            boolean bl;
            int n12 = renderedOp.getColorModel().getColorSpace().getType();
            boolean bl2 = bl = n12 != 6 && n12 != 5;
            if (bl) {
                double[][] dArray = n11 == 3 ? IIPCRIF.composeMatrices(YCC_TO_RGB, YCC_TO_RGB_CONST) : IIPCRIF.composeMatrices(YCCA_TO_RGBA, YCCA_TO_RGBA_CONST);
                parameterBlock2 = new ParameterBlock().addSource(renderableImage).add(dArray);
                renderableImage = JAI.createRenderable("bandcombine", parameterBlock2);
            }
            float f5 = parameterBlock.getFloatParameter(4);
            LookupTableJAI lookupTableJAI = IIPCRIF.createContrastLUT(f5, n11);
            parameterBlock2 = new ParameterBlock().addSource(renderableImage).add(lookupTableJAI);
            renderableImage = JAI.createRenderable("lookup", parameterBlock2);
            if (bl) {
                double[][] dArray = n11 == 3 ? IIPCRIF.composeMatrices(RGB_TO_YCC, RGB_TO_YCC_CONST) : IIPCRIF.composeMatrices(RGBA_TO_YCCA, RGBA_TO_YCCA_CONST);
                parameterBlock2 = new ParameterBlock().addSource(renderableImage).add(dArray);
                renderableImage = JAI.createRenderable("bandcombine", parameterBlock2);
            }
        }
        if ((n & 8) != 0) {
            object = (Rectangle2D)parameterBlock.getObjectParameter(5);
            if (!((Rectangle2D)object).intersects(0.0, 0.0, f2, 1.0)) {
                throw new RuntimeException(JaiI18N.getString("IIPCRIF5"));
            }
            Rectangle2D.Float float_2 = new Rectangle2D.Float(0.0f, 0.0f, f2, 1.0f);
            if (!((Rectangle2D)object).equals(float_2)) {
                object = ((Rectangle2D)object).createIntersection(float_2);
                parameterBlock2 = new ParameterBlock().addSource(renderableImage);
                parameterBlock2.add((float)((RectangularShape)object).getMinX()).add((float)((RectangularShape)object).getMinY());
                parameterBlock2.add((float)((RectangularShape)object).getWidth()).add((float)((RectangularShape)object).getHeight());
                renderableImage = JAI.createRenderable("crop", parameterBlock2);
            }
        }
        if ((n & 0x10) != 0) {
            object = (AffineTransform)parameterBlock.getObjectParameter(6);
            try {
                object = ((AffineTransform)object).createInverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                imagingListener.errorOccurred(JaiI18N.getString("AffineNotInvertible"), noninvertibleTransformException, this, false);
            }
            parameterBlock2 = new ParameterBlock().addSource(renderableImage).add(object);
            if (renderingHints != null && renderingHints.containsKey(JAI.KEY_INTERPOLATION)) {
                parameterBlock2.add(renderingHints.get(JAI.KEY_INTERPOLATION));
            }
            renderableImage = JAI.createRenderable("affine", parameterBlock2);
        }
        if (((RectangularShape)(object = (Object)((n & 0x40) != 0 ? (Rectangle2D)parameterBlock.getObjectParameter(8) : float_))).isEmpty()) {
            throw new RuntimeException(JaiI18N.getString("IIPCRIF3"));
        }
        Rectangle2D.Float float_3 = new Rectangle2D.Float(renderableImage.getMinX(), renderableImage.getMinY(), renderableImage.getWidth(), renderableImage.getHeight());
        if (!((Rectangle2D)object).equals(float_3)) {
            object = ((Rectangle2D)object).createIntersection(float_3);
            parameterBlock2 = new ParameterBlock().addSource(renderableImage);
            parameterBlock2.add((float)((RectangularShape)object).getMinX()).add((float)((RectangularShape)object).getMinY());
            parameterBlock2.add((float)((RectangularShape)object).getWidth()).add((float)((RectangularShape)object).getHeight());
            renderableImage = JAI.createRenderable("crop", parameterBlock2);
        }
        return renderableImage.createRendering(renderContext);
    }

    public RenderedImage create(ParameterBlock parameterBlock, RenderingHints renderingHints) {
        RenderableOp renderableOp = JAI.createRenderable("iip", parameterBlock);
        return renderableOp.createDefaultRendering();
    }

    public RenderedImage create(RenderContext renderContext, ParameterBlock parameterBlock) {
        Serializable serializable;
        Object object;
        int n = IIPCRIF.getOperationMask(parameterBlock);
        ImagingListener imagingListener = ImageUtil.getImagingListener(renderContext);
        ParameterBlock parameterBlock2 = new ParameterBlock();
        int[] nArray = (int[])parameterBlock.getObjectParameter(1);
        parameterBlock2.add(parameterBlock.getObjectParameter(0)).add(0).add(nArray[0]);
        RenderedOp renderedOp = JAI.create("iipresolution", parameterBlock2);
        int n2 = IIPCRIF.getServerCapabilityMask((String)parameterBlock.getObjectParameter(0), renderedOp);
        Object object2 = null;
        if ((n2 & 0x15) == 21 || (n2 & 0x2A) == 42 || (n2 & 5) == 5 || (n2 & 0xA) == 10) {
            object2 = this.serverProc(n2, renderContext, parameterBlock, n, renderedOp);
        } else {
            object2 = this.clientProc(renderContext, parameterBlock, n, renderedOp);
            if ((n & 8) != 0) {
                Object object3;
                object = (Rectangle2D)parameterBlock.getObjectParameter(5);
                serializable = (AffineTransform)((AffineTransform)parameterBlock.getObjectParameter(6)).clone();
                if (!((AffineTransform)serializable).isIdentity()) {
                    try {
                        serializable = ((AffineTransform)serializable).createInverse();
                    }
                    catch (Exception exception) {
                        object3 = JaiI18N.getString("IIPCRIF6");
                        imagingListener.errorOccurred((String)object3, new ImagingException((String)object3, exception), this, false);
                    }
                }
                ((AffineTransform)serializable).preConcatenate(renderContext.getTransform());
                ROIShape rOIShape = new ROIShape(((AffineTransform)serializable).createTransformedShape((Shape)object));
                object3 = new TiledImage(object2.getMinX(), object2.getMinY(), object2.getWidth(), object2.getHeight(), object2.getTileGridXOffset(), object2.getTileGridYOffset(), object2.getSampleModel(), object2.getColorModel());
                ((TiledImage)object3).set((RenderedImage)object2, rOIShape);
                parameterBlock2 = new ParameterBlock();
                parameterBlock2.add((float)((PlanarImage)object3).getWidth());
                parameterBlock2.add((float)((PlanarImage)object3).getHeight());
                Byte[] byteArray = new Byte[((PlanarImage)object3).getSampleModel().getNumBands()];
                int n3 = 0;
                while (n3 < byteArray.length) {
                    byteArray[n3] = new Byte(-1);
                    ++n3;
                }
                parameterBlock2.add(byteArray);
                ImageLayout imageLayout = new ImageLayout();
                imageLayout.setSampleModel(((PlanarImage)object3).getSampleModel());
                RenderingHints renderingHints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, imageLayout);
                RenderedOp renderedOp2 = JAI.create("constant", parameterBlock2, renderingHints);
                ROI rOI = new ROIShape(((PlanarImage)object3).getBounds()).subtract(rOIShape);
                int n4 = ((PlanarImage)object3).getMaxTileY();
                int n5 = ((PlanarImage)object3).getMaxTileX();
                int n6 = ((PlanarImage)object3).getMinTileY();
                while (n6 <= n4) {
                    int n7 = ((PlanarImage)object3).getMinTileX();
                    while (n7 <= n5) {
                        if (!rOIShape.intersects(((PlanarImage)object3).getTileRect(n7, n6))) {
                            ((TiledImage)object3).setData(((PlanarImage)renderedOp2).getTile(n7, n6), rOI);
                        }
                        ++n7;
                    }
                    ++n6;
                }
                object2 = object3;
            }
        }
        if ((n2 & 0x15) != 21 && (n2 & 0x2A) != 42) {
            if ((n & 0x80) != 0) {
                object = null;
                switch (parameterBlock.getIntParameter(9)) {
                    case 90: {
                        object = TransposeDescriptor.ROTATE_270;
                        break;
                    }
                    case 180: {
                        object = TransposeDescriptor.ROTATE_180;
                        break;
                    }
                    case 270: {
                        object = TransposeDescriptor.ROTATE_90;
                    }
                }
                if (object != null) {
                    object2 = JAI.create("transpose", (RenderedImage)object2, object);
                }
            }
            if ((n & 0x100) != 0) {
                object = (String)parameterBlock.getObjectParameter(10);
                serializable = ((String)object).equalsIgnoreCase("x") ? TransposeDescriptor.FLIP_VERTICAL : TransposeDescriptor.FLIP_HORIZONTAL;
                object2 = JAI.create("transpose", (RenderedImage)object2, (Object)serializable);
            }
        }
        return object2;
    }

    public Rectangle2D getBounds2D(ParameterBlock parameterBlock) {
        float f2;
        int n = IIPCRIF.getOperationMask(parameterBlock);
        if ((n & 0x40) != 0) {
            return (Rectangle2D)parameterBlock.getObjectParameter(8);
        }
        if ((n & 0x20) != 0) {
            f2 = parameterBlock.getFloatParameter(7);
        } else {
            ParameterBlock parameterBlock2 = new ParameterBlock();
            int[] nArray = (int[])parameterBlock.getObjectParameter(1);
            parameterBlock2.add(parameterBlock.getObjectParameter(0));
            parameterBlock2.add(0).add(nArray[0]);
            RenderedOp renderedOp = JAI.create("iipresolution", parameterBlock2);
            int[] nArray2 = (int[])renderedOp.getProperty("max-size");
            f2 = (float)nArray2[0] / (float)nArray2[1];
        }
        return new Rectangle2D.Float(0.0f, 0.0f, f2, 1.0f);
    }

    public static void main(String[] stringArray) {
        int n;
        int n2 = 0;
        int n3 = 0;
        double[][] dArray = IIPCRIF.matrixMultiply(RGBA_TO_YCCA, YCCA_TO_RGBA);
        n2 = dArray.length;
        n3 = dArray[0].length;
        int n4 = 0;
        while (n4 < n2) {
            n = 0;
            while (n < n3) {
                System.out.print(dArray[n4][n] + " ");
                ++n;
            }
            System.out.println("");
            ++n4;
        }
        System.out.println("");
        dArray = IIPCRIF.matrixMultiply(RGB_TO_YCC, YCC_TO_RGB);
        n2 = dArray.length;
        n3 = dArray[0].length;
        n = 0;
        while (n < n2) {
            int n5 = 0;
            while (n5 < n3) {
                System.out.print(dArray[n][n5] + " ");
                ++n5;
            }
            System.out.println("");
            ++n;
        }
        System.out.println("");
        double[][] dArrayArray = new double[][]{{1.0}, {2.0}, {3.0}, {4.0}};
        double[][] dArray2 = IIPCRIF.composeMatrices(YCCA_TO_RGBA, dArrayArray);
        n2 = dArray2.length;
        n3 = dArray2[0].length;
        int n6 = 0;
        while (n6 < n2) {
            int n7 = 0;
            while (n7 < n3) {
                System.out.print(dArray2[n6][n7] + " ");
                ++n7;
            }
            System.out.println("");
            ++n6;
        }
        System.out.println("");
        double[][] dArray3 = IIPCRIF.matrixMultiply(RGBA_TO_YCCA, YCCA_TO_RGBA_CONST);
        n2 = dArray3.length;
        n3 = dArray3[0].length;
        int n8 = 0;
        while (n8 < n2) {
            int n9 = 0;
            while (n9 < n3) {
                System.out.print(-dArray3[n8][n9] + " ");
                ++n9;
            }
            System.out.println("");
            ++n8;
        }
        System.out.println("");
        double[][] dArray4 = IIPCRIF.matrixMultiply(RGB_TO_YCC, YCC_TO_RGB_CONST);
        n2 = dArray4.length;
        n3 = dArray4[0].length;
        int n10 = 0;
        while (n10 < n2) {
            int n11 = 0;
            while (n11 < n3) {
                System.out.print(-dArray4[n10][n11] + " ");
                ++n11;
            }
            System.out.println("");
            ++n10;
        }
        System.out.println("");
    }
}

