/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ColormapOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

final class LogOpImage
extends ColormapOpImage {
    private byte[] byteTable = null;

    public LogOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout) {
        super(renderedImage, imageLayout, map, true);
        this.permitInPlaceOperation();
        this.initializeColormapOperation();
    }

    protected void transformColormap(byte[][] byArray) {
        this.initByteTable();
        int n = 0;
        while (n < 3) {
            byte[] byArray2 = byArray[n];
            int n2 = byArray2.length;
            int n3 = 0;
            while (n3 < n2) {
                byArray2[n3] = this.byteTable[byArray2[n3] & 0xFF];
                ++n3;
            }
            ++n;
        }
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        RasterAccessor rasterAccessor = new RasterAccessor(rasterArray[0], rectangle, rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.computeRectByte(rasterAccessor, rasterAccessor2);
                break;
            }
            case 1: {
                this.computeRectUShort(rasterAccessor, rasterAccessor2);
                break;
            }
            case 2: {
                this.computeRectShort(rasterAccessor, rasterAccessor2);
                break;
            }
            case 3: {
                this.computeRectInt(rasterAccessor, rasterAccessor2);
                break;
            }
            case 4: {
                this.computeRectFloat(rasterAccessor, rasterAccessor2);
                break;
            }
            case 5: {
                this.computeRectDouble(rasterAccessor, rasterAccessor2);
            }
        }
        if (rasterAccessor2.needsClamping()) {
            rasterAccessor2.clampDataArrays();
        }
        rasterAccessor2.copyDataToRaster();
    }

    private void computeRectByte(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        this.initByteTable();
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        byte[][] byArray = rasterAccessor.getByteDataArrays();
        int n3 = rasterAccessor2.getScanlineStride();
        int n4 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        byte[][] byArray2 = rasterAccessor2.getByteDataArrays();
        int n5 = rasterAccessor2.getWidth();
        int n6 = rasterAccessor2.getHeight();
        int n7 = rasterAccessor2.getNumBands();
        int n8 = 0;
        while (n8 < n7) {
            byte[] byArray3 = byArray[n8];
            byte[] byArray4 = byArray2[n8];
            int n9 = nArray[n8];
            int n10 = nArray2[n8];
            int n11 = 0;
            while (n11 < n6) {
                int n12 = n9;
                int n13 = n10;
                n9 += n;
                n10 += n3;
                int n14 = 0;
                while (n14 < n5) {
                    byArray4[n13] = this.byteTable[byArray3[n12] & 0xFF];
                    n12 += n2;
                    n13 += n4;
                    ++n14;
                }
                ++n11;
            }
            ++n8;
        }
    }

    private void computeRectUShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n3 = rasterAccessor2.getScanlineStride();
        int n4 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        short[][] sArray2 = rasterAccessor2.getShortDataArrays();
        int n5 = rasterAccessor2.getWidth();
        int n6 = rasterAccessor2.getHeight();
        int n7 = rasterAccessor2.getNumBands();
        int n8 = 0;
        while (n8 < n7) {
            short[] sArray3 = sArray[n8];
            short[] sArray4 = sArray2[n8];
            int n9 = nArray[n8];
            int n10 = nArray2[n8];
            int n11 = 0;
            while (n11 < n6) {
                int n12 = n9;
                int n13 = n10;
                n9 += n;
                n10 += n3;
                int n14 = 0;
                while (n14 < n5) {
                    sArray4[n13] = (short)(Math.log(sArray3[n12] & 0xFFFF) + 0.5);
                    n12 += n2;
                    n13 += n4;
                    ++n14;
                }
                ++n11;
            }
            ++n8;
        }
    }

    private void computeRectShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n3 = rasterAccessor2.getScanlineStride();
        int n4 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        short[][] sArray2 = rasterAccessor2.getShortDataArrays();
        int n5 = rasterAccessor2.getWidth();
        int n6 = rasterAccessor2.getHeight();
        int n7 = rasterAccessor2.getNumBands();
        int n8 = 0;
        while (n8 < n7) {
            short[] sArray3 = sArray[n8];
            short[] sArray4 = sArray2[n8];
            int n9 = nArray[n8];
            int n10 = nArray2[n8];
            int n11 = 0;
            while (n11 < n6) {
                int n12 = n9;
                int n13 = n10;
                n9 += n;
                n10 += n3;
                int n14 = 0;
                while (n14 < n5) {
                    sArray4[n13] = (short)(Math.log(sArray3[n12]) + 0.5);
                    n12 += n2;
                    n13 += n4;
                    ++n14;
                }
                ++n11;
            }
            ++n8;
        }
    }

    private void computeRectInt(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        int[][] nArray2 = rasterAccessor.getIntDataArrays();
        int n3 = rasterAccessor2.getScanlineStride();
        int n4 = rasterAccessor2.getPixelStride();
        int[] nArray3 = rasterAccessor2.getBandOffsets();
        int[][] nArray4 = rasterAccessor2.getIntDataArrays();
        int n5 = rasterAccessor2.getWidth();
        int n6 = rasterAccessor2.getHeight();
        int n7 = rasterAccessor2.getNumBands();
        int n8 = 0;
        while (n8 < n7) {
            int[] nArray5 = nArray2[n8];
            int[] nArray6 = nArray4[n8];
            int n9 = nArray[n8];
            int n10 = nArray3[n8];
            int n11 = 0;
            while (n11 < n6) {
                int n12 = n9;
                int n13 = n10;
                n9 += n;
                n10 += n3;
                int n14 = 0;
                while (n14 < n5) {
                    double d2 = nArray5[n12];
                    nArray6[n13] = d2 > 0.0 ? (int)(Math.log(d2) + 0.5) : (d2 == 0.0 ? 0 : -1);
                    n12 += n2;
                    n13 += n4;
                    ++n14;
                }
                ++n11;
            }
            ++n8;
        }
    }

    private void computeRectFloat(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        float[][] fArray = rasterAccessor.getFloatDataArrays();
        int n3 = rasterAccessor2.getScanlineStride();
        int n4 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        float[][] fArray2 = rasterAccessor2.getFloatDataArrays();
        int n5 = rasterAccessor2.getWidth();
        int n6 = rasterAccessor2.getHeight();
        int n7 = rasterAccessor2.getNumBands();
        int n8 = 0;
        while (n8 < n7) {
            float[] fArray3 = fArray[n8];
            float[] fArray4 = fArray2[n8];
            int n9 = nArray[n8];
            int n10 = nArray2[n8];
            int n11 = 0;
            while (n11 < n6) {
                int n12 = n9;
                int n13 = n10;
                n9 += n;
                n10 += n3;
                int n14 = 0;
                while (n14 < n5) {
                    fArray4[n13] = (float)Math.log(fArray3[n12]);
                    n12 += n2;
                    n13 += n4;
                    ++n14;
                }
                ++n11;
            }
            ++n8;
        }
    }

    private void computeRectDouble(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        double[][] dArray = rasterAccessor.getDoubleDataArrays();
        int n3 = rasterAccessor2.getScanlineStride();
        int n4 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        double[][] dArray2 = rasterAccessor2.getDoubleDataArrays();
        int n5 = rasterAccessor2.getWidth();
        int n6 = rasterAccessor2.getHeight();
        int n7 = rasterAccessor2.getNumBands();
        int n8 = 0;
        while (n8 < n7) {
            double[] dArray3 = dArray[n8];
            double[] dArray4 = dArray2[n8];
            int n9 = nArray[n8];
            int n10 = nArray2[n8];
            int n11 = 0;
            while (n11 < n6) {
                int n12 = n9;
                int n13 = n10;
                n9 += n;
                n10 += n3;
                int n14 = 0;
                while (n14 < n5) {
                    dArray4[n13] = Math.log(dArray3[n12]);
                    n12 += n2;
                    n13 += n4;
                    ++n14;
                }
                ++n11;
            }
            ++n8;
        }
    }

    private synchronized void initByteTable() {
        if (this.byteTable != null) {
            return;
        }
        this.byteTable = new byte[256];
        this.byteTable[0] = 0;
        this.byteTable[1] = 0;
        int n = 2;
        while (n < 256) {
            this.byteTable[n] = (byte)(Math.log(n) + 0.5);
            ++n;
        }
    }
}

