/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.util.ImageUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Vector;
import javax.media.jai.BorderExtender;
import javax.media.jai.BorderExtenderConstant;
import javax.media.jai.ImageLayout;
import javax.media.jai.OpImage;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.operator.MosaicDescriptor;
import javax.media.jai.operator.MosaicType;

public class MosaicOpImage
extends OpImage {
    private static final int WEIGHT_TYPE_ALPHA = 1;
    private static final int WEIGHT_TYPE_ROI = 2;
    private static final int WEIGHT_TYPE_THRESHOLD = 3;
    protected MosaicType mosaicType;
    protected PlanarImage[] sourceAlpha;
    protected ROI[] sourceROI;
    protected double[][] sourceThreshold;
    protected double[] backgroundValues;
    protected int numBands = this.sampleModel.getNumBands();
    protected int[] background;
    protected int[][] threshold;
    protected boolean isAlphaBitmask = false;
    private BorderExtender sourceExtender;
    private BorderExtender zeroExtender;
    private PlanarImage[] roiImage;

    private static final ImageLayout getLayout(Vector vector, ImageLayout imageLayout) {
        int n;
        Object object;
        Object object2;
        RenderedImage renderedImage = null;
        SampleModel sampleModel = null;
        ColorModel colorModel = null;
        int n2 = vector.size();
        if (n2 > 0) {
            renderedImage = (RenderedImage)vector.get(0);
            sampleModel = renderedImage.getSampleModel();
            colorModel = renderedImage.getColorModel();
        } else if (imageLayout != null && imageLayout.isValid(268)) {
            sampleModel = imageLayout.getSampleModel(null);
            if (sampleModel == null) {
                throw new IllegalArgumentException(JaiI18N.getString("MosaicOpImage7"));
            }
        } else {
            throw new IllegalArgumentException(JaiI18N.getString("MosaicOpImage8"));
        }
        int n3 = sampleModel.getDataType();
        int n4 = sampleModel.getNumBands();
        int n5 = sampleModel.getSampleSize(0);
        int n6 = 1;
        while (n6 < n4) {
            if (sampleModel.getSampleSize(n6) != n5) {
                throw new IllegalArgumentException(JaiI18N.getString("MosaicOpImage1"));
            }
            ++n6;
        }
        if (n2 < 1) {
            return (ImageLayout)imageLayout.clone();
        }
        int n7 = 1;
        while (n7 < n2) {
            object2 = (RenderedImage)vector.get(n7);
            object = object2.getSampleModel();
            if (((SampleModel)object).getDataType() != n3) {
                throw new IllegalArgumentException(JaiI18N.getString("MosaicOpImage2"));
            }
            if (((SampleModel)object).getNumBands() != n4) {
                throw new IllegalArgumentException(JaiI18N.getString("MosaicOpImage3"));
            }
            n = 0;
            while (n < n4) {
                if (((SampleModel)object).getSampleSize(n) != n5) {
                    throw new IllegalArgumentException(JaiI18N.getString("MosaicOpImage1"));
                }
                ++n;
            }
            ++n7;
        }
        object2 = imageLayout == null ? new ImageLayout() : (ImageLayout)imageLayout.clone();
        object = new Rectangle();
        if (((ImageLayout)object2).isValid(15)) {
            ((Rectangle)object).setBounds(((ImageLayout)object2).getMinX(null), ((ImageLayout)object2).getMinY(null), ((ImageLayout)object2).getWidth(null), ((ImageLayout)object2).getHeight(null));
        } else if (n2 > 0) {
            ((Rectangle)object).setBounds(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight());
            n = 1;
            while (n < n2) {
                RenderedImage renderedImage2 = (RenderedImage)vector.get(n);
                Rectangle rectangle = new Rectangle(renderedImage2.getMinX(), renderedImage2.getMinY(), renderedImage2.getWidth(), renderedImage2.getHeight());
                object = ((Rectangle)object).union(rectangle);
                ++n;
            }
        }
        ((ImageLayout)object2).setMinX(((Rectangle)object).x);
        ((ImageLayout)object2).setMinY(((Rectangle)object).y);
        ((ImageLayout)object2).setWidth(((Rectangle)object).width);
        ((ImageLayout)object2).setHeight(((Rectangle)object).height);
        if (((ImageLayout)object2).isValid(256)) {
            SampleModel sampleModel2 = ((ImageLayout)object2).getSampleModel(null);
            boolean bl = sampleModel2.getNumBands() != n4 || sampleModel2.getDataType() != n3;
            int n8 = 0;
            while (!bl && n8 < n4) {
                if (sampleModel2.getSampleSize(n8) != n5) {
                    bl = true;
                }
                ++n8;
            }
            if (bl) {
                ((ImageLayout)object2).unsetValid(256);
            }
        }
        return object2;
    }

    public MosaicOpImage(Vector vector, ImageLayout imageLayout, Map map, MosaicType mosaicType, PlanarImage[] planarImageArray, ROI[] rOIArray, double[][] object, double[] dArray) {
        super(vector, MosaicOpImage.getLayout(vector, imageLayout), map, true);
        double d2;
        int n;
        int n2;
        int n3 = this.getNumSources();
        this.mosaicType = mosaicType;
        this.sourceAlpha = null;
        if (planarImageArray != null) {
            n2 = 0;
            while (n2 < planarImageArray.length) {
                if (planarImageArray[n2] != null) {
                    SampleModel sampleModel = planarImageArray[n2].getSampleModel();
                    if (sampleModel.getNumBands() != 1) {
                        throw new IllegalArgumentException(JaiI18N.getString("MosaicOpImage4"));
                    }
                    if (sampleModel.getDataType() != this.sampleModel.getDataType()) {
                        throw new IllegalArgumentException(JaiI18N.getString("MosaicOpImage4"));
                    }
                    if (sampleModel.getSampleSize(0) != this.sampleModel.getSampleSize(0)) {
                        throw new IllegalArgumentException(JaiI18N.getString("MosaicOpImage4"));
                    }
                }
                ++n2;
            }
            this.sourceAlpha = new PlanarImage[n3];
            System.arraycopy(planarImageArray, 0, this.sourceAlpha, 0, Math.min(planarImageArray.length, n3));
        }
        this.sourceROI = null;
        if (rOIArray != null) {
            this.sourceROI = new ROI[n3];
            System.arraycopy(rOIArray, 0, this.sourceROI, 0, Math.min(rOIArray.length, n3));
        }
        boolean bl = this.isAlphaBitmask = mosaicType != MosaicDescriptor.MOSAIC_TYPE_BLEND || planarImageArray == null || planarImageArray.length < n3;
        if (!this.isAlphaBitmask) {
            n2 = 0;
            while (n2 < n3) {
                if (planarImageArray[n2] == null) {
                    this.isAlphaBitmask = true;
                    break;
                }
                ++n2;
            }
        }
        this.sourceThreshold = new double[n3][this.numBands];
        if (object == null) {
            object = new double[][]{{1.0}};
        }
        n2 = 0;
        while (n2 < n3) {
            if (n2 < ((double[][])object).length && object[n2] != null) {
                if (object[n2].length < this.numBands) {
                    Arrays.fill(this.sourceThreshold[n2], object[n2][0]);
                } else {
                    System.arraycopy(object[n2], 0, this.sourceThreshold[n2], 0, this.numBands);
                }
            } else {
                this.sourceThreshold[n2] = this.sourceThreshold[0];
            }
            ++n2;
        }
        this.threshold = new int[n3][this.numBands];
        int n4 = 0;
        while (n4 < n3) {
            n = 0;
            while (n < this.numBands) {
                this.threshold[n4][n] = (int)this.sourceThreshold[n4][n];
                ++n;
            }
            ++n4;
        }
        this.backgroundValues = new double[this.numBands];
        if (dArray == null) {
            dArray = new double[]{0.0};
        }
        if (dArray.length < this.numBands) {
            Arrays.fill(this.backgroundValues, dArray[0]);
        } else {
            System.arraycopy(dArray, 0, this.backgroundValues, 0, this.numBands);
        }
        this.background = new int[this.backgroundValues.length];
        n = this.sampleModel.getDataType();
        int n5 = 0;
        while (n5 < this.background.length) {
            switch (n) {
                case 0: {
                    this.background[n5] = ImageUtil.clampRoundByte(this.backgroundValues[n5]);
                    break;
                }
                case 1: {
                    this.background[n5] = ImageUtil.clampRoundUShort(this.backgroundValues[n5]);
                    break;
                }
                case 2: {
                    this.background[n5] = ImageUtil.clampRoundShort(this.backgroundValues[n5]);
                    break;
                }
                case 3: {
                    this.background[n5] = ImageUtil.clampRoundInt(this.backgroundValues[n5]);
                    break;
                }
            }
            ++n5;
        }
        switch (n) {
            case 0: {
                d2 = 0.0;
                break;
            }
            case 1: {
                d2 = 0.0;
                break;
            }
            case 2: {
                d2 = -32768.0;
                break;
            }
            case 3: {
                d2 = -2.147483648E9;
                break;
            }
            case 4: {
                d2 = -3.4028234663852886E38;
                break;
            }
            default: {
                d2 = -1.7976931348623157E308;
            }
        }
        BorderExtender borderExtender = this.sourceExtender = d2 == 0.0 ? BorderExtender.createInstance(0) : new BorderExtenderConstant(new double[]{d2});
        if (planarImageArray != null || rOIArray != null) {
            this.zeroExtender = BorderExtender.createInstance(0);
        }
        if (rOIArray != null) {
            this.roiImage = new PlanarImage[n3];
            int n6 = 0;
            while (n6 < rOIArray.length) {
                if (rOIArray[n6] != null) {
                    this.roiImage[n6] = rOIArray[n6].getAsImage();
                }
                ++n6;
            }
        }
    }

    public Rectangle mapDestRect(Rectangle rectangle, int n) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n < 0 || n >= this.getNumSources()) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        return rectangle.intersection(this.getSourceImage(n).getBounds());
    }

    public Rectangle mapSourceRect(Rectangle rectangle, int n) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n < 0 || n >= this.getNumSources()) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic1"));
        }
        return rectangle.intersection(this.getBounds());
    }

    public Raster computeTile(int n, int n2) {
        Object object;
        WritableRaster writableRaster = this.createWritableRaster(this.sampleModel, new Point(this.tileXToX(n), this.tileYToY(n2)));
        Rectangle rectangle = this.getTileRect(n, n2);
        int n3 = this.getNumSources();
        Raster[] rasterArray = new Raster[n3];
        Raster[] rasterArray2 = this.sourceAlpha != null ? new Raster[n3] : null;
        Raster[] rasterArray3 = this.sourceROI != null ? new Raster[n3] : null;
        int n4 = 0;
        while (n4 < n3) {
            PlanarImage planarImage = this.getSourceImage(n4);
            object = this.mapDestRect(rectangle, n4);
            Raster raster = rasterArray[n4] = object != null && ((Rectangle)object).isEmpty() ? null : planarImage.getExtendedData(rectangle, this.sourceExtender);
            if (rasterArray[n4] != null) {
                if (this.sourceAlpha != null && this.sourceAlpha[n4] != null) {
                    rasterArray2[n4] = this.sourceAlpha[n4].getExtendedData(rectangle, this.zeroExtender);
                }
                if (this.sourceROI != null && this.sourceROI[n4] != null) {
                    rasterArray3[n4] = this.roiImage[n4].getExtendedData(rectangle, this.zeroExtender);
                }
            }
            ++n4;
        }
        this.computeRect(rasterArray, writableRaster, rectangle, rasterArray2, rasterArray3);
        int n5 = 0;
        while (n5 < n3) {
            PlanarImage planarImage;
            object = rasterArray[n5];
            if (object != null && (planarImage = this.getSourceImage(n5)).overlapsMultipleTiles(((Raster)object).getBounds())) {
                this.recycleTile((Raster)object);
            }
            ++n5;
        }
        return writableRaster;
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        this.computeRect(rasterArray, writableRaster, rectangle, null, null);
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle, Raster[] rasterArray2, Raster[] rasterArray3) {
        Object object;
        int n = rasterArray.length;
        ArrayList<Raster> arrayList = new ArrayList<Raster>(n);
        int n2 = 0;
        while (n2 < n) {
            if (rasterArray[n2] != null) {
                arrayList.add(rasterArray[n2]);
            }
            ++n2;
        }
        int n3 = arrayList.size();
        if (n3 == 0) {
            ImageUtil.fillBackground(writableRaster, rectangle, this.backgroundValues);
            return;
        }
        SampleModel[] sampleModelArray = new SampleModel[n3];
        int n4 = 0;
        while (n4 < n3) {
            sampleModelArray[n4] = ((Raster)arrayList.get(n4)).getSampleModel();
            ++n4;
        }
        int n5 = RasterAccessor.findCompatibleTag(sampleModelArray, writableRaster.getSampleModel());
        RasterAccessor[] rasterAccessorArray = new RasterAccessor[n];
        int n6 = 0;
        while (n6 < n) {
            if (rasterArray[n6] != null) {
                object = new RasterFormatTag(rasterArray[n6].getSampleModel(), n5);
                rasterAccessorArray[n6] = new RasterAccessor(rasterArray[n6], rectangle, (RasterFormatTag)object, null);
            }
            ++n6;
        }
        object = new RasterAccessor(writableRaster, rectangle, new RasterFormatTag(writableRaster.getSampleModel(), n5), null);
        RasterAccessor[] rasterAccessorArray2 = new RasterAccessor[n];
        if (rasterArray2 != null) {
            int n7 = 0;
            while (n7 < n) {
                if (rasterArray2[n7] != null) {
                    SampleModel sampleModel = rasterArray2[n7].getSampleModel();
                    int n8 = RasterAccessor.findCompatibleTag(null, sampleModel);
                    RasterFormatTag rasterFormatTag = new RasterFormatTag(sampleModel, n8);
                    rasterAccessorArray2[n7] = new RasterAccessor(rasterArray2[n7], rectangle, rasterFormatTag, this.sourceAlpha[n7].getColorModel());
                }
                ++n7;
            }
        }
        switch (((RasterAccessor)object).getDataType()) {
            case 0: {
                this.computeRectByte(rasterAccessorArray, (RasterAccessor)object, rasterAccessorArray2, rasterArray3);
                break;
            }
            case 1: {
                this.computeRectUShort(rasterAccessorArray, (RasterAccessor)object, rasterAccessorArray2, rasterArray3);
                break;
            }
            case 2: {
                this.computeRectShort(rasterAccessorArray, (RasterAccessor)object, rasterAccessorArray2, rasterArray3);
                break;
            }
            case 3: {
                this.computeRectInt(rasterAccessorArray, (RasterAccessor)object, rasterAccessorArray2, rasterArray3);
                break;
            }
            case 4: {
                this.computeRectFloat(rasterAccessorArray, (RasterAccessor)object, rasterAccessorArray2, rasterArray3);
                break;
            }
            case 5: {
                this.computeRectDouble(rasterAccessorArray, (RasterAccessor)object, rasterAccessorArray2, rasterArray3);
            }
        }
        ((RasterAccessor)object).copyDataToRaster();
    }

    private void computeRectByte(RasterAccessor[] rasterAccessorArray, RasterAccessor rasterAccessor, RasterAccessor[] rasterAccessorArray2, Raster[] rasterArray) {
        int n = rasterAccessorArray.length;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int[][] nArrayArray = new int[n][];
        byte[][][] byArrayArray = new byte[n][][];
        int n2 = 0;
        while (n2 < n) {
            if (rasterAccessorArray[n2] != null) {
                nArray[n2] = rasterAccessorArray[n2].getScanlineStride();
                nArray2[n2] = rasterAccessorArray[n2].getPixelStride();
                nArrayArray[n2] = rasterAccessorArray[n2].getBandOffsets();
                byArrayArray[n2] = rasterAccessorArray[n2].getByteDataArrays();
            }
            ++n2;
        }
        int n3 = rasterAccessor.getX();
        int n4 = rasterAccessor.getY();
        int n5 = rasterAccessor.getWidth();
        int n6 = rasterAccessor.getHeight();
        int n7 = n3 + n5;
        int n8 = n4 + n6;
        int n9 = rasterAccessor.getNumBands();
        int n10 = rasterAccessor.getScanlineStride();
        int n11 = rasterAccessor.getPixelStride();
        int[] nArray3 = rasterAccessor.getBandOffsets();
        byte[][] byArray = rasterAccessor.getByteDataArrays();
        boolean bl = false;
        int n12 = 0;
        while (n12 < n) {
            if (rasterAccessorArray2[n12] != null) {
                bl = true;
                break;
            }
            ++n12;
        }
        int[] nArray4 = null;
        int[] nArray5 = null;
        int[][] nArrayArray2 = null;
        byte[][][] byArrayArray2 = null;
        if (bl) {
            nArray4 = new int[n];
            nArray5 = new int[n];
            nArrayArray2 = new int[n][];
            byArrayArray2 = new byte[n][][];
            int n13 = 0;
            while (n13 < n) {
                if (rasterAccessorArray2[n13] != null) {
                    nArray4[n13] = rasterAccessorArray2[n13].getScanlineStride();
                    nArray5[n13] = rasterAccessorArray2[n13].getPixelStride();
                    nArrayArray2[n13] = rasterAccessorArray2[n13].getBandOffsets();
                    byArrayArray2[n13] = rasterAccessorArray2[n13].getByteDataArrays();
                }
                ++n13;
            }
        }
        int[] nArray6 = new int[n];
        int n14 = 0;
        while (n14 < n) {
            nArray6[n14] = 3;
            if (rasterAccessorArray2[n14] != null) {
                nArray6[n14] = 1;
            } else if (this.sourceROI != null && this.sourceROI[n14] != null) {
                nArray6[n14] = 2;
            }
            ++n14;
        }
        int[] nArray7 = new int[n];
        int[] nArray8 = new int[n];
        byte[][] byArrayArray3 = new byte[n][];
        int[] nArray9 = null;
        int[] nArray10 = null;
        byte[][] byArrayArray4 = null;
        if (bl) {
            nArray9 = new int[n];
            nArray10 = new int[n];
            byArrayArray4 = new byte[n][];
        }
        int n15 = 0;
        while (n15 < n9) {
            int n16;
            int n17;
            int n18;
            int n19;
            int n20;
            int n21;
            int n22 = 0;
            while (n22 < n) {
                if (rasterAccessorArray[n22] != null) {
                    byArrayArray3[n22] = byArrayArray[n22][n15];
                    nArray7[n22] = nArrayArray[n22][n15];
                }
                if (nArray6[n22] == 1) {
                    byArrayArray4[n22] = byArrayArray2[n22][0];
                    nArray9[n22] = nArrayArray2[n22][0];
                }
                ++n22;
            }
            byte[] byArray2 = byArray[n15];
            int n23 = nArray3[n15];
            if (this.mosaicType == MosaicDescriptor.MOSAIC_TYPE_OVERLAY) {
                n21 = n4;
                while (n21 < n8) {
                    n20 = 0;
                    while (n20 < n) {
                        if (rasterAccessorArray[n20] != null) {
                            nArray8[n20] = nArray7[n20];
                            int n24 = n20;
                            nArray7[n24] = nArray7[n24] + nArray[n20];
                        }
                        if (rasterAccessorArray2[n20] != null) {
                            nArray10[n20] = nArray9[n20];
                            int n25 = n20;
                            nArray9[n25] = nArray9[n25] + nArray4[n20];
                        }
                        ++n20;
                    }
                    n19 = n23;
                    n23 += n10;
                    n18 = n3;
                    while (n18 < n7) {
                        boolean bl2 = false;
                        int n26 = 0;
                        while (n26 < n) {
                            if (rasterAccessorArray[n26] != null) {
                                n17 = byArrayArray3[n26][nArray8[n26]];
                                int n27 = n26;
                                nArray8[n27] = nArray8[n27] + nArray2[n26];
                                switch (nArray6[n26]) {
                                    case 1: {
                                        bl2 = byArrayArray4[n26][nArray10[n26]] != 0;
                                        int n28 = n26;
                                        nArray10[n28] = nArray10[n28] + nArray5[n26];
                                        break;
                                    }
                                    case 2: {
                                        bl2 = rasterArray[n26].getSample(n18, n21, 0) > 0;
                                        break;
                                    }
                                    default: {
                                        boolean bl3 = bl2 = (double)(n17 & 0xFF) >= this.sourceThreshold[n26][n15];
                                    }
                                }
                                if (bl2) {
                                    byArray2[n19] = n17;
                                    n16 = n26 + 1;
                                    while (n16 < n) {
                                        if (rasterAccessorArray[n16] != null) {
                                            int n29 = n16;
                                            nArray8[n29] = nArray8[n29] + nArray2[n16];
                                        }
                                        if (rasterAccessorArray2[n16] != null) {
                                            int n30 = n16;
                                            nArray10[n30] = nArray10[n30] + nArray5[n16];
                                        }
                                        ++n16;
                                    }
                                    break;
                                }
                            }
                            ++n26;
                        }
                        if (!bl2) {
                            byArray2[n19] = (byte)this.background[n15];
                        }
                        n19 += n11;
                        ++n18;
                    }
                    ++n21;
                }
            } else {
                n21 = n4;
                while (n21 < n8) {
                    n20 = 0;
                    while (n20 < n) {
                        if (rasterAccessorArray[n20] != null) {
                            nArray8[n20] = nArray7[n20];
                            int n31 = n20;
                            nArray7[n31] = nArray7[n31] + nArray[n20];
                        }
                        if (nArray6[n20] == 1) {
                            nArray10[n20] = nArray9[n20];
                            int n32 = n20;
                            nArray9[n32] = nArray9[n32] + nArray4[n20];
                        }
                        ++n20;
                    }
                    n19 = n23;
                    n23 += n10;
                    n18 = n3;
                    while (n18 < n7) {
                        float f2 = 0.0f;
                        float f3 = 0.0f;
                        n17 = 0;
                        while (n17 < n) {
                            if (rasterAccessorArray[n17] != null) {
                                n16 = byArrayArray3[n17][nArray8[n17]];
                                int n33 = n17;
                                nArray8[n33] = nArray8[n33] + nArray2[n17];
                                float f4 = 0.0f;
                                switch (nArray6[n17]) {
                                    case 1: {
                                        f4 = byArrayArray4[n17][nArray10[n17]] & 0xFF;
                                        f4 = f4 > 0.0f && this.isAlphaBitmask ? 1.0f : (f4 /= 255.0f);
                                        int n34 = n17;
                                        nArray10[n34] = nArray10[n34] + nArray5[n17];
                                        break;
                                    }
                                    case 2: {
                                        f4 = rasterArray[n17].getSample(n18, n21, 0) > 0 ? 1.0f : 0.0f;
                                        break;
                                    }
                                    default: {
                                        f4 = (double)(n16 & 0xFF) >= this.sourceThreshold[n17][n15] ? 1.0f : 0.0f;
                                    }
                                }
                                f2 += f4 * (float)(n16 & 0xFF);
                                f3 += f4;
                            }
                            ++n17;
                        }
                        byArray2[n19] = (double)f3 == 0.0 ? (byte)this.background[n15] : ImageUtil.clampRoundByte(f2 / f3);
                        n19 += n11;
                        ++n18;
                    }
                    ++n21;
                }
            }
            ++n15;
        }
    }

    private void computeRectUShort(RasterAccessor[] rasterAccessorArray, RasterAccessor rasterAccessor, RasterAccessor[] rasterAccessorArray2, Raster[] rasterArray) {
        int n = rasterAccessorArray.length;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int[][] nArrayArray = new int[n][];
        short[][][] sArrayArray = new short[n][][];
        int n2 = 0;
        while (n2 < n) {
            if (rasterAccessorArray[n2] != null) {
                nArray[n2] = rasterAccessorArray[n2].getScanlineStride();
                nArray2[n2] = rasterAccessorArray[n2].getPixelStride();
                nArrayArray[n2] = rasterAccessorArray[n2].getBandOffsets();
                sArrayArray[n2] = rasterAccessorArray[n2].getShortDataArrays();
            }
            ++n2;
        }
        int n3 = rasterAccessor.getX();
        int n4 = rasterAccessor.getY();
        int n5 = rasterAccessor.getWidth();
        int n6 = rasterAccessor.getHeight();
        int n7 = n3 + n5;
        int n8 = n4 + n6;
        int n9 = rasterAccessor.getNumBands();
        int n10 = rasterAccessor.getScanlineStride();
        int n11 = rasterAccessor.getPixelStride();
        int[] nArray3 = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        boolean bl = false;
        int n12 = 0;
        while (n12 < n) {
            if (rasterAccessorArray2[n12] != null) {
                bl = true;
                break;
            }
            ++n12;
        }
        int[] nArray4 = null;
        int[] nArray5 = null;
        int[][] nArrayArray2 = null;
        short[][][] sArrayArray2 = null;
        if (bl) {
            nArray4 = new int[n];
            nArray5 = new int[n];
            nArrayArray2 = new int[n][];
            sArrayArray2 = new short[n][][];
            int n13 = 0;
            while (n13 < n) {
                if (rasterAccessorArray2[n13] != null) {
                    nArray4[n13] = rasterAccessorArray2[n13].getScanlineStride();
                    nArray5[n13] = rasterAccessorArray2[n13].getPixelStride();
                    nArrayArray2[n13] = rasterAccessorArray2[n13].getBandOffsets();
                    sArrayArray2[n13] = rasterAccessorArray2[n13].getShortDataArrays();
                }
                ++n13;
            }
        }
        int[] nArray6 = new int[n];
        int n14 = 0;
        while (n14 < n) {
            nArray6[n14] = 3;
            if (rasterAccessorArray2[n14] != null) {
                nArray6[n14] = 1;
            } else if (this.sourceROI != null && this.sourceROI[n14] != null) {
                nArray6[n14] = 2;
            }
            ++n14;
        }
        int[] nArray7 = new int[n];
        int[] nArray8 = new int[n];
        short[][] sArrayArray3 = new short[n][];
        int[] nArray9 = null;
        int[] nArray10 = null;
        short[][] sArrayArray4 = null;
        if (bl) {
            nArray9 = new int[n];
            nArray10 = new int[n];
            sArrayArray4 = new short[n][];
        }
        int n15 = 0;
        while (n15 < n9) {
            int n16;
            int n17;
            int n18;
            int n19;
            int n20;
            int n21;
            int n22 = 0;
            while (n22 < n) {
                if (rasterAccessorArray[n22] != null) {
                    sArrayArray3[n22] = sArrayArray[n22][n15];
                    nArray7[n22] = nArrayArray[n22][n15];
                }
                if (nArray6[n22] == 1) {
                    sArrayArray4[n22] = sArrayArray2[n22][0];
                    nArray9[n22] = nArrayArray2[n22][0];
                }
                ++n22;
            }
            short[] sArray2 = sArray[n15];
            int n23 = nArray3[n15];
            if (this.mosaicType == MosaicDescriptor.MOSAIC_TYPE_OVERLAY) {
                n21 = n4;
                while (n21 < n8) {
                    n20 = 0;
                    while (n20 < n) {
                        if (rasterAccessorArray[n20] != null) {
                            nArray8[n20] = nArray7[n20];
                            int n24 = n20;
                            nArray7[n24] = nArray7[n24] + nArray[n20];
                        }
                        if (rasterAccessorArray2[n20] != null) {
                            nArray10[n20] = nArray9[n20];
                            int n25 = n20;
                            nArray9[n25] = nArray9[n25] + nArray4[n20];
                        }
                        ++n20;
                    }
                    n19 = n23;
                    n23 += n10;
                    n18 = n3;
                    while (n18 < n7) {
                        boolean bl2 = false;
                        int n26 = 0;
                        while (n26 < n) {
                            if (rasterAccessorArray[n26] != null) {
                                n17 = sArrayArray3[n26][nArray8[n26]];
                                int n27 = n26;
                                nArray8[n27] = nArray8[n27] + nArray2[n26];
                                switch (nArray6[n26]) {
                                    case 1: {
                                        bl2 = sArrayArray4[n26][nArray10[n26]] != 0;
                                        int n28 = n26;
                                        nArray10[n28] = nArray10[n28] + nArray5[n26];
                                        break;
                                    }
                                    case 2: {
                                        bl2 = rasterArray[n26].getSample(n18, n21, 0) > 0;
                                        break;
                                    }
                                    default: {
                                        boolean bl3 = bl2 = (double)(n17 & 0xFFFF) >= this.sourceThreshold[n26][n15];
                                    }
                                }
                                if (bl2) {
                                    sArray2[n19] = n17;
                                    n16 = n26 + 1;
                                    while (n16 < n) {
                                        if (rasterAccessorArray[n16] != null) {
                                            int n29 = n16;
                                            nArray8[n29] = nArray8[n29] + nArray2[n16];
                                        }
                                        if (rasterAccessorArray2[n16] != null) {
                                            int n30 = n16;
                                            nArray10[n30] = nArray10[n30] + nArray5[n16];
                                        }
                                        ++n16;
                                    }
                                    break;
                                }
                            }
                            ++n26;
                        }
                        if (!bl2) {
                            sArray2[n19] = (short)this.background[n15];
                        }
                        n19 += n11;
                        ++n18;
                    }
                    ++n21;
                }
            } else {
                n21 = n4;
                while (n21 < n8) {
                    n20 = 0;
                    while (n20 < n) {
                        if (rasterAccessorArray[n20] != null) {
                            nArray8[n20] = nArray7[n20];
                            int n31 = n20;
                            nArray7[n31] = nArray7[n31] + nArray[n20];
                        }
                        if (nArray6[n20] == 1) {
                            nArray10[n20] = nArray9[n20];
                            int n32 = n20;
                            nArray9[n32] = nArray9[n32] + nArray4[n20];
                        }
                        ++n20;
                    }
                    n19 = n23;
                    n23 += n10;
                    n18 = n3;
                    while (n18 < n7) {
                        float f2 = 0.0f;
                        float f3 = 0.0f;
                        n17 = 0;
                        while (n17 < n) {
                            if (rasterAccessorArray[n17] != null) {
                                n16 = sArrayArray3[n17][nArray8[n17]];
                                int n33 = n17;
                                nArray8[n33] = nArray8[n33] + nArray2[n17];
                                float f4 = 0.0f;
                                switch (nArray6[n17]) {
                                    case 1: {
                                        f4 = sArrayArray4[n17][nArray10[n17]] & 0xFFFF;
                                        f4 = f4 > 0.0f && this.isAlphaBitmask ? 1.0f : (f4 /= 65535.0f);
                                        int n34 = n17;
                                        nArray10[n34] = nArray10[n34] + nArray5[n17];
                                        break;
                                    }
                                    case 2: {
                                        f4 = rasterArray[n17].getSample(n18, n21, 0) > 0 ? 1.0f : 0.0f;
                                        break;
                                    }
                                    default: {
                                        f4 = (double)(n16 & 0xFFFF) >= this.sourceThreshold[n17][n15] ? 1.0f : 0.0f;
                                    }
                                }
                                f2 += f4 * (float)(n16 & 0xFFFF);
                                f3 += f4;
                            }
                            ++n17;
                        }
                        sArray2[n19] = (double)f3 == 0.0 ? (short)this.background[n15] : ImageUtil.clampRoundUShort(f2 / f3);
                        n19 += n11;
                        ++n18;
                    }
                    ++n21;
                }
            }
            ++n15;
        }
    }

    private void computeRectShort(RasterAccessor[] rasterAccessorArray, RasterAccessor rasterAccessor, RasterAccessor[] rasterAccessorArray2, Raster[] rasterArray) {
        int n = rasterAccessorArray.length;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int[][] nArrayArray = new int[n][];
        short[][][] sArrayArray = new short[n][][];
        int n2 = 0;
        while (n2 < n) {
            if (rasterAccessorArray[n2] != null) {
                nArray[n2] = rasterAccessorArray[n2].getScanlineStride();
                nArray2[n2] = rasterAccessorArray[n2].getPixelStride();
                nArrayArray[n2] = rasterAccessorArray[n2].getBandOffsets();
                sArrayArray[n2] = rasterAccessorArray[n2].getShortDataArrays();
            }
            ++n2;
        }
        int n3 = rasterAccessor.getX();
        int n4 = rasterAccessor.getY();
        int n5 = rasterAccessor.getWidth();
        int n6 = rasterAccessor.getHeight();
        int n7 = n3 + n5;
        int n8 = n4 + n6;
        int n9 = rasterAccessor.getNumBands();
        int n10 = rasterAccessor.getScanlineStride();
        int n11 = rasterAccessor.getPixelStride();
        int[] nArray3 = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        boolean bl = false;
        int n12 = 0;
        while (n12 < n) {
            if (rasterAccessorArray2[n12] != null) {
                bl = true;
                break;
            }
            ++n12;
        }
        int[] nArray4 = null;
        int[] nArray5 = null;
        int[][] nArrayArray2 = null;
        short[][][] sArrayArray2 = null;
        if (bl) {
            nArray4 = new int[n];
            nArray5 = new int[n];
            nArrayArray2 = new int[n][];
            sArrayArray2 = new short[n][][];
            int n13 = 0;
            while (n13 < n) {
                if (rasterAccessorArray2[n13] != null) {
                    nArray4[n13] = rasterAccessorArray2[n13].getScanlineStride();
                    nArray5[n13] = rasterAccessorArray2[n13].getPixelStride();
                    nArrayArray2[n13] = rasterAccessorArray2[n13].getBandOffsets();
                    sArrayArray2[n13] = rasterAccessorArray2[n13].getShortDataArrays();
                }
                ++n13;
            }
        }
        int[] nArray6 = new int[n];
        int n14 = 0;
        while (n14 < n) {
            nArray6[n14] = 3;
            if (rasterAccessorArray2[n14] != null) {
                nArray6[n14] = 1;
            } else if (this.sourceROI != null && this.sourceROI[n14] != null) {
                nArray6[n14] = 2;
            }
            ++n14;
        }
        int[] nArray7 = new int[n];
        int[] nArray8 = new int[n];
        short[][] sArrayArray3 = new short[n][];
        int[] nArray9 = null;
        int[] nArray10 = null;
        short[][] sArrayArray4 = null;
        if (bl) {
            nArray9 = new int[n];
            nArray10 = new int[n];
            sArrayArray4 = new short[n][];
        }
        int n15 = 0;
        while (n15 < n9) {
            int n16;
            int n17;
            int n18;
            int n19;
            int n20;
            int n21;
            int n22 = 0;
            while (n22 < n) {
                if (rasterAccessorArray[n22] != null) {
                    sArrayArray3[n22] = sArrayArray[n22][n15];
                    nArray7[n22] = nArrayArray[n22][n15];
                }
                if (nArray6[n22] == 1) {
                    sArrayArray4[n22] = sArrayArray2[n22][0];
                    nArray9[n22] = nArrayArray2[n22][0];
                }
                ++n22;
            }
            short[] sArray2 = sArray[n15];
            int n23 = nArray3[n15];
            if (this.mosaicType == MosaicDescriptor.MOSAIC_TYPE_OVERLAY) {
                n21 = n4;
                while (n21 < n8) {
                    n20 = 0;
                    while (n20 < n) {
                        if (rasterAccessorArray[n20] != null) {
                            nArray8[n20] = nArray7[n20];
                            int n24 = n20;
                            nArray7[n24] = nArray7[n24] + nArray[n20];
                        }
                        if (rasterAccessorArray2[n20] != null) {
                            nArray10[n20] = nArray9[n20];
                            int n25 = n20;
                            nArray9[n25] = nArray9[n25] + nArray4[n20];
                        }
                        ++n20;
                    }
                    n19 = n23;
                    n23 += n10;
                    n18 = n3;
                    while (n18 < n7) {
                        boolean bl2 = false;
                        int n26 = 0;
                        while (n26 < n) {
                            if (rasterAccessorArray[n26] != null) {
                                n17 = sArrayArray3[n26][nArray8[n26]];
                                int n27 = n26;
                                nArray8[n27] = nArray8[n27] + nArray2[n26];
                                switch (nArray6[n26]) {
                                    case 1: {
                                        bl2 = sArrayArray4[n26][nArray10[n26]] != 0;
                                        int n28 = n26;
                                        nArray10[n28] = nArray10[n28] + nArray5[n26];
                                        break;
                                    }
                                    case 2: {
                                        bl2 = rasterArray[n26].getSample(n18, n21, 0) > 0;
                                        break;
                                    }
                                    default: {
                                        boolean bl3 = bl2 = (double)n17 >= this.sourceThreshold[n26][n15];
                                    }
                                }
                                if (bl2) {
                                    sArray2[n19] = n17;
                                    n16 = n26 + 1;
                                    while (n16 < n) {
                                        if (rasterAccessorArray[n16] != null) {
                                            int n29 = n16;
                                            nArray8[n29] = nArray8[n29] + nArray2[n16];
                                        }
                                        if (rasterAccessorArray2[n16] != null) {
                                            int n30 = n16;
                                            nArray10[n30] = nArray10[n30] + nArray5[n16];
                                        }
                                        ++n16;
                                    }
                                    break;
                                }
                            }
                            ++n26;
                        }
                        if (!bl2) {
                            sArray2[n19] = (short)this.background[n15];
                        }
                        n19 += n11;
                        ++n18;
                    }
                    ++n21;
                }
            } else {
                n21 = n4;
                while (n21 < n8) {
                    n20 = 0;
                    while (n20 < n) {
                        if (rasterAccessorArray[n20] != null) {
                            nArray8[n20] = nArray7[n20];
                            int n31 = n20;
                            nArray7[n31] = nArray7[n31] + nArray[n20];
                        }
                        if (nArray6[n20] == 1) {
                            nArray10[n20] = nArray9[n20];
                            int n32 = n20;
                            nArray9[n32] = nArray9[n32] + nArray4[n20];
                        }
                        ++n20;
                    }
                    n19 = n23;
                    n23 += n10;
                    n18 = n3;
                    while (n18 < n7) {
                        float f2 = 0.0f;
                        float f3 = 0.0f;
                        n17 = 0;
                        while (n17 < n) {
                            if (rasterAccessorArray[n17] != null) {
                                n16 = sArrayArray3[n17][nArray8[n17]];
                                int n33 = n17;
                                nArray8[n33] = nArray8[n33] + nArray2[n17];
                                float f4 = 0.0f;
                                switch (nArray6[n17]) {
                                    case 1: {
                                        f4 = sArrayArray4[n17][nArray10[n17]];
                                        f4 = f4 > 0.0f && this.isAlphaBitmask ? 1.0f : (f4 /= 32767.0f);
                                        int n34 = n17;
                                        nArray10[n34] = nArray10[n34] + nArray5[n17];
                                        break;
                                    }
                                    case 2: {
                                        f4 = rasterArray[n17].getSample(n18, n21, 0) > 0 ? 1.0f : 0.0f;
                                        break;
                                    }
                                    default: {
                                        f4 = (double)n16 >= this.sourceThreshold[n17][n15] ? 1.0f : 0.0f;
                                    }
                                }
                                f2 += f4 * (float)n16;
                                f3 += f4;
                            }
                            ++n17;
                        }
                        sArray2[n19] = (double)f3 == 0.0 ? (short)this.background[n15] : ImageUtil.clampRoundShort(f2 / f3);
                        n19 += n11;
                        ++n18;
                    }
                    ++n21;
                }
            }
            ++n15;
        }
    }

    private void computeRectInt(RasterAccessor[] rasterAccessorArray, RasterAccessor rasterAccessor, RasterAccessor[] rasterAccessorArray2, Raster[] rasterArray) {
        int n = rasterAccessorArray.length;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int[][] nArrayArray = new int[n][];
        int[][][] nArrayArray2 = new int[n][][];
        int n2 = 0;
        while (n2 < n) {
            if (rasterAccessorArray[n2] != null) {
                nArray[n2] = rasterAccessorArray[n2].getScanlineStride();
                nArray2[n2] = rasterAccessorArray[n2].getPixelStride();
                nArrayArray[n2] = rasterAccessorArray[n2].getBandOffsets();
                nArrayArray2[n2] = rasterAccessorArray[n2].getIntDataArrays();
            }
            ++n2;
        }
        int n3 = rasterAccessor.getX();
        int n4 = rasterAccessor.getY();
        int n5 = rasterAccessor.getWidth();
        int n6 = rasterAccessor.getHeight();
        int n7 = n3 + n5;
        int n8 = n4 + n6;
        int n9 = rasterAccessor.getNumBands();
        int n10 = rasterAccessor.getScanlineStride();
        int n11 = rasterAccessor.getPixelStride();
        int[] nArray3 = rasterAccessor.getBandOffsets();
        int[][] nArray4 = rasterAccessor.getIntDataArrays();
        boolean bl = false;
        int n12 = 0;
        while (n12 < n) {
            if (rasterAccessorArray2[n12] != null) {
                bl = true;
                break;
            }
            ++n12;
        }
        int[] nArray5 = null;
        int[] nArray6 = null;
        int[][] nArrayArray3 = null;
        int[][][] nArrayArray4 = null;
        if (bl) {
            nArray5 = new int[n];
            nArray6 = new int[n];
            nArrayArray3 = new int[n][];
            nArrayArray4 = new int[n][][];
            int n13 = 0;
            while (n13 < n) {
                if (rasterAccessorArray2[n13] != null) {
                    nArray5[n13] = rasterAccessorArray2[n13].getScanlineStride();
                    nArray6[n13] = rasterAccessorArray2[n13].getPixelStride();
                    nArrayArray3[n13] = rasterAccessorArray2[n13].getBandOffsets();
                    nArrayArray4[n13] = rasterAccessorArray2[n13].getIntDataArrays();
                }
                ++n13;
            }
        }
        int[] nArray7 = new int[n];
        int n14 = 0;
        while (n14 < n) {
            nArray7[n14] = 3;
            if (rasterAccessorArray2[n14] != null) {
                nArray7[n14] = 1;
            } else if (this.sourceROI != null && this.sourceROI[n14] != null) {
                nArray7[n14] = 2;
            }
            ++n14;
        }
        int[] nArray8 = new int[n];
        int[] nArray9 = new int[n];
        int[][] nArrayArray5 = new int[n][];
        int[] nArray10 = null;
        int[] nArray11 = null;
        int[][] nArrayArray6 = null;
        if (bl) {
            nArray10 = new int[n];
            nArray11 = new int[n];
            nArrayArray6 = new int[n][];
        }
        int n15 = 0;
        while (n15 < n9) {
            int n16;
            int n17;
            int n18;
            int n19;
            int n20 = 0;
            while (n20 < n) {
                if (rasterAccessorArray[n20] != null) {
                    nArrayArray5[n20] = nArrayArray2[n20][n15];
                    nArray8[n20] = nArrayArray[n20][n15];
                }
                if (nArray7[n20] == 1) {
                    nArrayArray6[n20] = nArrayArray4[n20][0];
                    nArray10[n20] = nArrayArray3[n20][0];
                }
                ++n20;
            }
            int[] nArray12 = nArray4[n15];
            int n21 = nArray3[n15];
            if (this.mosaicType == MosaicDescriptor.MOSAIC_TYPE_OVERLAY) {
                n19 = n4;
                while (n19 < n8) {
                    n18 = 0;
                    while (n18 < n) {
                        if (rasterAccessorArray[n18] != null) {
                            nArray9[n18] = nArray8[n18];
                            int n22 = n18;
                            nArray8[n22] = nArray8[n22] + nArray[n18];
                        }
                        if (rasterAccessorArray2[n18] != null) {
                            nArray11[n18] = nArray10[n18];
                            int n23 = n18;
                            nArray10[n23] = nArray10[n23] + nArray5[n18];
                        }
                        ++n18;
                    }
                    n17 = n21;
                    n21 += n10;
                    n16 = n3;
                    while (n16 < n7) {
                        boolean bl2 = false;
                        int n24 = 0;
                        while (n24 < n) {
                            if (rasterAccessorArray[n24] != null) {
                                int n25 = nArrayArray5[n24][nArray9[n24]];
                                int n26 = n24;
                                nArray9[n26] = nArray9[n26] + nArray2[n24];
                                switch (nArray7[n24]) {
                                    case 1: {
                                        bl2 = nArrayArray6[n24][nArray11[n24]] != 0;
                                        int n27 = n24;
                                        nArray11[n27] = nArray11[n27] + nArray6[n24];
                                        break;
                                    }
                                    case 2: {
                                        bl2 = rasterArray[n24].getSample(n16, n19, 0) > 0;
                                        break;
                                    }
                                    default: {
                                        boolean bl3 = bl2 = (double)n25 >= this.sourceThreshold[n24][n15];
                                    }
                                }
                                if (bl2) {
                                    nArray12[n17] = n25;
                                    int n28 = n24 + 1;
                                    while (n28 < n) {
                                        if (rasterAccessorArray[n28] != null) {
                                            int n29 = n28;
                                            nArray9[n29] = nArray9[n29] + nArray2[n28];
                                        }
                                        if (rasterAccessorArray2[n28] != null) {
                                            int n30 = n28;
                                            nArray11[n30] = nArray11[n30] + nArray6[n28];
                                        }
                                        ++n28;
                                    }
                                    break;
                                }
                            }
                            ++n24;
                        }
                        if (!bl2) {
                            nArray12[n17] = this.background[n15];
                        }
                        n17 += n11;
                        ++n16;
                    }
                    ++n19;
                }
            } else {
                n19 = n4;
                while (n19 < n8) {
                    n18 = 0;
                    while (n18 < n) {
                        if (rasterAccessorArray[n18] != null) {
                            nArray9[n18] = nArray8[n18];
                            int n31 = n18;
                            nArray8[n31] = nArray8[n31] + nArray[n18];
                        }
                        if (nArray7[n18] == 1) {
                            nArray11[n18] = nArray10[n18];
                            int n32 = n18;
                            nArray10[n32] = nArray10[n32] + nArray5[n18];
                        }
                        ++n18;
                    }
                    n17 = n21;
                    n21 += n10;
                    n16 = n3;
                    while (n16 < n7) {
                        double d2 = 0.0;
                        double d3 = 0.0;
                        int n33 = 0;
                        while (n33 < n) {
                            if (rasterAccessorArray[n33] != null) {
                                int n34 = nArrayArray5[n33][nArray9[n33]];
                                int n35 = n33;
                                nArray9[n35] = nArray9[n35] + nArray2[n33];
                                double d4 = 0.0;
                                switch (nArray7[n33]) {
                                    case 1: {
                                        d4 = nArrayArray6[n33][nArray11[n33]];
                                        d4 = d4 > 0.0 && this.isAlphaBitmask ? 1.0 : (d4 /= 2.147483647E9);
                                        int n36 = n33;
                                        nArray11[n36] = nArray11[n36] + nArray6[n33];
                                        break;
                                    }
                                    case 2: {
                                        d4 = rasterArray[n33].getSample(n16, n19, 0) > 0 ? 1.0 : 0.0;
                                        break;
                                    }
                                    default: {
                                        d4 = (double)n34 >= this.sourceThreshold[n33][n15] ? 1.0 : 0.0;
                                    }
                                }
                                d2 += d4 * (double)n34;
                                d3 += d4;
                            }
                            ++n33;
                        }
                        nArray12[n17] = d3 == 0.0 ? this.background[n15] : ImageUtil.clampRoundInt(d2 / d3);
                        n17 += n11;
                        ++n16;
                    }
                    ++n19;
                }
            }
            ++n15;
        }
    }

    private void computeRectFloat(RasterAccessor[] rasterAccessorArray, RasterAccessor rasterAccessor, RasterAccessor[] rasterAccessorArray2, Raster[] rasterArray) {
        int n = rasterAccessorArray.length;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int[][] nArrayArray = new int[n][];
        float[][][] fArrayArray = new float[n][][];
        int n2 = 0;
        while (n2 < n) {
            if (rasterAccessorArray[n2] != null) {
                nArray[n2] = rasterAccessorArray[n2].getScanlineStride();
                nArray2[n2] = rasterAccessorArray[n2].getPixelStride();
                nArrayArray[n2] = rasterAccessorArray[n2].getBandOffsets();
                fArrayArray[n2] = rasterAccessorArray[n2].getFloatDataArrays();
            }
            ++n2;
        }
        int n3 = rasterAccessor.getX();
        int n4 = rasterAccessor.getY();
        int n5 = rasterAccessor.getWidth();
        int n6 = rasterAccessor.getHeight();
        int n7 = n3 + n5;
        int n8 = n4 + n6;
        int n9 = rasterAccessor.getNumBands();
        int n10 = rasterAccessor.getScanlineStride();
        int n11 = rasterAccessor.getPixelStride();
        int[] nArray3 = rasterAccessor.getBandOffsets();
        float[][] fArray = rasterAccessor.getFloatDataArrays();
        boolean bl = false;
        int n12 = 0;
        while (n12 < n) {
            if (rasterAccessorArray2[n12] != null) {
                bl = true;
                break;
            }
            ++n12;
        }
        int[] nArray4 = null;
        int[] nArray5 = null;
        int[][] nArrayArray2 = null;
        float[][][] fArrayArray2 = null;
        if (bl) {
            nArray4 = new int[n];
            nArray5 = new int[n];
            nArrayArray2 = new int[n][];
            fArrayArray2 = new float[n][][];
            int n13 = 0;
            while (n13 < n) {
                if (rasterAccessorArray2[n13] != null) {
                    nArray4[n13] = rasterAccessorArray2[n13].getScanlineStride();
                    nArray5[n13] = rasterAccessorArray2[n13].getPixelStride();
                    nArrayArray2[n13] = rasterAccessorArray2[n13].getBandOffsets();
                    fArrayArray2[n13] = rasterAccessorArray2[n13].getFloatDataArrays();
                }
                ++n13;
            }
        }
        int[] nArray6 = new int[n];
        int n14 = 0;
        while (n14 < n) {
            nArray6[n14] = 3;
            if (rasterAccessorArray2[n14] != null) {
                nArray6[n14] = 1;
            } else if (this.sourceROI != null && this.sourceROI[n14] != null) {
                nArray6[n14] = 2;
            }
            ++n14;
        }
        int[] nArray7 = new int[n];
        int[] nArray8 = new int[n];
        float[][] fArrayArray3 = new float[n][];
        int[] nArray9 = null;
        int[] nArray10 = null;
        float[][] fArrayArray4 = null;
        if (bl) {
            nArray9 = new int[n];
            nArray10 = new int[n];
            fArrayArray4 = new float[n][];
        }
        int n15 = 0;
        while (n15 < n9) {
            int n16;
            int n17;
            int n18;
            int n19;
            int n20 = 0;
            while (n20 < n) {
                if (rasterAccessorArray[n20] != null) {
                    fArrayArray3[n20] = fArrayArray[n20][n15];
                    nArray7[n20] = nArrayArray[n20][n15];
                }
                if (nArray6[n20] == 1) {
                    fArrayArray4[n20] = fArrayArray2[n20][0];
                    nArray9[n20] = nArrayArray2[n20][0];
                }
                ++n20;
            }
            float[] fArray2 = fArray[n15];
            int n21 = nArray3[n15];
            if (this.mosaicType == MosaicDescriptor.MOSAIC_TYPE_OVERLAY) {
                n19 = n4;
                while (n19 < n8) {
                    n18 = 0;
                    while (n18 < n) {
                        if (rasterAccessorArray[n18] != null) {
                            nArray8[n18] = nArray7[n18];
                            int n22 = n18;
                            nArray7[n22] = nArray7[n22] + nArray[n18];
                        }
                        if (rasterAccessorArray2[n18] != null) {
                            nArray10[n18] = nArray9[n18];
                            int n23 = n18;
                            nArray9[n23] = nArray9[n23] + nArray4[n18];
                        }
                        ++n18;
                    }
                    n17 = n21;
                    n21 += n10;
                    n16 = n3;
                    while (n16 < n7) {
                        boolean bl2 = false;
                        int n24 = 0;
                        while (n24 < n) {
                            if (rasterAccessorArray[n24] != null) {
                                float f2 = fArrayArray3[n24][nArray8[n24]];
                                int n25 = n24;
                                nArray8[n25] = nArray8[n25] + nArray2[n24];
                                switch (nArray6[n24]) {
                                    case 1: {
                                        bl2 = fArrayArray4[n24][nArray10[n24]] != 0.0f;
                                        int n26 = n24;
                                        nArray10[n26] = nArray10[n26] + nArray5[n24];
                                        break;
                                    }
                                    case 2: {
                                        bl2 = rasterArray[n24].getSample(n16, n19, 0) > 0;
                                        break;
                                    }
                                    default: {
                                        boolean bl3 = bl2 = (double)f2 >= this.sourceThreshold[n24][n15];
                                    }
                                }
                                if (bl2) {
                                    fArray2[n17] = f2;
                                    int n27 = n24 + 1;
                                    while (n27 < n) {
                                        if (rasterAccessorArray[n27] != null) {
                                            int n28 = n27;
                                            nArray8[n28] = nArray8[n28] + nArray2[n27];
                                        }
                                        if (rasterAccessorArray2[n27] != null) {
                                            int n29 = n27;
                                            nArray10[n29] = nArray10[n29] + nArray5[n27];
                                        }
                                        ++n27;
                                    }
                                    break;
                                }
                            }
                            ++n24;
                        }
                        if (!bl2) {
                            fArray2[n17] = (float)this.backgroundValues[n15];
                        }
                        n17 += n11;
                        ++n16;
                    }
                    ++n19;
                }
            } else {
                n19 = n4;
                while (n19 < n8) {
                    n18 = 0;
                    while (n18 < n) {
                        if (rasterAccessorArray[n18] != null) {
                            nArray8[n18] = nArray7[n18];
                            int n30 = n18;
                            nArray7[n30] = nArray7[n30] + nArray[n18];
                        }
                        if (nArray6[n18] == 1) {
                            nArray10[n18] = nArray9[n18];
                            int n31 = n18;
                            nArray9[n31] = nArray9[n31] + nArray4[n18];
                        }
                        ++n18;
                    }
                    n17 = n21;
                    n21 += n10;
                    n16 = n3;
                    while (n16 < n7) {
                        float f3 = 0.0f;
                        float f4 = 0.0f;
                        int n32 = 0;
                        while (n32 < n) {
                            if (rasterAccessorArray[n32] != null) {
                                float f5 = fArrayArray3[n32][nArray8[n32]];
                                int n33 = n32;
                                nArray8[n33] = nArray8[n33] + nArray2[n32];
                                float f6 = 0.0f;
                                switch (nArray6[n32]) {
                                    case 1: {
                                        f6 = fArrayArray4[n32][nArray10[n32]];
                                        if (f6 > 0.0f && this.isAlphaBitmask) {
                                            f6 = 1.0f;
                                        }
                                        int n34 = n32;
                                        nArray10[n34] = nArray10[n34] + nArray5[n32];
                                        break;
                                    }
                                    case 2: {
                                        f6 = rasterArray[n32].getSample(n16, n19, 0) > 0 ? 1.0f : 0.0f;
                                        break;
                                    }
                                    default: {
                                        f6 = (double)f5 >= this.sourceThreshold[n32][n15] ? 1.0f : 0.0f;
                                    }
                                }
                                f3 += f6 * f5;
                                f4 += f6;
                            }
                            ++n32;
                        }
                        fArray2[n17] = (double)f4 == 0.0 ? (float)this.backgroundValues[n15] : f3 / f4;
                        n17 += n11;
                        ++n16;
                    }
                    ++n19;
                }
            }
            ++n15;
        }
    }

    private void computeRectDouble(RasterAccessor[] rasterAccessorArray, RasterAccessor rasterAccessor, RasterAccessor[] rasterAccessorArray2, Raster[] rasterArray) {
        int n = rasterAccessorArray.length;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int[][] nArrayArray = new int[n][];
        double[][][] dArrayArray = new double[n][][];
        int n2 = 0;
        while (n2 < n) {
            if (rasterAccessorArray[n2] != null) {
                nArray[n2] = rasterAccessorArray[n2].getScanlineStride();
                nArray2[n2] = rasterAccessorArray[n2].getPixelStride();
                nArrayArray[n2] = rasterAccessorArray[n2].getBandOffsets();
                dArrayArray[n2] = rasterAccessorArray[n2].getDoubleDataArrays();
            }
            ++n2;
        }
        int n3 = rasterAccessor.getX();
        int n4 = rasterAccessor.getY();
        int n5 = rasterAccessor.getWidth();
        int n6 = rasterAccessor.getHeight();
        int n7 = n3 + n5;
        int n8 = n4 + n6;
        int n9 = rasterAccessor.getNumBands();
        int n10 = rasterAccessor.getScanlineStride();
        int n11 = rasterAccessor.getPixelStride();
        int[] nArray3 = rasterAccessor.getBandOffsets();
        double[][] dArray = rasterAccessor.getDoubleDataArrays();
        boolean bl = false;
        int n12 = 0;
        while (n12 < n) {
            if (rasterAccessorArray2[n12] != null) {
                bl = true;
                break;
            }
            ++n12;
        }
        int[] nArray4 = null;
        int[] nArray5 = null;
        int[][] nArrayArray2 = null;
        double[][][] dArrayArray2 = null;
        if (bl) {
            nArray4 = new int[n];
            nArray5 = new int[n];
            nArrayArray2 = new int[n][];
            dArrayArray2 = new double[n][][];
            int n13 = 0;
            while (n13 < n) {
                if (rasterAccessorArray2[n13] != null) {
                    nArray4[n13] = rasterAccessorArray2[n13].getScanlineStride();
                    nArray5[n13] = rasterAccessorArray2[n13].getPixelStride();
                    nArrayArray2[n13] = rasterAccessorArray2[n13].getBandOffsets();
                    dArrayArray2[n13] = rasterAccessorArray2[n13].getDoubleDataArrays();
                }
                ++n13;
            }
        }
        int[] nArray6 = new int[n];
        int n14 = 0;
        while (n14 < n) {
            nArray6[n14] = 3;
            if (rasterAccessorArray2[n14] != null) {
                nArray6[n14] = 1;
            } else if (this.sourceROI != null && this.sourceROI[n14] != null) {
                nArray6[n14] = 2;
            }
            ++n14;
        }
        int[] nArray7 = new int[n];
        int[] nArray8 = new int[n];
        double[][] dArrayArray3 = new double[n][];
        int[] nArray9 = null;
        int[] nArray10 = null;
        double[][] dArrayArray4 = null;
        if (bl) {
            nArray9 = new int[n];
            nArray10 = new int[n];
            dArrayArray4 = new double[n][];
        }
        int n15 = 0;
        while (n15 < n9) {
            int n16;
            double d2;
            int n17;
            int n18;
            int n19;
            int n20;
            int n21 = 0;
            while (n21 < n) {
                if (rasterAccessorArray[n21] != null) {
                    dArrayArray3[n21] = dArrayArray[n21][n15];
                    nArray7[n21] = nArrayArray[n21][n15];
                }
                if (nArray6[n21] == 1) {
                    dArrayArray4[n21] = dArrayArray2[n21][0];
                    nArray9[n21] = nArrayArray2[n21][0];
                }
                ++n21;
            }
            double[] dArray2 = dArray[n15];
            int n22 = nArray3[n15];
            if (this.mosaicType == MosaicDescriptor.MOSAIC_TYPE_OVERLAY) {
                n20 = n4;
                while (n20 < n8) {
                    n19 = 0;
                    while (n19 < n) {
                        if (rasterAccessorArray[n19] != null) {
                            nArray8[n19] = nArray7[n19];
                            int n23 = n19;
                            nArray7[n23] = nArray7[n23] + nArray[n19];
                        }
                        if (rasterAccessorArray2[n19] != null) {
                            nArray10[n19] = nArray9[n19];
                            int n24 = n19;
                            nArray9[n24] = nArray9[n24] + nArray4[n19];
                        }
                        ++n19;
                    }
                    n18 = n22;
                    n22 += n10;
                    n17 = n3;
                    while (n17 < n7) {
                        boolean bl2 = false;
                        int n25 = 0;
                        while (n25 < n) {
                            if (rasterAccessorArray[n25] != null) {
                                d2 = dArrayArray3[n25][nArray8[n25]];
                                int n26 = n25;
                                nArray8[n26] = nArray8[n26] + nArray2[n25];
                                switch (nArray6[n25]) {
                                    case 1: {
                                        bl2 = dArrayArray4[n25][nArray10[n25]] != 0.0;
                                        int n27 = n25;
                                        nArray10[n27] = nArray10[n27] + nArray5[n25];
                                        break;
                                    }
                                    case 2: {
                                        bl2 = rasterArray[n25].getSample(n17, n20, 0) > 0;
                                        break;
                                    }
                                    default: {
                                        boolean bl3 = bl2 = d2 >= this.sourceThreshold[n25][n15];
                                    }
                                }
                                if (bl2) {
                                    dArray2[n18] = d2;
                                    n16 = n25 + 1;
                                    while (n16 < n) {
                                        if (rasterAccessorArray[n16] != null) {
                                            int n28 = n16;
                                            nArray8[n28] = nArray8[n28] + nArray2[n16];
                                        }
                                        if (rasterAccessorArray2[n16] != null) {
                                            int n29 = n16;
                                            nArray10[n29] = nArray10[n29] + nArray5[n16];
                                        }
                                        ++n16;
                                    }
                                    break;
                                }
                            }
                            ++n25;
                        }
                        if (!bl2) {
                            dArray2[n18] = this.backgroundValues[n15];
                        }
                        n18 += n11;
                        ++n17;
                    }
                    ++n20;
                }
            } else {
                n20 = n4;
                while (n20 < n8) {
                    n19 = 0;
                    while (n19 < n) {
                        if (rasterAccessorArray[n19] != null) {
                            nArray8[n19] = nArray7[n19];
                            int n30 = n19;
                            nArray7[n30] = nArray7[n30] + nArray[n19];
                        }
                        if (nArray6[n19] == 1) {
                            nArray10[n19] = nArray9[n19];
                            int n31 = n19;
                            nArray9[n31] = nArray9[n31] + nArray4[n19];
                        }
                        ++n19;
                    }
                    n18 = n22;
                    n22 += n10;
                    n17 = n3;
                    while (n17 < n7) {
                        double d3 = 0.0;
                        d2 = 0.0;
                        n16 = 0;
                        while (n16 < n) {
                            if (rasterAccessorArray[n16] != null) {
                                double d4 = dArrayArray3[n16][nArray8[n16]];
                                int n32 = n16;
                                nArray8[n32] = nArray8[n32] + nArray2[n16];
                                double d5 = 0.0;
                                switch (nArray6[n16]) {
                                    case 1: {
                                        d5 = dArrayArray4[n16][nArray10[n16]];
                                        if (d5 > 0.0 && this.isAlphaBitmask) {
                                            d5 = 1.0;
                                        }
                                        int n33 = n16;
                                        nArray10[n33] = nArray10[n33] + nArray5[n16];
                                        break;
                                    }
                                    case 2: {
                                        d5 = rasterArray[n16].getSample(n17, n20, 0) > 0 ? 1.0 : 0.0;
                                        break;
                                    }
                                    default: {
                                        d5 = d4 >= this.sourceThreshold[n16][n15] ? 1.0 : 0.0;
                                    }
                                }
                                d3 += d5 * d4;
                                d2 += d5;
                            }
                            ++n16;
                        }
                        dArray2[n18] = d2 == 0.0 ? this.backgroundValues[n15] : d3 / d2;
                        n18 += n11;
                        ++n17;
                    }
                    ++n20;
                }
            }
            ++n15;
        }
    }
}

