/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.util.ImageUtil;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ColormapOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

final class PiecewiseOpImage
extends ColormapOpImage {
    private float[][] abscissas;
    private float[][] slopes;
    private float[][] intercepts;
    private float[] minOrdinates;
    private float[] maxOrdinates;
    private boolean isByteData = false;
    private LookupTableJAI lut;

    private static float binarySearch(float[] fArray, float f2, float f3, float[] fArray2, float[] fArray3, float f4) {
        int n = fArray.length - 1;
        if (f4 <= fArray[0]) {
            return f2;
        }
        if (f4 >= fArray[n]) {
            return f3;
        }
        int n2 = 0;
        int n3 = n - n2;
        while (n3 > 1) {
            int n4 = n2 + n3 / 2;
            if (f4 >= fArray[n4]) {
                n2 = n4;
            } else {
                n = n4;
            }
            n3 = n - n2;
        }
        return fArray2[n2] * f4 + fArray3[n2];
    }

    public PiecewiseOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, float[][][] fArray) {
        super(renderedImage, imageLayout, map, true);
        int n = this.sampleModel.getNumBands();
        this.initFields(n, fArray);
        boolean bl = this.isByteData = this.sampleModel.getTransferType() == 0;
        if (this.isByteData) {
            this.createLUT();
            this.unsetFields();
        }
        this.permitInPlaceOperation();
        this.initializeColormapOperation();
    }

    protected void transformColormap(byte[][] byArray) {
        byte[][] byArray2 = this.lut.getByteData();
        int n = 0;
        while (n < 3) {
            byte[] byArray3 = byArray[n];
            byte[] byArray4 = byArray2[n >= byArray2.length ? 0 : n];
            int n2 = byArray3.length;
            int n3 = 0;
            while (n3 < n2) {
                byArray3[n3] = byArray4[byArray3[n3] & 0xFF];
                ++n3;
            }
            ++n;
        }
    }

    private void initFields(int n, float[][][] fArray) {
        this.abscissas = new float[n][];
        this.slopes = new float[n][];
        this.intercepts = new float[n][];
        this.minOrdinates = new float[n];
        this.maxOrdinates = new float[n];
        int n2 = 0;
        while (n2 < n) {
            this.abscissas[n2] = fArray.length == 1 ? fArray[0][0] : fArray[n2][0];
            int n3 = this.abscissas[n2].length - 1;
            this.minOrdinates[n2] = fArray.length == 1 ? fArray[0][1][0] : fArray[n2][1][0];
            this.maxOrdinates[n2] = fArray.length == 1 ? fArray[0][1][n3] : fArray[n2][1][n3];
            this.slopes[n2] = new float[n3];
            this.intercepts[n2] = new float[n3];
            float[] fArray2 = this.abscissas[n2];
            float[] fArray3 = fArray.length == 1 ? fArray[0][1] : fArray[n2][1];
            float[] fArray4 = this.slopes[n2];
            float[] fArray5 = this.intercepts[n2];
            int n4 = 0;
            while (n4 < n3) {
                int n5 = n4 + 1;
                fArray4[n4] = (fArray3[n5] - fArray3[n4]) / (fArray2[n5] - fArray2[n4]);
                fArray5[n4] = fArray3[n4] - fArray2[n4] * fArray4[n4];
                ++n4;
            }
            ++n2;
        }
    }

    private void unsetFields() {
        this.abscissas = null;
        this.slopes = null;
        this.intercepts = null;
        this.minOrdinates = null;
        this.maxOrdinates = null;
    }

    private void createLUT() {
        int n = this.abscissas.length;
        byte[][] byArrayArray = new byte[n][];
        int n2 = 0;
        while (n2 < n) {
            byArrayArray[n2] = new byte[256];
            byte[] byArray = byArrayArray[n2];
            float[] fArray = this.abscissas[n2];
            float[] fArray2 = this.slopes[n2];
            float[] fArray3 = this.intercepts[n2];
            float f2 = this.minOrdinates[n2];
            float f3 = this.maxOrdinates[n2];
            int n3 = 0;
            while (n3 < 256) {
                byArray[n3] = ImageUtil.clampRoundByte(PiecewiseOpImage.binarySearch(fArray, f2, f3, fArray2, fArray3, n3));
                ++n3;
            }
            ++n2;
        }
        this.lut = new LookupTableJAI(byArrayArray);
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        if (this.isByteData) {
            this.computeRectByte(rasterArray, writableRaster, rectangle);
        } else {
            RasterAccessor rasterAccessor = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
            RasterAccessor rasterAccessor2 = new RasterAccessor(rasterArray[0], rectangle, rasterFormatTagArray[0], this.getSource(0).getColorModel());
            switch (rasterAccessor.getDataType()) {
                case 1: {
                    this.computeRectUShort(rasterAccessor2, rasterAccessor);
                    break;
                }
                case 2: {
                    this.computeRectShort(rasterAccessor2, rasterAccessor);
                    break;
                }
                case 3: {
                    this.computeRectInt(rasterAccessor2, rasterAccessor);
                    break;
                }
                case 4: {
                    this.computeRectFloat(rasterAccessor2, rasterAccessor);
                    break;
                }
                case 5: {
                    this.computeRectDouble(rasterAccessor2, rasterAccessor);
                }
            }
            rasterAccessor.copyDataToRaster();
        }
    }

    private void computeRectByte(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        this.lut.lookup(rasterArray[0], writableRaster, rectangle);
    }

    private void computeRectUShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray = rasterAccessor2.getBandOffsets();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int n6 = rasterAccessor.getScanlineStride();
        int n7 = rasterAccessor.getPixelStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int n8 = 0;
        while (n8 < n3) {
            short[] sArray3 = sArray[n8];
            short[] sArray4 = sArray2[n8];
            int n9 = nArray[n8];
            int n10 = nArray2[n8];
            float[] fArray = this.abscissas[n8];
            float[] fArray2 = this.slopes[n8];
            float[] fArray3 = this.intercepts[n8];
            float f2 = this.minOrdinates[n8];
            float f3 = this.maxOrdinates[n8];
            int n11 = 0;
            while (n11 < n2) {
                int n12 = n9;
                int n13 = n10;
                n9 += n4;
                n10 += n6;
                int n14 = 0;
                while (n14 < n) {
                    sArray3[n12] = ImageUtil.clampRoundUShort(PiecewiseOpImage.binarySearch(fArray, f2, f3, fArray2, fArray3, sArray4[n13] & 0xFFFF));
                    n12 += n5;
                    n13 += n7;
                    ++n14;
                }
                ++n11;
            }
            ++n8;
        }
    }

    private void computeRectShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray = rasterAccessor2.getBandOffsets();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int n6 = rasterAccessor.getScanlineStride();
        int n7 = rasterAccessor.getPixelStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int n8 = 0;
        while (n8 < n3) {
            short[] sArray3 = sArray[n8];
            short[] sArray4 = sArray2[n8];
            int n9 = nArray[n8];
            int n10 = nArray2[n8];
            float[] fArray = this.abscissas[n8];
            float[] fArray2 = this.slopes[n8];
            float[] fArray3 = this.intercepts[n8];
            float f2 = this.minOrdinates[n8];
            float f3 = this.maxOrdinates[n8];
            int n11 = 0;
            while (n11 < n2) {
                int n12 = n9;
                int n13 = n10;
                n9 += n4;
                n10 += n6;
                int n14 = 0;
                while (n14 < n) {
                    sArray3[n12] = ImageUtil.clampRoundShort(PiecewiseOpImage.binarySearch(fArray, f2, f3, fArray2, fArray3, sArray4[n13]));
                    n12 += n5;
                    n13 += n7;
                    ++n14;
                }
                ++n11;
            }
            ++n8;
        }
    }

    private void computeRectInt(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int[][] nArray2 = rasterAccessor2.getIntDataArrays();
        int n6 = rasterAccessor.getScanlineStride();
        int n7 = rasterAccessor.getPixelStride();
        int[] nArray3 = rasterAccessor.getBandOffsets();
        int[][] nArray4 = rasterAccessor.getIntDataArrays();
        int n8 = 0;
        while (n8 < n3) {
            int[] nArray5 = nArray2[n8];
            int[] nArray6 = nArray4[n8];
            int n9 = nArray[n8];
            int n10 = nArray3[n8];
            float[] fArray = this.abscissas[n8];
            float[] fArray2 = this.slopes[n8];
            float[] fArray3 = this.intercepts[n8];
            float f2 = this.minOrdinates[n8];
            float f3 = this.maxOrdinates[n8];
            int n11 = 0;
            while (n11 < n2) {
                int n12 = n9;
                int n13 = n10;
                n9 += n4;
                n10 += n6;
                int n14 = 0;
                while (n14 < n) {
                    nArray5[n12] = ImageUtil.clampRoundInt(PiecewiseOpImage.binarySearch(fArray, f2, f3, fArray2, fArray3, nArray6[n13]));
                    n12 += n5;
                    n13 += n7;
                    ++n14;
                }
                ++n11;
            }
            ++n8;
        }
    }

    private void computeRectFloat(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray = rasterAccessor2.getBandOffsets();
        float[][] fArray = rasterAccessor2.getFloatDataArrays();
        int n6 = rasterAccessor.getScanlineStride();
        int n7 = rasterAccessor.getPixelStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        float[][] fArray2 = rasterAccessor.getFloatDataArrays();
        int n8 = 0;
        while (n8 < n3) {
            float[] fArray3 = fArray[n8];
            float[] fArray4 = fArray2[n8];
            int n9 = nArray[n8];
            int n10 = nArray2[n8];
            float[] fArray5 = this.abscissas[n8];
            float[] fArray6 = this.slopes[n8];
            float[] fArray7 = this.intercepts[n8];
            float f2 = this.minOrdinates[n8];
            float f3 = this.maxOrdinates[n8];
            int n11 = 0;
            while (n11 < n2) {
                int n12 = n9;
                int n13 = n10;
                n9 += n4;
                n10 += n6;
                int n14 = 0;
                while (n14 < n) {
                    fArray3[n12] = PiecewiseOpImage.binarySearch(fArray5, f2, f3, fArray6, fArray7, fArray4[n13]);
                    n12 += n5;
                    n13 += n7;
                    ++n14;
                }
                ++n11;
            }
            ++n8;
        }
    }

    private void computeRectDouble(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        int n4 = rasterAccessor2.getScanlineStride();
        int n5 = rasterAccessor2.getPixelStride();
        int[] nArray = rasterAccessor2.getBandOffsets();
        double[][] dArray = rasterAccessor2.getDoubleDataArrays();
        int n6 = rasterAccessor.getScanlineStride();
        int n7 = rasterAccessor.getPixelStride();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        double[][] dArray2 = rasterAccessor.getDoubleDataArrays();
        int n8 = 0;
        while (n8 < n3) {
            double[] dArray3 = dArray[n8];
            double[] dArray4 = dArray2[n8];
            int n9 = nArray[n8];
            int n10 = nArray2[n8];
            float[] fArray = this.abscissas[n8];
            float[] fArray2 = this.slopes[n8];
            float[] fArray3 = this.intercepts[n8];
            float f2 = this.minOrdinates[n8];
            float f3 = this.maxOrdinates[n8];
            int n11 = 0;
            while (n11 < n2) {
                int n12 = n9;
                int n13 = n10;
                n9 += n4;
                n10 += n6;
                int n14 = 0;
                while (n14 < n) {
                    dArray3[n12] = PiecewiseOpImage.binarySearch(fArray, f2, f3, fArray2, fArray3, (float)dArray4[n13]);
                    n12 += n5;
                    n13 += n7;
                    ++n14;
                }
                ++n11;
            }
            ++n8;
        }
    }
}

