/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.CopyOpImage;
import com.sun.media.jai.opimage.RIFUtil;
import com.sun.media.jai.opimage.ScaleBicubicOpImage;
import com.sun.media.jai.opimage.ScaleBilinearBinaryOpImage;
import com.sun.media.jai.opimage.ScaleBilinearOpImage;
import com.sun.media.jai.opimage.ScaleGeneralOpImage;
import com.sun.media.jai.opimage.ScaleNearestBinaryOpImage;
import com.sun.media.jai.opimage.ScaleNearestOpImage;
import com.sun.media.jai.opimage.TranslateIntOpImage;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import javax.media.jai.BorderExtender;
import javax.media.jai.CRIFImpl;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationBicubic;
import javax.media.jai.InterpolationBicubic2;
import javax.media.jai.InterpolationBilinear;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.TileCache;

public class ScaleCRIF
extends CRIFImpl {
    private static final float TOLERANCE = 0.01f;

    public ScaleCRIF() {
        super("scale");
    }

    public RenderedImage create(ParameterBlock parameterBlock, RenderingHints renderingHints) {
        ImageLayout imageLayout = RIFUtil.getImageLayoutHint(renderingHints);
        TileCache tileCache = RIFUtil.getTileCacheHint(renderingHints);
        BorderExtender borderExtender = RIFUtil.getBorderExtenderHint(renderingHints);
        RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
        float f2 = parameterBlock.getFloatParameter(0);
        float f3 = parameterBlock.getFloatParameter(1);
        float f4 = parameterBlock.getFloatParameter(2);
        float f5 = parameterBlock.getFloatParameter(3);
        Interpolation interpolation = (Interpolation)parameterBlock.getObjectParameter(4);
        if (f2 == 1.0f && f3 == 1.0f && f4 == 0.0f && f5 == 0.0f) {
            return new CopyOpImage(renderedImage, renderingHints, imageLayout);
        }
        if (f2 == 1.0f && f3 == 1.0f && Math.abs(f4 - (float)((int)f4)) < 0.01f && Math.abs(f5 - (float)((int)f5)) < 0.01f && imageLayout == null) {
            return new TranslateIntOpImage(renderedImage, renderingHints, (int)f4, (int)f5);
        }
        if (interpolation instanceof InterpolationNearest) {
            SampleModel sampleModel = renderedImage.getSampleModel();
            if (sampleModel instanceof MultiPixelPackedSampleModel && sampleModel.getSampleSize(0) == 1 && (sampleModel.getDataType() == 0 || sampleModel.getDataType() == 1 || sampleModel.getDataType() == 3)) {
                return new ScaleNearestBinaryOpImage(renderedImage, borderExtender, renderingHints, imageLayout, f2, f3, f4, f5, interpolation);
            }
            return new ScaleNearestOpImage(renderedImage, borderExtender, renderingHints, imageLayout, f2, f3, f4, f5, interpolation);
        }
        if (interpolation instanceof InterpolationBilinear) {
            SampleModel sampleModel = renderedImage.getSampleModel();
            if (sampleModel instanceof MultiPixelPackedSampleModel && sampleModel.getSampleSize(0) == 1 && (sampleModel.getDataType() == 0 || sampleModel.getDataType() == 1 || sampleModel.getDataType() == 3)) {
                return new ScaleBilinearBinaryOpImage(renderedImage, borderExtender, renderingHints, imageLayout, f2, f3, f4, f5, interpolation);
            }
            return new ScaleBilinearOpImage(renderedImage, borderExtender, renderingHints, imageLayout, f2, f3, f4, f5, interpolation);
        }
        if (interpolation instanceof InterpolationBicubic || interpolation instanceof InterpolationBicubic2) {
            return new ScaleBicubicOpImage(renderedImage, borderExtender, renderingHints, imageLayout, f2, f3, f4, f5, interpolation);
        }
        return new ScaleGeneralOpImage(renderedImage, borderExtender, renderingHints, imageLayout, f2, f3, f4, f5, interpolation);
    }

    public RenderedImage create(RenderContext renderContext, ParameterBlock parameterBlock) {
        return parameterBlock.getRenderedSource(0);
    }

    public RenderContext mapRenderContext(int n, RenderContext renderContext, ParameterBlock parameterBlock, RenderableImage renderableImage) {
        float f2 = parameterBlock.getFloatParameter(0);
        float f3 = parameterBlock.getFloatParameter(1);
        float f4 = parameterBlock.getFloatParameter(2);
        float f5 = parameterBlock.getFloatParameter(3);
        AffineTransform affineTransform = new AffineTransform((double)f2, 0.0, 0.0, (double)f3, (double)f4, (double)f5);
        RenderContext renderContext2 = (RenderContext)renderContext.clone();
        AffineTransform affineTransform2 = renderContext2.getTransform();
        affineTransform2.concatenate(affineTransform);
        renderContext2.setTransform(affineTransform2);
        return renderContext2;
    }

    public Rectangle2D getBounds2D(ParameterBlock parameterBlock) {
        RenderableImage renderableImage = parameterBlock.getRenderableSource(0);
        float f2 = parameterBlock.getFloatParameter(0);
        float f3 = parameterBlock.getFloatParameter(1);
        float f4 = parameterBlock.getFloatParameter(2);
        float f5 = parameterBlock.getFloatParameter(3);
        Interpolation interpolation = (Interpolation)parameterBlock.getObjectParameter(4);
        float f6 = renderableImage.getMinX();
        float f7 = renderableImage.getMinY();
        float f8 = renderableImage.getWidth();
        float f9 = renderableImage.getHeight();
        float f10 = f6 * f2 + f4;
        float f11 = f7 * f3 + f5;
        float f12 = f8 * f2;
        float f13 = f9 * f3;
        return new Rectangle2D.Float(f10, f11, f12, f13);
    }
}

