/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.CopyOpImage;
import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.opimage.RIFUtil;
import com.sun.media.jai.opimage.SubsampleBinaryToGray2x2OpImage;
import com.sun.media.jai.opimage.SubsampleBinaryToGray4x4OpImage;
import com.sun.media.jai.opimage.SubsampleBinaryToGrayOpImage;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.CRIFImpl;
import javax.media.jai.ImageLayout;

public class SubsampleBinaryToGrayCRIF
extends CRIFImpl {
    public SubsampleBinaryToGrayCRIF() {
        super("subsamplebinarytogray");
    }

    public RenderedImage create(ParameterBlock parameterBlock, RenderingHints renderingHints) {
        ImageLayout imageLayout = RIFUtil.getImageLayoutHint(renderingHints);
        BorderExtender borderExtender = RIFUtil.getBorderExtenderHint(renderingHints);
        RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
        float f2 = parameterBlock.getFloatParameter(0);
        float f3 = parameterBlock.getFloatParameter(1);
        if (f2 == 1.0f && f3 == 1.0f) {
            return new CopyOpImage(renderedImage, renderingHints, imageLayout);
        }
        SampleModel sampleModel = renderedImage.getSampleModel();
        if (sampleModel instanceof MultiPixelPackedSampleModel && sampleModel.getSampleSize(0) == 1 && (sampleModel.getDataType() == 0 || sampleModel.getDataType() == 1 || sampleModel.getDataType() == 3)) {
            int n = renderedImage.getWidth();
            int n2 = renderedImage.getHeight();
            float f4 = 0.1f * Math.min(f2 / ((float)n * f2 + 1.0f), f3 / ((float)n2 * f3 + 1.0f));
            int n3 = Math.round(1.0f / f2);
            if (Math.abs((float)n3 - 1.0f / f2) < f4 && Math.abs((float)n3 - 1.0f / f3) < f4) {
                switch (n3) {
                    case 2: {
                        return new SubsampleBinaryToGray2x2OpImage(renderedImage, imageLayout, (Map)renderingHints);
                    }
                    case 4: {
                        return new SubsampleBinaryToGray4x4OpImage(renderedImage, imageLayout, (Map)renderingHints);
                    }
                }
            }
            return new SubsampleBinaryToGrayOpImage(renderedImage, imageLayout, renderingHints, f2, f3);
        }
        throw new IllegalArgumentException(JaiI18N.getString("SubsampleBinaryToGray3"));
    }

    public RenderedImage create(RenderContext renderContext, ParameterBlock parameterBlock) {
        return parameterBlock.getRenderedSource(0);
    }

    public RenderContext mapRenderContext(int n, RenderContext renderContext, ParameterBlock parameterBlock, RenderableImage renderableImage) {
        float f2 = parameterBlock.getFloatParameter(0);
        float f3 = parameterBlock.getFloatParameter(1);
        AffineTransform affineTransform = new AffineTransform((double)f2, 0.0, 0.0, (double)f3, 0.0, 0.0);
        RenderContext renderContext2 = (RenderContext)renderContext.clone();
        AffineTransform affineTransform2 = renderContext2.getTransform();
        affineTransform2.concatenate(affineTransform);
        renderContext2.setTransform(affineTransform2);
        return renderContext2;
    }

    public Rectangle2D getBounds2D(ParameterBlock parameterBlock) {
        RenderableImage renderableImage = parameterBlock.getRenderableSource(0);
        float f2 = parameterBlock.getFloatParameter(0);
        float f3 = parameterBlock.getFloatParameter(1);
        float f4 = renderableImage.getMinX();
        float f5 = renderableImage.getMinY();
        float f6 = renderableImage.getWidth();
        float f7 = renderableImage.getHeight();
        float f8 = f4 * f2;
        float f9 = f5 * f3;
        float f10 = f6 * f2;
        float f11 = f7 * f3;
        return new Rectangle2D.Float(f8, f9, f10, f11);
    }
}

