/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.util.ImageUtil;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.Warp;
import javax.media.jai.WarpOpImage;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;

final class WarpGeneralOpImage
extends WarpOpImage {
    private byte[][] ctable = null;

    public WarpGeneralOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, Warp warp, Interpolation interpolation, double[] dArray) {
        super(renderedImage, imageLayout, map, false, borderExtender, interpolation, warp, dArray);
        ColorModel colorModel = renderedImage.getColorModel();
        if (colorModel instanceof IndexColorModel) {
            IndexColorModel indexColorModel = (IndexColorModel)colorModel;
            this.ctable = new byte[3][indexColorModel.getMapSize()];
            indexColorModel.getReds(this.ctable[0]);
            indexColorModel.getGreens(this.ctable[1]);
            indexColorModel.getBlues(this.ctable[2]);
        }
    }

    protected void computeRect(PlanarImage[] planarImageArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        RasterAccessor rasterAccessor = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        switch (rasterAccessor.getDataType()) {
            case 0: {
                this.computeRectByte(planarImageArray[0], rasterAccessor);
                break;
            }
            case 1: {
                this.computeRectUShort(planarImageArray[0], rasterAccessor);
                break;
            }
            case 2: {
                this.computeRectShort(planarImageArray[0], rasterAccessor);
                break;
            }
            case 3: {
                this.computeRectInt(planarImageArray[0], rasterAccessor);
                break;
            }
            case 4: {
                this.computeRectFloat(planarImageArray[0], rasterAccessor);
                break;
            }
            case 5: {
                this.computeRectDouble(planarImageArray[0], rasterAccessor);
            }
        }
        if (rasterAccessor.isDataCopy()) {
            rasterAccessor.clampDataArrays();
            rasterAccessor.copyDataToRaster();
        }
    }

    private void computeRectByte(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        if (this.interp != null) {
            n8 = this.interp.getLeftPadding();
            n7 = this.interp.getRightPadding();
            n6 = this.interp.getTopPadding();
            n5 = this.interp.getBottomPadding();
        } else {
            n5 = 0;
            n6 = 0;
            n7 = 0;
            n8 = 0;
        }
        if (this.extender != null) {
            n4 = planarImage.getMinX();
            n3 = planarImage.getMaxX();
            n2 = planarImage.getMinY();
            n = planarImage.getMaxY();
            Rectangle rectangle = new Rectangle(planarImage.getMinX() - n8, planarImage.getMinY() - n6, planarImage.getWidth() + n8 + n7, planarImage.getHeight() + n6 + n5);
            randomIter = RandomIterFactory.create(planarImage.getExtendedData(rectangle, this.extender), rectangle);
        } else {
            n4 = planarImage.getMinX() + n8;
            n3 = planarImage.getMaxX() - n7;
            n2 = planarImage.getMinY() + n6;
            n = planarImage.getMaxY() - n5;
            randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        }
        int n9 = this.interp.getWidth();
        int n10 = this.interp.getHeight();
        int n11 = rasterAccessor.getWidth();
        int n12 = rasterAccessor.getHeight();
        int n13 = rasterAccessor.getNumBands();
        int n14 = rasterAccessor.getScanlineStride();
        int n15 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        byte[][] byArray = rasterAccessor.getByteDataArrays();
        int n16 = 1 << this.interp.getSubsampleBitsH();
        int n17 = 1 << this.interp.getSubsampleBitsV();
        float[] fArray = new float[2 * n11];
        int[][] nArray2 = new int[n10][n9];
        int n18 = 0;
        byte[] byArray2 = new byte[n13];
        int n19 = 0;
        while (n19 < n13) {
            byArray2[n19] = (byte)this.backgroundValues[n19];
            ++n19;
        }
        if (this.ctable == null) {
            int n20 = 0;
            while (n20 < n12) {
                int n21 = n18;
                n18 += n14;
                this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n20, n11, 1, fArray);
                int n22 = 0;
                int n23 = 0;
                while (n23 < n11) {
                    int n24;
                    float f2 = fArray[n22++];
                    float f3 = fArray[n22++];
                    int n25 = WarpGeneralOpImage.floor(f2);
                    int n26 = WarpGeneralOpImage.floor(f3);
                    int n27 = (int)((f2 - (float)n25) * (float)n16);
                    int n28 = (int)((f3 - (float)n26) * (float)n17);
                    if (n25 < n4 || n25 >= n3 || n26 < n2 || n26 >= n) {
                        if (this.setBackground) {
                            n24 = 0;
                            while (n24 < n13) {
                                byArray[n24][n21 + nArray[n24]] = byArray2[n24];
                                ++n24;
                            }
                        }
                    } else {
                        n25 -= n8;
                        n26 -= n6;
                        n24 = 0;
                        while (n24 < n13) {
                            int n29 = 0;
                            while (n29 < n10) {
                                int n30 = 0;
                                while (n30 < n9) {
                                    nArray2[n29][n30] = randomIter.getSample(n25 + n30, n26 + n29, n24) & 0xFF;
                                    ++n30;
                                }
                                ++n29;
                            }
                            byArray[n24][n21 + nArray[n24]] = ImageUtil.clampByte(this.interp.interpolate(nArray2, n27, n28));
                            ++n24;
                        }
                    }
                    n21 += n15;
                    ++n23;
                }
                ++n20;
            }
        } else {
            int n31 = 0;
            while (n31 < n12) {
                int n32 = n18;
                n18 += n14;
                this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n31, n11, 1, fArray);
                int n33 = 0;
                int n34 = 0;
                while (n34 < n11) {
                    int n35;
                    float f4 = fArray[n33++];
                    float f5 = fArray[n33++];
                    int n36 = WarpGeneralOpImage.floor(f4);
                    int n37 = WarpGeneralOpImage.floor(f5);
                    int n38 = (int)((f4 - (float)n36) * (float)n16);
                    int n39 = (int)((f5 - (float)n37) * (float)n17);
                    if (n36 < n4 || n36 >= n3 || n37 < n2 || n37 >= n) {
                        if (this.setBackground) {
                            n35 = 0;
                            while (n35 < n13) {
                                byArray[n35][n32 + nArray[n35]] = byArray2[n35];
                                ++n35;
                            }
                        }
                    } else {
                        n36 -= n8;
                        n37 -= n6;
                        n35 = 0;
                        while (n35 < n13) {
                            byte[] byArray3 = this.ctable[n35];
                            int n40 = 0;
                            while (n40 < n10) {
                                int n41 = 0;
                                while (n41 < n9) {
                                    nArray2[n40][n41] = byArray3[randomIter.getSample(n36 + n41, n37 + n40, 0) & 0xFF] & 0xFF;
                                    ++n41;
                                }
                                ++n40;
                            }
                            byArray[n35][n32 + nArray[n35]] = ImageUtil.clampByte(this.interp.interpolate(nArray2, n38, n39));
                            ++n35;
                        }
                    }
                    n32 += n15;
                    ++n34;
                }
                ++n31;
            }
        }
    }

    private void computeRectUShort(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        if (this.interp != null) {
            n8 = this.interp.getLeftPadding();
            n7 = this.interp.getRightPadding();
            n6 = this.interp.getTopPadding();
            n5 = this.interp.getBottomPadding();
        } else {
            n5 = 0;
            n6 = 0;
            n7 = 0;
            n8 = 0;
        }
        if (this.extender != null) {
            n4 = planarImage.getMinX();
            n3 = planarImage.getMaxX();
            n2 = planarImage.getMinY();
            n = planarImage.getMaxY();
            Rectangle rectangle = new Rectangle(planarImage.getMinX() - n8, planarImage.getMinY() - n6, planarImage.getWidth() + n8 + n7, planarImage.getHeight() + n6 + n5);
            randomIter = RandomIterFactory.create(planarImage.getExtendedData(rectangle, this.extender), rectangle);
        } else {
            n4 = planarImage.getMinX() + n8;
            n3 = planarImage.getMaxX() - n7;
            n2 = planarImage.getMinY() + n6;
            n = planarImage.getMaxY() - n5;
            randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        }
        int n9 = this.interp.getWidth();
        int n10 = this.interp.getHeight();
        int n11 = rasterAccessor.getWidth();
        int n12 = rasterAccessor.getHeight();
        int n13 = rasterAccessor.getNumBands();
        int n14 = rasterAccessor.getScanlineStride();
        int n15 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n16 = 1 << this.interp.getSubsampleBitsH();
        int n17 = 1 << this.interp.getSubsampleBitsV();
        float[] fArray = new float[2 * n11];
        int[][] nArray2 = new int[n10][n9];
        int n18 = 0;
        short[] sArray2 = new short[n13];
        int n19 = 0;
        while (n19 < n13) {
            sArray2[n19] = (short)this.backgroundValues[n19];
            ++n19;
        }
        int n20 = 0;
        while (n20 < n12) {
            int n21 = n18;
            n18 += n14;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n20, n11, 1, fArray);
            int n22 = 0;
            int n23 = 0;
            while (n23 < n11) {
                int n24;
                float f2 = fArray[n22++];
                float f3 = fArray[n22++];
                int n25 = WarpGeneralOpImage.floor(f2);
                int n26 = WarpGeneralOpImage.floor(f3);
                int n27 = (int)((f2 - (float)n25) * (float)n16);
                int n28 = (int)((f3 - (float)n26) * (float)n17);
                if (n25 < n4 || n25 >= n3 || n26 < n2 || n26 >= n) {
                    if (this.setBackground) {
                        n24 = 0;
                        while (n24 < n13) {
                            sArray[n24][n21 + nArray[n24]] = sArray2[n24];
                            ++n24;
                        }
                    }
                } else {
                    n25 -= n8;
                    n26 -= n6;
                    n24 = 0;
                    while (n24 < n13) {
                        int n29 = 0;
                        while (n29 < n10) {
                            int n30 = 0;
                            while (n30 < n9) {
                                nArray2[n29][n30] = randomIter.getSample(n25 + n30, n26 + n29, n24) & 0xFFFF;
                                ++n30;
                            }
                            ++n29;
                        }
                        sArray[n24][n21 + nArray[n24]] = ImageUtil.clampUShort(this.interp.interpolate(nArray2, n27, n28));
                        ++n24;
                    }
                }
                n21 += n15;
                ++n23;
            }
            ++n20;
        }
    }

    private void computeRectShort(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        if (this.interp != null) {
            n8 = this.interp.getLeftPadding();
            n7 = this.interp.getRightPadding();
            n6 = this.interp.getTopPadding();
            n5 = this.interp.getBottomPadding();
        } else {
            n5 = 0;
            n6 = 0;
            n7 = 0;
            n8 = 0;
        }
        if (this.extender != null) {
            n4 = planarImage.getMinX();
            n3 = planarImage.getMaxX();
            n2 = planarImage.getMinY();
            n = planarImage.getMaxY();
            Rectangle rectangle = new Rectangle(planarImage.getMinX() - n8, planarImage.getMinY() - n6, planarImage.getWidth() + n8 + n7, planarImage.getHeight() + n6 + n5);
            randomIter = RandomIterFactory.create(planarImage.getExtendedData(rectangle, this.extender), rectangle);
        } else {
            n4 = planarImage.getMinX() + n8;
            n3 = planarImage.getMaxX() - n7;
            n2 = planarImage.getMinY() + n6;
            n = planarImage.getMaxY() - n5;
            randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        }
        int n9 = this.interp.getWidth();
        int n10 = this.interp.getHeight();
        int n11 = rasterAccessor.getWidth();
        int n12 = rasterAccessor.getHeight();
        int n13 = rasterAccessor.getNumBands();
        int n14 = rasterAccessor.getScanlineStride();
        int n15 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n16 = 1 << this.interp.getSubsampleBitsH();
        int n17 = 1 << this.interp.getSubsampleBitsV();
        float[] fArray = new float[2 * n11];
        int[][] nArray2 = new int[n10][n9];
        int n18 = 0;
        short[] sArray2 = new short[n13];
        int n19 = 0;
        while (n19 < n13) {
            sArray2[n19] = (short)this.backgroundValues[n19];
            ++n19;
        }
        int n20 = 0;
        while (n20 < n12) {
            int n21 = n18;
            n18 += n14;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n20, n11, 1, fArray);
            int n22 = 0;
            int n23 = 0;
            while (n23 < n11) {
                int n24;
                float f2 = fArray[n22++];
                float f3 = fArray[n22++];
                int n25 = WarpGeneralOpImage.floor(f2);
                int n26 = WarpGeneralOpImage.floor(f3);
                int n27 = (int)((f2 - (float)n25) * (float)n16);
                int n28 = (int)((f3 - (float)n26) * (float)n17);
                if (n25 < n4 || n25 >= n3 || n26 < n2 || n26 >= n) {
                    if (this.setBackground) {
                        n24 = 0;
                        while (n24 < n13) {
                            sArray[n24][n21 + nArray[n24]] = sArray2[n24];
                            ++n24;
                        }
                    }
                } else {
                    n25 -= n8;
                    n26 -= n6;
                    n24 = 0;
                    while (n24 < n13) {
                        int n29 = 0;
                        while (n29 < n10) {
                            int n30 = 0;
                            while (n30 < n9) {
                                nArray2[n29][n30] = randomIter.getSample(n25 + n30, n26 + n29, n24);
                                ++n30;
                            }
                            ++n29;
                        }
                        sArray[n24][n21 + nArray[n24]] = ImageUtil.clampShort(this.interp.interpolate(nArray2, n27, n28));
                        ++n24;
                    }
                }
                n21 += n15;
                ++n23;
            }
            ++n20;
        }
    }

    private void computeRectInt(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        if (this.interp != null) {
            n8 = this.interp.getLeftPadding();
            n7 = this.interp.getRightPadding();
            n6 = this.interp.getTopPadding();
            n5 = this.interp.getBottomPadding();
        } else {
            n5 = 0;
            n6 = 0;
            n7 = 0;
            n8 = 0;
        }
        if (this.extender != null) {
            n4 = planarImage.getMinX();
            n3 = planarImage.getMaxX();
            n2 = planarImage.getMinY();
            n = planarImage.getMaxY();
            Rectangle rectangle = new Rectangle(planarImage.getMinX() - n8, planarImage.getMinY() - n6, planarImage.getWidth() + n8 + n7, planarImage.getHeight() + n6 + n5);
            randomIter = RandomIterFactory.create(planarImage.getExtendedData(rectangle, this.extender), rectangle);
        } else {
            n4 = planarImage.getMinX() + n8;
            n3 = planarImage.getMaxX() - n7;
            n2 = planarImage.getMinY() + n6;
            n = planarImage.getMaxY() - n5;
            randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        }
        int n9 = this.interp.getWidth();
        int n10 = this.interp.getHeight();
        int n11 = rasterAccessor.getWidth();
        int n12 = rasterAccessor.getHeight();
        int n13 = rasterAccessor.getNumBands();
        int n14 = rasterAccessor.getScanlineStride();
        int n15 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        int[][] nArray2 = rasterAccessor.getIntDataArrays();
        int n16 = 1 << this.interp.getSubsampleBitsH();
        int n17 = 1 << this.interp.getSubsampleBitsV();
        float[] fArray = new float[2 * n11];
        int[][] nArray3 = new int[n10][n9];
        int n18 = 0;
        int[] nArray4 = new int[n13];
        int n19 = 0;
        while (n19 < n13) {
            nArray4[n19] = (int)this.backgroundValues[n19];
            ++n19;
        }
        int n20 = 0;
        while (n20 < n12) {
            int n21 = n18;
            n18 += n14;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n20, n11, 1, fArray);
            int n22 = 0;
            int n23 = 0;
            while (n23 < n11) {
                int n24;
                float f2 = fArray[n22++];
                float f3 = fArray[n22++];
                int n25 = WarpGeneralOpImage.floor(f2);
                int n26 = WarpGeneralOpImage.floor(f3);
                int n27 = (int)((f2 - (float)n25) * (float)n16);
                int n28 = (int)((f3 - (float)n26) * (float)n17);
                if (n25 < n4 || n25 >= n3 || n26 < n2 || n26 >= n) {
                    if (this.setBackground) {
                        n24 = 0;
                        while (n24 < n13) {
                            nArray2[n24][n21 + nArray[n24]] = nArray4[n24];
                            ++n24;
                        }
                    }
                } else {
                    n25 -= n8;
                    n26 -= n6;
                    n24 = 0;
                    while (n24 < n13) {
                        int n29 = 0;
                        while (n29 < n10) {
                            int n30 = 0;
                            while (n30 < n9) {
                                nArray3[n29][n30] = randomIter.getSample(n25 + n30, n26 + n29, n24);
                                ++n30;
                            }
                            ++n29;
                        }
                        nArray2[n24][n21 + nArray[n24]] = this.interp.interpolate(nArray3, n27, n28);
                        ++n24;
                    }
                }
                n21 += n15;
                ++n23;
            }
            ++n20;
        }
    }

    private void computeRectFloat(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        if (this.interp != null) {
            n8 = this.interp.getLeftPadding();
            n7 = this.interp.getRightPadding();
            n6 = this.interp.getTopPadding();
            n5 = this.interp.getBottomPadding();
        } else {
            n5 = 0;
            n6 = 0;
            n7 = 0;
            n8 = 0;
        }
        if (this.extender != null) {
            n4 = planarImage.getMinX();
            n3 = planarImage.getMaxX();
            n2 = planarImage.getMinY();
            n = planarImage.getMaxY();
            Rectangle rectangle = new Rectangle(planarImage.getMinX() - n8, planarImage.getMinY() - n6, planarImage.getWidth() + n8 + n7, planarImage.getHeight() + n6 + n5);
            randomIter = RandomIterFactory.create(planarImage.getExtendedData(rectangle, this.extender), rectangle);
        } else {
            n4 = planarImage.getMinX() + n8;
            n3 = planarImage.getMaxX() - n7;
            n2 = planarImage.getMinY() + n6;
            n = planarImage.getMaxY() - n5;
            randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        }
        int n9 = this.interp.getWidth();
        int n10 = this.interp.getHeight();
        int n11 = rasterAccessor.getWidth();
        int n12 = rasterAccessor.getHeight();
        int n13 = rasterAccessor.getNumBands();
        int n14 = rasterAccessor.getScanlineStride();
        int n15 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        float[][] fArray = rasterAccessor.getFloatDataArrays();
        float[] fArray2 = new float[2 * n11];
        float[][] fArray3 = new float[n10][n9];
        int n16 = 0;
        float[] fArray4 = new float[n13];
        int n17 = 0;
        while (n17 < n13) {
            fArray4[n17] = (float)this.backgroundValues[n17];
            ++n17;
        }
        int n18 = 0;
        while (n18 < n12) {
            int n19 = n16;
            n16 += n14;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n18, n11, 1, fArray2);
            int n20 = 0;
            int n21 = 0;
            while (n21 < n11) {
                int n22;
                float f2 = fArray2[n20++];
                float f3 = fArray2[n20++];
                int n23 = WarpGeneralOpImage.floor(f2);
                int n24 = WarpGeneralOpImage.floor(f3);
                float f4 = f2 - (float)n23;
                float f5 = f3 - (float)n24;
                if (n23 < n4 || n23 >= n3 || n24 < n2 || n24 >= n) {
                    if (this.setBackground) {
                        n22 = 0;
                        while (n22 < n13) {
                            fArray[n22][n19 + nArray[n22]] = fArray4[n22];
                            ++n22;
                        }
                    }
                } else {
                    n23 -= n8;
                    n24 -= n6;
                    n22 = 0;
                    while (n22 < n13) {
                        int n25 = 0;
                        while (n25 < n10) {
                            int n26 = 0;
                            while (n26 < n9) {
                                fArray3[n25][n26] = randomIter.getSampleFloat(n23 + n26, n24 + n25, n22);
                                ++n26;
                            }
                            ++n25;
                        }
                        fArray[n22][n19 + nArray[n22]] = this.interp.interpolate(fArray3, f4, f5);
                        ++n22;
                    }
                }
                n19 += n15;
                ++n21;
            }
            ++n18;
        }
    }

    private void computeRectDouble(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        if (this.interp != null) {
            n8 = this.interp.getLeftPadding();
            n7 = this.interp.getRightPadding();
            n6 = this.interp.getTopPadding();
            n5 = this.interp.getBottomPadding();
        } else {
            n5 = 0;
            n6 = 0;
            n7 = 0;
            n8 = 0;
        }
        if (this.extender != null) {
            n4 = planarImage.getMinX();
            n3 = planarImage.getMaxX();
            n2 = planarImage.getMinY();
            n = planarImage.getMaxY();
            Rectangle rectangle = new Rectangle(planarImage.getMinX() - n8, planarImage.getMinY() - n6, planarImage.getWidth() + n8 + n7, planarImage.getHeight() + n6 + n5);
            randomIter = RandomIterFactory.create(planarImage.getExtendedData(rectangle, this.extender), rectangle);
        } else {
            n4 = planarImage.getMinX() + n8;
            n3 = planarImage.getMaxX() - n7;
            n2 = planarImage.getMinY() + n6;
            n = planarImage.getMaxY() - n5;
            randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        }
        int n9 = this.interp.getWidth();
        int n10 = this.interp.getHeight();
        int n11 = rasterAccessor.getWidth();
        int n12 = rasterAccessor.getHeight();
        int n13 = rasterAccessor.getNumBands();
        int n14 = rasterAccessor.getScanlineStride();
        int n15 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        double[][] dArray = rasterAccessor.getDoubleDataArrays();
        float[] fArray = new float[2 * n11];
        double[][] dArray2 = new double[n10][n9];
        int n16 = 0;
        int n17 = 0;
        while (n17 < n12) {
            int n18 = n16;
            n16 += n14;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n17, n11, 1, fArray);
            int n19 = 0;
            int n20 = 0;
            while (n20 < n11) {
                int n21;
                float f2 = fArray[n19++];
                float f3 = fArray[n19++];
                int n22 = WarpGeneralOpImage.floor(f2);
                int n23 = WarpGeneralOpImage.floor(f3);
                float f4 = f2 - (float)n22;
                float f5 = f3 - (float)n23;
                if (n22 < n4 || n22 >= n3 || n23 < n2 || n23 >= n) {
                    if (this.setBackground) {
                        n21 = 0;
                        while (n21 < n13) {
                            dArray[n21][n18 + nArray[n21]] = this.backgroundValues[n21];
                            ++n21;
                        }
                    }
                } else {
                    n22 -= n8;
                    n23 -= n6;
                    n21 = 0;
                    while (n21 < n13) {
                        int n24 = 0;
                        while (n24 < n10) {
                            int n25 = 0;
                            while (n25 < n9) {
                                dArray2[n24][n25] = randomIter.getSampleDouble(n22 + n25, n23 + n24, n21);
                                ++n25;
                            }
                            ++n24;
                        }
                        dArray[n21][n18 + nArray[n21]] = this.interp.interpolate(dArray2, f4, f5);
                        ++n21;
                    }
                }
                n18 += n15;
                ++n20;
            }
            ++n17;
        }
    }

    private static final int floor(float f2) {
        return f2 >= 0.0f ? (int)f2 : (int)f2 - 1;
    }
}

