/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.Warp;
import javax.media.jai.WarpOpImage;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;

final class WarpNearestOpImage
extends WarpOpImage {
    public WarpNearestOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, Warp warp, Interpolation interpolation, double[] dArray) {
        super(renderedImage, imageLayout, map, false, null, interpolation, warp, dArray);
        ColorModel colorModel = renderedImage.getColorModel();
        if (colorModel instanceof IndexColorModel) {
            this.sampleModel = renderedImage.getSampleModel().createCompatibleSampleModel(this.tileWidth, this.tileHeight);
            this.colorModel = colorModel;
        }
    }

    protected void computeRect(PlanarImage[] planarImageArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        RasterAccessor rasterAccessor = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        switch (rasterAccessor.getDataType()) {
            case 0: {
                this.computeRectByte(planarImageArray[0], rasterAccessor);
                break;
            }
            case 1: {
                this.computeRectUShort(planarImageArray[0], rasterAccessor);
                break;
            }
            case 2: {
                this.computeRectShort(planarImageArray[0], rasterAccessor);
                break;
            }
            case 3: {
                this.computeRectInt(planarImageArray[0], rasterAccessor);
                break;
            }
            case 4: {
                this.computeRectFloat(planarImageArray[0], rasterAccessor);
                break;
            }
            case 5: {
                this.computeRectDouble(planarImageArray[0], rasterAccessor);
            }
        }
        if (rasterAccessor.isDataCopy()) {
            rasterAccessor.clampDataArrays();
            rasterAccessor.copyDataToRaster();
        }
    }

    private void computeRectByte(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        int n = planarImage.getMinX();
        int n2 = planarImage.getMaxX();
        int n3 = planarImage.getMinY();
        int n4 = planarImage.getMaxY();
        int n5 = rasterAccessor.getWidth();
        int n6 = rasterAccessor.getHeight();
        int n7 = rasterAccessor.getNumBands();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        byte[][] byArray = rasterAccessor.getByteDataArrays();
        float[] fArray = new float[2 * n5];
        int n10 = 0;
        byte[] byArray2 = new byte[n7];
        int n11 = 0;
        while (n11 < n7) {
            byArray2[n11] = (byte)this.backgroundValues[n11];
            ++n11;
        }
        int n12 = 0;
        while (n12 < n6) {
            int n13 = n10;
            n10 += n8;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n12, n5, 1, fArray);
            int n14 = 0;
            int n15 = 0;
            while (n15 < n5) {
                int n16;
                int n17 = WarpNearestOpImage.round(fArray[n14++]);
                int n18 = WarpNearestOpImage.round(fArray[n14++]);
                if (n17 < n || n17 >= n2 || n18 < n3 || n18 >= n4) {
                    if (this.setBackground) {
                        n16 = 0;
                        while (n16 < n7) {
                            byArray[n16][n13 + nArray[n16]] = byArray2[n16];
                            ++n16;
                        }
                    }
                } else {
                    n16 = 0;
                    while (n16 < n7) {
                        byArray[n16][n13 + nArray[n16]] = (byte)(randomIter.getSample(n17, n18, n16) & 0xFF);
                        ++n16;
                    }
                }
                n13 += n9;
                ++n15;
            }
            ++n12;
        }
    }

    private void computeRectUShort(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        int n = planarImage.getMinX();
        int n2 = planarImage.getMaxX();
        int n3 = planarImage.getMinY();
        int n4 = planarImage.getMaxY();
        int n5 = rasterAccessor.getWidth();
        int n6 = rasterAccessor.getHeight();
        int n7 = rasterAccessor.getNumBands();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        float[] fArray = new float[2 * n5];
        int n10 = 0;
        short[] sArray2 = new short[n7];
        int n11 = 0;
        while (n11 < n7) {
            sArray2[n11] = (short)this.backgroundValues[n11];
            ++n11;
        }
        int n12 = 0;
        while (n12 < n6) {
            int n13 = n10;
            n10 += n8;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n12, n5, 1, fArray);
            int n14 = 0;
            int n15 = 0;
            while (n15 < n5) {
                int n16;
                int n17 = WarpNearestOpImage.round(fArray[n14++]);
                int n18 = WarpNearestOpImage.round(fArray[n14++]);
                if (n17 < n || n17 >= n2 || n18 < n3 || n18 >= n4) {
                    if (this.setBackground) {
                        n16 = 0;
                        while (n16 < n7) {
                            sArray[n16][n13 + nArray[n16]] = sArray2[n16];
                            ++n16;
                        }
                    }
                } else {
                    n16 = 0;
                    while (n16 < n7) {
                        sArray[n16][n13 + nArray[n16]] = (short)(randomIter.getSample(n17, n18, n16) & 0xFFFF);
                        ++n16;
                    }
                }
                n13 += n9;
                ++n15;
            }
            ++n12;
        }
    }

    private void computeRectShort(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        int n = planarImage.getMinX();
        int n2 = planarImage.getMaxX();
        int n3 = planarImage.getMinY();
        int n4 = planarImage.getMaxY();
        int n5 = rasterAccessor.getWidth();
        int n6 = rasterAccessor.getHeight();
        int n7 = rasterAccessor.getNumBands();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        float[] fArray = new float[2 * n5];
        int n10 = 0;
        short[] sArray2 = new short[n7];
        int n11 = 0;
        while (n11 < n7) {
            sArray2[n11] = (short)this.backgroundValues[n11];
            ++n11;
        }
        int n12 = 0;
        while (n12 < n6) {
            int n13 = n10;
            n10 += n8;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n12, n5, 1, fArray);
            int n14 = 0;
            int n15 = 0;
            while (n15 < n5) {
                int n16;
                int n17 = WarpNearestOpImage.round(fArray[n14++]);
                int n18 = WarpNearestOpImage.round(fArray[n14++]);
                if (n17 < n || n17 >= n2 || n18 < n3 || n18 >= n4) {
                    if (this.setBackground) {
                        n16 = 0;
                        while (n16 < n7) {
                            sArray[n16][n13 + nArray[n16]] = sArray2[n16];
                            ++n16;
                        }
                    }
                } else {
                    n16 = 0;
                    while (n16 < n7) {
                        sArray[n16][n13 + nArray[n16]] = (short)randomIter.getSample(n17, n18, n16);
                        ++n16;
                    }
                }
                n13 += n9;
                ++n15;
            }
            ++n12;
        }
    }

    private void computeRectInt(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        int n = planarImage.getMinX();
        int n2 = planarImage.getMaxX();
        int n3 = planarImage.getMinY();
        int n4 = planarImage.getMaxY();
        int n5 = rasterAccessor.getWidth();
        int n6 = rasterAccessor.getHeight();
        int n7 = rasterAccessor.getNumBands();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        int[][] nArray2 = rasterAccessor.getIntDataArrays();
        float[] fArray = new float[2 * n5];
        int n10 = 0;
        int[] nArray3 = new int[n7];
        int n11 = 0;
        while (n11 < n7) {
            nArray3[n11] = (int)this.backgroundValues[n11];
            ++n11;
        }
        int n12 = 0;
        while (n12 < n6) {
            int n13 = n10;
            n10 += n8;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n12, n5, 1, fArray);
            int n14 = 0;
            int n15 = 0;
            while (n15 < n5) {
                int n16;
                int n17 = WarpNearestOpImage.round(fArray[n14++]);
                int n18 = WarpNearestOpImage.round(fArray[n14++]);
                if (n17 < n || n17 >= n2 || n18 < n3 || n18 >= n4) {
                    if (this.setBackground) {
                        n16 = 0;
                        while (n16 < n7) {
                            nArray2[n16][n13 + nArray[n16]] = nArray3[n16];
                            ++n16;
                        }
                    }
                } else {
                    n16 = 0;
                    while (n16 < n7) {
                        nArray2[n16][n13 + nArray[n16]] = randomIter.getSample(n17, n18, n16);
                        ++n16;
                    }
                }
                n13 += n9;
                ++n15;
            }
            ++n12;
        }
    }

    private void computeRectFloat(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        int n = planarImage.getMinX();
        int n2 = planarImage.getMaxX();
        int n3 = planarImage.getMinY();
        int n4 = planarImage.getMaxY();
        int n5 = rasterAccessor.getWidth();
        int n6 = rasterAccessor.getHeight();
        int n7 = rasterAccessor.getNumBands();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        float[][] fArray = rasterAccessor.getFloatDataArrays();
        float[] fArray2 = new float[2 * n5];
        int n10 = 0;
        float[] fArray3 = new float[n7];
        int n11 = 0;
        while (n11 < n7) {
            fArray3[n11] = (float)this.backgroundValues[n11];
            ++n11;
        }
        int n12 = 0;
        while (n12 < n6) {
            int n13 = n10;
            n10 += n8;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n12, n5, 1, fArray2);
            int n14 = 0;
            int n15 = 0;
            while (n15 < n5) {
                int n16;
                int n17 = WarpNearestOpImage.round(fArray2[n14++]);
                int n18 = WarpNearestOpImage.round(fArray2[n14++]);
                if (n17 < n || n17 >= n2 || n18 < n3 || n18 >= n4) {
                    if (this.setBackground) {
                        n16 = 0;
                        while (n16 < n7) {
                            fArray[n16][n13 + nArray[n16]] = fArray3[n16];
                            ++n16;
                        }
                    }
                } else {
                    n16 = 0;
                    while (n16 < n7) {
                        fArray[n16][n13 + nArray[n16]] = randomIter.getSampleFloat(n17, n18, n16);
                        ++n16;
                    }
                }
                n13 += n9;
                ++n15;
            }
            ++n12;
        }
    }

    private void computeRectDouble(PlanarImage planarImage, RasterAccessor rasterAccessor) {
        RandomIter randomIter = RandomIterFactory.create(planarImage, planarImage.getBounds());
        int n = planarImage.getMinX();
        int n2 = planarImage.getMaxX();
        int n3 = planarImage.getMinY();
        int n4 = planarImage.getMaxY();
        int n5 = rasterAccessor.getWidth();
        int n6 = rasterAccessor.getHeight();
        int n7 = rasterAccessor.getNumBands();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        double[][] dArray = rasterAccessor.getDoubleDataArrays();
        float[] fArray = new float[2 * n5];
        int n10 = 0;
        int n11 = 0;
        while (n11 < n6) {
            int n12 = n10;
            n10 += n8;
            this.warp.warpRect(rasterAccessor.getX(), rasterAccessor.getY() + n11, n5, 1, fArray);
            int n13 = 0;
            int n14 = 0;
            while (n14 < n5) {
                int n15;
                int n16 = WarpNearestOpImage.round(fArray[n13++]);
                int n17 = WarpNearestOpImage.round(fArray[n13++]);
                if (n16 < n || n16 >= n2 || n17 < n3 || n17 >= n4) {
                    if (this.setBackground) {
                        n15 = 0;
                        while (n15 < n7) {
                            dArray[n15][n12 + nArray[n15]] = this.backgroundValues[n15];
                            ++n15;
                        }
                    }
                } else {
                    n15 = 0;
                    while (n15 < n7) {
                        dArray[n15][n12 + nArray[n15]] = randomIter.getSampleDouble(n16, n17, n15);
                        ++n15;
                    }
                }
                n12 += n9;
                ++n14;
            }
            ++n11;
        }
    }

    private static final int round(float f2) {
        return f2 >= 0.0f ? (int)(f2 + 0.5f) : (int)(f2 - 0.5f);
    }
}

