/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.rmi;

import com.sun.media.jai.rmi.RMIServerProxy;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import javax.media.jai.remote.PlanarImageServerProxy;
import javax.media.jai.remote.RemoteRenderedOp;
import javax.media.jai.remote.SerializableRenderedImage;

public final class JAIRMIUtil {
    public static Vector replaceIdWithSources(Vector vector, Hashtable hashtable, String string, RenderingHints renderingHints) {
        Vector<Object> vector2 = new Vector<Object>();
        int n = 0;
        while (n < vector.size()) {
            Object object;
            Object e2 = vector.elementAt(n);
            if (e2 instanceof String) {
                boolean bl;
                object = (String)e2;
                int n2 = ((String)object).indexOf("::");
                boolean bl2 = bl = n2 != -1;
                if (bl) {
                    vector2.add(new RMIServerProxy((String)object, string, renderingHints));
                } else {
                    vector2.add(hashtable.get(Long.valueOf((String)object)));
                }
            } else {
                object = PlanarImage.wrapRenderedImage((RenderedImage)e2);
                vector2.add(object);
            }
            ++n;
        }
        return vector2;
    }

    public static Vector replaceSourcesWithId(Vector vector, String string) {
        Vector<Object> vector2 = new Vector<Object>();
        int n = 0;
        while (n < vector.size()) {
            Object object;
            RenderedImage renderedImage;
            Object e2 = vector.elementAt(n);
            if (e2 instanceof RMIServerProxy) {
                renderedImage = (RMIServerProxy)e2;
                if (((PlanarImageServerProxy)renderedImage).getServerName().equalsIgnoreCase(string)) {
                    vector2.add(((RMIServerProxy)renderedImage).getRMIID().toString());
                } else {
                    object = new String(((PlanarImageServerProxy)renderedImage).getServerName() + "::" + ((RMIServerProxy)renderedImage).getRMIID());
                    vector2.add(object);
                }
            } else if (e2 instanceof RemoteRenderedOp) {
                RenderedImage renderedImage2;
                renderedImage = (RemoteRenderedOp)e2;
                object = ((RenderedOp)renderedImage).getRendering();
                if (object instanceof RMIServerProxy) {
                    renderedImage2 = (RMIServerProxy)object;
                    if (((PlanarImageServerProxy)renderedImage2).getServerName().equalsIgnoreCase(string)) {
                        vector2.add(((RMIServerProxy)renderedImage2).getRMIID().toString());
                    } else {
                        String string2 = new String(((PlanarImageServerProxy)renderedImage2).getServerName() + "::" + ((RMIServerProxy)renderedImage2).getRMIID());
                        vector2.add(string2);
                    }
                } else {
                    renderedImage2 = (RenderedImage)object;
                    vector2.add(new SerializableRenderedImage(renderedImage2));
                }
            } else if (e2 instanceof RenderedOp) {
                renderedImage = (RenderedOp)e2;
                vector2.add(new SerializableRenderedImage(((RenderedOp)renderedImage).getRendering()));
            } else if (e2 instanceof Serializable) {
                vector2.add(e2);
            } else if (e2 instanceof RenderedImage) {
                renderedImage = (RenderedImage)e2;
                vector2.add(new SerializableRenderedImage(renderedImage));
            }
            ++n;
        }
        return vector2;
    }

    public static Object replaceImage(RenderedImage renderedImage, String string) {
        if (renderedImage instanceof RMIServerProxy) {
            RMIServerProxy rMIServerProxy = (RMIServerProxy)renderedImage;
            if (rMIServerProxy.getServerName().equalsIgnoreCase(string)) {
                return "::" + rMIServerProxy.getRMIID();
            }
            return rMIServerProxy.getServerName() + "::" + rMIServerProxy.getRMIID() + ";;" + rMIServerProxy.getOperationName();
        }
        if (renderedImage instanceof RenderedOp) {
            PlanarImage planarImage = ((RenderedOp)renderedImage).getRendering();
            return JAIRMIUtil.replaceImage(planarImage, string);
        }
        if (renderedImage instanceof RenderedImage) {
            if (renderedImage instanceof Serializable) {
                return renderedImage;
            }
            return new SerializableRenderedImage(renderedImage);
        }
        return renderedImage;
    }

    public static void checkClientParameters(ParameterBlock parameterBlock, String string) {
        if (parameterBlock == null) {
            return;
        }
        int n = parameterBlock.getNumParameters();
        Vector<Object> vector = parameterBlock.getParameters();
        int n2 = 0;
        while (n2 < n) {
            Object object = vector.elementAt(n2);
            if (object != null && object instanceof RenderedImage) {
                parameterBlock.set(JAIRMIUtil.replaceImage((RenderedImage)object, string), n2);
            }
            ++n2;
        }
    }

    public static void checkClientParameters(Vector vector, String string) {
        if (vector == null) {
            return;
        }
        int n = 0;
        while (n < vector.size()) {
            Object e2 = vector.elementAt(n);
            if (e2 != null && e2 instanceof RenderedImage) {
                vector.set(n, JAIRMIUtil.replaceImage((RenderedImage)e2, string));
            }
            ++n;
        }
    }

    public static Object replaceStringWithImage(String string, Hashtable hashtable) {
        int n = string.indexOf("::");
        int n2 = string.indexOf(";;");
        if (n == -1) {
            return string;
        }
        if (n2 == -1) {
            Long l = Long.valueOf(string.substring(n + 2));
            return hashtable.get(l);
        }
        Long l = Long.valueOf(string.substring(n + 2, n2));
        String string2 = string.substring(0, n);
        String string3 = string.substring(n2 + 2);
        return new RMIServerProxy(string2 + "::" + l, string3, null);
    }

    public static void checkServerParameters(ParameterBlock parameterBlock, Hashtable hashtable) {
        if (parameterBlock == null) {
            return;
        }
        int n = parameterBlock.getNumParameters();
        Vector<Object> vector = parameterBlock.getParameters();
        int n2 = 0;
        while (n2 < n) {
            Object object = vector.elementAt(n2);
            if (object != null && object instanceof String) {
                parameterBlock.set(JAIRMIUtil.replaceStringWithImage((String)object, hashtable), n2);
            }
            ++n2;
        }
    }

    public static void checkServerParameters(Vector vector, Hashtable hashtable) {
        if (vector == null) {
            return;
        }
        int n = 0;
        while (n < vector.size()) {
            Object e2 = vector.elementAt(n);
            if (e2 != null && e2 instanceof String) {
                vector.set(n, JAIRMIUtil.replaceStringWithImage((String)e2, hashtable));
            }
            ++n;
        }
    }
}

