/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.util;

import javax.media.jai.Interpolation;

public class InterpAverage
extends Interpolation {
    public InterpAverage(int n, int n2) {
        super(n, n2, 0, n - 1, 0, n2 - 1, 32, 32);
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException("blockX <= 0 || blockY <= 0");
        }
    }

    public int interpolateH(int[] nArray, int n) {
        int n2 = nArray.length;
        double d2 = 0.0;
        int n3 = 0;
        while (n3 < n2) {
            d2 += (double)(nArray[n3] / n2);
            ++n3;
        }
        return (int)(d2 + 0.5);
    }

    public float interpolateH(float[] fArray, float f2) {
        int n = fArray.length;
        float f3 = 0.0f;
        int n2 = 0;
        while (n2 < n) {
            f3 += fArray[n2] / (float)n;
            ++n2;
        }
        return f3;
    }

    public double interpolateH(double[] dArray, float f2) {
        int n = dArray.length;
        double d2 = 0.0;
        int n2 = 0;
        while (n2 < n) {
            d2 += dArray[n2] / (double)n;
            ++n2;
        }
        return d2;
    }
}

