/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.io;

import it.tidalwave.imageio.io.BitReader;
import it.tidalwave.imageio.io.FastBitReader;
import it.tidalwave.imageio.io.RAWImageInputStream;
import it.tidalwave.imageio.io.SixteenBitsReader;
import it.tidalwave.imageio.io.TwelveBitsReader;
import it.tidalwave.imageio.util.Logger;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageInputStreamImpl;

public class RAWImageInputStreamImpl
extends ImageInputStreamImpl
implements RAWImageInputStream {
    private static final String CLASS = RAWImageInputStreamImpl.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    @Nonnegative
    private long baseOffset;
    @Nonnull
    protected ImageInputStream delegate;
    @CheckForNull
    private BitReader bitReader;
    private boolean dontCloseDelegate;

    public RAWImageInputStreamImpl(@Nonnull ImageInputStream delegate) {
        this.delegate = delegate;
    }

    public void setBaseOffset(@Nonnegative long baseOffset) {
        this.baseOffset = baseOffset;
    }

    @Nonnegative
    public long getBaseOffset() {
        return this.baseOffset;
    }

    public void selectBitReader(@Nonnegative int bitCount, @Nonnegative int bufferSize) {
        if (bufferSize == 0) {
            bufferSize = 65536;
        }
        this.bitReader = bitCount == 12 ? new TwelveBitsReader(this.delegate, bufferSize) : (bitCount == 16 ? new SixteenBitsReader(this.delegate, bufferSize) : new FastBitReader(this.delegate, bufferSize));
        logger.finest(">>>> Using bitReader: %s", this.bitReader);
    }

    public void setSkipZeroAfterFF(boolean skipZeroAfterFF) {
        assert (this.bitReader != null) : "null bitReader";
        this.bitReader.setSkipZeroAfterFF(skipZeroAfterFF);
    }

    public final void skipBits(@Nonnegative int bitCount) throws IOException {
        assert (this.bitReader != null) : "null bitReader";
        this.bitReader.skipBits(bitCount);
    }

    public void setDontCloseDelegate() {
        this.dontCloseDelegate = true;
    }

    public String toString() {
        return String.format("RAWImageInputStream[%s, %s]", this.bitReader, this.delegate);
    }

    public final int readBit() throws IOException {
        return this.bitReader != null ? this.bitReader.readBits(1) : this.delegate.readBit();
    }

    public final long readBits(int bitCount) throws IOException {
        return this.bitReader != null ? (long)this.bitReader.readBits(bitCount) : this.delegate.readBits(bitCount);
    }

    public void seek(long position) throws IOException {
        if (this.bitReader != null) {
            this.bitReader.seek(position + this.baseOffset);
        } else {
            this.delegate.seek(position + this.baseOffset);
        }
    }

    public long getStreamPosition() throws IOException {
        return (this.bitReader != null ? this.bitReader.getStreamPosition() : this.delegate.getStreamPosition()) - this.baseOffset;
    }

    public int getBitOffset() throws IOException {
        return this.bitReader != null ? this.bitReader.getBitOffset() : this.delegate.getBitOffset();
    }

    public void setBitOffset(int bitOffset) throws IOException {
        if (this.bitReader != null) {
            this.bitReader.setBitOffset(bitOffset);
        } else {
            this.delegate.setBitOffset(bitOffset);
        }
    }

    public int read() throws IOException {
        return this.delegate.read();
    }

    public int read(byte[] b2, int off, int len) throws IOException {
        return this.delegate.read(b2, off, len);
    }

    @Nonnegative
    public long length() {
        try {
            return this.delegate.length() - this.baseOffset;
        }
        catch (IOException e2) {
            return -1L;
        }
    }

    public int skipBytes(@Nonnegative int byteCount) throws IOException {
        return this.delegate.skipBytes(byteCount);
    }

    public long skipBytes(@Nonnegative long byteCount) throws IOException {
        return this.delegate.skipBytes(byteCount);
    }

    public void flushBefore(long position) throws IOException {
        this.delegate.flushBefore(position + this.baseOffset);
    }

    public void flush() throws IOException {
        this.delegate.flush();
    }

    public long getFlushedPosition() {
        return this.delegate.getFlushedPosition();
    }

    public boolean isCached() {
        return this.delegate.isCached();
    }

    public boolean isCachedMemory() {
        return this.delegate.isCachedMemory();
    }

    public boolean isCachedFile() {
        return this.delegate.isCachedFile();
    }

    public void close() throws IOException {
    }
}

