/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.nef;

import it.tidalwave.imageio.io.RAWImageInputStream;
import it.tidalwave.imageio.nef.NikonMakerNote3;
import it.tidalwave.imageio.raw.Directory;
import it.tidalwave.imageio.raw.HeaderProcessor;
import it.tidalwave.imageio.tiff.IFD;
import it.tidalwave.imageio.tiff.IFDGenerated;
import it.tidalwave.imageio.tiff.TIFFMetadataSupport;
import it.tidalwave.imageio.tiff.ThumbnailLoader;
import it.tidalwave.imageio.util.Logger;
import java.awt.Dimension;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;

public class NEFMetadata
extends TIFFMetadataSupport {
    private static final String CLASS = NEFMetadata.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    private static final long serialVersionUID = 1795868438676854749L;
    @Nonnegative
    private int width;
    @Nonnegative
    private int height;
    @CheckForNull
    private transient Object nceMetadata;

    public NEFMetadata(@Nonnull Directory primaryIFD, @Nonnull RAWImageInputStream iis, @CheckForNull HeaderProcessor headerProcessor) {
        super(primaryIFD, iis, headerProcessor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void postInit(@Nonnull RAWImageInputStream iis) {
        if (this.rasterIFD == null) {
            logger.fine(">>>> rasterIFD not detected yet, guessing...", new Object[0]);
            this.rasterIFD = this.getPrimaryIFD();
            Directory nextDirectory = this.rasterIFD.getNextDirectory();
            if (nextDirectory != null && nextDirectory instanceof IFD) {
                this.thumbnailLoaders.add(new ThumbnailLoader(iis, (IFD)nextDirectory));
            }
        }
        if (!this.rasterIFD.isJPEGInterchangeFormatAvailable()) {
            this.width = this.rasterIFD.getImageWidth();
            this.height = this.rasterIFD.getImageLength();
        } else {
            try {
                int byteCount = this.rasterIFD.getJPEGInterchangeFormatLength();
                long offset = this.rasterIFD.getJPEGInterchangeFormat();
                byte[] buffer = new byte[byteCount];
                iis.seek(offset);
                iis.readFully(buffer);
                ImageReader ir = ImageIO.getImageReadersByFormatName("JPEG").next();
                try {
                    ir.setInput(ImageIO.createImageInputStream(new ByteArrayInputStream(buffer)));
                    this.width = ir.getWidth(0);
                    this.height = ir.getHeight(0);
                }
                finally {
                    ir.dispose();
                }
            }
            catch (IOException e2) {
                logger.warning("While reading size of NEF embedded JPEG: " + e2, new Object[0]);
            }
        }
    }

    @Nonnull
    public NikonMakerNote3 getNikonMakerNote() {
        return (NikonMakerNote3)this.getMakerNote();
    }

    @CheckForNull
    public Object getCaptureEditorMetadata() {
        return this.nceMetadata;
    }

    public void _setCaptureEditorMetadata(@CheckForNull Object captureEditorMetadata) {
        this.nceMetadata = captureEditorMetadata;
    }

    @Nonnull
    protected Dimension getImageSize() {
        return new Dimension(this.width, this.height);
    }

    protected boolean isRasterIFD(@Nonnull IFD ifd) {
        return ifd.isNewSubFileTypeAvailable() && ifd.getNewSubFileType() == IFDGenerated.NewSubFileType.IMAGE;
    }

    protected boolean isThumbnailIFD(@Nonnull IFD ifd) {
        return ifd.isNewSubFileTypeAvailable() && ifd.getNewSubFileType() == IFDGenerated.NewSubFileType.REDUCED_RESOLUTION || ifd.isJPEGInterchangeFormatAvailable();
    }
}

