/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.nef;

import it.tidalwave.imageio.nef.NikonMakerNote3;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.annotation.Nonnull;

public class NEFWhiteBalanceInfo {
    @Nonnull
    private final ByteBuffer buffer;
    private boolean valid = true;
    private int version;
    private int redIndex;
    private int green1Index;
    private int green2Index;
    private int blueIndex;
    private final int[] coefficients = new int[4];
    private static final double SCALE = 0.00390625;
    private static final short[] KEY1 = new short[]{193, 191, 109, 13, 89, 197, 19, 157, 131, 97, 107, 79, 199, 127, 61, 61, 83, 89, 227, 199, 233, 47, 149, 167, 149, 31, 223, 127, 43, 41, 199, 13, 223, 7, 239, 113, 137, 61, 19, 61, 59, 19, 251, 13, 137, 193, 101, 31, 179, 13, 107, 41, 227, 251, 239, 163, 107, 71, 127, 149, 53, 167, 71, 79, 199, 241, 89, 149, 53, 17, 41, 97, 241, 61, 179, 43, 13, 67, 137, 193, 157, 157, 137, 101, 241, 233, 223, 191, 61, 127, 83, 151, 229, 233, 149, 23, 29, 61, 139, 251, 199, 227, 103, 167, 7, 241, 113, 167, 83, 181, 41, 137, 229, 43, 167, 23, 41, 233, 79, 197, 101, 109, 107, 239, 13, 137, 73, 47, 179, 67, 83, 101, 29, 73, 163, 19, 137, 89, 239, 107, 239, 101, 29, 11, 89, 19, 227, 79, 157, 179, 41, 67, 43, 7, 29, 149, 89, 89, 71, 251, 229, 233, 97, 71, 47, 53, 127, 23, 127, 239, 127, 149, 149, 113, 211, 163, 11, 113, 163, 173, 11, 59, 181, 251, 163, 191, 79, 131, 29, 173, 233, 47, 113, 101, 163, 229, 7, 53, 61, 13, 181, 233, 229, 71, 59, 157, 239, 53, 163, 191, 179, 223, 83, 211, 151, 83, 73, 113, 7, 53, 97, 113, 47, 67, 47, 17, 223, 23, 151, 251, 149, 59, 127, 107, 211, 37, 191, 173, 199, 197, 197, 181, 139, 239, 47, 211, 7, 107, 37, 73, 149, 37, 73, 109, 113, 199};
    private static final short[] KEY2 = new short[]{167, 188, 201, 173, 145, 223, 133, 229, 212, 120, 213, 23, 70, 124, 41, 76, 77, 3, 233, 37, 104, 17, 134, 179, 189, 247, 111, 97, 34, 162, 38, 52, 42, 190, 30, 70, 20, 104, 157, 68, 24, 194, 64, 244, 126, 95, 27, 173, 11, 148, 182, 103, 180, 11, 225, 234, 149, 156, 102, 220, 231, 93, 108, 5, 218, 213, 223, 122, 239, 246, 219, 31, 130, 76, 192, 104, 71, 161, 189, 238, 57, 80, 86, 74, 221, 223, 165, 248, 198, 218, 202, 144, 202, 1, 66, 157, 139, 12, 115, 67, 117, 5, 148, 222, 36, 179, 128, 52, 229, 44, 220, 155, 63, 202, 51, 69, 208, 219, 95, 245, 82, 195, 33, 218, 226, 34, 114, 107, 62, 208, 91, 168, 135, 140, 6, 93, 15, 221, 9, 25, 147, 208, 185, 252, 139, 15, 132, 96, 51, 28, 155, 69, 241, 240, 163, 148, 58, 18, 119, 51, 77, 68, 120, 40, 60, 158, 253, 101, 87, 22, 148, 107, 251, 89, 208, 200, 34, 54, 219, 210, 99, 152, 67, 161, 4, 135, 134, 247, 166, 38, 187, 214, 89, 77, 191, 106, 46, 170, 43, 239, 230, 120, 182, 78, 224, 47, 220, 124, 190, 87, 25, 50, 126, 42, 208, 184, 186, 41, 0, 60, 82, 125, 168, 73, 59, 45, 235, 37, 73, 250, 163, 170, 57, 167, 197, 167, 80, 17, 54, 251, 198, 103, 74, 245, 165, 18, 101, 126, 176, 223, 175, 78, 179, 97, 127, 47};

    protected NEFWhiteBalanceInfo(@Nonnull NikonMakerNote3 makerNote, boolean bigEndian) {
        this.buffer = ByteBuffer.wrap(makerNote.getBlock151());
        this.buffer.order(bigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
        this.computeVersion();
        if (this.version >= 512) {
            this.demangle(makerNote);
        }
        this.computeCoefficients();
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isValid() {
        return this.valid;
    }

    @Nonnull
    public int[] getCoefficients() {
        return this.coefficients;
    }

    public double getRedCoefficient() {
        return 0.00390625 * (double)this.coefficients[this.redIndex];
    }

    public double getGreen1Coefficient() {
        return 0.00390625 * (double)this.coefficients[this.green1Index];
    }

    public double getGreen2Coefficient() {
        return 0.00390625 * (double)this.coefficients[this.green2Index];
    }

    public double getBlueCoefficient() {
        return 0.00390625 * (double)this.coefficients[this.blueIndex];
    }

    private void demangle(@Nonnull NikonMakerNote3 makerNote) {
        int offset;
        String serialNumber = makerNote.getD2XSerialNumber();
        int shutterCount = makerNote.getShutterCount();
        int key = 0;
        for (int i = 0; i < serialNumber.length(); ++i) {
            char c2 = serialNumber.charAt(i);
            key = key * 10 + (Character.isDigit(c2) ? c2 - 48 : c2 % 10);
        }
        int k1 = key & 0xFF;
        int k2 = shutterCount >>> 24 & 0xFF ^ shutterCount >>> 16 & 0xFF ^ shutterCount >>> 8 & 0xFF ^ shutterCount >>> 0 & 0xFF;
        byte c1 = (byte)KEY1[k1];
        byte c2 = (byte)KEY2[k2];
        int c3 = 96;
        for (int i = offset = this.version != 517 ? 284 : 4; i < this.buffer.limit(); ++i) {
            int n = c3;
            c3 = (byte)(c3 + 1);
            c2 = (byte)(c2 + c1 * n);
            this.buffer.put(i, (byte)(this.buffer.get(i) ^ c2));
        }
    }

    private void computeVersion() {
        this.version = 0;
        for (int i = 0; i < 4; ++i) {
            this.version <<= 4;
            this.version |= this.buffer.get(i) - 48;
        }
    }

    private void computeCoefficients() {
        int offset = 0;
        switch (this.version) {
            case 256: {
                offset = 72;
                this.redIndex = 0;
                this.green1Index = 2;
                this.green2Index = 3;
                this.blueIndex = 1;
                break;
            }
            case 258: {
                offset = 10;
                this.redIndex = 0;
                this.green1Index = 1;
                this.green2Index = 2;
                this.blueIndex = 3;
                break;
            }
            case 259: {
                offset = 20;
                this.redIndex = 0;
                this.green1Index = 1;
                this.green2Index = 3;
                this.blueIndex = 2;
                break;
            }
            case 512: 
            case 513: 
            case 514: 
            case 515: 
            case 516: 
            case 518: 
            case 519: {
                offset = 290;
                this.redIndex = 0;
                this.green1Index = 1;
                this.green2Index = 2;
                this.blueIndex = 3;
                break;
            }
            case 517: {
                offset = 18;
                this.redIndex = 0;
                this.green1Index = 1;
                this.green2Index = 2;
                this.blueIndex = 3;
                break;
            }
            default: {
                this.valid = false;
            }
        }
        if (this.valid) {
            for (int i = 0; i < 4; ++i) {
                this.coefficients[i] = this.buffer.getShort(offset + i * 2);
            }
        }
    }
}

