/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.nef;

import it.tidalwave.imageio.util.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Properties;
import javax.annotation.Nonnull;

public class NikonLensInfo {
    private static final String CLASS = NikonLensInfo.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    private static Properties lensNameByID = new Properties();
    private int version;
    private static final int V100 = 0x30313030;
    private static final int V101 = 0x30313031;
    private byte lensID;
    private String lensName;
    private byte lensFStops;
    private byte minFocalLength;
    private byte maxFocalLength;
    private byte maxApertureAtMinFocal;
    private byte maxApertureAtMaxFocal;
    private byte mcuVersion;

    NikonLensInfo(@Nonnull byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        this.version = buffer.getInt();
        int offset = 6;
        if (this.version == 0x30313031) {
            offset = 11;
        }
        if (this.version != 0x30313030 && this.version != 0x30313031) {
            return;
        }
        this.lensID = buffer.get(offset + 0);
        this.lensName = lensNameByID.getProperty("" + this.lensID);
        this.lensFStops = buffer.get(offset + 1);
        this.minFocalLength = buffer.get(offset + 2);
        this.maxFocalLength = buffer.get(offset + 3);
        this.maxApertureAtMinFocal = buffer.get(offset + 4);
        this.maxApertureAtMaxFocal = buffer.get(offset + 5);
        this.mcuVersion = buffer.get(12);
    }

    public String getLensName() {
        return this.lensName;
    }

    @Nonnull
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Version: " + Integer.toHexString(this.version));
        buffer.append(", lensID: " + this.lensID);
        buffer.append(", lensName: " + this.lensName);
        buffer.append(", lensFStops: " + this.lensFStops);
        buffer.append(", minFocalLength: " + this.minFocalLength);
        buffer.append(", maxFocalLength: " + this.maxFocalLength);
        buffer.append(", maxApertureAtMinFocal: " + this.maxApertureAtMinFocal);
        buffer.append(", maxApertureAtMaxFocal: " + this.maxApertureAtMaxFocal);
        buffer.append(", mcuVersion: " + this.mcuVersion);
        return buffer.toString();
    }

    static {
        try {
            InputStream is = NikonLensInfo.class.getResourceAsStream("NikonLens.properties");
            if (is == null) {
                throw new RuntimeException("Cannot load NikonLens.properties");
            }
            lensNameByID.load(is);
            is.close();
        }
        catch (IOException e2) {
            logger.severe(e2.toString(), new Object[0]);
            logger.throwing(CLASS, "static ctor", e2);
        }
    }
}

