/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.pef;

import it.tidalwave.imageio.io.RAWImageInputStream;
import it.tidalwave.imageio.util.Logger;
import java.io.DataInputStream;
import java.io.IOException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class PEFDecoder {
    private static final String CLASS = PEFDecoder.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    private int bitBuffer = 0;
    private int availableBitCount = 0;
    private boolean reset = false;
    private final int[] bitCountTable = new int[4096];
    private final byte[] byteTable = new byte[4096];

    public void load(@Nonnull DataInputStream iis) throws IOException {
        int c2;
        short[] bit0 = new short[13];
        short[] bit1 = new short[13];
        for (c2 = 0; c2 < 13; ++c2) {
            bit0[c2] = iis.readShort();
        }
        for (c2 = 0; c2 < 13; ++c2) {
            bit1[c2] = iis.readByte();
        }
        for (c2 = 0; c2 < 13; ++c2) {
            for (int i = bit0[c2]; i <= (bit0[c2] + (this.bitCountTable.length >> bit1[c2]) - 1 & this.bitCountTable.length - 1); ++i) {
                this.bitCountTable[i] = bit1[c2];
                this.byteTable[i] = (byte)c2;
            }
        }
    }

    public int decode(@Nonnegative int bitCount, boolean useTable, @Nonnull RAWImageInputStream iis, boolean zeroAfterFF) throws IOException {
        int value;
        if (bitCount == 0 || this.availableBitCount < 0) {
            return 0;
        }
        while (!this.reset && this.availableBitCount < bitCount && (value = iis.read() & 0xFF) != -1 && !(this.reset = zeroAfterFF && value == 255 && iis.read() != 0)) {
            this.bitBuffer = this.bitBuffer << 8 | value;
            this.availableBitCount += 8;
        }
        value = this.bitBuffer << 32 - this.availableBitCount >>> 32 - bitCount;
        if (useTable) {
            this.availableBitCount -= this.bitCountTable[value];
            value = this.byteTable[value] & 0xFF;
        } else {
            this.availableBitCount -= bitCount;
        }
        assert (this.availableBitCount >= 0);
        return value;
    }
}

