/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.raf;

import it.tidalwave.imageio.io.RAWImageInputStream;
import java.io.IOException;
import java.io.Serializable;

public class FujiTable1
implements Serializable {
    private short rawHeight;
    private short rawWidth;
    private short height;
    private short width;
    private boolean fujiLayout;
    private short[] coefficients = new short[4];

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getRawWidth() {
        return this.rawWidth;
    }

    public int getRawHeight() {
        return this.rawHeight;
    }

    public int getRotatedWidth() {
        return this.getWidth() / (this.fujiLayout ? 1 : 2) + this.getHeight() / (this.fujiLayout ? 2 : 1);
    }

    public int getRotatedHeight() {
        return this.getRotatedWidth() - 1;
    }

    public boolean isFujiLayout() {
        return this.fujiLayout;
    }

    public short[] getCoefficients() {
        return this.coefficients == null ? null : (short[])this.coefficients.clone();
    }

    public void load(RAWImageInputStream iis, int offset, int length) throws IOException {
        iis.seek(offset);
        int entries = iis.readInt();
        for (int i = 0; i < entries && iis.getStreamPosition() < (long)(offset + length); ++i) {
            short tag = iis.readShort();
            short len = iis.readShort();
            long save = iis.getStreamPosition();
            switch (tag) {
                case 256: {
                    this.rawHeight = iis.readShort();
                    this.rawWidth = iis.readShort();
                    break;
                }
                case 289: {
                    this.height = iis.readShort();
                    this.width = iis.readShort();
                    if (this.width != 4824) break;
                    this.width = (short)(this.width + 3);
                    break;
                }
                case 304: {
                    this.fujiLayout = (iis.readByte() & 0x80) != 0;
                    break;
                }
                case 12272: {
                    for (int c2 = 0; c2 < this.coefficients.length; ++c2) {
                        this.coefficients[c2] = iis.readShort();
                    }
                    break;
                }
            }
            iis.seek(save + (long)len);
        }
        if (this.fujiLayout) {
            this.width = (short)(this.width / 2);
            this.height = (short)(this.height * 2);
        }
    }
}

