/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.raw;

import it.tidalwave.imageio.io.RAWImageInputStream;
import it.tidalwave.imageio.raw.RAWImageReaderSupport;
import it.tidalwave.imageio.raw.RasterReader;
import it.tidalwave.imageio.util.Logger;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public class Packed12RasterReader
extends RasterReader {
    private static final String CLASS = Packed12RasterReader.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);

    protected void loadUncompressedRaster(@Nonnull RAWImageInputStream iis, @Nonnull WritableRaster raster, @Nonnull RAWImageReaderSupport ir) throws IOException {
        logger.fine("loadUncompressedRaster(%s, %s, %s)", iis, raster, ir);
        DataBufferUShort dataBuffer = (DataBufferUShort)raster.getDataBuffer();
        short[] data = dataBuffer.getData();
        int width = raster.getWidth();
        int height = raster.getHeight();
        int pixelStride = 3;
        int scanStride = width * 3;
        this.setBitsPerSample(12);
        this.selectBitReader(iis, raster, 12);
        for (int y = 0; y < height; ++y) {
            int row = this.getRow(y, height);
            int k = row % 2 * 2;
            int i = row * scanStride;
            for (int x = 0; x < width; ++x) {
                int sample = (int)iis.readBits(12);
                if (this.linearizationTable != null) {
                    sample = this.linearizationTable[sample];
                }
                int j = x % 2;
                data[i + this.cfaOffsets[j + k]] = (short)sample;
                this.endOfColumn(x, iis);
                i += 3;
            }
            ir.processImageProgress(100.0f * (float)y / (float)height);
            this.endOfRow(y, iis);
        }
    }

    protected void endOfColumn(@Nonnegative int x, @Nonnull RAWImageInputStream iis) throws IOException {
    }

    protected void endOfRow(@Nonnegative int y, @Nonnull RAWImageInputStream iis) throws IOException {
    }

    @Nonnull
    public String toString() {
        return String.format("Packed12RasterReader@%x", System.identityHashCode(this));
    }
}

