/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.raw;

import it.tidalwave.imageio.io.RAWImageInputStream;
import it.tidalwave.imageio.io.RAWImageInputStreamImpl;
import it.tidalwave.imageio.raw.PostProcessor;
import it.tidalwave.imageio.raw.RAWImageReadParam;
import it.tidalwave.imageio.raw.RAWMetadataSupport;
import it.tidalwave.imageio.raw.Source;
import it.tidalwave.imageio.raw.Version;
import it.tidalwave.imageio.util.Logger;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.imageio.ImageIO;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RAWImageReaderSpiSupport
extends ImageReaderSpi {
    private static final String CLASS = RAWImageReaderSpiSupport.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    private static Map<Class<?>, PostProcessor> postProcessorMapBySpiClass = new HashMap();

    protected RAWImageReaderSpiSupport(String[] names, String[] suffixes, String[] MIMETypes, Class readerClass, Class[] inputTypes, String[] writerSpiNames, boolean supportsStandardStreamMetadataFormat, String nativeStreamMetadataFormatName, String nativeStreamMetadataFormatClassName, String[] extraStreamMetadataFormatNames, String[] extraStreamMetadataFormatClassNames, boolean supportsStandardImageMetadataFormat, String nativeImageMetadataFormatName, String nativeImageMetadataFormatClassName, String[] extraImageMetadataFormatNames, String[] extraImageMetadataFormatClassNames) {
        super("tidalwave.it", Version.TAG, names, suffixes, MIMETypes, readerClass.getName(), inputTypes, writerSpiNames, supportsStandardStreamMetadataFormat, nativeStreamMetadataFormatName, nativeStreamMetadataFormatClassName, extraStreamMetadataFormatNames, extraStreamMetadataFormatClassNames, supportsStandardImageMetadataFormat, nativeImageMetadataFormatName, nativeImageMetadataFormatClassName, extraImageMetadataFormatNames, extraImageMetadataFormatClassNames);
    }

    protected RAWImageReaderSpiSupport(String name, String[] suffixes, String mimeType, Class readerClass) {
        this(new String[]{name.toLowerCase(), name.toUpperCase()}, suffixes, new String[]{mimeType}, readerClass, new Class[]{ImageInputStream.class}, null, false, null, null, null, null, false, null, null, null, null);
    }

    protected RAWImageReaderSpiSupport(String name, String suffix, String mimeType, Class readerClass) {
        this(name, new String[]{suffix.toLowerCase(), suffix.toUpperCase()}, mimeType, readerClass);
    }

    public static void installPostProcessor(Class<?> spiClass, PostProcessor postProcessor) {
        postProcessorMapBySpiClass.put(spiClass, postProcessor);
    }

    @Nonnull
    protected BufferedImage postProcess(@Nonnull BufferedImage image, @Nonnull RAWMetadataSupport metadata, @Nonnull RAWImageReadParam readParam) {
        logger.fine("postProcess(%s, %s, %s)", image, metadata.getClass(), readParam);
        Source source = readParam.lookup(Source.class);
        PostProcessor postProcessor = !source.needsPostProcessor() ? null : postProcessorMapBySpiClass.get(this.getClass());
        logger.finer(">>>> source: %s, postProcessor: %s", source, postProcessor);
        return postProcessor != null ? postProcessor.process(image, metadata, readParam) : image;
    }

    protected void postProcessMetadata(@Nonnull RAWMetadataSupport metadata, @Nonnull RAWImageReadParam readParam) {
        logger.fine("postProcessMetadata(%s, %s)", metadata.getClass(), readParam);
        Source source = readParam.lookup(Source.class);
        PostProcessor postProcessor = !source.needsPostProcessor() ? null : postProcessorMapBySpiClass.get(this.getClass());
        logger.finer(">>>> source: %s, postProcessor: %s", source, postProcessor);
        if (postProcessor != null) {
            postProcessor.processMetadata(metadata, readParam);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canDecodeInput(Object source) throws IOException {
        if (source instanceof ImageInputStream) {
            return this.canDecodeInput((ImageInputStream)source);
        }
        ImageInputStream iis = null;
        try {
            iis = ImageIO.createImageInputStream(source);
            if (iis != null) {
                boolean bl = this.canDecodeInput(iis);
                return bl;
            }
        }
        finally {
            if (iis != null) {
                iis.close();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canDecodeInput(ImageInputStream source) throws IOException {
        RAWImageInputStreamImpl iis = new RAWImageInputStreamImpl(source);
        iis.setDontCloseDelegate();
        try {
            iis.mark();
            boolean bl = this.canDecodeInput(iis);
            return bl;
        }
        catch (Exception e2) {
            boolean bl = false;
            return bl;
        }
        finally {
            iis.setBaseOffset(0L);
            iis.reset();
        }
    }

    protected abstract boolean canDecodeInput(RAWImageInputStream var1) throws IOException;
}

