/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.rawprocessor.demosaic;

import it.tidalwave.imageio.rawprocessor.demosaic.BayerInfo;
import it.tidalwave.imageio.rawprocessor.demosaic.DemosaicingFilter;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;

public class BilinearDemosaicingFilter
extends DemosaicingFilter {
    public void filter(Raster raster, BayerInfo bayerInfo) {
        int c2;
        int x;
        int y;
        int rsStride = bayerInfo.getRedSampleStride();
        int gs1Stride = bayerInfo.getGreenSample1Stride();
        int gs2Stride = bayerInfo.getGreenSample2Stride();
        int bsStride = bayerInfo.getBlueSampleStride();
        int rihStride = bayerInfo.getRedHInterpStride();
        int rivStride = bayerInfo.getRedVInterpStride();
        int ricStride = bayerInfo.getRedCInterpStride();
        int gi1Stride = bayerInfo.getGreenInterp1Stride();
        int gi2Stride = bayerInfo.getGreenInterp2Stride();
        int bihStride = bayerInfo.getBlueHInterpStride();
        int bivStride = bayerInfo.getBlueVInterpStride();
        int bicStride = bayerInfo.getBlueCInterpStride();
        DataBufferUShort dataBuffer = (DataBufferUShort)raster.getDataBuffer();
        short[] data = dataBuffer.getData();
        int w = raster.getWidth();
        int h = raster.getHeight();
        int pixelStride = bayerInfo.getPixelStride();
        int scanStride = bayerInfo.getScanlineStride();
        int margin = 1;
        int tl = -scanStride - pixelStride;
        int t = -scanStride;
        int tr = -scanStride + pixelStride;
        int l = -pixelStride;
        int r = pixelStride;
        int bl = scanStride - pixelStride;
        int b2 = scanStride;
        int br = scanStride + pixelStride;
        for (y = 0; y < h - 1; y += 2) {
            for (x = 0; x < w - 1; x += 2) {
                c2 = x * pixelStride + y * scanStride;
                int rs = c2 + rsStride;
                int gs1 = c2 + gs1Stride;
                int gs2 = c2 + gs2Stride;
                int bs = c2 + bsStride;
                data[rs] = this.applyCoefficientAndCurve(this.redCoefficient, data[rs] & 0xFFFF);
                data[gs1] = this.applyCoefficientAndCurve(this.greenCoefficient, data[gs1] & 0xFFFF);
                data[gs2] = this.applyCoefficientAndCurve(this.greenCoefficient, data[gs2] & 0xFFFF);
                data[bs] = this.applyCoefficientAndCurve(this.blueCoefficient, data[bs] & 0xFFFF);
            }
            Thread.yield();
        }
        for (y = margin * 2; y < h - margin * 2; y += 2) {
            for (x = margin * 2; x < w - margin * 2; x += 2) {
                c2 = x * pixelStride + y * scanStride;
                int rih = c2 + rihStride;
                int riv = c2 + rivStride;
                int ric = c2 + ricStride;
                int gi1 = c2 + gi1Stride;
                int gi2 = c2 + gi2Stride;
                int bih = c2 + bihStride;
                int biv = c2 + bivStride;
                int bic = c2 + bicStride;
                int drih = ((data[rih + l] & 0xFFFF) + (data[rih + r] & 0xFFFF)) / 2;
                int driv = ((data[riv + t] & 0xFFFF) + (data[riv + b2] & 0xFFFF)) / 2;
                int dric = ((data[ric + tl] & 0xFFFF) + (data[ric + tr] & 0xFFFF) + (data[ric + bl] & 0xFFFF) + (data[ric + br] & 0xFFFF)) / 4;
                int dgi1 = ((data[gi1 + t] & 0xFFFF) + (data[gi1 + l] & 0xFFFF) + (data[gi1 + r] & 0xFFFF) + (data[gi1 + b2] & 0xFFFF)) / 4;
                int dgi2 = ((data[gi2 + t] & 0xFFFF) + (data[gi2 + l] & 0xFFFF) + (data[gi2 + r] & 0xFFFF) + (data[gi2 + b2] & 0xFFFF)) / 4;
                int dbih = ((data[bih + l] & 0xFFFF) + (data[bih + r] & 0xFFFF)) / 2;
                int dbiv = ((data[biv + t] & 0xFFFF) + (data[biv + b2] & 0xFFFF)) / 2;
                int dbic = ((data[bic + tl] & 0xFFFF) + (data[bic + tr] & 0xFFFF) + (data[bic + bl] & 0xFFFF) + (data[bic + br] & 0xFFFF)) / 4;
                data[rih] = (short)(drih <= 65535 ? drih : 65535);
                data[riv] = (short)(driv <= 65535 ? driv : 65535);
                data[ric] = (short)(dric <= 65535 ? dric : 65535);
                data[gi1] = (short)(dgi1 <= 65535 ? dgi1 : 65535);
                data[gi2] = (short)(dgi2 <= 65535 ? dgi2 : 65535);
                data[bih] = (short)(dbih <= 65535 ? dbih : 65535);
                data[biv] = (short)(dbiv <= 65535 ? dbiv : 65535);
                data[bic] = (short)(dbic <= 65535 ? dbic : 65535);
            }
            Thread.yield();
        }
    }
}

