/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.rawprocessor.demosaic;

import it.tidalwave.imageio.rawprocessor.demosaic.BayerInfo;
import it.tidalwave.imageio.rawprocessor.demosaic.DemosaicingFilter;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;

public class PixelGroupingDemosaicingFilter
extends DemosaicingFilter {
    private int tl;
    private int t;
    private int tr;
    private int l;
    private int r;
    private int bl;
    private int b;
    private int br;
    private int R_OFFSET;
    private int G_OFFSET;
    private int B_OFFSET;

    public void filter(Raster raster, BayerInfo bayerInfo) {
        int rsStride = bayerInfo.getRedSampleStride();
        int gs1Stride = bayerInfo.getGreenSample1Stride();
        int gs2Stride = bayerInfo.getGreenSample2Stride();
        int bsStride = bayerInfo.getBlueSampleStride();
        DataBufferUShort dataBuffer = (DataBufferUShort)raster.getDataBuffer();
        short[] data = dataBuffer.getData();
        int w = raster.getWidth();
        int h = raster.getHeight();
        int pixelStride = bayerInfo.getPixelStride();
        int scanStride = bayerInfo.getScanlineStride();
        int margin = 1;
        this.R_OFFSET = bayerInfo.getRedOffset();
        this.G_OFFSET = bayerInfo.getGreenOffset();
        this.B_OFFSET = bayerInfo.getBlueOffset();
        this.tl = -scanStride - pixelStride;
        this.t = -scanStride;
        this.tr = -scanStride + pixelStride;
        this.l = -pixelStride;
        this.r = pixelStride;
        this.bl = scanStride - pixelStride;
        this.b = scanStride;
        this.br = scanStride + pixelStride;
        int top = margin * 2;
        int bottom = h - margin * 2;
        int OFFSET1 = 8;
        int OFFSET2 = OFFSET1 + 8;
        for (int y = 0; y < h + OFFSET2; y += 2) {
            int c2;
            int x;
            int y1 = y;
            int y2 = y - OFFSET1;
            int y3 = y - OFFSET2;
            if (y1 >= 0 && y1 < h) {
                for (x = 0; x < w; x += 2) {
                    c2 = x * pixelStride + y1 * scanStride;
                    int rs = c2 + rsStride;
                    int gs1 = c2 + gs1Stride;
                    int gs2 = c2 + gs2Stride;
                    int bs = c2 + bsStride;
                    data[rs] = this.applyCoefficientAndCurve(this.redCoefficient, data[rs] & 0xFFFF);
                    data[gs1] = this.applyCoefficientAndCurve(this.greenCoefficient, data[gs1] & 0xFFFF);
                    data[gs2] = this.applyCoefficientAndCurve(this.greenCoefficient, data[gs2] & 0xFFFF);
                    data[bs] = this.applyCoefficientAndCurve(this.blueCoefficient, data[bs] & 0xFFFF);
                }
            }
            if (y2 >= top && y2 < bottom) {
                for (x = margin * 2; x < w - margin * 2; x += 2) {
                    c2 = x * pixelStride + y2 * scanStride;
                    this.interpolateGreen(data, c2 + this.r, this.R_OFFSET);
                    this.interpolateGreen(data, c2 + this.b, this.B_OFFSET);
                }
            }
            if (y3 >= top && y3 < bottom) {
                for (x = margin * 2; x < w - margin * 2; x += 2) {
                    c2 = x * pixelStride + y3 * scanStride;
                    this.interpolateRedBlueAtGreen(data, c2, this.R_OFFSET, this.B_OFFSET);
                    this.interpolateRedBlueAtGreen(data, c2 + this.br, this.B_OFFSET, this.R_OFFSET);
                    this.interpolateRedXBlue(data, c2 + this.r, this.B_OFFSET, this.R_OFFSET);
                    this.interpolateRedXBlue(data, c2 + this.b, this.R_OFFSET, this.B_OFFSET);
                }
            }
            Thread.yield();
        }
    }

    private void interpolateGreen(short[] data, int c2, int chOffset) {
        int rt2 = data[c2 + this.t * 2 + chOffset] & 0xFFFF;
        int rb2 = data[c2 + this.b * 2 + chOffset] & 0xFFFF;
        int rl2 = data[c2 + this.l * 2 + chOffset] & 0xFFFF;
        int rr2 = data[c2 + this.r * 2 + chOffset] & 0xFFFF;
        int rc = data[c2 + chOffset] & 0xFFFF;
        int gt = data[c2 + this.t + this.G_OFFSET] & 0xFFFF;
        int gb = data[c2 + this.b + this.G_OFFSET] & 0xFFFF;
        int gl = data[c2 + this.l + this.G_OFFSET] & 0xFFFF;
        int gr = data[c2 + this.r + this.G_OFFSET] & 0xFFFF;
        int deltaN = Math.abs(rt2 - rc) * 2 + Math.abs(gt - gb);
        int deltaE = Math.abs(rr2 - rc) * 2 + Math.abs(gl - gr);
        int deltaW = Math.abs(rl2 - rc) * 2 + Math.abs(gl - gr);
        int deltaS = Math.abs(rb2 - rc) * 2 + Math.abs(gt - gb);
        int deltaMin = Math.min(deltaN, Math.min(deltaE, Math.min(deltaW, deltaS)));
        int green = 0;
        if (deltaMin == deltaN) {
            green = (gt * 3 + rc + gb - rt2) / 4;
        } else if (deltaMin == deltaE) {
            green = (gr * 3 + rc + gl - rr2) / 4;
        } else if (deltaMin == deltaW) {
            green = (gl * 3 + rc + gr - rl2) / 4;
        } else if (deltaMin == deltaS) {
            green = (gb * 3 + rc + gt - rb2) / 4;
        }
        if (green < 0) {
            green = 0;
        }
        data[c2 + this.G_OFFSET] = (short)(green < 65535 ? green : 65535);
    }

    private void interpolateRedBlueAtGreen(short[] data, int c2, int chOffsetH, int chOffsetV) {
        int gsc = data[c2 + this.G_OFFSET] & 0xFFFF;
        int gsl = data[c2 + this.l + this.G_OFFSET] & 0xFFFF;
        int gsr = data[c2 + this.r + this.G_OFFSET] & 0xFFFF;
        int gst = data[c2 + this.t + this.G_OFFSET] & 0xFFFF;
        int gsb = data[c2 + this.b + this.G_OFFSET] & 0xFFFF;
        int hsl = data[c2 + this.l + chOffsetH] & 0xFFFF;
        int hsr = data[c2 + this.r + chOffsetH] & 0xFFFF;
        int vst = data[c2 + this.t + chOffsetV] & 0xFFFF;
        int vsb = data[c2 + this.b + chOffsetV] & 0xFFFF;
        int hh = PixelGroupingDemosaicingFilter.hueTransit(gsl, gsc, gsr, hsl, hsr);
        int vv = PixelGroupingDemosaicingFilter.hueTransit(gst, gsc, gsb, vst, vsb);
        if (hh < 0) {
            hh = 0;
        }
        if (vv < 0) {
            vv = 0;
        }
        data[c2 + chOffsetH] = (short)(hh < 65535 ? hh : 65535);
        data[c2 + chOffsetV] = (short)(vv < 65535 ? vv : 65535);
    }

    private void interpolateRedXBlue(short[] data, int c2, int chOffset, int chOffset2) {
        int gsc = data[c2 + this.G_OFFSET] & 0xFFFF;
        int gstr = data[c2 + this.tr + this.G_OFFSET] & 0xFFFF;
        int gsbl = data[c2 + this.bl + this.G_OFFSET] & 0xFFFF;
        int gstl = data[c2 + this.tl + this.G_OFFSET] & 0xFFFF;
        int gsbr = data[c2 + this.br + this.G_OFFSET] & 0xFFFF;
        int bstr = data[c2 + this.tr + chOffset] & 0xFFFF;
        int bsbl = data[c2 + this.bl + chOffset] & 0xFFFF;
        int bstl = data[c2 + this.tl + chOffset] & 0xFFFF;
        int bsbr = data[c2 + this.br + chOffset] & 0xFFFF;
        int rsc = data[c2 + chOffset2] & 0xFFFF;
        int rstr2 = data[c2 + this.tr * 2 + chOffset2] & 0xFFFF;
        int rsbl2 = data[c2 + this.bl * 2 + chOffset2] & 0xFFFF;
        int rstl2 = data[c2 + this.tl * 2 + chOffset2] & 0xFFFF;
        int rsbr2 = data[c2 + this.br * 2 + chOffset2] & 0xFFFF;
        int deltaNE = Math.abs(bstr - bsbl) + Math.abs(rstr2 - rsc) + Math.abs(rsbl2 - rsc) + Math.abs(gstr - gsc) + Math.abs(gsbl - gsc);
        int deltaNW = Math.abs(bstl - bsbr) + Math.abs(rstl2 - rsc) + Math.abs(rsbr2 - rsc) + Math.abs(gstl - gsc) + Math.abs(gsbr - gsc);
        int cc = 0;
        cc = deltaNE <= deltaNW ? PixelGroupingDemosaicingFilter.hueTransit(gstr, gsc, gsbl, bstr, bsbl) : PixelGroupingDemosaicingFilter.hueTransit(gstl, gsc, gsbr, bstl, bsbr);
        if (cc < 0) {
            cc = 0;
        }
        data[c2 + chOffset] = (short)(cc < 65535 ? cc : 65535);
    }

    private static int hueTransit(int l1, int l2, int l3, int v1, int v3) {
        if (l1 < l2 && l2 < l3 || l1 > l2 && l2 > l3) {
            long x = (long)(v3 - v1) * (long)(l2 - l1);
            return v1 + (int)(x / (long)(l3 - l1));
        }
        return (v1 + v3) / 2 + (l2 * 2 - l1 - l3) / 4;
    }
}

