/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.rawprocessor.nef;

import it.tidalwave.imageio.nef.NEFMetadata;
import it.tidalwave.imageio.nef.Nikon3MakerNoteSupport;
import it.tidalwave.imageio.nef.NikonMakerNote3;
import it.tidalwave.imageio.rawprocessor.ColorMatrix;
import it.tidalwave.imageio.rawprocessor.PipelineArtifact;
import it.tidalwave.imageio.rawprocessor.raw.ColorConversionOperation;
import it.tidalwave.imageio.tiff.IFD;
import it.tidalwave.imageio.util.Logger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class NEFColorConversionOperation
extends ColorConversionOperation {
    private static final String CLASS = NEFColorConversionOperation.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    private static Map colorMatrixProfileMap;
    private static Map colorModesMap;

    @CheckForNull
    protected ColorMatrix getColorMatrixXYZ(@Nonnull PipelineArtifact artifact) {
        NEFMetadata metadata = (NEFMetadata)artifact.getRAWMetadata();
        IFD primaryIFD = metadata.getPrimaryIFD();
        NikonMakerNote3 makerNote = metadata.getNikonMakerNote();
        Nikon3MakerNoteSupport.ColorMode colorMode = makerNote.isColorModeAvailable() ? makerNote.getColorMode() : Nikon3MakerNoteSupport.ColorMode.getInstance("default");
        ColorMatrix colorMatrix = NEFColorConversionOperation.getColorModeColorMatrix(primaryIFD.getModel(), colorMode);
        logger.finer(">>>> model: %s colorMode: %s matrixXYZ: %s", primaryIFD.getModel(), colorMode, colorMatrix);
        return colorMatrix;
    }

    @Nonnull
    private static ColorMatrix parseColorMatrix(@Nonnull String string) {
        int j = string.indexOf(35);
        if (j >= 0) {
            string = string.substring(0, j);
        }
        String[] parts = string.trim().split(" ");
        assert (parts.length == 9) : "Not a 3x3 matrix: " + Arrays.asList(parts);
        double[] c2 = new double[9];
        for (int i = 0; i < c2.length; ++i) {
            c2[i] = Double.parseDouble(parts[i].trim());
        }
        return new ColorMatrix(c2);
    }

    @CheckForNull
    public static ColorMatrix getColorModeColorMatrix(@Nonnull String model, @Nonnull Nikon3MakerNoteSupport.ColorMode cameraColorMode) {
        NEFColorConversionOperation.loadICCProfileMap();
        return (ColorMatrix)colorMatrixProfileMap.get(NEFColorConversionOperation.getCompositeKey(model, cameraColorMode));
    }

    @CheckForNull
    public static ColorMatrix getColorModeColorMatrix(@Nonnull String model, int nceColorMode) {
        NEFColorConversionOperation.loadICCProfileMap();
        return (ColorMatrix)colorMatrixProfileMap.get(NEFColorConversionOperation.getCompositeKey(model, new Integer(nceColorMode)));
    }

    @CheckForNull
    public static int[] getColorModes(@Nonnull String model) {
        NEFColorConversionOperation.loadICCProfileMap();
        return (int[])colorModesMap.get(model);
    }

    @Nonnull
    private static Object getCompositeKey(@Nonnull String model, @Nonnull Object colorMode) {
        return model.toString().trim() + "." + colorMode.toString().trim();
    }

    private static synchronized void loadICCProfileMap() {
        if (colorMatrixProfileMap == null) {
            colorMatrixProfileMap = new HashMap();
            colorModesMap = new HashMap();
            Properties properties = NEFColorConversionOperation.getProperties(NEFColorConversionOperation.class);
            String property = properties.getProperty("models");
            if (property != null) {
                String[] models = property.split(",");
                for (int j = 0; j < models.length; ++j) {
                    String model;
                    String prefix = model = models[j].trim();
                    String alias = properties.getProperty(model + ".alias");
                    if (alias != null) {
                        prefix = alias;
                    }
                    String[] colorModeNames = properties.getProperty(prefix + ".colorModes").split(",");
                    int[] colorModes = new int[colorModeNames.length];
                    for (int i = 0; i < colorModes.length; ++i) {
                        String colorMode = colorModeNames[i].trim();
                        Integer nceCode = new Integer(properties.getProperty(prefix + "." + colorMode + ".nceCode"));
                        colorModes[i] = nceCode;
                        ColorMatrix colorMatrix = null;
                        String colorMatrixString = properties.getProperty(prefix + "." + colorMode + ".colorMatrix");
                        if (colorMatrixString != null) {
                            colorMatrix = NEFColorConversionOperation.parseColorMatrix(colorMatrixString);
                            colorMatrixProfileMap.put(NEFColorConversionOperation.getCompositeKey(model, nceCode), colorMatrix);
                            colorMatrixProfileMap.put(NEFColorConversionOperation.getCompositeKey(model, colorMode), colorMatrix);
                        }
                        logger.fine("Model: %s, colorMode: %s, nce code: %s", model, colorMode, nceCode);
                        logger.fine(">>>> Color matrix:   %s", colorMatrix);
                    }
                    colorModesMap.put(model, colorModes);
                }
            }
        }
    }
}

