/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.rawprocessor.orf;

import it.tidalwave.imageio.orf.OlympusMakerNote;
import it.tidalwave.imageio.rawprocessor.PipelineArtifact;
import it.tidalwave.imageio.rawprocessor.raw.CurveOperation;
import it.tidalwave.imageio.tiff.TIFFMetadataSupport;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class ORFCurveOperation
extends CurveOperation {
    @CheckForNull
    private OlympusMakerNote orfMakernote;
    @CheckForNull
    private String model;

    public void init(@Nonnull PipelineArtifact artifact) throws Exception {
        this.orfMakernote = (OlympusMakerNote)artifact.getRAWMetadata().getMakerNote();
        this.model = ((TIFFMetadataSupport)artifact.getRAWMetadata()).getPrimaryIFD().getModel().toUpperCase().trim();
    }

    @Nonnull
    protected int[] getBlackLevel(@Nonnull PipelineArtifact artifact) {
        int[] blackLevels = new int[]{0, 0, 0};
        if (this.orfMakernote.isBlackLevelAvailable()) {
            int[] orfBlackLevel = this.orfMakernote.getBlackLevel();
            blackLevels[0] = orfBlackLevel[0];
            blackLevels[1] = orfBlackLevel[1];
            blackLevels[2] = orfBlackLevel[2];
        }
        return blackLevels;
    }

    protected double getWhiteLevel(@Nonnull PipelineArtifact artifact) {
        int validBits = 12;
        if (this.orfMakernote.isValidBitsAvailable()) {
            validBits = this.orfMakernote.getValidBits()[0];
        }
        if ("E-1".equals(this.model) || "E-10".equals(this.model)) {
            validBits = 16;
        }
        return (1 << validBits) - 1;
    }
}

