/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.rawprocessor.raw;

import it.tidalwave.imageio.raw.Source;
import it.tidalwave.imageio.raw.TagRational;
import it.tidalwave.imageio.rawprocessor.ColorMatrix;
import it.tidalwave.imageio.rawprocessor.OperationSupport;
import it.tidalwave.imageio.rawprocessor.PipelineArtifact;
import it.tidalwave.imageio.util.Logger;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public abstract class ColorConversionOperation
extends OperationSupport {
    private static final Logger logger = ColorConversionOperation.getLogger(ColorConversionOperation.class);

    public ColorConversionOperation() {
        super(Source.Type.RAW);
    }

    public void process(@Nonnull PipelineArtifact artifact) {
        ColorMatrix colorMatrix = this.getColorMatrix(artifact);
        if (colorMatrix != null) {
            ColorConversionOperation.applyMatrix(artifact.getImage().getRaster(), colorMatrix);
        }
    }

    @CheckForNull
    protected ColorMatrix getColorMatrix(@Nonnull PipelineArtifact artifact) {
        ColorMatrix colorMatrix = this.getColorMatrixXYZ(artifact);
        if (colorMatrix != null) {
            logger.finer(">>>> colorMatrix in XYZ space: %s", colorMatrix);
            ColorMatrix colorMatrixRGB = colorMatrix.product(ColorMatrix.XYZ_TO_RGB);
            logger.finer(">>>> colorMatrix in RGB space: %s", colorMatrixRGB);
            colorMatrixRGB.normalizeRows();
            logger.finer(">>>> colorMatrix in RGB space, normalized: %s", colorMatrixRGB);
            colorMatrixRGB = colorMatrixRGB.inverse();
            logger.finer(">>>> final colorMatrix: %s", colorMatrixRGB);
            return colorMatrixRGB;
        }
        return null;
    }

    @CheckForNull
    protected ColorMatrix getColorMatrixXYZ(@Nonnull PipelineArtifact artifact) {
        return null;
    }

    @CheckForNull
    protected static ColorMatrix getMatrix(@Nonnull TagRational[] matrix) {
        double[] c2 = new double[matrix.length];
        for (int i = 0; i < c2.length; ++i) {
            c2[i] = matrix[i].doubleValue();
        }
        return new ColorMatrix(c2);
    }

    @CheckForNull
    protected static ColorMatrix getMatrix(@Nonnull int[] matrix, @Nonnegative double scale) {
        double[] c2 = new double[matrix.length];
        for (int i = 0; i < c2.length; ++i) {
            c2[i] = scale * (double)matrix[i];
        }
        return new ColorMatrix(c2);
    }

    private static void applyMatrix(@Nonnull WritableRaster raster, @Nonnull ColorMatrix colorMatrix1) {
        logger.fine("applyMatrix(%s, %s)", raster, colorMatrix1);
        long time = System.currentTimeMillis();
        DataBufferUShort dataBuffer = (DataBufferUShort)raster.getDataBuffer();
        short[] data = dataBuffer.getData();
        int w = raster.getWidth();
        int h = raster.getHeight();
        while (raster.getParent() != null) {
            raster = (WritableRaster)raster.getParent();
        }
        int pixelStride = raster.getNumBands();
        int scanStride = raster.getWidth() * pixelStride;
        logger.finer(">>>> pixelStride: %d, scanStride: %d", pixelStride, scanStride);
        logger.finer(">>>> offset: %d", dataBuffer.getOffset());
        w = raster.getWidth();
        h = raster.getHeight();
        for (int y = 0; y < h; ++y) {
            int scan = y * scanStride + dataBuffer.getOffset();
            for (int x = 0; x < w; ++x) {
                colorMatrix1.process(data, scan);
                scan += pixelStride;
            }
            Thread.yield();
        }
        logger.finest(">>>> applyMatrix() completed ok in %d msec.", System.currentTimeMillis() - time);
    }
}

