/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.rawprocessor.raw;

import it.tidalwave.imageio.raw.Source;
import it.tidalwave.imageio.raw.TagRational;
import it.tidalwave.imageio.rawprocessor.OperationSupport;
import it.tidalwave.imageio.rawprocessor.PipelineArtifact;
import it.tidalwave.imageio.tiff.IFD;
import it.tidalwave.imageio.tiff.TIFFMetadataSupport;
import it.tidalwave.imageio.util.Logger;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class SizeOperation
extends OperationSupport {
    private static final Logger logger = SizeOperation.getLogger(SizeOperation.class);
    protected static final TagRational ONE = new TagRational(1, 1);
    protected static final TagRational[] SCALE_UNCHANGED = new TagRational[]{ONE, ONE};
    protected static final Insets NULL_CROP = new Insets(0, 0, 0, 0);
    private final Properties properties = new Properties();

    public SizeOperation() {
        super(Source.Type.RAW);
        try {
            String fileName = "/" + this.getClass().getName().replace('.', '/') + ".properties";
            InputStream is = this.getClass().getResourceAsStream(fileName);
            if (is != null) {
                this.properties.load(is);
                is.close();
            }
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    public void process(@Nonnull PipelineArtifact artifact) throws Exception {
        Dimension size;
        logger.fine("process(%s)", artifact);
        Insets crop = this.getCrop(artifact);
        if (crop != null && !crop.equals(NULL_CROP)) {
            logger.finer(">>>> crop: %s", crop);
            artifact.setImage(this.crop(artifact.getImage(), crop));
        }
        if ((size = this.getSize(artifact)) != null) {
            logger.finer(">>>> size: %s", size);
            artifact.setImage(this.resample(artifact.getImage(), size));
        }
    }

    public void processMetadata(@Nonnull PipelineArtifact artifact) {
        logger.fine("processMetadata(%s)", artifact);
        artifact.getRAWMetadata().setOverriddenImageSize(this.getSize(artifact));
    }

    @Nonnull
    protected Insets getCrop(@Nonnull PipelineArtifact artifact) {
        logger.fine("getCrop(%s)", artifact);
        TIFFMetadataSupport metadata = (TIFFMetadataSupport)artifact.getRAWMetadata();
        IFD primaryIFD = metadata.getPrimaryIFD();
        Insets crop = this.getStandardCrop(primaryIFD.getModel());
        if (crop == null) {
            crop = new Insets(0, 0, 0, 0);
        }
        return crop;
    }

    @Nonnull
    protected Dimension getSize(@Nonnull PipelineArtifact artifact) {
        logger.fine("getSize(%s)", artifact);
        TIFFMetadataSupport metadata = (TIFFMetadataSupport)artifact.getRAWMetadata();
        IFD primaryIFD = metadata.getPrimaryIFD();
        return this.getStandardSize(primaryIFD.getModel());
    }

    @Nonnull
    protected BufferedImage resample(@Nonnull BufferedImage image, @Nonnull Dimension dimension) {
        logger.warning("resample(" + dimension + ") - NOT IMPLEMENTED", new Object[0]);
        SizeOperation.logImage(logger, ">>>> image: ", image);
        SizeOperation.logImage(logger, ">>>> resample returning: ", image);
        return image;
    }

    @Nonnull
    protected BufferedImage crop(@Nonnull BufferedImage image, @Nonnull Insets crop) {
        logger.finer("crop(%s)", crop);
        SizeOperation.logImage(logger, ">>>> image: ", image);
        image = image.getSubimage(crop.left, crop.top, image.getWidth() - crop.left - crop.right, image.getHeight() - crop.top - crop.bottom);
        SizeOperation.logImage(logger, ">>>> crop returning: ", image);
        return image;
    }

    @CheckForNull
    protected static Dimension rotate(@Nullable Dimension size, @Nonnegative int rotation) {
        logger.finer("rotate(%s, %d)", size, rotation);
        Dimension result = null;
        if (size != null) {
            switch (rotation) {
                case 0: 
                case 180: {
                    result = new Dimension(size);
                    break;
                }
                case 90: 
                case 270: {
                    result = new Dimension(size.height, size.width);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("rotation=" + rotation);
                }
            }
        }
        logger.finest(">>>> returning: %s", result);
        return result;
    }

    @Nonnull
    protected static Insets rotate(@Nonnull Insets crop, @Nonnegative int rotation) {
        logger.finer("rotate(%s, %d)", crop, rotation);
        Insets result = new Insets(0, 0, 0, 0);
        switch (rotation) {
            case 0: {
                result.left = crop.left;
                result.top = crop.top;
                result.right = crop.right;
                result.bottom = crop.bottom;
                break;
            }
            case 90: {
                result.left = crop.top;
                result.top = crop.right;
                result.right = crop.bottom;
                result.bottom = crop.left;
                break;
            }
            case 180: {
                result.left = crop.right;
                result.top = crop.bottom;
                result.right = crop.left;
                result.bottom = crop.top;
                break;
            }
            case 270: {
                result.left = crop.bottom;
                result.top = crop.left;
                result.right = crop.top;
                result.bottom = crop.right;
                break;
            }
            default: {
                throw new IllegalArgumentException("rotation=" + rotation);
            }
        }
        logger.finest(">>>> returning: %s", result);
        return result;
    }

    @Nonnull
    protected static Rectangle rotate(@Nonnull Rectangle rectangle, @Nonnull Dimension size, @Nonnegative int rotation) {
        logger.finest("rotate(%s, %s, %d)", rectangle, size, rotation);
        Rectangle result = new Rectangle(0, 0, 0, 0);
        switch (rotation) {
            case 0: {
                result.x = rectangle.x;
                result.y = rectangle.y;
                result.width = rectangle.width;
                result.height = rectangle.height;
                break;
            }
            case 90: {
                result.x = rectangle.y;
                result.y = size.width - rectangle.x - rectangle.width;
                result.width = rectangle.height;
                result.height = rectangle.width;
                break;
            }
            case 180: {
                result.x = size.width - rectangle.x - rectangle.width;
                result.y = size.height - rectangle.y - rectangle.height;
                result.width = rectangle.width;
                result.height = rectangle.height;
                break;
            }
            case 270: {
                result.x = size.height - rectangle.y - rectangle.height;
                result.y = rectangle.x;
                result.width = rectangle.height;
                result.height = rectangle.width;
                break;
            }
            default: {
                throw new IllegalArgumentException("rotation=" + rotation);
            }
        }
        logger.finest(">>>> returning: %s", result);
        return result;
    }

    @Nonnull
    public Dimension getStandardSize(@Nonnull String model) {
        model = model.trim();
        logger.fine("getStandardSize(%s)", model);
        String string = this.properties.getProperty(model);
        Dimension size = null;
        if (string != null) {
            StringTokenizer st = new StringTokenizer(string, " \t");
            int width = Integer.parseInt(st.nextToken());
            int height = Integer.parseInt(st.nextToken());
            size = new Dimension(width, height);
        }
        logger.finer(">>>> size: %s", size);
        return size;
    }

    @Nonnull
    public Insets getStandardCrop(@Nonnull String model) {
        model = model.trim();
        logger.fine("getStandardCrop(%s)", model);
        String string = this.properties.getProperty(model);
        Insets cropInsets = null;
        if (string != null) {
            StringTokenizer st = new StringTokenizer(string, " \t");
            st.nextToken();
            st.nextToken();
            int l = Integer.parseInt(st.nextToken());
            int r = Integer.parseInt(st.nextToken());
            int t = Integer.parseInt(st.nextToken());
            int b2 = Integer.parseInt(st.nextToken());
            cropInsets = new Insets(t, l, b2, r);
        }
        logger.finer(">>>> cropInsets: %s", cropInsets);
        return cropInsets;
    }
}

