/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.media.jai.JaiI18N;
import javax.media.jai.PixelAccessor;
import javax.media.jai.ROI;
import javax.media.jai.UnpackedImageData;

public class Histogram
implements Serializable {
    private int[] numBins;
    private double[] lowValue;
    private double[] highValue;
    private int numBands;
    private double[] binWidth;
    private int[][] bins = null;
    private int[] totals = null;
    private double[] mean = null;

    private static final int[] fill(int[] nArray, int n) {
        int[] nArray2 = null;
        if (nArray == null || nArray.length == 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n > 0) {
            nArray2 = new int[n];
            int n2 = nArray.length;
            int n3 = 0;
            while (n3 < n) {
                nArray2[n3] = n3 < n2 ? nArray[n3] : nArray[0];
                ++n3;
            }
        }
        return nArray2;
    }

    private static final double[] fill(double[] dArray, int n) {
        double[] dArray2 = null;
        if (dArray == null || dArray.length == 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n > 0) {
            dArray2 = new double[n];
            int n2 = dArray.length;
            int n3 = 0;
            while (n3 < n) {
                dArray2[n3] = n3 < n2 ? dArray[n3] : dArray[0];
                ++n3;
            }
        }
        return dArray2;
    }

    public Histogram(int[] nArray, double[] dArray, double[] dArray2) {
        if (nArray == null || dArray == null || dArray2 == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.numBands = nArray.length;
        if (dArray.length != this.numBands || dArray2.length != this.numBands) {
            throw new IllegalArgumentException(JaiI18N.getString("Histogram0"));
        }
        if (this.numBands == 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Histogram1"));
        }
        int n = 0;
        while (n < this.numBands) {
            if (nArray[n] <= 0) {
                throw new IllegalArgumentException(JaiI18N.getString("Histogram2"));
            }
            if (dArray[n] >= dArray2[n]) {
                throw new IllegalArgumentException(JaiI18N.getString("Histogram3"));
            }
            ++n;
        }
        this.numBins = (int[])nArray.clone();
        this.lowValue = (double[])dArray.clone();
        this.highValue = (double[])dArray2.clone();
        this.binWidth = new double[this.numBands];
        int n2 = 0;
        while (n2 < this.numBands) {
            this.binWidth[n2] = (dArray2[n2] - dArray[n2]) / (double)nArray[n2];
            ++n2;
        }
    }

    public Histogram(int[] nArray, double[] dArray, double[] dArray2, int n) {
        this(Histogram.fill(nArray, n), Histogram.fill(dArray, n), Histogram.fill(dArray2, n));
    }

    public Histogram(int n, double d2, double d3, int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Histogram1"));
        }
        if (n <= 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Histogram2"));
        }
        if (d2 >= d3) {
            throw new IllegalArgumentException(JaiI18N.getString("Histogram3"));
        }
        this.numBands = n2;
        this.numBins = new int[n2];
        this.lowValue = new double[n2];
        this.highValue = new double[n2];
        this.binWidth = new double[n2];
        double d4 = (d3 - d2) / (double)n;
        int n3 = 0;
        while (n3 < n2) {
            this.numBins[n3] = n;
            this.lowValue[n3] = d2;
            this.highValue[n3] = d3;
            this.binWidth[n3] = d4;
            ++n3;
        }
    }

    public int[] getNumBins() {
        return (int[])this.numBins.clone();
    }

    public int getNumBins(int n) {
        return this.numBins[n];
    }

    public double[] getLowValue() {
        return (double[])this.lowValue.clone();
    }

    public double getLowValue(int n) {
        return this.lowValue[n];
    }

    public double[] getHighValue() {
        return (double[])this.highValue.clone();
    }

    public double getHighValue(int n) {
        return this.highValue[n];
    }

    public int getNumBands() {
        return this.numBands;
    }

    public synchronized int[][] getBins() {
        if (this.bins == null) {
            this.bins = new int[this.numBands][];
            int n = 0;
            while (n < this.numBands) {
                this.bins[n] = new int[this.numBins[n]];
                ++n;
            }
        }
        return this.bins;
    }

    public int[] getBins(int n) {
        this.getBins();
        return this.bins[n];
    }

    public int getBinSize(int n, int n2) {
        this.getBins();
        return this.bins[n][n2];
    }

    public double getBinLowValue(int n, int n2) {
        return this.lowValue[n] + (double)n2 * this.binWidth[n];
    }

    public void clearHistogram() {
        if (this.bins != null) {
            int[][] nArray = this.bins;
            synchronized (nArray) {
                int n = 0;
                while (n < this.numBands) {
                    int[] nArray2 = this.bins[n];
                    int n2 = nArray2.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        nArray2[n3] = 0;
                        ++n3;
                    }
                    ++n;
                }
            }
        }
    }

    public int[] getTotals() {
        if (this.totals == null) {
            this.getBins();
            Histogram histogram = this;
            synchronized (histogram) {
                this.totals = new int[this.numBands];
                int n = 0;
                while (n < this.numBands) {
                    int[] nArray = this.bins[n];
                    int n2 = nArray.length;
                    int n3 = 0;
                    int n4 = 0;
                    while (n4 < n2) {
                        n3 += nArray[n4];
                        ++n4;
                    }
                    this.totals[n] = n3;
                    ++n;
                }
            }
        }
        return this.totals;
    }

    public int getSubTotal(int n, int n2, int n3) {
        if (n2 < 0 || n3 >= this.numBins[n]) {
            throw new ArrayIndexOutOfBoundsException(JaiI18N.getString("Histogram5"));
        }
        if (n2 > n3) {
            throw new IllegalArgumentException(JaiI18N.getString("Histogram10"));
        }
        int[] nArray = this.getBins(n);
        int n4 = 0;
        int n5 = n2;
        while (n5 <= n3) {
            n4 += nArray[n5];
            ++n5;
        }
        return n4;
    }

    public double[] getMean() {
        if (this.mean == null) {
            this.getTotals();
            Histogram histogram = this;
            synchronized (histogram) {
                this.mean = new double[this.numBands];
                int n = 0;
                while (n < this.numBands) {
                    int[] nArray = this.getBins(n);
                    int n2 = this.numBins[n];
                    double d2 = this.getLowValue(n);
                    double d3 = this.binWidth[n];
                    double d4 = 0.0;
                    double d5 = this.totals[n];
                    int n3 = 0;
                    while (n3 < n2) {
                        d4 += (double)nArray[n3] / d5 * d2;
                        d2 += d3;
                        ++n3;
                    }
                    this.mean[n] = d4;
                    ++n;
                }
            }
        }
        return this.mean;
    }

    public void countPixels(Raster raster, ROI rOI, int n, int n2, int n3, int n4) {
        LinkedList linkedList;
        if (raster == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        SampleModel sampleModel = raster.getSampleModel();
        if (sampleModel.getNumBands() != this.numBands) {
            throw new IllegalArgumentException(JaiI18N.getString("Histogram4"));
        }
        Rectangle rectangle = raster.getBounds();
        if (rOI == null) {
            linkedList = new LinkedList();
            linkedList.addLast(rectangle);
        } else {
            linkedList = rOI.getAsRectangleList(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            if (linkedList == null) {
                return;
            }
        }
        PixelAccessor pixelAccessor = new PixelAccessor(sampleModel, null);
        ListIterator listIterator = linkedList.listIterator(0);
        while (listIterator.hasNext()) {
            Rectangle rectangle2 = (Rectangle)listIterator.next();
            int n5 = rectangle2.x;
            int n6 = rectangle2.y;
            rectangle2.x = this.startPosition(n5, n, n3);
            rectangle2.y = this.startPosition(n6, n2, n4);
            rectangle2.width = n5 + rectangle2.width - rectangle2.x;
            rectangle2.height = n6 + rectangle2.height - rectangle2.y;
            if (rectangle2.width <= 0 || rectangle2.height <= 0) continue;
            switch (pixelAccessor.sampleType) {
                case -1: 
                case 0: {
                    this.countPixelsByte(pixelAccessor, raster, rectangle2, n3, n4);
                    break;
                }
                case 1: {
                    this.countPixelsUShort(pixelAccessor, raster, rectangle2, n3, n4);
                    break;
                }
                case 2: {
                    this.countPixelsShort(pixelAccessor, raster, rectangle2, n3, n4);
                    break;
                }
                case 3: {
                    this.countPixelsInt(pixelAccessor, raster, rectangle2, n3, n4);
                    break;
                }
                case 4: {
                    this.countPixelsFloat(pixelAccessor, raster, rectangle2, n3, n4);
                    break;
                }
                case 5: {
                    this.countPixelsDouble(pixelAccessor, raster, rectangle2, n3, n4);
                    break;
                }
                default: {
                    throw new RuntimeException(JaiI18N.getString("Histogram11"));
                }
            }
        }
    }

    private void countPixelsByte(PixelAccessor pixelAccessor, Raster raster, Rectangle rectangle, int n, int n2) {
        UnpackedImageData unpackedImageData = pixelAccessor.getPixels(raster, rectangle, 0, false);
        byte[][] byArray = unpackedImageData.getByteData();
        int n3 = unpackedImageData.pixelStride * n;
        int n4 = unpackedImageData.lineStride * n2;
        int[] nArray = unpackedImageData.bandOffsets;
        int n5 = 0;
        while (n5 < this.numBands) {
            byte[] byArray2 = byArray[n5];
            int n6 = nArray[n5];
            int[] nArray2 = new int[this.numBins[n5]];
            double d2 = this.lowValue[n5];
            double d3 = this.highValue[n5];
            double d4 = this.binWidth[n5];
            int n7 = 0;
            while (n7 < rectangle.height) {
                int n8 = n6;
                n6 += n4;
                int n9 = 0;
                while (n9 < rectangle.width) {
                    int n10 = byArray2[n8] & 0xFF;
                    n8 += n3;
                    if ((double)n10 >= d2 && (double)n10 < d3) {
                        int n11;
                        int n12 = n11 = (int)(((double)n10 - d2) / d4);
                        nArray2[n12] = nArray2[n12] + 1;
                    }
                    n9 += n;
                }
                n7 += n2;
            }
            this.mergeBins(n5, nArray2);
            ++n5;
        }
    }

    private void countPixelsUShort(PixelAccessor pixelAccessor, Raster raster, Rectangle rectangle, int n, int n2) {
        UnpackedImageData unpackedImageData = pixelAccessor.getPixels(raster, rectangle, 1, false);
        short[][] sArray = unpackedImageData.getShortData();
        int n3 = unpackedImageData.pixelStride * n;
        int n4 = unpackedImageData.lineStride * n2;
        int[] nArray = unpackedImageData.bandOffsets;
        int n5 = 0;
        while (n5 < this.numBands) {
            short[] sArray2 = sArray[n5];
            int n6 = nArray[n5];
            int[] nArray2 = new int[this.numBins[n5]];
            double d2 = this.lowValue[n5];
            double d3 = this.highValue[n5];
            double d4 = this.binWidth[n5];
            int n7 = 0;
            while (n7 < rectangle.height) {
                int n8 = n6;
                n6 += n4;
                int n9 = 0;
                while (n9 < rectangle.width) {
                    int n10 = sArray2[n8] & 0xFFFF;
                    n8 += n3;
                    if ((double)n10 >= d2 && (double)n10 < d3) {
                        int n11;
                        int n12 = n11 = (int)(((double)n10 - d2) / d4);
                        nArray2[n12] = nArray2[n12] + 1;
                    }
                    n9 += n;
                }
                n7 += n2;
            }
            this.mergeBins(n5, nArray2);
            ++n5;
        }
    }

    private void countPixelsShort(PixelAccessor pixelAccessor, Raster raster, Rectangle rectangle, int n, int n2) {
        UnpackedImageData unpackedImageData = pixelAccessor.getPixels(raster, rectangle, 2, false);
        short[][] sArray = unpackedImageData.getShortData();
        int n3 = unpackedImageData.pixelStride * n;
        int n4 = unpackedImageData.lineStride * n2;
        int[] nArray = unpackedImageData.bandOffsets;
        int n5 = 0;
        while (n5 < this.numBands) {
            short[] sArray2 = sArray[n5];
            int n6 = nArray[n5];
            int[] nArray2 = new int[this.numBins[n5]];
            double d2 = this.lowValue[n5];
            double d3 = this.highValue[n5];
            double d4 = this.binWidth[n5];
            int n7 = 0;
            while (n7 < rectangle.height) {
                int n8 = n6;
                n6 += n4;
                int n9 = 0;
                while (n9 < rectangle.width) {
                    short s = sArray2[n8];
                    n8 += n3;
                    if ((double)s >= d2 && (double)s < d3) {
                        int n10;
                        int n11 = n10 = (int)(((double)s - d2) / d4);
                        nArray2[n11] = nArray2[n11] + 1;
                    }
                    n9 += n;
                }
                n7 += n2;
            }
            this.mergeBins(n5, nArray2);
            ++n5;
        }
    }

    private void countPixelsInt(PixelAccessor pixelAccessor, Raster raster, Rectangle rectangle, int n, int n2) {
        UnpackedImageData unpackedImageData = pixelAccessor.getPixels(raster, rectangle, 3, false);
        int[][] nArray = unpackedImageData.getIntData();
        int n3 = unpackedImageData.pixelStride * n;
        int n4 = unpackedImageData.lineStride * n2;
        int[] nArray2 = unpackedImageData.bandOffsets;
        int n5 = 0;
        while (n5 < this.numBands) {
            int[] nArray3 = nArray[n5];
            int n6 = nArray2[n5];
            int[] nArray4 = new int[this.numBins[n5]];
            double d2 = this.lowValue[n5];
            double d3 = this.highValue[n5];
            double d4 = this.binWidth[n5];
            int n7 = 0;
            while (n7 < rectangle.height) {
                int n8 = n6;
                n6 += n4;
                int n9 = 0;
                while (n9 < rectangle.width) {
                    int n10 = nArray3[n8];
                    n8 += n3;
                    if ((double)n10 >= d2 && (double)n10 < d3) {
                        int n11;
                        int n12 = n11 = (int)(((double)n10 - d2) / d4);
                        nArray4[n12] = nArray4[n12] + 1;
                    }
                    n9 += n;
                }
                n7 += n2;
            }
            this.mergeBins(n5, nArray4);
            ++n5;
        }
    }

    private void countPixelsFloat(PixelAccessor pixelAccessor, Raster raster, Rectangle rectangle, int n, int n2) {
        UnpackedImageData unpackedImageData = pixelAccessor.getPixels(raster, rectangle, 4, false);
        float[][] fArray = unpackedImageData.getFloatData();
        int n3 = unpackedImageData.pixelStride * n;
        int n4 = unpackedImageData.lineStride * n2;
        int[] nArray = unpackedImageData.bandOffsets;
        int n5 = 0;
        while (n5 < this.numBands) {
            float[] fArray2 = fArray[n5];
            int n6 = nArray[n5];
            int[] nArray2 = new int[this.numBins[n5]];
            double d2 = this.lowValue[n5];
            double d3 = this.highValue[n5];
            double d4 = this.binWidth[n5];
            int n7 = 0;
            while (n7 < rectangle.height) {
                int n8 = n6;
                n6 += n4;
                int n9 = 0;
                while (n9 < rectangle.width) {
                    float f2 = fArray2[n8];
                    n8 += n3;
                    if ((double)f2 >= d2 && (double)f2 < d3) {
                        int n10;
                        int n11 = n10 = (int)(((double)f2 - d2) / d4);
                        nArray2[n11] = nArray2[n11] + 1;
                    }
                    n9 += n;
                }
                n7 += n2;
            }
            this.mergeBins(n5, nArray2);
            ++n5;
        }
    }

    private void countPixelsDouble(PixelAccessor pixelAccessor, Raster raster, Rectangle rectangle, int n, int n2) {
        UnpackedImageData unpackedImageData = pixelAccessor.getPixels(raster, rectangle, 5, false);
        double[][] dArray = unpackedImageData.getDoubleData();
        int n3 = unpackedImageData.pixelStride * n;
        int n4 = unpackedImageData.lineStride * n2;
        int[] nArray = unpackedImageData.bandOffsets;
        int n5 = 0;
        while (n5 < this.numBands) {
            double[] dArray2 = dArray[n5];
            int n6 = nArray[n5];
            int[] nArray2 = new int[this.numBins[n5]];
            double d2 = this.lowValue[n5];
            double d3 = this.highValue[n5];
            double d4 = this.binWidth[n5];
            int n7 = 0;
            while (n7 < rectangle.height) {
                int n8 = n6;
                n6 += n4;
                int n9 = 0;
                while (n9 < rectangle.width) {
                    double d5 = dArray2[n8];
                    n8 += n3;
                    if (d5 >= d2 && d5 < d3) {
                        int n10;
                        int n11 = n10 = (int)((d5 - d2) / d4);
                        nArray2[n11] = nArray2[n11] + 1;
                    }
                    n9 += n;
                }
                n7 += n2;
            }
            this.mergeBins(n5, nArray2);
            ++n5;
        }
    }

    private int startPosition(int n, int n2, int n3) {
        int n4 = (n - n2) % n3;
        return n4 == 0 ? n : n + (n3 - n4);
    }

    private void mergeBins(int n, int[] nArray) {
        this.getBins();
        int[][] nArray2 = this.bins;
        synchronized (nArray2) {
            int[] nArray3 = this.bins[n];
            int n2 = nArray3.length;
            int n3 = 0;
            while (n3 < n2) {
                int n4 = n3;
                nArray3[n4] = nArray3[n4] + nArray[n3];
                ++n3;
            }
        }
    }

    public double[] getMoment(int n, boolean bl, boolean bl2) {
        if (n < 1) {
            throw new IllegalArgumentException(JaiI18N.getString("Histogram6"));
        }
        if ((n == 1 || bl2) && this.mean == null) {
            this.getMean();
        }
        if (n == 1 && !bl && !bl2) {
            return this.mean;
        }
        double[] dArray = new double[this.numBands];
        if (n == 1 && bl2) {
            int n2 = 0;
            while (n2 < this.numBands) {
                dArray[n2] = 0.0;
                ++n2;
            }
        } else {
            this.getTotals();
            int n3 = 0;
            while (n3 < this.numBands) {
                int[] nArray = this.getBins(n3);
                int n4 = this.numBins[n3];
                double d2 = this.getLowValue(n3);
                double d3 = this.binWidth[n3];
                double d4 = this.totals[n3];
                double d5 = 0.0;
                if (bl2) {
                    int n5;
                    double d6 = this.mean[n3];
                    if (bl && n % 2 == 0) {
                        n5 = 0;
                        while (n5 < n4) {
                            d5 += Math.pow(d2 - d6, n) * (double)nArray[n5] / d4;
                            d2 += d3;
                            ++n5;
                        }
                    } else {
                        n5 = 0;
                        while (n5 < n4) {
                            d5 += Math.abs(Math.pow(d2 - d6, n)) * (double)nArray[n5] / d4;
                            d2 += d3;
                            ++n5;
                        }
                    }
                } else if (bl && n % 2 != 0) {
                    int n6 = 0;
                    while (n6 < n4) {
                        d5 += Math.abs(Math.pow(d2, n)) * (double)nArray[n6] / d4;
                        d2 += d3;
                        ++n6;
                    }
                } else {
                    int n7 = 0;
                    while (n7 < n4) {
                        d5 += Math.pow(d2, n) * (double)nArray[n7] / d4;
                        d2 += d3;
                        ++n7;
                    }
                }
                dArray[n3] = d5;
                ++n3;
            }
        }
        return dArray;
    }

    public double[] getStandardDeviation() {
        this.getMean();
        double[] dArray = this.getMoment(2, false, false);
        double[] dArray2 = new double[this.numBands];
        int n = 0;
        while (n < dArray.length) {
            dArray2[n] = Math.sqrt(dArray[n] - this.mean[n] * this.mean[n]);
            ++n;
        }
        return dArray2;
    }

    public double[] getEntropy() {
        this.getTotals();
        double d2 = Math.log(2.0);
        double[] dArray = new double[this.numBands];
        int n = 0;
        while (n < this.numBands) {
            int[] nArray = this.getBins(n);
            int n2 = this.numBins[n];
            double d3 = this.totals[n];
            double d4 = 0.0;
            int n3 = 0;
            while (n3 < n2) {
                double d5 = (double)nArray[n3] / d3;
                if (d5 != 0.0) {
                    d4 -= d5 * (Math.log(d5) / d2);
                }
                ++n3;
            }
            dArray[n] = d4;
            ++n;
        }
        return dArray;
    }

    public Histogram getSmoothed(boolean bl, int n) {
        int n2;
        int n3;
        int n4;
        if (n < 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Histogram7"));
        }
        if (n == 0) {
            return this;
        }
        Histogram histogram = new Histogram(this.getNumBins(), this.getLowValue(), this.getHighValue());
        int[][] nArray = histogram.getBins();
        this.getTotals();
        double[] dArray = null;
        if (bl) {
            n4 = 2 * n + 1;
            double d2 = n4 * n4;
            dArray = new double[n4];
            n3 = 0;
            while (n3 <= n) {
                dArray[n3] = (double)(n3 + 1) / d2;
                ++n3;
            }
            n2 = n + 1;
            while (n2 < n4) {
                dArray[n2] = dArray[n4 - 1 - n2];
                ++n2;
            }
        }
        n4 = 0;
        while (n4 < this.numBands) {
            int n5;
            int n6;
            int n7;
            int n8;
            int[] nArray2 = this.getBins(n4);
            int[] nArray3 = nArray[n4];
            n3 = histogram.getNumBins(n4);
            n2 = 0;
            if (bl) {
                n8 = 0;
                while (n8 < n3) {
                    n7 = Math.max(n8 - n, 0);
                    n6 = Math.min(n8 + n, n3);
                    n5 = n > n8 ? n - n8 : 0;
                    double d3 = 0.0;
                    double d4 = 0.0;
                    int n9 = n7;
                    while (n9 < n6) {
                        double d5 = dArray[n5++];
                        d3 += (double)nArray2[n9] * d5;
                        d4 += d5;
                        ++n9;
                    }
                    nArray3[n8] = (int)(d3 / d4 + 0.5);
                    n2 += nArray3[n8];
                    ++n8;
                }
            } else {
                n8 = 0;
                while (n8 < n3) {
                    n7 = Math.max(n8 - n, 0);
                    n6 = Math.min(n8 + n, n3);
                    n5 = 0;
                    int n10 = n7;
                    while (n10 < n6) {
                        n5 += nArray2[n10];
                        ++n10;
                    }
                    nArray3[n8] = (int)((double)n5 / (double)(n6 - n7 + 1) + 0.5);
                    n2 += nArray3[n8];
                    ++n8;
                }
            }
            double d6 = (double)this.totals[n4] / (double)n2;
            n6 = 0;
            while (n6 < n3) {
                nArray3[n6] = (int)((double)nArray3[n6] * d6 + 0.5);
                ++n6;
            }
            ++n4;
        }
        return histogram;
    }

    public Histogram getGaussianSmoothed(double d2) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException(JaiI18N.getString("Histogram8"));
        }
        if (d2 == 0.0) {
            return this;
        }
        Histogram histogram = new Histogram(this.getNumBins(), this.getLowValue(), this.getHighValue());
        int[][] nArray = histogram.getBins();
        this.getTotals();
        int n = (int)(5.16 * d2 + 0.5);
        if (n % 2 == 0) {
            ++n;
        }
        double[] dArray = new double[n];
        int n2 = n / 2;
        double d3 = d2 * d2;
        double d4 = 1.0 / Math.sqrt(Math.PI * 2 * d3);
        double d5 = -1.0 / (2.0 * d3);
        int n3 = n2;
        while (n3 < n) {
            double d6 = n3 - n2;
            double d7 = d4 * Math.exp(d5 * d6 * d6);
            dArray[n - 1 - n3] = d7;
            dArray[n3] = d7;
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.numBands) {
            int n5;
            int[] nArray2 = this.getBins(n4);
            int[] nArray3 = nArray[n4];
            int n6 = histogram.getNumBins(n4);
            int n7 = 0;
            int n8 = 0;
            while (n8 < n6) {
                int n9 = Math.max(n8 - n2, 0);
                int n10 = Math.min(n8 + n2, n6);
                n5 = n2 > n8 ? n2 - n8 : 0;
                double d8 = 0.0;
                double d9 = 0.0;
                int n11 = n9;
                while (n11 < n10) {
                    double d10 = dArray[n5++];
                    d8 += (double)nArray2[n11] * d10;
                    d9 += d10;
                    ++n11;
                }
                nArray3[n8] = (int)(d8 / d9 + 0.5);
                n7 += nArray3[n8];
                ++n8;
            }
            double d11 = (double)this.totals[n4] / (double)n7;
            n5 = 0;
            while (n5 < n6) {
                nArray3[n5] = (int)((double)nArray3[n5] * d11 + 0.5);
                ++n5;
            }
            ++n4;
        }
        return histogram;
    }

    public double[] getPTileThreshold(double d2) {
        if (d2 <= 0.0 || d2 >= 1.0) {
            throw new IllegalArgumentException(JaiI18N.getString("Histogram9"));
        }
        double[] dArray = new double[this.numBands];
        this.getTotals();
        int n = 0;
        while (n < this.numBands) {
            int n2 = this.numBins[n];
            int[] nArray = this.getBins(n);
            int n3 = this.totals[n];
            int n4 = 0;
            int n5 = nArray[0];
            int n6 = 0;
            while ((double)n5 / (double)n3 < d2) {
                ++n4;
                n5 += nArray[++n6];
            }
            dArray[n] = this.getLowValue(n) + (double)n4 * this.binWidth[n];
            ++n;
        }
        return dArray;
    }

    public double[] getModeThreshold(double d2) {
        double[] dArray = new double[this.numBands];
        this.getTotals();
        int n = 0;
        while (n < this.numBands) {
            int n2 = this.numBins[n];
            int[] nArray = this.getBins(n);
            int n3 = 0;
            int n4 = nArray[0];
            int n5 = 1;
            while (n5 < n2) {
                if (nArray[n5] > n4) {
                    n3 = n5;
                    n4 = nArray[n5];
                }
                ++n5;
            }
            int n6 = -1;
            double d3 = 0.0;
            int n7 = 0;
            while (n7 < n2) {
                double d4 = (double)nArray[n7] * Math.pow(Math.abs(n7 - n3), d2);
                if (d4 > d3) {
                    n6 = n7;
                    d3 = d4;
                }
                ++n7;
            }
            int n8 = n3;
            int n9 = nArray[n3];
            int n10 = n3 + 1;
            while (n10 <= n6) {
                if (nArray[n10] < n9) {
                    n8 = n10;
                    n9 = nArray[n10];
                }
                ++n10;
            }
            dArray[n] = (int)((double)(n3 + n6) / 2.0 + 0.5);
            ++n;
        }
        return dArray;
    }

    public double[] getIterativeThreshold() {
        double[] dArray = new double[this.numBands];
        this.getTotals();
        int n = 0;
        while (n < this.numBands) {
            int n2 = this.numBins[n];
            int[] nArray = this.getBins(n);
            double d2 = this.binWidth[n];
            double d3 = 0.5 * (this.getLowValue(n) + this.getHighValue(n));
            double d4 = 0.5 * (this.getLowValue(n) + d3);
            double d5 = 0.5 * (d3 + this.getHighValue(n));
            if (this.totals[n] != 0) {
                double d6;
                double d7;
                int n3 = 1000;
                do {
                    dArray[n] = d3;
                    double d8 = this.totals[n];
                    double d9 = this.getLowValue(n);
                    d7 = 0.0;
                    d6 = 0.0;
                    int n4 = 0;
                    int n5 = 0;
                    while (n5 < n2) {
                        if (d9 <= d3) {
                            int n6 = nArray[n5];
                            d7 += (double)n6 * d9;
                            n4 += n6;
                        } else {
                            d6 += (double)nArray[n5] * d9;
                        }
                        d9 += d2;
                        ++n5;
                    }
                    d7 = n4 != 0 ? (d7 /= (double)n4) : d4;
                    if (d8 != (double)n4) {
                        d6 /= d8 - (double)n4;
                        continue;
                    }
                    d6 = d5;
                } while (Math.abs((d3 = 0.5 * (d7 + d6)) - dArray[n]) > 1.0E-6 && --n3 > 0);
            } else {
                dArray[n] = d3;
            }
            ++n;
        }
        return dArray;
    }

    public double[] getMaxVarianceThreshold() {
        double[] dArray = new double[this.numBands];
        this.getTotals();
        this.getMean();
        double[] dArray2 = this.getMoment(2, false, false);
        int n = 0;
        while (n < this.numBands) {
            double d2;
            int n2 = this.numBins[n];
            int[] nArray = this.getBins(n);
            double d3 = this.totals[n];
            double d4 = this.mean[n];
            double d5 = this.binWidth[n];
            double d6 = 0.0;
            double d7 = 0.0;
            double d8 = d2 = this.getLowValue(n);
            double d9 = -1.7976931348623157E308;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            while (n5 < n2) {
                double d10 = (double)nArray[n5] / d3;
                if ((d6 += d10) != 0.0) {
                    double d11 = (d7 += d10 * d8) / d6;
                    double d12 = 1.0 - d6;
                    if (d12 != 0.0) {
                        double d13;
                        double d14;
                        double d15 = (d4 - d7) / d12;
                        double d16 = 0.0;
                        double d17 = d2;
                        int n6 = 0;
                        while (n6 <= n5) {
                            d14 = d17 - d11;
                            d16 += d14 * d14 * (double)nArray[n6];
                            ++n6;
                            d17 += d5;
                        }
                        d16 /= d3;
                        d14 = 0.0;
                        int n7 = n5 + 1;
                        while (n7 < n2) {
                            d13 = d17 - d15;
                            d14 += d13 * d13 * (double)nArray[n7];
                            ++n7;
                            d17 += d5;
                        }
                        if (d16 == 0.0 && (d14 /= d3) == 0.0 && d15 != 0.0) {
                            n3 = (int)(((d11 + d15) / 2.0 - this.getLowValue(n)) / d5 + 0.5);
                            n4 = 0;
                            break;
                        }
                        if (!(d16 / d6 < 0.5) && !(d14 / d12 < 0.5)) {
                            d13 = d11 - d15;
                            double d18 = d6 * d12 * d13 * d13 / (d16 + d14);
                            if (d18 > d9) {
                                d9 = d18;
                                n3 = n5;
                                n4 = 0;
                            } else if (d18 == d9) {
                                ++n4;
                            }
                        }
                    }
                }
                ++n5;
                d8 += d5;
            }
            dArray[n] = this.getLowValue(n) + ((double)n3 + (double)n4 / 2.0 + 0.5) * d5;
            ++n;
        }
        return dArray;
    }

    public double[] getMaxEntropyThreshold() {
        double[] dArray = new double[this.numBands];
        this.getTotals();
        double[] dArray2 = this.getEntropy();
        double d2 = Math.log(2.0);
        int n = 0;
        while (n < this.numBands) {
            int n2 = this.numBins[n];
            int[] nArray = this.getBins(n);
            double d3 = this.totals[n];
            double d4 = dArray2[n];
            double d5 = 0.0;
            double d6 = 0.0;
            double d7 = -1.7976931348623157E308;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            while (n5 < n2) {
                double d8 = (double)nArray[n5] / d3;
                if (d8 != 0.0) {
                    d5 += d8;
                    d6 -= d8 * Math.log(d8) / d2;
                    double d9 = 0.0;
                    int n6 = 0;
                    while (n6 <= n5) {
                        if ((double)nArray[n6] > d9) {
                            d9 = nArray[n6];
                        }
                        ++n6;
                    }
                    if (d9 != 0.0) {
                        double d10 = 0.0;
                        int n7 = n5 + 1;
                        while (n7 < n2) {
                            if ((double)nArray[n7] > d10) {
                                d10 = nArray[n7];
                            }
                            ++n7;
                        }
                        if (d10 != 0.0) {
                            double d11 = d6 / d4;
                            double d12 = d11 * Math.log(d5) / Math.log(d9 / d3) + (1.0 - d11) * Math.log(1.0 - d5) / Math.log(d10 / d3);
                            if (d12 > d7) {
                                d7 = d12;
                                n3 = n5;
                                n4 = 0;
                            } else if (d12 == d7) {
                                ++n4;
                            }
                        }
                    }
                }
                ++n5;
            }
            dArray[n] = this.getLowValue(n) + ((double)n3 + (double)n4 / 2.0 + 0.5) * this.binWidth[n];
            ++n;
        }
        return dArray;
    }

    public double[] getMinErrorThreshold() {
        double[] dArray = new double[this.numBands];
        this.getTotals();
        this.getMean();
        int n = 0;
        while (n < this.numBands) {
            int n2 = this.numBins[n];
            int[] nArray = this.getBins(n);
            double d2 = this.totals[n];
            double d3 = this.getLowValue(n);
            double d4 = this.binWidth[n];
            int n3 = 0;
            int n4 = this.totals[n];
            double d5 = 0.0;
            double d6 = this.mean[n] * d2;
            double d7 = d3;
            double d8 = Double.MAX_VALUE;
            int n5 = 0;
            int n6 = 0;
            double d9 = Double.MAX_VALUE;
            double d10 = Double.MAX_VALUE;
            double d11 = Double.MAX_VALUE;
            int n7 = 0;
            int n8 = 0;
            while (n8 < n2) {
                int n9 = nArray[n8];
                n4 -= n9;
                double d12 = d7 * (double)n9;
                d6 -= d12;
                if ((n3 += n9) != 0 && (d5 += d12) != 0.0) {
                    double d13;
                    if (n4 == 0 || d6 == 0.0) break;
                    double d14 = d5 / (double)n3;
                    double d15 = d6 / (double)n4;
                    double d16 = 0.0;
                    double d17 = d3;
                    int n10 = 0;
                    while (n10 <= n8) {
                        d13 = d17 - d14;
                        d16 += (double)nArray[n10] * d13 * d13;
                        ++n10;
                        d17 += d4;
                    }
                    if (!((d16 /= (double)n3) < 0.5)) {
                        double d18;
                        d13 = 0.0;
                        int n11 = n8 + 1;
                        while (n11 < n2) {
                            d18 = d17 - d15;
                            d13 += (double)nArray[n11] * d18 * d18;
                            ++n11;
                            d17 += d4;
                        }
                        if (!((d13 /= (double)n4) < 0.5)) {
                            d18 = (double)n3 / d2;
                            double d19 = (double)n4 / d2;
                            double d20 = 1.0 + d18 * Math.log(d16) + d19 * Math.log(d13) - 2.0 * (d18 * Math.log(d18) + d19 * Math.log(d19));
                            d9 = d10;
                            d10 = d11;
                            d11 = d20;
                            if (++n7 >= 3 && d10 <= d9 && d10 <= d11) {
                                if (d10 < d8) {
                                    d8 = d10;
                                    n5 = n8 - 1;
                                    n6 = 0;
                                } else if (d10 == d8) {
                                    ++n6;
                                }
                            }
                        }
                    }
                }
                ++n8;
                d7 += d4;
            }
            dArray[n] = n5 == 0 ? this.mean[n] : this.getLowValue(n) + ((double)n5 + (double)n6 / 2.0 + 0.5) * d4;
            ++n;
        }
        return dArray;
    }

    public double[] getMinFuzzinessThreshold() {
        double[] dArray = new double[this.numBands];
        this.getTotals();
        this.getMean();
        int n = 0;
        while (n < this.numBands) {
            double d2;
            int n2 = this.numBins[n];
            int[] nArray = this.getBins(n);
            double d3 = this.totals[n];
            double d4 = this.binWidth[n];
            int n3 = 0;
            int n4 = this.totals[n];
            double d5 = 0.0;
            double d6 = this.mean[n] * d3;
            double d7 = d2 = this.getLowValue(n);
            double d8 = this.getHighValue(n) - d2;
            double d9 = Double.MAX_VALUE;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            while (n7 < n2) {
                int n8 = nArray[n7];
                double d10 = d7 * (double)n8;
                d5 += d10;
                d6 -= d10;
                if ((n3 += n8) != 0 && (n4 -= n8) != 0) {
                    double d11 = d5 / (double)n3;
                    double d12 = d6 / (double)n4;
                    double d13 = d2;
                    double d14 = 0.0;
                    int n9 = 0;
                    while (n9 < n2) {
                        double d15 = n9 <= n7 ? 1.0 / (1.0 + Math.abs(d13 - d11) / d8) : 1.0 / (1.0 + Math.abs(d13 - d12) / d8);
                        double d16 = 1.0 - d15;
                        d14 += (-d15 * Math.log(d15) - d16 * Math.log(d16)) * ((double)nArray[n9] / d3);
                        ++n9;
                        d13 += d4;
                    }
                    if (d14 < d9) {
                        d9 = d14;
                        n5 = n7;
                        n6 = 0;
                    } else if (d14 == d9) {
                        ++n6;
                    }
                }
                ++n7;
                d7 += d4;
            }
            dArray[n] = d2 + ((double)n5 + (double)n6 / 2.0 + 0.5) * d4;
            ++n;
        }
        return dArray;
    }
}

