/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.Point;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.lang.ref.SoftReference;
import javax.media.jai.ColorSpaceJAI;
import javax.media.jai.PixelAccessor;
import javax.media.jai.RasterFactory;
import javax.media.jai.UnpackedImageData;

public final class IHSColorSpace
extends ColorSpaceJAI {
    private static final double PI2 = Math.PI * 2;
    private static final double PI23 = 2.0943951023931953;
    private static final double PI43 = 4.1887902047863905;
    private static final double SQRT3 = Math.sqrt(3.0);
    private static final double BYTESCALE = 40.58451048843331;
    private static SoftReference reference = new SoftReference<Object>(null);
    private static byte[] acosTable = null;
    private static double[] sqrtTable = null;
    private static double[] tanTable = null;
    private static SoftReference acosSoftRef;
    private static SoftReference sqrtSoftRef;
    private static SoftReference tanSoftRef;

    public static IHSColorSpace getInstance() {
        SoftReference softReference = reference;
        synchronized (softReference) {
            IHSColorSpace iHSColorSpace;
            Object t = reference.get();
            if (t == null) {
                iHSColorSpace = new IHSColorSpace();
                reference = new SoftReference<IHSColorSpace>(iHSColorSpace);
            } else {
                iHSColorSpace = (IHSColorSpace)t;
            }
            IHSColorSpace iHSColorSpace2 = iHSColorSpace;
            return iHSColorSpace2;
        }
    }

    protected IHSColorSpace() {
        super(7, 3, true);
    }

    private synchronized void generateACosTable() {
        if (acosSoftRef == null || acosSoftRef.get() == null) {
            acosTable = new byte[1001];
            acosSoftRef = new SoftReference<byte[]>(acosTable);
            int n = 0;
            while (n <= 1000) {
                IHSColorSpace.acosTable[n] = (byte)(40.58451048843331 * Math.acos((double)(n - 500) * 0.002) + 0.5);
                ++n;
            }
        }
    }

    private synchronized void generateSqrtTable() {
        if (sqrtSoftRef == null || sqrtSoftRef.get() == null) {
            sqrtTable = new double[1001];
            sqrtSoftRef = new SoftReference<double[]>(sqrtTable);
            int n = 0;
            while (n <= 1000) {
                IHSColorSpace.sqrtTable[n] = Math.sqrt((double)n / 1000.0);
                ++n;
            }
        }
    }

    private synchronized void generateTanTable() {
        if (tanSoftRef == null || tanSoftRef.get() == null) {
            tanTable = new double[256];
            tanSoftRef = new SoftReference<double[]>(tanTable);
            int n = 0;
            while (n < 256) {
                IHSColorSpace.tanTable[n] = Math.tan((double)n * (Math.PI * 2) / 255.0);
                ++n;
            }
        }
    }

    public float[] fromCIEXYZ(float[] fArray) {
        float[] fArray2 = new float[3];
        ColorSpaceJAI.XYZ2RGB(fArray, fArray2);
        float f2 = fArray2[0];
        float f3 = fArray2[1];
        float f4 = fArray2[2];
        float[] fArray3 = new float[3];
        fArray3[0] = (f2 + f3 + f4) / 3.0f;
        float f5 = f2 - f3;
        float f6 = f2 - f4;
        float f7 = (float)Math.sqrt((double)f5 * (double)f5 + (double)f6 * (double)(f6 - f5));
        if (f7 != 0.0f) {
            f7 = (float)Math.acos((double)(f5 + f6) / (double)f7 / 2.0);
            fArray3[1] = f3 < f4 ? (float)(Math.PI * 2 - (double)f7) : f7;
        } else {
            fArray3[1] = (float)Math.PI * 2;
        }
        float f8 = f2 < f3 ? f2 : f3;
        f8 = f8 < f4 ? f8 : f4;
        fArray3[2] = fArray3[0] == 0.0f ? 0.0f : 1.0f - f8 / fArray3[0];
        return fArray3;
    }

    public float[] fromRGB(float[] fArray) {
        float f2 = fArray[0];
        float f3 = fArray[1];
        float f4 = fArray[2];
        float f5 = f2 < 0.0f ? 0.0f : (f2 = f2 > 1.0f ? 1.0f : f2);
        float f6 = f3 < 0.0f ? 0.0f : (f3 = f3 > 1.0f ? 1.0f : f3);
        f4 = f4 < 0.0f ? 0.0f : (f4 > 1.0f ? 1.0f : f4);
        float[] fArray2 = new float[3];
        fArray2[0] = (f2 + f3 + f4) / 3.0f;
        float f7 = f2 - f3;
        float f8 = f2 - f4;
        float f9 = (float)Math.sqrt((double)f7 * (double)f7 + (double)f8 * (double)(f8 - f7));
        if (f9 != 0.0f) {
            f9 = (float)Math.acos((double)(f7 + f8) / (double)f9 / 2.0);
            fArray2[1] = f3 < f4 ? (float)(Math.PI * 2 - (double)f9) : f9;
        } else {
            fArray2[1] = (float)Math.PI * 2;
        }
        float f10 = f2 < f3 ? f2 : f3;
        f10 = f10 < f4 ? f10 : f4;
        fArray2[2] = fArray2[0] == 0.0f ? 0.0f : 1.0f - f10 / fArray2[0];
        return fArray2;
    }

    public float[] toCIEXYZ(float[] fArray) {
        float f2;
        float f3;
        float f4 = fArray[0];
        float f5 = fArray[1];
        float f6 = fArray[2];
        float f7 = f4 < 0.0f ? 0.0f : (f4 = f4 > 1.0f ? 1.0f : f4);
        float f8 = f5 < 0.0f ? 0.0f : (f5 = f5 > (float)Math.PI * 2 ? (float)Math.PI * 2 : f5);
        f6 = f6 < 0.0f ? 0.0f : (f6 > 1.0f ? 1.0f : f6);
        float f9 = 0.0f;
        float f10 = 0.0f;
        float f11 = 0.0f;
        if (f6 == 0.0f) {
            f10 = f11 = f4;
            f9 = f11;
        } else if ((double)f5 >= 2.0943951023931953 && (double)f5 < 4.1887902047863905) {
            f9 = (1.0f - f6) * f4;
            f3 = 3.0f * f4 - f9;
            f2 = (float)(SQRT3 * (double)(f9 - f4) * Math.tan(f5));
            f10 = (f3 + f2) / 2.0f;
            f11 = (f3 - f2) / 2.0f;
        } else if ((double)f5 > 4.1887902047863905) {
            f10 = (1.0f - f6) * f4;
            f3 = 3.0f * f4 - f10;
            f2 = (float)(SQRT3 * (double)(f10 - f4) * Math.tan((double)f5 - 2.0943951023931953));
            f11 = (f3 + f2) / 2.0f;
            f9 = (f3 - f2) / 2.0f;
        } else if ((double)f5 < 2.0943951023931953) {
            f11 = (1.0f - f6) * f4;
            f3 = 3.0f * f4 - f11;
            f2 = (float)(SQRT3 * (double)(f11 - f4) * Math.tan((double)f5 - 4.1887902047863905));
            f9 = (f3 + f2) / 2.0f;
            f10 = (f3 - f2) / 2.0f;
        }
        float[] fArray2 = new float[3];
        float[] fArray3 = new float[]{f9, f10, f11};
        ColorSpaceJAI.RGB2XYZ(fArray3, fArray2);
        return fArray2;
    }

    public float[] toRGB(float[] fArray) {
        float f2 = fArray[0];
        float f3 = fArray[1];
        float f4 = fArray[2];
        float f5 = f2 < 0.0f ? 0.0f : (f2 = f2 > 1.0f ? 1.0f : f2);
        float f6 = f3 < 0.0f ? 0.0f : (f3 = f3 > (float)Math.PI * 2 ? (float)Math.PI * 2 : f3);
        f4 = f4 < 0.0f ? 0.0f : (f4 > 1.0f ? 1.0f : f4);
        float[] fArray2 = new float[3];
        if (f4 == 0.0f) {
            fArray2[1] = fArray2[2] = f2;
            fArray2[0] = fArray2[2];
        } else if ((double)f3 >= 2.0943951023931953 && (double)f3 < 4.1887902047863905) {
            float f7 = (1.0f - f4) * f2;
            float f8 = 3.0f * f2 - f7;
            float f9 = (float)(SQRT3 * (double)(f7 - f2) * Math.tan(f3));
            fArray2[0] = f7;
            fArray2[1] = (f8 + f9) / 2.0f;
            fArray2[2] = (f8 - f9) / 2.0f;
        } else if ((double)f3 > 4.1887902047863905) {
            float f10 = (1.0f - f4) * f2;
            float f11 = 3.0f * f2 - f10;
            float f12 = (float)(SQRT3 * (double)(f10 - f2) * Math.tan((double)f3 - 2.0943951023931953));
            fArray2[0] = (f11 - f12) / 2.0f;
            fArray2[1] = f10;
            fArray2[2] = (f11 + f12) / 2.0f;
        } else if ((double)f3 < 2.0943951023931953) {
            float f13 = (1.0f - f4) * f2;
            float f14 = 3.0f * f2 - f13;
            float f15 = (float)(SQRT3 * (double)(f13 - f2) * Math.tan((double)f3 - 4.1887902047863905));
            fArray2[0] = (f14 + f15) / 2.0f;
            fArray2[1] = (f14 - f15) / 2.0f;
            fArray2[2] = f13;
        }
        return fArray2;
    }

    public WritableRaster fromCIEXYZ(Raster raster, int[] nArray, WritableRaster writableRaster, int[] nArray2) {
        WritableRaster writableRaster2 = ColorSpaceJAI.CIEXYZToRGB(raster, nArray, null, null);
        return this.fromRGB(writableRaster2, writableRaster2.getSampleModel().getSampleSize(), writableRaster, nArray2);
    }

    public WritableRaster fromRGB(Raster raster, int[] nArray, WritableRaster writableRaster, int[] nArray2) {
        Object object;
        ColorSpaceJAI.checkParameters(raster, nArray, writableRaster, nArray2);
        SampleModel sampleModel = raster.getSampleModel();
        if (nArray == null) {
            nArray = sampleModel.getSampleSize();
        }
        if (writableRaster == null) {
            object = new Point(raster.getMinX(), raster.getMinY());
            writableRaster = RasterFactory.createWritableRaster(sampleModel, (Point)object);
        }
        object = writableRaster.getSampleModel();
        if (nArray2 == null) {
            nArray2 = ((SampleModel)object).getSampleSize();
        }
        PixelAccessor pixelAccessor = new PixelAccessor(sampleModel, null);
        UnpackedImageData unpackedImageData = pixelAccessor.getPixels(raster, raster.getBounds(), sampleModel.getDataType(), false);
        switch (sampleModel.getDataType()) {
            case 0: {
                this.fromRGBByte(unpackedImageData, nArray, writableRaster, nArray2);
                break;
            }
            case 1: 
            case 2: {
                this.fromRGBShort(unpackedImageData, nArray, writableRaster, nArray2);
                break;
            }
            case 3: {
                this.fromRGBInt(unpackedImageData, nArray, writableRaster, nArray2);
                break;
            }
            case 4: {
                this.fromRGBFloat(unpackedImageData, nArray, writableRaster, nArray2);
                break;
            }
            case 5: {
                this.fromRGBDouble(unpackedImageData, nArray, writableRaster, nArray2);
            }
        }
        return writableRaster;
    }

    private void fromRGBByte(UnpackedImageData unpackedImageData, int[] nArray, WritableRaster writableRaster, int[] nArray2) {
        boolean bl;
        byte[] byArray = unpackedImageData.getByteData(0);
        byte[] byArray2 = unpackedImageData.getByteData(1);
        byte[] byArray3 = unpackedImageData.getByteData(2);
        int n = 8 - nArray[0];
        int n2 = 8 - nArray[1];
        int n3 = 8 - nArray[2];
        double d2 = 0.00392156862745098;
        double d3 = 1.0;
        double d4 = 1.0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = writableRaster.getSampleModel().getDataType();
        boolean bl2 = bl = n7 == 0;
        if (bl) {
            n4 = 8 - nArray2[0];
            n5 = 8 - nArray2[1];
            n6 = 8 - nArray2[2];
            this.generateACosTable();
            this.generateSqrtTable();
        } else if (n7 < 4) {
            d2 = (double)((1L << nArray2[0]) - 1L) / 255.0;
            d3 = (double)((1L << nArray2[1]) - 1L) / (Math.PI * 2);
            d4 = (1L << nArray2[2]) - 1L;
        }
        int n8 = writableRaster.getHeight();
        int n9 = writableRaster.getWidth();
        double[] dArray = null;
        int[] nArray3 = null;
        if (bl) {
            nArray3 = new int[3 * n8 * n9];
        } else {
            dArray = new double[3 * n8 * n9];
        }
        int n10 = unpackedImageData.bandOffsets[0];
        int n11 = unpackedImageData.bandOffsets[1];
        int n12 = unpackedImageData.bandOffsets[2];
        int n13 = unpackedImageData.pixelStride;
        int n14 = unpackedImageData.lineStride;
        int n15 = 0;
        int n16 = 0;
        while (n16 < n8) {
            int n17 = 0;
            int n18 = n10;
            int n19 = n11;
            int n20 = n12;
            while (n17 < n9) {
                double d5;
                float f2;
                short s = (short)((byArray[n18] & 0xFF) << n);
                short s2 = (short)((byArray2[n19] & 0xFF) << n2);
                short s3 = (short)((byArray3[n20] & 0xFF) << n3);
                if (bl) {
                    f2 = (float)(s + s2 + s3) / 3.0f;
                    nArray3[n15++] = (short)(f2 + 0.5f) >> n4;
                    short s4 = (short)(s - s2);
                    short s5 = (short)(s - s3);
                    int n21 = s4 * s4 + s5 * (s5 - s4);
                    short s6 = (short)(s4 + s5);
                    d5 = n21 != 0 ? sqrtTable[(int)(250.0 * (double)s6 * (double)s6 / (double)n21 + 0.5)] : -1.0;
                    byte by = s6 > 0 ? acosTable[(int)(500.0 * d5 + 0.5) + 500] : acosTable[(int)(-500.0 * d5 - 0.5) + 500];
                    nArray3[n15++] = s3 >= s2 ? 255 - by >> n5 : by >> n5;
                    short s7 = s2 > s3 ? s3 : s2;
                    s7 = s > s7 ? s7 : s;
                    nArray3[n15++] = 255 - (int)((float)(255 * s7) / f2 + 0.5f) >> n6;
                } else {
                    f2 = (float)(s + s2 + s3) / 3.0f;
                    dArray[n15++] = d2 * (double)f2;
                    double d6 = s - s2;
                    double d7 = s - s3;
                    d5 = Math.sqrt(d6 * d6 + d7 * (d7 - d6));
                    if (d5 != 0.0) {
                        d5 = Math.acos((d6 + d7) / d5 / 2.0);
                        if (s3 >= s2) {
                            d5 = Math.PI * 2 - d5;
                        }
                    } else {
                        d5 = Math.PI * 2;
                    }
                    dArray[n15++] = d3 * d5;
                    double d8 = s2 > s3 ? (double)s3 : (double)s2;
                    d8 = (double)s > d8 ? d8 : (double)s;
                    dArray[n15++] = d4 * (1.0 - d8 / (double)f2);
                }
                ++n17;
                n18 += n13;
                n19 += n13;
                n20 += n13;
            }
            ++n16;
            n10 += n14;
            n11 += n14;
            n12 += n14;
        }
        if (bl) {
            writableRaster.setPixels(writableRaster.getMinX(), writableRaster.getMinY(), n9, n8, nArray3);
        } else {
            ColorSpaceJAI.convertToSigned(dArray, n7);
            writableRaster.setPixels(writableRaster.getMinX(), writableRaster.getMinY(), n9, n8, dArray);
        }
    }

    private void fromRGBShort(UnpackedImageData unpackedImageData, int[] nArray, WritableRaster writableRaster, int[] nArray2) {
        boolean bl;
        short[] sArray = unpackedImageData.getShortData(0);
        short[] sArray2 = unpackedImageData.getShortData(1);
        short[] sArray3 = unpackedImageData.getShortData(2);
        int n = 16 - nArray[0];
        int n2 = 16 - nArray[1];
        int n3 = 16 - nArray[2];
        double d2 = 1.5259021896696422E-5;
        double d3 = 1.0;
        double d4 = 1.0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = writableRaster.getSampleModel().getDataType();
        boolean bl2 = bl = n7 == 0;
        if (bl) {
            n4 = 16 - nArray2[0];
            n5 = 8 - nArray2[1];
            n6 = 8 - nArray2[2];
            this.generateACosTable();
            this.generateSqrtTable();
        } else if (n7 < 4) {
            d2 = (double)((1L << nArray2[0]) - 1L) / 65535.0;
            d3 = (double)((1L << nArray2[1]) - 1L) / (Math.PI * 2);
            d4 = (1L << nArray2[2]) - 1L;
        }
        int n8 = writableRaster.getHeight();
        int n9 = writableRaster.getWidth();
        double[] dArray = null;
        int[] nArray3 = null;
        if (bl) {
            nArray3 = new int[3 * n8 * n9];
        } else {
            dArray = new double[3 * n8 * n9];
        }
        int n10 = unpackedImageData.bandOffsets[0];
        int n11 = unpackedImageData.bandOffsets[1];
        int n12 = unpackedImageData.bandOffsets[2];
        int n13 = unpackedImageData.pixelStride;
        int n14 = unpackedImageData.lineStride;
        int n15 = 0;
        int n16 = 0;
        while (n16 < n8) {
            int n17 = 0;
            int n18 = n10;
            int n19 = n11;
            int n20 = n12;
            while (n17 < n9) {
                double d5;
                double d6;
                double d7;
                float f2;
                int n21 = (sArray[n18] & 0xFFFF) << n;
                int n22 = (sArray2[n19] & 0xFFFF) << n2;
                int n23 = (sArray3[n20] & 0xFFFF) << n3;
                if (bl) {
                    f2 = (float)(n21 + n22 + n23) / 3.0f;
                    nArray3[n15++] = (int)(f2 + 0.5f) >> n4;
                    int n24 = n21 - n22;
                    int n25 = n21 - n23;
                    d7 = (double)n24 * (double)n24 + (double)n25 * (double)(n25 - n24);
                    d6 = n24 + n25;
                    d5 = d7 != 0.0 ? sqrtTable[(int)(250.0 * d6 * d6 / d7 + 0.5)] : -1.0;
                    byte by = d6 > 0.0 ? acosTable[(int)(500.0 * d5 + 0.5) + 500] : acosTable[(int)(-500.0 * d5 - 0.5) + 500];
                    nArray3[n15++] = n23 >= n22 ? 255 - by >> n5 : by >> n5;
                    int n26 = n22 > n23 ? n23 : n22;
                    n26 = n21 > n26 ? n26 : n21;
                    nArray3[n15++] = 255 - (int)((float)(255 * n26) / f2 + 0.5f) >> n6;
                } else {
                    f2 = (float)(n21 + n22 + n23) / 3.0f;
                    dArray[n15++] = d2 * (double)f2;
                    double d8 = n21 - n22;
                    d7 = n21 - n23;
                    d6 = Math.sqrt(d8 * d8 + d7 * (d7 - d8));
                    if (d6 != 0.0) {
                        d6 = Math.acos((d8 + d7) / d6 / 2.0);
                        if (n23 >= n22) {
                            d6 = Math.PI * 2 - d6;
                        }
                    } else {
                        d6 = Math.PI * 2;
                    }
                    dArray[n15++] = d3 * d6;
                    d5 = n22 > n23 ? (double)n23 : (double)n22;
                    d5 = (double)n21 > d5 ? d5 : (double)n21;
                    dArray[n15++] = d4 * (1.0 - d5 / (double)f2);
                }
                ++n17;
                n18 += n13;
                n19 += n13;
                n20 += n13;
            }
            ++n16;
            n10 += n14;
            n11 += n14;
            n12 += n14;
        }
        if (bl) {
            writableRaster.setPixels(writableRaster.getMinX(), writableRaster.getMinY(), n9, n8, nArray3);
        } else {
            ColorSpaceJAI.convertToSigned(dArray, n7);
            writableRaster.setPixels(writableRaster.getMinX(), writableRaster.getMinY(), n9, n8, dArray);
        }
    }

    private void fromRGBInt(UnpackedImageData unpackedImageData, int[] nArray, WritableRaster writableRaster, int[] nArray2) {
        boolean bl;
        int[] nArray3 = unpackedImageData.getIntData(0);
        int[] nArray4 = unpackedImageData.getIntData(1);
        int[] nArray5 = unpackedImageData.getIntData(2);
        int n = 32 - nArray[0];
        int n2 = 32 - nArray[1];
        int n3 = 32 - nArray[2];
        double d2 = 4.294967295E9;
        double d3 = 1.0 / d2;
        double d4 = 1.0;
        double d5 = 1.0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = writableRaster.getSampleModel().getDataType();
        boolean bl2 = bl = n7 == 0;
        if (bl) {
            n4 = 32 - nArray2[0];
            n5 = 8 - nArray2[1];
            n6 = 8 - nArray2[2];
            this.generateACosTable();
            this.generateSqrtTable();
        } else if (n7 < 4) {
            d3 = (double)((1L << nArray2[0]) - 1L) / d2;
            d4 = (double)((1L << nArray2[1]) - 1L) / (Math.PI * 2);
            d5 = (1L << nArray2[2]) - 1L;
        }
        int n8 = writableRaster.getHeight();
        int n9 = writableRaster.getWidth();
        double[] dArray = null;
        int[] nArray6 = null;
        if (bl) {
            nArray6 = new int[3 * n8 * n9];
        } else {
            dArray = new double[3 * n8 * n9];
        }
        int n10 = unpackedImageData.bandOffsets[0];
        int n11 = unpackedImageData.bandOffsets[1];
        int n12 = unpackedImageData.bandOffsets[2];
        int n13 = unpackedImageData.pixelStride;
        int n14 = unpackedImageData.lineStride;
        int n15 = 0;
        int n16 = 0;
        while (n16 < n8) {
            int n17 = 0;
            int n18 = n10;
            int n19 = n11;
            int n20 = n12;
            while (n17 < n9) {
                double d6;
                double d7;
                float f2;
                long l = ((long)nArray3[n18] & 0xFFFFFFFFL) << n;
                long l2 = ((long)nArray4[n19] & 0xFFFFFFFFL) << n2;
                long l3 = ((long)nArray5[n20] & 0xFFFFFFFFL) << n3;
                if (bl) {
                    f2 = (float)(l + l2 + l3) / 3.0f;
                    nArray6[n15++] = (int)((long)(f2 + 0.5f) >> n4);
                    long l4 = l - l2;
                    long l5 = l - l3;
                    d7 = (double)l4 * (double)l4 + (double)l5 * (double)(l5 - l4);
                    d6 = l4 + l5;
                    double d8 = d7 != 0.0 ? sqrtTable[(int)(250.0 * d6 * d6 / d7 + 0.5)] : -1.0;
                    byte by = d6 > 0.0 ? acosTable[(int)(500.0 * d8 + 0.5) + 500] : acosTable[(int)(-500.0 * d8 - 0.5) + 500];
                    nArray6[n15++] = l3 >= l2 ? 255 - by >> n5 : by >> n5;
                    long l6 = l2 > l3 ? l3 : l2;
                    l6 = l > l6 ? l6 : l;
                    nArray6[n15++] = 255 - (int)((float)(255L * l6) / f2 + 0.5f) >> n6;
                } else {
                    f2 = (float)(l + l2 + l3) / 3.0f;
                    dArray[n15++] = d3 * (double)f2;
                    double d9 = l - l2;
                    double d10 = l - l3;
                    d7 = Math.sqrt(d9 * d9 + d10 * (d10 - d9));
                    if (d7 != 0.0) {
                        d7 = Math.acos((d9 + d10) / d7 / 2.0);
                        if (l3 >= l2) {
                            d7 = Math.PI * 2 - d7;
                        }
                    } else {
                        d7 = Math.PI * 2;
                    }
                    dArray[n15++] = d4 * d7;
                    d6 = l2 > l3 ? (double)l3 : (double)l2;
                    d6 = (double)l > d6 ? d6 : (double)l;
                    dArray[n15++] = d5 * (1.0 - d6 / (double)f2);
                }
                ++n17;
                n18 += n13;
                n19 += n13;
                n20 += n13;
            }
            ++n16;
            n10 += n14;
            n11 += n14;
            n12 += n14;
        }
        if (bl) {
            writableRaster.setPixels(writableRaster.getMinX(), writableRaster.getMinY(), n9, n8, nArray6);
        } else {
            ColorSpaceJAI.convertToSigned(dArray, n7);
            writableRaster.setPixels(writableRaster.getMinX(), writableRaster.getMinY(), n9, n8, dArray);
        }
    }

    private void fromRGBFloat(UnpackedImageData unpackedImageData, int[] nArray, WritableRaster writableRaster, int[] nArray2) {
        boolean bl;
        float[] fArray = unpackedImageData.getFloatData(0);
        float[] fArray2 = unpackedImageData.getFloatData(1);
        float[] fArray3 = unpackedImageData.getFloatData(2);
        double d2 = 1.0;
        double d3 = 1.0;
        double d4 = 1.0;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = writableRaster.getSampleModel().getDataType();
        boolean bl2 = bl = n4 == 0;
        if (bl) {
            n = (1 << nArray2[0]) - 1;
            n2 = 8 - nArray2[1];
            n3 = 8 - nArray2[2];
            this.generateACosTable();
            this.generateSqrtTable();
        } else if (n4 < 4) {
            d2 = (1L << nArray2[0]) - 1L;
            d3 = (double)((1L << nArray2[1]) - 1L) / (Math.PI * 2);
            d4 = (1L << nArray2[2]) - 1L;
        }
        int n5 = writableRaster.getHeight();
        int n6 = writableRaster.getWidth();
        double[] dArray = null;
        int[] nArray3 = null;
        if (bl) {
            nArray3 = new int[3 * n5 * n6];
        } else {
            dArray = new double[3 * n5 * n6];
        }
        int n7 = unpackedImageData.bandOffsets[0];
        int n8 = unpackedImageData.bandOffsets[1];
        int n9 = unpackedImageData.bandOffsets[2];
        int n10 = unpackedImageData.pixelStride;
        int n11 = unpackedImageData.lineStride;
        int n12 = 0;
        int n13 = 0;
        while (n13 < n5) {
            int n14 = 0;
            int n15 = n7;
            int n16 = n8;
            int n17 = n9;
            while (n14 < n6) {
                double d5;
                double d6;
                double d7;
                float f2;
                float f3 = fArray[n15];
                float f4 = fArray2[n16];
                float f5 = fArray3[n17];
                if (bl) {
                    f2 = (f3 + f4 + f5) / 3.0f;
                    nArray3[n12++] = (int)(f2 * (float)n + 0.5f);
                    float f6 = f3 - f4;
                    float f7 = f3 - f5;
                    d7 = (double)f6 * (double)f6 + (double)f7 * (double)(f7 - f6);
                    d6 = f6 + f7;
                    d5 = d7 != 0.0 ? sqrtTable[(int)(250.0 * d6 * d6 / d7 + 0.5)] : -1.0;
                    byte by = d6 > 0.0 ? acosTable[(int)(500.0 * d5 + 0.5) + 500] : acosTable[(int)(-500.0 * d5 - 0.5) + 500];
                    nArray3[n12++] = f5 >= f4 ? 255 - by >> n2 : by >> n2;
                    float f8 = f4 > f5 ? f5 : f4;
                    f8 = f3 > f8 ? f8 : f3;
                    nArray3[n12++] = 255 - (int)(255.0f * f8 / f2 + 0.5f) >> n3;
                } else {
                    f2 = (f3 + f4 + f5) / 3.0f;
                    dArray[n12++] = d2 * (double)f2;
                    double d8 = f3 - f4;
                    d7 = f3 - f5;
                    d6 = Math.sqrt(d8 * d8 + d7 * (d7 - d8));
                    if (d6 != 0.0) {
                        d6 = Math.acos((d8 + d7) / d6 / 2.0);
                        if (f5 >= f4) {
                            d6 = Math.PI * 2 - d6;
                        }
                    } else {
                        d6 = Math.PI * 2;
                    }
                    dArray[n12++] = d3 * d6;
                    d5 = f4 > f5 ? (double)f5 : (double)f4;
                    d5 = (double)f3 > d5 ? d5 : (double)f3;
                    dArray[n12++] = d4 * (1.0 - d5 / (double)f2);
                }
                ++n14;
                n15 += n10;
                n16 += n10;
                n17 += n10;
            }
            ++n13;
            n7 += n11;
            n8 += n11;
            n9 += n11;
        }
        if (bl) {
            writableRaster.setPixels(writableRaster.getMinX(), writableRaster.getMinY(), n6, n5, nArray3);
        } else {
            ColorSpaceJAI.convertToSigned(dArray, n4);
            writableRaster.setPixels(writableRaster.getMinX(), writableRaster.getMinY(), n6, n5, dArray);
        }
    }

    private void fromRGBDouble(UnpackedImageData unpackedImageData, int[] nArray, WritableRaster writableRaster, int[] nArray2) {
        boolean bl;
        double[] dArray = unpackedImageData.getDoubleData(0);
        double[] dArray2 = unpackedImageData.getDoubleData(1);
        double[] dArray3 = unpackedImageData.getDoubleData(2);
        double d2 = 1.0;
        double d3 = 1.0;
        double d4 = 1.0;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = writableRaster.getSampleModel().getDataType();
        boolean bl2 = bl = n4 == 0;
        if (bl) {
            n = (1 << nArray2[0]) - 1;
            n2 = 8 - nArray2[1];
            n3 = 8 - nArray2[2];
            this.generateACosTable();
            this.generateSqrtTable();
        } else if (n4 < 4) {
            d2 = (1L << nArray2[0]) - 1L;
            d3 = (double)((1L << nArray2[1]) - 1L) / (Math.PI * 2);
            d4 = (1L << nArray2[2]) - 1L;
        }
        int n5 = writableRaster.getHeight();
        int n6 = writableRaster.getWidth();
        double[] dArray4 = null;
        int[] nArray3 = null;
        if (bl) {
            nArray3 = new int[3 * n5 * n6];
        } else {
            dArray4 = new double[3 * n5 * n6];
        }
        int n7 = unpackedImageData.bandOffsets[0];
        int n8 = unpackedImageData.bandOffsets[1];
        int n9 = unpackedImageData.bandOffsets[2];
        int n10 = unpackedImageData.pixelStride;
        int n11 = unpackedImageData.lineStride;
        int n12 = 0;
        int n13 = 0;
        while (n13 < n5) {
            int n14 = 0;
            int n15 = n7;
            int n16 = n8;
            int n17 = n9;
            while (n14 < n6) {
                double d5;
                double d6;
                double d7;
                double d8;
                double d9;
                double d10 = dArray[n15];
                double d11 = dArray2[n16];
                double d12 = dArray3[n17];
                if (bl) {
                    d9 = (d10 + d11 + d12) / 3.0;
                    nArray3[n12++] = (int)(d9 * (double)n + 0.5);
                    d8 = d10 - d11;
                    d7 = d10 - d12;
                    d6 = d8 * d8 + d7 * (d7 - d8);
                    d5 = d8 + d7;
                    double d13 = d6 != 0.0 ? sqrtTable[(int)(250.0 * d5 * d5 / d6 + 0.5)] : -1.0;
                    byte by = d5 > 0.0 ? acosTable[(int)(500.0 * d13 + 0.5) + 500] : acosTable[(int)(-500.0 * d13 - 0.5) + 500];
                    nArray3[n12++] = d12 >= d11 ? 255 - by >> n2 : by >> n2;
                    double d14 = d11 > d12 ? d12 : d11;
                    d14 = d10 > d14 ? d14 : d10;
                    nArray3[n12++] = 255 - (int)(255.0 * d14 / d9 + 0.5) >> n3;
                } else {
                    d9 = (d10 + d11 + d12) / 3.0;
                    dArray4[n12++] = d2 * d9;
                    d8 = d10 - d11;
                    d7 = d10 - d12;
                    d6 = Math.sqrt(d8 * d8 + d7 * (d7 - d8));
                    if (d6 != 0.0) {
                        d6 = Math.acos((d8 + d7) / d6 / 2.0);
                        if (d12 >= d11) {
                            d6 = Math.PI * 2 - d6;
                        }
                    } else {
                        d6 = Math.PI * 2;
                    }
                    dArray4[n12++] = d3 * d6;
                    d5 = d11 > d12 ? d12 : d11;
                    d5 = d10 > d5 ? d5 : d10;
                    dArray4[n12++] = d4 * (1.0 - d5 / d9);
                }
                ++n14;
                n15 += n10;
                n16 += n10;
                n17 += n10;
            }
            ++n13;
            n7 += n11;
            n8 += n11;
            n9 += n11;
        }
        if (bl) {
            writableRaster.setPixels(writableRaster.getMinX(), writableRaster.getMinY(), n6, n5, nArray3);
        } else {
            ColorSpaceJAI.convertToSigned(dArray4, n4);
            writableRaster.setPixels(writableRaster.getMinX(), writableRaster.getMinY(), n6, n5, dArray4);
        }
    }

    public WritableRaster toCIEXYZ(Raster raster, int[] nArray, WritableRaster writableRaster, int[] nArray2) {
        WritableRaster writableRaster2 = this.toRGB(raster, nArray, null, null);
        return ColorSpaceJAI.RGBToCIEXYZ(writableRaster2, writableRaster2.getSampleModel().getSampleSize(), writableRaster, nArray2);
    }

    public WritableRaster toRGB(Raster raster, int[] nArray, WritableRaster writableRaster, int[] nArray2) {
        Object object;
        ColorSpaceJAI.checkParameters(raster, nArray, writableRaster, nArray2);
        SampleModel sampleModel = raster.getSampleModel();
        if (nArray == null) {
            nArray = sampleModel.getSampleSize();
        }
        if (writableRaster == null) {
            object = new Point(raster.getMinX(), raster.getMinY());
            writableRaster = RasterFactory.createWritableRaster(sampleModel, (Point)object);
        }
        object = writableRaster.getSampleModel();
        if (nArray2 == null) {
            nArray2 = ((SampleModel)object).getSampleSize();
        }
        PixelAccessor pixelAccessor = new PixelAccessor(sampleModel, null);
        UnpackedImageData unpackedImageData = pixelAccessor.getPixels(raster, raster.getBounds(), sampleModel.getDataType(), false);
        switch (sampleModel.getDataType()) {
            case 0: {
                this.toRGBByte(unpackedImageData, nArray, writableRaster, nArray2);
                break;
            }
            case 1: 
            case 2: {
                this.toRGBShort(unpackedImageData, nArray, writableRaster, nArray2);
                break;
            }
            case 3: {
                this.toRGBInt(unpackedImageData, nArray, writableRaster, nArray2);
                break;
            }
            case 4: {
                this.toRGBFloat(unpackedImageData, nArray, writableRaster, nArray2);
                break;
            }
            case 5: {
                this.toRGBDouble(unpackedImageData, nArray, writableRaster, nArray2);
            }
        }
        return writableRaster;
    }

    private void toRGBByte(UnpackedImageData unpackedImageData, int[] nArray, WritableRaster writableRaster, int[] nArray2) {
        boolean bl;
        byte[] byArray = unpackedImageData.getByteData(0);
        byte[] byArray2 = unpackedImageData.getByteData(1);
        byte[] byArray3 = unpackedImageData.getByteData(2);
        double d2 = 1.0 / (double)((1 << nArray[0]) - 1);
        double d3 = 1.0 / (double)((1 << nArray[1]) - 1) * (Math.PI * 2);
        double d4 = 1.0 / (double)((1 << nArray[2]) - 1);
        double d5 = 1.0;
        double d6 = 1.0;
        double d7 = 1.0;
        int n = writableRaster.getSampleModel().getDataType();
        boolean bl2 = bl = n == 0;
        if (bl) {
            this.generateTanTable();
        }
        if (n < 4) {
            d5 = (1L << nArray2[0]) - 1L;
            d6 = (1L << nArray2[1]) - 1L;
            d7 = (1L << nArray2[2]) - 1L;
        }
        int n2 = writableRaster.getHeight();
        int n3 = writableRaster.getWidth();
        double[] dArray = null;
        int[] nArray3 = null;
        if (bl) {
            nArray3 = new int[3 * n2 * n3];
        } else {
            dArray = new double[3 * n2 * n3];
        }
        int n4 = unpackedImageData.bandOffsets[0];
        int n5 = unpackedImageData.bandOffsets[1];
        int n6 = unpackedImageData.bandOffsets[2];
        int n7 = unpackedImageData.pixelStride;
        int n8 = unpackedImageData.lineStride;
        int n9 = 0;
        int n10 = 0;
        while (n10 < n2) {
            int n11 = 0;
            int n12 = n4;
            int n13 = n5;
            int n14 = n6;
            while (n11 < n3) {
                double d8 = (double)(byArray[n12] & 0xFF) * d2;
                int n15 = byArray2[n13] & 0xFF;
                double d9 = (double)(byArray3[n14] & 0xFF) * d4;
                if (bl) {
                    float f2;
                    float f3 = f2 = (float)d8;
                    float f4 = f2;
                    if (d9 != 0.0) {
                        float f5;
                        if (n15 >= 85 && n15 < 170) {
                            f4 = (float)((1.0 - d9) * d8);
                            f5 = (float)(3.0 * d8 - (double)f4);
                            float f6 = (float)(SQRT3 * ((double)f4 - d8) * tanTable[n15]);
                            f3 = (f5 + f6) / 2.0f;
                            f2 = (f5 - f6) / 2.0f;
                        } else if (n15 > 170) {
                            f3 = (float)((1.0 - d9) * d8);
                            f5 = (float)(3.0 * d8 - (double)f3);
                            float f7 = (float)(SQRT3 * ((double)f3 - d8) * tanTable[n15 - 85]);
                            f2 = (f5 + f7) / 2.0f;
                            f4 = (f5 - f7) / 2.0f;
                        } else if (n15 < 85) {
                            f2 = (float)((1.0 - d9) * d8);
                            f5 = (float)(3.0 * d8 - (double)f2);
                            float f8 = (float)(SQRT3 * ((double)f2 - d8) * tanTable[n15 + 85]);
                            f4 = (f5 + f8) / 2.0f;
                            f3 = (f5 - f8) / 2.0f;
                        }
                    }
                    nArray3[n9++] = (int)((f4 < 0.0f ? 0.0 : (f4 > 1.0f ? 1.0 : (double)f4)) * d5 + 0.5);
                    nArray3[n9++] = (int)((f3 < 0.0f ? 0.0 : (f3 > 1.0f ? 1.0 : (double)f3)) * d6 + 0.5);
                    nArray3[n9++] = (int)((f2 < 0.0f ? 0.0 : (f2 > 1.0f ? 1.0 : (double)f2)) * d7 + 0.5);
                } else {
                    double d10;
                    double d11 = d10 = d8;
                    double d12 = d10;
                    if (d9 != 0.0) {
                        double d13;
                        double d14;
                        double d15 = (double)n15 * d3;
                        if (d15 >= 2.0943951023931953 && d15 < 4.1887902047863905) {
                            d12 = (1.0 - d9) * d8;
                            d14 = 3.0 * d8 - d12;
                            d13 = SQRT3 * (d12 - d8) * Math.tan(d15);
                            d11 = (d14 + d13) / 2.0;
                            d10 = (d14 - d13) / 2.0;
                        } else if (d15 > 4.1887902047863905) {
                            d11 = (1.0 - d9) * d8;
                            d14 = 3.0 * d8 - d11;
                            d13 = SQRT3 * (d11 - d8) * Math.tan(d15 - 2.0943951023931953);
                            d10 = (d14 + d13) / 2.0;
                            d12 = (d14 - d13) / 2.0;
                        } else if (d15 < 2.0943951023931953) {
                            d10 = (1.0 - d9) * d8;
                            d14 = 3.0 * d8 - d10;
                            d13 = SQRT3 * (d10 - d8) * Math.tan(d15 - 4.1887902047863905);
                            d12 = (d14 + d13) / 2.0;
                            d11 = (d14 - d13) / 2.0;
                        }
                    }
                    dArray[n9++] = (d12 < 0.0 ? 0.0 : (d12 > 1.0 ? 1.0 : d12)) * d5;
                    dArray[n9++] = (d11 < 0.0 ? 0.0 : (d11 > 1.0 ? 1.0 : d11)) * d6;
                    dArray[n9++] = (d10 < 0.0 ? 0.0 : (d10 > 1.0 ? 1.0 : d10)) * d7;
                }
                ++n11;
                n12 += n7;
                n13 += n7;
                n14 += n7;
            }
            ++n10;
            n4 += n8;
            n5 += n8;
            n6 += n8;
        }
        if (bl) {
            writableRaster.setPixels(writableRaster.getMinX(), writableRaster.getMinY(), n3, n2, nArray3);
        } else {
            ColorSpaceJAI.convertToSigned(dArray, n);
            writableRaster.setPixels(writableRaster.getMinX(), writableRaster.getMinY(), n3, n2, dArray);
        }
    }

    private void toRGBShort(UnpackedImageData unpackedImageData, int[] nArray, WritableRaster writableRaster, int[] nArray2) {
        short[] sArray = unpackedImageData.getShortData(0);
        short[] sArray2 = unpackedImageData.getShortData(1);
        short[] sArray3 = unpackedImageData.getShortData(2);
        double d2 = 1.0 / (double)((1 << nArray[0]) - 1);
        double d3 = 1.0 / (double)((1 << nArray[1]) - 1) * (Math.PI * 2);
        double d4 = 1.0 / (double)((1 << nArray[2]) - 1);
        double d5 = 1.0;
        double d6 = 1.0;
        double d7 = 1.0;
        int n = writableRaster.getSampleModel().getDataType();
        if (n < 4) {
            d5 = (1L << nArray2[0]) - 1L;
            d6 = (1L << nArray2[1]) - 1L;
            d7 = (1L << nArray2[2]) - 1L;
        }
        int n2 = writableRaster.getHeight();
        int n3 = writableRaster.getWidth();
        double[] dArray = new double[3 * n2 * n3];
        int n4 = unpackedImageData.bandOffsets[0];
        int n5 = unpackedImageData.bandOffsets[1];
        int n6 = unpackedImageData.bandOffsets[2];
        int n7 = unpackedImageData.pixelStride;
        int n8 = unpackedImageData.lineStride;
        int n9 = 0;
        int n10 = 0;
        while (n10 < n2) {
            int n11 = 0;
            int n12 = n4;
            int n13 = n5;
            int n14 = n6;
            while (n11 < n3) {
                double d8;
                double d9 = (double)(sArray[n12] & 0xFFFF) * d2;
                double d10 = (double)(sArray2[n13] & 0xFFFF) * d3;
                double d11 = (double)(sArray3[n14] & 0xFFFF) * d4;
                double d12 = d8 = d9;
                double d13 = d8;
                if (d11 != 0.0) {
                    double d14;
                    double d15;
                    if (d10 >= 2.0943951023931953 && d10 < 4.1887902047863905) {
                        d13 = (1.0 - d11) * d9;
                        d15 = 3.0 * d9 - d13;
                        d14 = SQRT3 * (d13 - d9) * Math.tan(d10);
                        d12 = (d15 + d14) / 2.0;
                        d8 = (d15 - d14) / 2.0;
                    } else if (d10 > 4.1887902047863905) {
                        d12 = (1.0 - d11) * d9;
                        d15 = 3.0 * d9 - d12;
                        d14 = SQRT3 * (d12 - d9) * Math.tan(d10 - 2.0943951023931953);
                        d8 = (d15 + d14) / 2.0;
                        d13 = (d15 - d14) / 2.0;
                    } else if (d10 < 2.0943951023931953) {
                        d8 = (1.0 - d11) * d9;
                        d15 = 3.0 * d9 - d8;
                        d14 = SQRT3 * (d8 - d9) * Math.tan(d10 - 4.1887902047863905);
                        d13 = (d15 + d14) / 2.0;
                        d12 = (d15 - d14) / 2.0;
                    }
                }
                dArray[n9++] = (d13 < 0.0 ? 0.0 : (d13 > 1.0 ? 1.0 : d13)) * d5;
                dArray[n9++] = (d12 < 0.0 ? 0.0 : (d12 > 1.0 ? 1.0 : d12)) * d6;
                dArray[n9++] = (d8 < 0.0 ? 0.0 : (d8 > 1.0 ? 1.0 : d8)) * d7;
                ++n11;
                n12 += n7;
                n13 += n7;
                n14 += n7;
            }
            ++n10;
            n4 += n8;
            n5 += n8;
            n6 += n8;
        }
        ColorSpaceJAI.convertToSigned(dArray, n);
        writableRaster.setPixels(writableRaster.getMinX(), writableRaster.getMinY(), n3, n2, dArray);
    }

    private void toRGBInt(UnpackedImageData unpackedImageData, int[] nArray, WritableRaster writableRaster, int[] nArray2) {
        int[] nArray3 = unpackedImageData.getIntData(0);
        int[] nArray4 = unpackedImageData.getIntData(1);
        int[] nArray5 = unpackedImageData.getIntData(2);
        double d2 = 1.0 / (double)((1L << nArray[0]) - 1L);
        double d3 = 1.0 / (double)((1L << nArray[1]) - 1L) * (Math.PI * 2);
        double d4 = 1.0 / (double)((1L << nArray[2]) - 1L);
        double d5 = 1.0;
        double d6 = 1.0;
        double d7 = 1.0;
        int n = writableRaster.getSampleModel().getDataType();
        if (n < 4) {
            d5 = (1L << nArray2[0]) - 1L;
            d6 = (1L << nArray2[1]) - 1L;
            d7 = (1L << nArray2[2]) - 1L;
        }
        int n2 = writableRaster.getHeight();
        int n3 = writableRaster.getWidth();
        double[] dArray = new double[3 * n2 * n3];
        int n4 = unpackedImageData.bandOffsets[0];
        int n5 = unpackedImageData.bandOffsets[1];
        int n6 = unpackedImageData.bandOffsets[2];
        int n7 = unpackedImageData.pixelStride;
        int n8 = unpackedImageData.lineStride;
        int n9 = 0;
        int n10 = 0;
        while (n10 < n2) {
            int n11 = 0;
            int n12 = n4;
            int n13 = n5;
            int n14 = n6;
            while (n11 < n3) {
                double d8;
                double d9 = (double)((long)nArray3[n12] & 0xFFFFFFFFL) * d2;
                double d10 = (double)((long)nArray4[n13] & 0xFFFFFFFFL) * d3;
                double d11 = (double)((long)nArray5[n14] & 0xFFFFFFFFL) * d4;
                double d12 = d8 = d9;
                double d13 = d8;
                if (d11 != 0.0) {
                    double d14;
                    double d15;
                    if (d10 >= 2.0943951023931953 && d10 < 4.1887902047863905) {
                        d13 = (1.0 - d11) * d9;
                        d15 = 3.0 * d9 - d13;
                        d14 = SQRT3 * (d13 - d9) * Math.tan(d10);
                        d12 = (d15 + d14) / 2.0;
                        d8 = (d15 - d14) / 2.0;
                    } else if (d10 > 4.1887902047863905) {
                        d12 = (1.0 - d11) * d9;
                        d15 = 3.0 * d9 - d12;
                        d14 = SQRT3 * (d12 - d9) * Math.tan(d10 - 2.0943951023931953);
                        d8 = (d15 + d14) / 2.0;
                        d13 = (d15 - d14) / 2.0;
                    } else if (d10 < 2.0943951023931953) {
                        d8 = (1.0 - d11) * d9;
                        d15 = 3.0 * d9 - d8;
                        d14 = SQRT3 * (d8 - d9) * Math.tan(d10 - 4.1887902047863905);
                        d13 = (d15 + d14) / 2.0;
                        d12 = (d15 - d14) / 2.0;
                    }
                }
                dArray[n9++] = (d13 < 0.0 ? 0.0 : (d13 > 1.0 ? 1.0 : d13)) * d5;
                dArray[n9++] = (d12 < 0.0 ? 0.0 : (d12 > 1.0 ? 1.0 : d12)) * d6;
                dArray[n9++] = (d8 < 0.0 ? 0.0 : (d8 > 1.0 ? 1.0 : d8)) * d7;
                ++n11;
                n12 += n7;
                n13 += n7;
                n14 += n7;
            }
            ++n10;
            n4 += n8;
            n5 += n8;
            n6 += n8;
        }
        ColorSpaceJAI.convertToSigned(dArray, n);
        writableRaster.setPixels(writableRaster.getMinX(), writableRaster.getMinY(), n3, n2, dArray);
    }

    private void toRGBFloat(UnpackedImageData unpackedImageData, int[] nArray, WritableRaster writableRaster, int[] nArray2) {
        float[] fArray = unpackedImageData.getFloatData(0);
        float[] fArray2 = unpackedImageData.getFloatData(1);
        float[] fArray3 = unpackedImageData.getFloatData(2);
        double d2 = 1.0;
        double d3 = 1.0;
        double d4 = 1.0;
        int n = writableRaster.getSampleModel().getDataType();
        if (n < 4) {
            d2 = (1L << nArray2[0]) - 1L;
            d3 = (1L << nArray2[1]) - 1L;
            d4 = (1L << nArray2[2]) - 1L;
        }
        int n2 = writableRaster.getHeight();
        int n3 = writableRaster.getWidth();
        double[] dArray = new double[3 * n2 * n3];
        int n4 = unpackedImageData.bandOffsets[0];
        int n5 = unpackedImageData.bandOffsets[1];
        int n6 = unpackedImageData.bandOffsets[2];
        int n7 = unpackedImageData.pixelStride;
        int n8 = unpackedImageData.lineStride;
        int n9 = 0;
        int n10 = 0;
        while (n10 < n2) {
            int n11 = 0;
            int n12 = n4;
            int n13 = n5;
            int n14 = n6;
            while (n11 < n3) {
                double d5;
                double d6 = fArray[n12];
                double d7 = fArray2[n13];
                double d8 = fArray3[n14];
                double d9 = d5 = d6;
                double d10 = d5;
                if (d8 != 0.0) {
                    double d11;
                    double d12;
                    if (d7 >= 2.0943951023931953 && d7 < 4.1887902047863905) {
                        d10 = (1.0 - d8) * d6;
                        d12 = 3.0 * d6 - d10;
                        d11 = SQRT3 * (d10 - d6) * Math.tan(d7);
                        d9 = (d12 + d11) / 2.0;
                        d5 = (d12 - d11) / 2.0;
                    } else if (d7 > 4.1887902047863905) {
                        d9 = (1.0 - d8) * d6;
                        d12 = 3.0 * d6 - d9;
                        d11 = SQRT3 * (d9 - d6) * Math.tan(d7 - 2.0943951023931953);
                        d5 = (d12 + d11) / 2.0;
                        d10 = (d12 - d11) / 2.0;
                    } else if (d7 < 2.0943951023931953) {
                        d5 = (1.0 - d8) * d6;
                        d12 = 3.0 * d6 - d5;
                        d11 = SQRT3 * (d5 - d6) * Math.tan(d7 - 4.1887902047863905);
                        d10 = (d12 + d11) / 2.0;
                        d9 = (d12 - d11) / 2.0;
                    }
                }
                dArray[n9++] = (d10 < 0.0 ? 0.0 : (d10 > 1.0 ? 1.0 : d10)) * d2;
                dArray[n9++] = (d9 < 0.0 ? 0.0 : (d9 > 1.0 ? 1.0 : d9)) * d3;
                dArray[n9++] = (d5 < 0.0 ? 0.0 : (d5 > 1.0 ? 1.0 : d5)) * d4;
                ++n11;
                n12 += n7;
                n13 += n7;
                n14 += n7;
            }
            ++n10;
            n4 += n8;
            n5 += n8;
            n6 += n8;
        }
        ColorSpaceJAI.convertToSigned(dArray, n);
        writableRaster.setPixels(writableRaster.getMinX(), writableRaster.getMinY(), n3, n2, dArray);
    }

    private void toRGBDouble(UnpackedImageData unpackedImageData, int[] nArray, WritableRaster writableRaster, int[] nArray2) {
        double[] dArray = unpackedImageData.getDoubleData(0);
        double[] dArray2 = unpackedImageData.getDoubleData(1);
        double[] dArray3 = unpackedImageData.getDoubleData(2);
        double d2 = 1.0;
        double d3 = 1.0;
        double d4 = 1.0;
        int n = writableRaster.getSampleModel().getDataType();
        if (n < 4) {
            d2 = (1L << nArray2[0]) - 1L;
            d3 = (1L << nArray2[1]) - 1L;
            d4 = (1L << nArray2[2]) - 1L;
        }
        int n2 = writableRaster.getHeight();
        int n3 = writableRaster.getWidth();
        double[] dArray4 = new double[3 * n2 * n3];
        int n4 = unpackedImageData.bandOffsets[0];
        int n5 = unpackedImageData.bandOffsets[1];
        int n6 = unpackedImageData.bandOffsets[2];
        int n7 = unpackedImageData.pixelStride;
        int n8 = unpackedImageData.lineStride;
        int n9 = 0;
        int n10 = 0;
        while (n10 < n2) {
            int n11 = 0;
            int n12 = n4;
            int n13 = n5;
            int n14 = n6;
            while (n11 < n3) {
                double d5;
                double d6 = dArray[n12];
                double d7 = dArray2[n13];
                double d8 = dArray3[n14];
                double d9 = d5 = d6;
                double d10 = d5;
                if (d8 != 0.0) {
                    double d11;
                    double d12;
                    if (d7 >= 2.0943951023931953 && d7 < 4.1887902047863905) {
                        d10 = (1.0 - d8) * d6;
                        d12 = 3.0 * d6 - d10;
                        d11 = SQRT3 * (d10 - d6) * Math.tan(d7);
                        d9 = (d12 + d11) / 2.0;
                        d5 = (d12 - d11) / 2.0;
                    } else if (d7 > 4.1887902047863905) {
                        d9 = (1.0 - d8) * d6;
                        d12 = 3.0 * d6 - d9;
                        d11 = SQRT3 * (d9 - d6) * Math.tan(d7 - 2.0943951023931953);
                        d5 = (d12 + d11) / 2.0;
                        d10 = (d12 - d11) / 2.0;
                    } else if (d7 < 2.0943951023931953) {
                        d5 = (1.0 - d8) * d6;
                        d12 = 3.0 * d6 - d5;
                        d11 = SQRT3 * (d5 - d6) * Math.tan(d7 - 4.1887902047863905);
                        d10 = (d12 + d11) / 2.0;
                        d9 = (d12 - d11) / 2.0;
                    }
                }
                dArray4[n9++] = (d10 < 0.0 ? 0.0 : (d10 > 1.0 ? 1.0 : d10)) * d2;
                dArray4[n9++] = (d9 < 0.0 ? 0.0 : (d9 > 1.0 ? 1.0 : d9)) * d3;
                dArray4[n9++] = (d5 < 0.0 ? 0.0 : (d5 > 1.0 ? 1.0 : d5)) * d4;
                ++n11;
                n12 += n7;
                n13 += n7;
                n14 += n7;
            }
            ++n10;
            n4 += n8;
            n5 += n8;
            n6 += n8;
        }
        ColorSpaceJAI.convertToSigned(dArray4, n);
        writableRaster.setPixels(writableRaster.getMinX(), writableRaster.getMinY(), n3, n2, dArray4);
    }
}

