/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.JaiI18N;
import javax.media.jai.PropertyChangeSupportJAI;
import javax.media.jai.WritablePropertySource;
import javax.media.jai.WritablePropertySourceImpl;
import javax.media.jai.remote.SerializableState;
import javax.media.jai.remote.SerializerFactory;

public class MultiResolutionRenderableImage
implements WritablePropertySource,
RenderableImage,
Serializable {
    protected transient RenderedImage[] renderedSource;
    private int numSources;
    protected float aspect;
    protected float minX;
    protected float minY;
    protected float width;
    protected float height;
    protected PropertyChangeSupportJAI eventManager = new PropertyChangeSupportJAI(this);
    protected WritablePropertySourceImpl properties = new WritablePropertySourceImpl(null, null, this.eventManager);

    private MultiResolutionRenderableImage() {
    }

    public MultiResolutionRenderableImage(Vector vector, float f2, float f3, float f4) {
        this();
        if (f4 <= 0.0f) {
            throw new IllegalArgumentException(JaiI18N.getString("MultiResolutionRenderableImage0"));
        }
        this.numSources = vector.size();
        this.renderedSource = new RenderedImage[this.numSources];
        int n = 0;
        while (n < this.numSources) {
            this.renderedSource[n] = (RenderedImage)vector.elementAt(n);
            ++n;
        }
        int n2 = this.renderedSource[0].getWidth();
        int n3 = this.renderedSource[0].getHeight();
        this.aspect = (float)n2 / (float)n3;
        this.minX = f2;
        this.width = f4 * this.aspect;
        this.minY = f3;
        this.height = f4;
    }

    public Vector getSources() {
        return null;
    }

    public String[] getPropertyNames() {
        return this.properties.getPropertyNames();
    }

    public String[] getPropertyNames(String string) {
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return this.properties.getPropertyNames(string);
    }

    public Class getPropertyClass(String string) {
        return this.properties.getPropertyClass(string);
    }

    public Object getProperty(String string) {
        return this.properties.getProperty(string);
    }

    public void setProperty(String string, Object object) {
        this.properties.setProperty(string, object);
    }

    public void removeProperty(String string) {
        this.properties.removeProperty(string);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.eventManager.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.eventManager.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.eventManager.removePropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.eventManager.removePropertyChangeListener(string, propertyChangeListener);
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public float getMinX() {
        return this.minX;
    }

    public float getMaxX() {
        return this.minX + this.width;
    }

    public float getMinY() {
        return this.minY;
    }

    public float getMaxY() {
        return this.minY + this.height;
    }

    public boolean isDynamic() {
        return false;
    }

    public RenderedImage createScaledRendering(int n, int n2, RenderingHints renderingHints) {
        Object object;
        if (n <= 0 && n2 <= 0) {
            throw new IllegalArgumentException(JaiI18N.getString("MultiResolutionRenderableImage1"));
        }
        int n3 = this.numSources - 1;
        while (n3 > 0) {
            int n4;
            if (n2 > 0 ? (n4 = this.renderedSource[n3].getHeight()) >= n2 : (n4 = this.renderedSource[n3].getWidth()) >= n) break;
            --n3;
        }
        RenderedImage renderedImage = this.renderedSource[n3];
        if (n <= 0) {
            n = Math.round(n2 * renderedImage.getWidth() / renderedImage.getHeight());
        } else if (n2 <= 0) {
            n2 = Math.round(n * renderedImage.getHeight() / renderedImage.getWidth());
        }
        double d2 = (double)n / (double)renderedImage.getWidth();
        double d3 = (double)n2 / (double)renderedImage.getHeight();
        double d4 = (double)(this.getMinX() - (float)renderedImage.getMinX()) * d2;
        double d5 = (double)(this.getMinY() - (float)renderedImage.getMinY()) * d3;
        Interpolation interpolation = Interpolation.getInstance(0);
        if (renderingHints != null && (object = renderingHints.get(JAI.KEY_INTERPOLATION)) != null) {
            interpolation = (Interpolation)object;
        }
        object = new ParameterBlock();
        ((ParameterBlock)object).addSource(renderedImage);
        ((ParameterBlock)object).add((float)d2);
        ((ParameterBlock)object).add((float)d3);
        ((ParameterBlock)object).add((float)d4);
        ((ParameterBlock)object).add((float)d5);
        ((ParameterBlock)object).add(interpolation);
        return JAI.create("scale", (ParameterBlock)object, null);
    }

    public RenderedImage createDefaultRendering() {
        return this.renderedSource[0];
    }

    public RenderedImage createRendering(RenderContext renderContext) {
        Object object;
        if (renderContext == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        AffineTransform affineTransform = renderContext.getTransform();
        RenderingHints renderingHints = renderContext.getRenderingHints();
        int n = affineTransform.getType();
        if (n == 2 || n == 4) {
            int n2 = (int)Math.ceil(affineTransform.getScaleX() * (double)this.getWidth());
            int n3 = (int)Math.ceil(affineTransform.getScaleY() * (double)this.getHeight());
            return this.createScaledRendering(n2, n3, renderingHints);
        }
        int n4 = (int)Math.ceil(Math.sqrt(affineTransform.getDeterminant()) * (double)this.getHeight());
        int n5 = this.numSources - 1;
        while (n5 > 0) {
            int n6 = this.renderedSource[n5].getHeight();
            if (n6 >= n4) break;
            --n5;
        }
        RenderedImage renderedImage = this.renderedSource[n5];
        double d2 = (double)this.getWidth() / (double)renderedImage.getWidth();
        double d3 = (double)this.getHeight() / (double)renderedImage.getHeight();
        AffineTransform affineTransform2 = new AffineTransform();
        affineTransform2.translate(-renderedImage.getMinX(), -renderedImage.getMinY());
        affineTransform2.scale(d2, d3);
        affineTransform2.translate(this.getMinX(), this.getMinY());
        affineTransform2.preConcatenate(affineTransform);
        Interpolation interpolation = Interpolation.getInstance(0);
        if (renderingHints != null && (object = renderingHints.get(JAI.KEY_INTERPOLATION)) != null) {
            interpolation = (Interpolation)object;
        }
        object = new ParameterBlock();
        ((ParameterBlock)object).addSource(renderedImage);
        ((ParameterBlock)object).add(affineTransform2);
        ((ParameterBlock)object).add(interpolation);
        return JAI.create("affine", (ParameterBlock)object, null);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Object[] objectArray = new Object[this.numSources];
        int n = 0;
        while (n < this.numSources) {
            objectArray[n] = this.renderedSource[n] instanceof Serializable ? this.renderedSource[n] : SerializerFactory.getState(this.renderedSource[n]);
            ++n;
        }
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(objectArray);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Object[] objectArray = (Object[])objectInputStream.readObject();
        this.numSources = objectArray.length;
        this.renderedSource = new RenderedImage[this.numSources];
        int n = 0;
        while (n < this.numSources) {
            if (objectArray[n] instanceof SerializableState) {
                SerializableState serializableState = (SerializableState)objectArray[n];
                this.renderedSource[n] = (RenderedImage)serializableState.getObject();
            } else {
                this.renderedSource[n] = (RenderedImage)objectArray[n];
            }
            ++n;
        }
    }
}

