/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import javax.media.jai.CollectionImage;
import javax.media.jai.JaiI18N;

public class RenderedImageList
extends CollectionImage
implements List,
RenderedImage,
Serializable {
    protected RenderedImageList() {
    }

    public RenderedImageList(List list) {
        if (list == null) {
            throw new IllegalArgumentException(JaiI18N.getString("RenderedImageList0"));
        }
        if (list.isEmpty()) {
            throw new IllegalArgumentException(JaiI18N.getString("RenderedImageList1"));
        }
        Iterator iterator = list.iterator();
        this.imageCollection = new Vector();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (e2 instanceof RenderedImage) {
                this.imageCollection.add(e2);
                continue;
            }
            throw new IllegalArgumentException(JaiI18N.getString("RenderedImageList2"));
        }
    }

    private List getList() {
        return (List)this.imageCollection;
    }

    public RenderedImage getPrimaryImage() {
        return (RenderedImage)this.getList().get(0);
    }

    public int getMinX() {
        return ((RenderedImage)this.getList().get(0)).getMinX();
    }

    public int getMinY() {
        return ((RenderedImage)this.getList().get(0)).getMinY();
    }

    public int getWidth() {
        return ((RenderedImage)this.getList().get(0)).getWidth();
    }

    public int getHeight() {
        return ((RenderedImage)this.getList().get(0)).getHeight();
    }

    public int getTileWidth() {
        return ((RenderedImage)this.getList().get(0)).getTileWidth();
    }

    public int getTileHeight() {
        return ((RenderedImage)this.getList().get(0)).getTileHeight();
    }

    public int getTileGridXOffset() {
        return ((RenderedImage)this.getList().get(0)).getTileGridXOffset();
    }

    public int getTileGridYOffset() {
        return ((RenderedImage)this.getList().get(0)).getTileGridYOffset();
    }

    public int getMinTileX() {
        return ((RenderedImage)this.getList().get(0)).getMinTileX();
    }

    public int getNumXTiles() {
        return ((RenderedImage)this.getList().get(0)).getNumXTiles();
    }

    public int getMinTileY() {
        return ((RenderedImage)this.getList().get(0)).getMinTileY();
    }

    public int getNumYTiles() {
        return ((RenderedImage)this.getList().get(0)).getNumYTiles();
    }

    public SampleModel getSampleModel() {
        return ((RenderedImage)this.getList().get(0)).getSampleModel();
    }

    public ColorModel getColorModel() {
        return ((RenderedImage)this.getList().get(0)).getColorModel();
    }

    public Object getProperty(String string) {
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("RenderedImageList0"));
        }
        return ((RenderedImage)this.getList().get(0)).getProperty(string);
    }

    public String[] getPropertyNames() {
        return ((RenderedImage)this.getList().get(0)).getPropertyNames();
    }

    public Vector getSources() {
        return ((RenderedImage)this.getList().get(0)).getSources();
    }

    public Raster getTile(int n, int n2) {
        return ((RenderedImage)this.getList().get(0)).getTile(n, n2);
    }

    public Raster getData() {
        return ((RenderedImage)this.getList().get(0)).getData();
    }

    public Raster getData(Rectangle rectangle) {
        return ((RenderedImage)this.getList().get(0)).getData(rectangle);
    }

    public WritableRaster copyData(WritableRaster writableRaster) {
        return ((RenderedImage)this.getList().get(0)).copyData(writableRaster);
    }

    public void add(int n, Object object) {
        if (object instanceof RenderedImage) {
            if (n < 0 || n > this.imageCollection.size()) {
                throw new IndexOutOfBoundsException(JaiI18N.getString("RenderedImageList3"));
            }
        } else {
            throw new IllegalArgumentException(JaiI18N.getString("RenderedImageList2"));
        }
        ((List)this.imageCollection).add(n, object);
    }

    public boolean addAll(int n, Collection collection) {
        if (n < 0 || n > this.imageCollection.size()) {
            throw new IndexOutOfBoundsException(JaiI18N.getString("RenderedImageList3"));
        }
        Vector vector = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (!(e2 instanceof RenderedImage)) continue;
            if (vector == null) {
                vector = new Vector();
            }
            vector.add(e2);
        }
        return ((List)this.imageCollection).addAll(n, vector);
    }

    public Object get(int n) {
        if (n < 0 || n >= this.imageCollection.size()) {
            throw new IndexOutOfBoundsException(JaiI18N.getString("RenderedImageList3"));
        }
        return ((List)this.imageCollection).get(n);
    }

    public int indexOf(Object object) {
        return ((List)this.imageCollection).indexOf(object);
    }

    public int lastIndexOf(Object object) {
        return ((List)this.imageCollection).lastIndexOf(object);
    }

    public ListIterator listIterator() {
        return ((List)this.imageCollection).listIterator();
    }

    public ListIterator listIterator(int n) {
        return ((List)this.imageCollection).listIterator(n);
    }

    public Object remove(int n) {
        return ((List)this.imageCollection).remove(n);
    }

    public Object set(int n, Object object) {
        if (object instanceof RenderedImage) {
            return ((List)this.imageCollection).set(n, object);
        }
        throw new IllegalArgumentException(JaiI18N.getString("RenderedImageList2"));
    }

    public List subList(int n, int n2) {
        return ((List)this.imageCollection).subList(n, n2);
    }

    public boolean add(Object object) {
        if (object == null) {
            throw new IllegalArgumentException(JaiI18N.getString("RenderedImageList0"));
        }
        if (object instanceof RenderedImage) {
            this.imageCollection.add(object);
            return true;
        }
        throw new IllegalArgumentException(JaiI18N.getString("RenderedImageList2"));
    }

    public boolean addAll(Collection collection) {
        Iterator iterator = collection.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (!(e2 instanceof RenderedImage)) continue;
            this.imageCollection.add(e2);
            bl = true;
        }
        return bl;
    }
}

