/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.Rectangle;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import javax.media.jai.JaiI18N;
import javax.media.jai.PerspectiveTransform;
import javax.media.jai.Warp;

public final class WarpPerspective
extends Warp {
    private PerspectiveTransform transform;
    private PerspectiveTransform invTransform;

    public WarpPerspective(PerspectiveTransform perspectiveTransform) {
        if (perspectiveTransform == null) {
            throw new IllegalArgumentException(JaiI18N.getString("WarpPerspective0"));
        }
        this.transform = perspectiveTransform;
        try {
            this.invTransform = perspectiveTransform.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            this.invTransform = null;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            this.invTransform = null;
        }
    }

    public PerspectiveTransform getTransform() {
        return (PerspectiveTransform)this.transform.clone();
    }

    public float[] warpSparseRect(int n, int n2, int n3, int n4, int n5, int n6, float[] fArray) {
        if (fArray == null) {
            fArray = new float[2 * ((n3 + n5 - 1) / n5) * ((n4 + n6 - 1) / n6)];
        }
        double[][] dArray = new double[3][3];
        dArray = this.transform.getMatrix(dArray);
        float f2 = (float)dArray[0][0];
        float f3 = (float)dArray[0][1];
        float f4 = (float)dArray[0][2];
        float f5 = (float)dArray[1][0];
        float f6 = (float)dArray[1][1];
        float f7 = (float)dArray[1][2];
        float f8 = (float)dArray[2][0];
        float f9 = (float)dArray[2][1];
        float f10 = (float)dArray[2][2];
        float f11 = f2 * (float)n5;
        float f12 = f5 * (float)n5;
        float f13 = f8 * (float)n5;
        float f14 = (float)n + 0.5f;
        n3 += n;
        n4 += n2;
        int n7 = 0;
        int n8 = n2;
        while (n8 < n4) {
            float f15 = (float)n8 + 0.5f;
            float f16 = f2 * f14 + f3 * f15 + f4;
            float f17 = f5 * f14 + f6 * f15 + f7;
            float f18 = f8 * f14 + f9 * f15 + f10;
            int n9 = n;
            while (n9 < n3) {
                float f19;
                float f20;
                try {
                    f20 = f16 / f18;
                    f19 = f17 / f18;
                }
                catch (ArithmeticException arithmeticException) {
                    f20 = (float)n9 + 0.5f;
                    f19 = (float)n8 + 0.5f;
                }
                fArray[n7++] = f20 - 0.5f;
                fArray[n7++] = f19 - 0.5f;
                f16 += f11;
                f17 += f12;
                f18 += f13;
                n9 += n5;
            }
            n8 += n6;
        }
        return fArray;
    }

    public Rectangle mapDestRect(Rectangle rectangle) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        int n = rectangle.x;
        int n2 = rectangle.x + rectangle.width;
        int n3 = rectangle.y;
        int n4 = rectangle.y + rectangle.height;
        Point2D[] point2DArray = new Point2D[]{new Point2D.Float(n, n3), new Point2D.Float(n2, n3), new Point2D.Float(n, n4), new Point2D.Float(n2, n4)};
        this.transform.transform(point2DArray, 0, point2DArray, 0, 4);
        int n5 = Integer.MAX_VALUE;
        int n6 = Integer.MIN_VALUE;
        int n7 = Integer.MAX_VALUE;
        int n8 = Integer.MIN_VALUE;
        int n9 = 0;
        while (n9 < 4) {
            int n10 = (int)point2DArray[n9].getX();
            int n11 = (int)point2DArray[n9].getY();
            n5 = Math.min(n5, n10);
            n6 = Math.max(n6, n10);
            n7 = Math.min(n7, n11);
            n8 = Math.max(n8, n11);
            ++n9;
        }
        return new Rectangle(n5, n7, n6 - n5, n8 - n7);
    }

    public Rectangle mapSourceRect(Rectangle rectangle) {
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (this.invTransform == null) {
            return null;
        }
        int n = rectangle.x;
        int n2 = rectangle.x + rectangle.width;
        int n3 = rectangle.y;
        int n4 = rectangle.y + rectangle.height;
        Point2D[] point2DArray = new Point2D[]{new Point2D.Float(n, n3), new Point2D.Float(n2, n3), new Point2D.Float(n, n4), new Point2D.Float(n2, n4)};
        this.invTransform.transform(point2DArray, 0, point2DArray, 0, 4);
        int n5 = Integer.MAX_VALUE;
        int n6 = Integer.MIN_VALUE;
        int n7 = Integer.MAX_VALUE;
        int n8 = Integer.MIN_VALUE;
        int n9 = 0;
        while (n9 < 4) {
            int n10 = (int)point2DArray[n9].getX();
            int n11 = (int)point2DArray[n9].getY();
            n5 = Math.min(n5, n10);
            n6 = Math.max(n6, n10);
            n7 = Math.min(n7, n11);
            n8 = Math.max(n8, n11);
            ++n9;
        }
        return new Rectangle(n5, n7, n6 - n5, n8 - n7);
    }

    public Point2D mapDestPoint(Point2D point2D) {
        if (point2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return this.transform.transform(point2D, null);
    }

    public Point2D mapSourcePoint(Point2D point2D) {
        if (point2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return this.invTransform != null ? this.invTransform.transform(point2D, null) : null;
    }
}

