/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai.remote;

import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.media.jai.remote.JaiI18N;
import javax.media.jai.remote.Negotiable;

public class NegotiableCollection
implements Negotiable {
    private Vector elements;
    private Class elementClass;

    public NegotiableCollection(Collection collection) {
        Object e2;
        if (collection == null) {
            throw new IllegalArgumentException(JaiI18N.getString("NegotiableCollection0"));
        }
        this.elements = new Vector();
        Iterator iterator = collection.iterator();
        if (iterator.hasNext()) {
            e2 = iterator.next();
            this.elements.add(e2);
            this.elementClass = e2.getClass();
        }
        while (iterator.hasNext()) {
            e2 = iterator.next();
            if (e2.getClass() != this.elementClass) {
                throw new IllegalArgumentException(JaiI18N.getString("NegotiableCollection1"));
            }
            this.elements.add(e2);
        }
    }

    public NegotiableCollection(Object[] objectArray) {
        if (objectArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("NegotiableCollection0"));
        }
        int n = objectArray.length;
        if (n != 0) {
            this.elementClass = objectArray[0].getClass();
        }
        this.elements = new Vector(n);
        int n2 = 0;
        while (n2 < n) {
            if (objectArray[n2].getClass() != this.elementClass) {
                throw new IllegalArgumentException(JaiI18N.getString("NegotiableCollection1"));
            }
            this.elements.add(objectArray[n2]);
            ++n2;
        }
    }

    public Collection getCollection() {
        if (this.elements.isEmpty()) {
            return null;
        }
        return this.elements;
    }

    public Negotiable negotiate(Negotiable negotiable) {
        if (negotiable == null) {
            return null;
        }
        if (!(negotiable instanceof NegotiableCollection) || negotiable.getNegotiatedValueClass() != this.elementClass) {
            return null;
        }
        Vector vector = new Vector();
        Collection collection = ((NegotiableCollection)negotiable).getCollection();
        if (collection == null) {
            return null;
        }
        Iterator iterator = ((AbstractList)this.elements).iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (!collection.contains(e2) || vector.contains(e2)) continue;
            vector.add(e2);
        }
        if (vector.isEmpty()) {
            return null;
        }
        return new NegotiableCollection(vector);
    }

    public Object getNegotiatedValue() {
        if (this.elements != null && this.elements.size() > 0) {
            return this.elements.elementAt(0);
        }
        return null;
    }

    public Class getNegotiatedValueClass() {
        return this.elementClass;
    }
}

