/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.codestream.reader;

import java.awt.Point;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.Vector;
import jj2000.j2k.codestream.CBlkCoordInfo;
import jj2000.j2k.codestream.PrecInfo;
import jj2000.j2k.codestream.reader.BitstreamReaderAgent;
import jj2000.j2k.codestream.reader.CBlkInfo;
import jj2000.j2k.codestream.reader.HeaderDecoder;
import jj2000.j2k.codestream.reader.PktHeaderBitReader;
import jj2000.j2k.codestream.reader.TagTreeDecoder;
import jj2000.j2k.decoder.DecoderSpecs;
import jj2000.j2k.entropy.StdEntropyCoderOptions;
import jj2000.j2k.io.RandomAccessIO;
import jj2000.j2k.util.ArrayUtil;
import jj2000.j2k.util.MathUtil;
import jj2000.j2k.wavelet.synthesis.SubbandSyn;

public class PktDecoder
implements StdEntropyCoderOptions {
    private BitstreamReaderAgent src;
    private boolean pph = false;
    private ByteArrayInputStream pphbais;
    private DecoderSpecs decSpec;
    private HeaderDecoder hd;
    private final int INIT_LBLOCK = 3;
    private PktHeaderBitReader bin;
    private RandomAccessIO ehs;
    private Point[][] numPrec;
    private int tIdx;
    private PrecInfo[][][] ppinfo;
    private int[][][][][] lblock;
    private TagTreeDecoder[][][][] ttIncl;
    private TagTreeDecoder[][][][] ttMaxBP;
    private int nl = 0;
    private int nc;
    private boolean sopUsed = false;
    private boolean ephUsed = false;
    private int pktIdx;
    private Vector[] cblks;
    private int ncb;
    private int maxCB;
    private boolean ncbQuit;
    private int tQuit;
    private int cQuit;
    private int sQuit;
    private int rQuit;
    private int xQuit;
    private int yQuit;
    private boolean isTruncMode;

    public PktDecoder(DecoderSpecs decoderSpecs, HeaderDecoder headerDecoder, RandomAccessIO randomAccessIO, BitstreamReaderAgent bitstreamReaderAgent, boolean bl, int n) {
        this.decSpec = decoderSpecs;
        this.hd = headerDecoder;
        this.ehs = randomAccessIO;
        this.isTruncMode = bl;
        this.bin = new PktHeaderBitReader(randomAccessIO);
        this.src = bitstreamReaderAgent;
        this.ncb = 0;
        this.ncbQuit = false;
        this.maxCB = n;
    }

    public CBlkInfo[][][][][] restart(int n, int[] nArray, int n2, CBlkInfo[][][][][] cBlkInfoArray, boolean bl, ByteArrayInputStream byteArrayInputStream) {
        this.nc = n;
        this.nl = n2;
        this.tIdx = this.src.getTileIdx();
        this.pph = bl;
        this.pphbais = byteArrayInputStream;
        this.sopUsed = (Boolean)this.decSpec.sops.getTileDef(this.tIdx);
        this.pktIdx = 0;
        this.ephUsed = (Boolean)this.decSpec.ephs.getTileDef(this.tIdx);
        cBlkInfoArray = new CBlkInfo[n][][][][];
        this.lblock = new int[n][][][][];
        this.ttIncl = new TagTreeDecoder[n][][][];
        this.ttMaxBP = new TagTreeDecoder[n][][][];
        this.numPrec = new Point[n][];
        this.ppinfo = new PrecInfo[n][][];
        Point point = null;
        int n3 = this.src.getCbULX();
        int n4 = this.src.getCbULY();
        for (int i = 0; i < n; ++i) {
            cBlkInfoArray[i] = new CBlkInfo[nArray[i] + 1][][][];
            this.lblock[i] = new int[nArray[i] + 1][][][];
            this.ttIncl[i] = new TagTreeDecoder[nArray[i] + 1][][];
            this.ttMaxBP[i] = new TagTreeDecoder[nArray[i] + 1][][];
            this.numPrec[i] = new Point[nArray[i] + 1];
            this.ppinfo[i] = new PrecInfo[nArray[i] + 1][];
            int n5 = this.src.getResULX(i, nArray[i]);
            int n6 = this.src.getResULY(i, nArray[i]);
            int n7 = n5 + this.src.getTileCompWidth(this.tIdx, i, nArray[i]);
            int n8 = n6 + this.src.getTileCompHeight(this.tIdx, i, nArray[i]);
            for (int j = 0; j <= nArray[i]; ++j) {
                int n9 = (int)Math.ceil((double)n5 / (double)(1 << nArray[i] - j));
                int n10 = (int)Math.ceil((double)n6 / (double)(1 << nArray[i] - j));
                int n11 = (int)Math.ceil((double)n7 / (double)(1 << nArray[i] - j));
                int n12 = (int)Math.ceil((double)n8 / (double)(1 << nArray[i] - j));
                double d2 = this.getPPX(this.tIdx, i, j);
                double d3 = this.getPPY(this.tIdx, i, j);
                this.numPrec[i][j] = new Point();
                this.numPrec[i][j].x = n11 > n9 ? (int)Math.ceil((double)(n11 - n3) / d2) - (int)Math.floor((double)(n9 - n3) / d2) : 0;
                this.numPrec[i][j].y = n12 > n10 ? (int)Math.ceil((double)(n12 - n4) / d3) - (int)Math.floor((double)(n10 - n4) / d3) : 0;
                int n13 = j == 0 ? 0 : 1;
                int n14 = j == 0 ? 1 : 4;
                int n15 = this.numPrec[i][j].x * this.numPrec[i][j].y;
                this.ttIncl[i][j] = new TagTreeDecoder[n15][n14 + 1];
                this.ttMaxBP[i][j] = new TagTreeDecoder[n15][n14 + 1];
                cBlkInfoArray[i][j] = new CBlkInfo[n14 + 1][][];
                this.lblock[i][j] = new int[n14 + 1][][];
                this.ppinfo[i][j] = new PrecInfo[n15];
                this.fillPrecInfo(i, j, nArray[i]);
                SubbandSyn subbandSyn = this.src.getSynSubbandTree(this.tIdx, i);
                for (int k = n13; k < n14; ++k) {
                    SubbandSyn subbandSyn2 = (SubbandSyn)subbandSyn.getSubbandByIdx(j, k);
                    point = subbandSyn2.numCb;
                    cBlkInfoArray[i][j][k] = new CBlkInfo[point.y][point.x];
                    this.lblock[i][j][k] = new int[point.y][point.x];
                    for (int i2 = point.y - 1; i2 >= 0; --i2) {
                        ArrayUtil.intArraySet(this.lblock[i][j][k][i2], 3);
                    }
                }
            }
        }
        return cBlkInfoArray;
    }

    private void fillPrecInfo(int n, int n2, int n3) {
        if (this.ppinfo[n][n2].length == 0) {
            return;
        }
        Point point = this.src.getTile(null);
        Point point2 = this.src.getNumTiles(null);
        int n4 = this.src.getTilePartULX();
        int n5 = this.src.getTilePartULY();
        int n6 = this.src.getNomTileWidth();
        int n7 = this.src.getNomTileHeight();
        int n8 = this.hd.getImgULX();
        int n9 = this.hd.getImgULY();
        int n10 = this.hd.getImgWidth();
        int n11 = this.hd.getImgHeight();
        int n12 = point.x == 0 ? n8 : n4 + point.x * n6;
        int n13 = point.y == 0 ? n9 : n5 + point.y * n7;
        int n14 = point.x != point2.x - 1 ? n4 + (point.x + 1) * n6 : n10;
        int n15 = point.y != point2.y - 1 ? n5 + (point.y + 1) * n7 : n11;
        int n16 = this.hd.getCompSubsX(n);
        int n17 = this.hd.getCompSubsY(n);
        int n18 = this.src.getResULX(n, n3);
        int n19 = this.src.getResULY(n, n3);
        int n20 = n18 + this.src.getTileCompWidth(this.tIdx, n, n3);
        int n21 = n19 + this.src.getTileCompHeight(this.tIdx, n, n3);
        int n22 = n3 - n2;
        int n23 = (int)Math.ceil((double)n18 / (double)(1 << n22));
        int n24 = (int)Math.ceil((double)n19 / (double)(1 << n22));
        int n25 = (int)Math.ceil((double)n20 / (double)(1 << n22));
        int n26 = (int)Math.ceil((double)n21 / (double)(1 << n22));
        int n27 = this.src.getCbULX();
        int n28 = this.src.getCbULY();
        double d2 = this.getPPX(this.tIdx, n, n2);
        double d3 = this.getPPY(this.tIdx, n, n2);
        int n29 = (int)(d2 / 2.0);
        int n30 = (int)(d3 / 2.0);
        int n31 = this.ppinfo[n][n2].length;
        int n32 = 0;
        int n33 = (int)Math.floor((double)(n24 - n28) / d3);
        int n34 = (int)Math.floor((double)(n26 - 1 - n28) / d3);
        int n35 = (int)Math.floor((double)(n23 - n27) / d2);
        int n36 = (int)Math.floor((double)(n25 - 1 - n27) / d2);
        SubbandSyn subbandSyn = this.src.getSynSubbandTree(this.tIdx, n);
        SubbandSyn subbandSyn2 = null;
        int n37 = (int)d2 << n22;
        int n38 = (int)d3 << n22;
        for (int i = n33; i <= n34; ++i) {
            int n39 = n35;
            while (n39 <= n36) {
                int n40;
                int n41;
                CBlkCoordInfo cBlkCoordInfo;
                int n42;
                int n43;
                int n44;
                int n45;
                int n46;
                int n47;
                int n48;
                int n49;
                int n50;
                int n51;
                int n52;
                int n53;
                int n54;
                int n55;
                int n56;
                int n57;
                int n58;
                int n59;
                int n60;
                int n61;
                int n62 = n39 == n35 && (n23 - n27) % (n16 * (int)d2) != 0 ? n12 : n27 + n39 * n16 * ((int)d2 << n22);
                int n63 = i == n33 && (n24 - n28) % (n17 * (int)d3) != 0 ? n13 : n28 + i * n17 * ((int)d3 << n22);
                this.ppinfo[n][n2][n32] = new PrecInfo(n2, (int)((double)n27 + (double)n39 * d2), (int)((double)n28 + (double)i * d3), (int)d2, (int)d3, n62, n63, n37, n38);
                if (n2 == 0) {
                    n61 = n27;
                    n60 = n28;
                    n59 = n61 + n39 * (int)d2;
                    n58 = n59 + (int)d2;
                    n57 = n60 + i * (int)d3;
                    n56 = n57 + (int)d3;
                    subbandSyn2 = (SubbandSyn)subbandSyn.getSubbandByIdx(0, 0);
                    n55 = n59 < subbandSyn2.ulcx ? subbandSyn2.ulcx : n59;
                    n54 = n58 > subbandSyn2.ulcx + subbandSyn2.w ? subbandSyn2.ulcx + subbandSyn2.w : n58;
                    n53 = n57 < subbandSyn2.ulcy ? subbandSyn2.ulcy : n57;
                    n52 = n56 > subbandSyn2.ulcy + subbandSyn2.h ? subbandSyn2.ulcy + subbandSyn2.h : n56;
                    n51 = subbandSyn2.nomCBlkW;
                    n50 = subbandSyn2.nomCBlkH;
                    n49 = (int)Math.floor((double)(subbandSyn2.ulcy - n60) / (double)n50);
                    n48 = (int)Math.floor((double)(n53 - n60) / (double)n50);
                    n47 = (int)Math.floor((double)(n52 - 1 - n60) / (double)n50);
                    n46 = (int)Math.floor((double)(subbandSyn2.ulcx - n61) / (double)n51);
                    n45 = (int)Math.floor((double)(n55 - n61) / (double)n51);
                    n44 = (int)Math.floor((double)(n54 - 1 - n61) / (double)n51);
                    if (n54 - n55 <= 0 || n52 - n53 <= 0) {
                        this.ppinfo[n][n2][n32].nblk[0] = 0;
                        this.ttIncl[n][n2][n32][0] = new TagTreeDecoder(0, 0);
                        this.ttMaxBP[n][n2][n32][0] = new TagTreeDecoder(0, 0);
                    } else {
                        this.ttIncl[n][n2][n32][0] = new TagTreeDecoder(n47 - n48 + 1, n44 - n45 + 1);
                        this.ttMaxBP[n][n2][n32][0] = new TagTreeDecoder(n47 - n48 + 1, n44 - n45 + 1);
                        this.ppinfo[n][n2][n32].cblk[0] = new CBlkCoordInfo[n47 - n48 + 1][n44 - n45 + 1];
                        this.ppinfo[n][n2][n32].nblk[0] = (n47 - n48 + 1) * (n44 - n45 + 1);
                        for (n43 = n48; n43 <= n47; ++n43) {
                            for (n42 = n45; n42 <= n44; ++n42) {
                                cBlkCoordInfo = new CBlkCoordInfo(n43 - n49, n42 - n46);
                                cBlkCoordInfo.ulx = n42 == n46 ? subbandSyn2.ulx : subbandSyn2.ulx + n42 * n51 - (subbandSyn2.ulcx - n61);
                                cBlkCoordInfo.uly = n43 == n49 ? subbandSyn2.uly : subbandSyn2.uly + n43 * n50 - (subbandSyn2.ulcy - n60);
                                n41 = n61 + n42 * n51;
                                n41 = n41 > subbandSyn2.ulcx ? n41 : subbandSyn2.ulcx;
                                n40 = n61 + (n42 + 1) * n51;
                                n40 = n40 > subbandSyn2.ulcx + subbandSyn2.w ? subbandSyn2.ulcx + subbandSyn2.w : n40;
                                cBlkCoordInfo.w = n40 - n41;
                                n41 = n60 + n43 * n50;
                                n41 = n41 > subbandSyn2.ulcy ? n41 : subbandSyn2.ulcy;
                                n40 = n60 + (n43 + 1) * n50;
                                n40 = n40 > subbandSyn2.ulcy + subbandSyn2.h ? subbandSyn2.ulcy + subbandSyn2.h : n40;
                                cBlkCoordInfo.h = n40 - n41;
                                this.ppinfo[n][n2][n32].cblk[0][n43 - n48][n42 - n45] = cBlkCoordInfo;
                            }
                        }
                    }
                } else {
                    n61 = 0;
                    n60 = n28;
                    n59 = n61 + n39 * n29;
                    n58 = n59 + n29;
                    n57 = n60 + i * n30;
                    n56 = n57 + n30;
                    subbandSyn2 = (SubbandSyn)subbandSyn.getSubbandByIdx(n2, 1);
                    n55 = n59 < subbandSyn2.ulcx ? subbandSyn2.ulcx : n59;
                    n54 = n58 > subbandSyn2.ulcx + subbandSyn2.w ? subbandSyn2.ulcx + subbandSyn2.w : n58;
                    n53 = n57 < subbandSyn2.ulcy ? subbandSyn2.ulcy : n57;
                    n52 = n56 > subbandSyn2.ulcy + subbandSyn2.h ? subbandSyn2.ulcy + subbandSyn2.h : n56;
                    n51 = subbandSyn2.nomCBlkW;
                    n50 = subbandSyn2.nomCBlkH;
                    n49 = (int)Math.floor((double)(subbandSyn2.ulcy - n60) / (double)n50);
                    n48 = (int)Math.floor((double)(n53 - n60) / (double)n50);
                    n47 = (int)Math.floor((double)(n52 - 1 - n60) / (double)n50);
                    n46 = (int)Math.floor((double)(subbandSyn2.ulcx - n61) / (double)n51);
                    n45 = (int)Math.floor((double)(n55 - n61) / (double)n51);
                    n44 = (int)Math.floor((double)(n54 - 1 - n61) / (double)n51);
                    if (n54 - n55 <= 0 || n52 - n53 <= 0) {
                        this.ppinfo[n][n2][n32].nblk[1] = 0;
                        this.ttIncl[n][n2][n32][1] = new TagTreeDecoder(0, 0);
                        this.ttMaxBP[n][n2][n32][1] = new TagTreeDecoder(0, 0);
                    } else {
                        this.ttIncl[n][n2][n32][1] = new TagTreeDecoder(n47 - n48 + 1, n44 - n45 + 1);
                        this.ttMaxBP[n][n2][n32][1] = new TagTreeDecoder(n47 - n48 + 1, n44 - n45 + 1);
                        this.ppinfo[n][n2][n32].cblk[1] = new CBlkCoordInfo[n47 - n48 + 1][n44 - n45 + 1];
                        this.ppinfo[n][n2][n32].nblk[1] = (n47 - n48 + 1) * (n44 - n45 + 1);
                        for (n43 = n48; n43 <= n47; ++n43) {
                            for (n42 = n45; n42 <= n44; ++n42) {
                                cBlkCoordInfo = new CBlkCoordInfo(n43 - n49, n42 - n46);
                                cBlkCoordInfo.ulx = n42 == n46 ? subbandSyn2.ulx : subbandSyn2.ulx + n42 * n51 - (subbandSyn2.ulcx - n61);
                                cBlkCoordInfo.uly = n43 == n49 ? subbandSyn2.uly : subbandSyn2.uly + n43 * n50 - (subbandSyn2.ulcy - n60);
                                n41 = n61 + n42 * n51;
                                n41 = n41 > subbandSyn2.ulcx ? n41 : subbandSyn2.ulcx;
                                n40 = n61 + (n42 + 1) * n51;
                                n40 = n40 > subbandSyn2.ulcx + subbandSyn2.w ? subbandSyn2.ulcx + subbandSyn2.w : n40;
                                cBlkCoordInfo.w = n40 - n41;
                                n41 = n60 + n43 * n50;
                                n41 = n41 > subbandSyn2.ulcy ? n41 : subbandSyn2.ulcy;
                                n40 = n60 + (n43 + 1) * n50;
                                n40 = n40 > subbandSyn2.ulcy + subbandSyn2.h ? subbandSyn2.ulcy + subbandSyn2.h : n40;
                                cBlkCoordInfo.h = n40 - n41;
                                this.ppinfo[n][n2][n32].cblk[1][n43 - n48][n42 - n45] = cBlkCoordInfo;
                            }
                        }
                    }
                    n61 = n27;
                    n60 = 0;
                    n59 = n61 + n39 * n29;
                    n58 = n59 + n29;
                    n57 = n60 + i * n30;
                    n56 = n57 + n30;
                    subbandSyn2 = (SubbandSyn)subbandSyn.getSubbandByIdx(n2, 2);
                    n55 = n59 < subbandSyn2.ulcx ? subbandSyn2.ulcx : n59;
                    n54 = n58 > subbandSyn2.ulcx + subbandSyn2.w ? subbandSyn2.ulcx + subbandSyn2.w : n58;
                    n53 = n57 < subbandSyn2.ulcy ? subbandSyn2.ulcy : n57;
                    n52 = n56 > subbandSyn2.ulcy + subbandSyn2.h ? subbandSyn2.ulcy + subbandSyn2.h : n56;
                    n51 = subbandSyn2.nomCBlkW;
                    n50 = subbandSyn2.nomCBlkH;
                    n49 = (int)Math.floor((double)(subbandSyn2.ulcy - n60) / (double)n50);
                    n48 = (int)Math.floor((double)(n53 - n60) / (double)n50);
                    n47 = (int)Math.floor((double)(n52 - 1 - n60) / (double)n50);
                    n46 = (int)Math.floor((double)(subbandSyn2.ulcx - n61) / (double)n51);
                    n45 = (int)Math.floor((double)(n55 - n61) / (double)n51);
                    n44 = (int)Math.floor((double)(n54 - 1 - n61) / (double)n51);
                    if (n54 - n55 <= 0 || n52 - n53 <= 0) {
                        this.ppinfo[n][n2][n32].nblk[2] = 0;
                        this.ttIncl[n][n2][n32][2] = new TagTreeDecoder(0, 0);
                        this.ttMaxBP[n][n2][n32][2] = new TagTreeDecoder(0, 0);
                    } else {
                        this.ttIncl[n][n2][n32][2] = new TagTreeDecoder(n47 - n48 + 1, n44 - n45 + 1);
                        this.ttMaxBP[n][n2][n32][2] = new TagTreeDecoder(n47 - n48 + 1, n44 - n45 + 1);
                        this.ppinfo[n][n2][n32].cblk[2] = new CBlkCoordInfo[n47 - n48 + 1][n44 - n45 + 1];
                        this.ppinfo[n][n2][n32].nblk[2] = (n47 - n48 + 1) * (n44 - n45 + 1);
                        for (n43 = n48; n43 <= n47; ++n43) {
                            for (n42 = n45; n42 <= n44; ++n42) {
                                cBlkCoordInfo = new CBlkCoordInfo(n43 - n49, n42 - n46);
                                cBlkCoordInfo.ulx = n42 == n46 ? subbandSyn2.ulx : subbandSyn2.ulx + n42 * n51 - (subbandSyn2.ulcx - n61);
                                cBlkCoordInfo.uly = n43 == n49 ? subbandSyn2.uly : subbandSyn2.uly + n43 * n50 - (subbandSyn2.ulcy - n60);
                                n41 = n61 + n42 * n51;
                                n41 = n41 > subbandSyn2.ulcx ? n41 : subbandSyn2.ulcx;
                                n40 = n61 + (n42 + 1) * n51;
                                n40 = n40 > subbandSyn2.ulcx + subbandSyn2.w ? subbandSyn2.ulcx + subbandSyn2.w : n40;
                                cBlkCoordInfo.w = n40 - n41;
                                n41 = n60 + n43 * n50;
                                n41 = n41 > subbandSyn2.ulcy ? n41 : subbandSyn2.ulcy;
                                n40 = n60 + (n43 + 1) * n50;
                                n40 = n40 > subbandSyn2.ulcy + subbandSyn2.h ? subbandSyn2.ulcy + subbandSyn2.h : n40;
                                cBlkCoordInfo.h = n40 - n41;
                                this.ppinfo[n][n2][n32].cblk[2][n43 - n48][n42 - n45] = cBlkCoordInfo;
                            }
                        }
                    }
                    n61 = 0;
                    n60 = 0;
                    n59 = n61 + n39 * n29;
                    n58 = n59 + n29;
                    n57 = n60 + i * n30;
                    n56 = n57 + n30;
                    subbandSyn2 = (SubbandSyn)subbandSyn.getSubbandByIdx(n2, 3);
                    n55 = n59 < subbandSyn2.ulcx ? subbandSyn2.ulcx : n59;
                    n54 = n58 > subbandSyn2.ulcx + subbandSyn2.w ? subbandSyn2.ulcx + subbandSyn2.w : n58;
                    n53 = n57 < subbandSyn2.ulcy ? subbandSyn2.ulcy : n57;
                    n52 = n56 > subbandSyn2.ulcy + subbandSyn2.h ? subbandSyn2.ulcy + subbandSyn2.h : n56;
                    n51 = subbandSyn2.nomCBlkW;
                    n50 = subbandSyn2.nomCBlkH;
                    n49 = (int)Math.floor((double)(subbandSyn2.ulcy - n60) / (double)n50);
                    n48 = (int)Math.floor((double)(n53 - n60) / (double)n50);
                    n47 = (int)Math.floor((double)(n52 - 1 - n60) / (double)n50);
                    n46 = (int)Math.floor((double)(subbandSyn2.ulcx - n61) / (double)n51);
                    n45 = (int)Math.floor((double)(n55 - n61) / (double)n51);
                    n44 = (int)Math.floor((double)(n54 - 1 - n61) / (double)n51);
                    if (n54 - n55 <= 0 || n52 - n53 <= 0) {
                        this.ppinfo[n][n2][n32].nblk[3] = 0;
                        this.ttIncl[n][n2][n32][3] = new TagTreeDecoder(0, 0);
                        this.ttMaxBP[n][n2][n32][3] = new TagTreeDecoder(0, 0);
                    } else {
                        this.ttIncl[n][n2][n32][3] = new TagTreeDecoder(n47 - n48 + 1, n44 - n45 + 1);
                        this.ttMaxBP[n][n2][n32][3] = new TagTreeDecoder(n47 - n48 + 1, n44 - n45 + 1);
                        this.ppinfo[n][n2][n32].cblk[3] = new CBlkCoordInfo[n47 - n48 + 1][n44 - n45 + 1];
                        this.ppinfo[n][n2][n32].nblk[3] = (n47 - n48 + 1) * (n44 - n45 + 1);
                        for (n43 = n48; n43 <= n47; ++n43) {
                            for (n42 = n45; n42 <= n44; ++n42) {
                                cBlkCoordInfo = new CBlkCoordInfo(n43 - n49, n42 - n46);
                                cBlkCoordInfo.ulx = n42 == n46 ? subbandSyn2.ulx : subbandSyn2.ulx + n42 * n51 - (subbandSyn2.ulcx - n61);
                                cBlkCoordInfo.uly = n43 == n49 ? subbandSyn2.uly : subbandSyn2.uly + n43 * n50 - (subbandSyn2.ulcy - n60);
                                n41 = n61 + n42 * n51;
                                n41 = n41 > subbandSyn2.ulcx ? n41 : subbandSyn2.ulcx;
                                n40 = n61 + (n42 + 1) * n51;
                                n40 = n40 > subbandSyn2.ulcx + subbandSyn2.w ? subbandSyn2.ulcx + subbandSyn2.w : n40;
                                cBlkCoordInfo.w = n40 - n41;
                                n41 = n60 + n43 * n50;
                                n41 = n41 > subbandSyn2.ulcy ? n41 : subbandSyn2.ulcy;
                                n40 = n60 + (n43 + 1) * n50;
                                n40 = n40 > subbandSyn2.ulcy + subbandSyn2.h ? subbandSyn2.ulcy + subbandSyn2.h : n40;
                                cBlkCoordInfo.h = n40 - n41;
                                this.ppinfo[n][n2][n32].cblk[3][n43 - n48][n42 - n45] = cBlkCoordInfo;
                            }
                        }
                    }
                }
                ++n39;
                ++n32;
            }
        }
    }

    public int getNumPrecinct(int n, int n2) {
        return this.numPrec[n][n2].x * this.numPrec[n][n2].y;
    }

    public boolean readPktHead(int n, int n2, int n3, int n4, CBlkInfo[][][] cBlkInfoArray, int[] nArray) throws IOException {
        int n5;
        int n6 = 0;
        int n7 = this.ehs.getPos();
        if (n7 >= this.ehs.length()) {
            return true;
        }
        int n8 = this.src.getTileIdx();
        SubbandSyn subbandSyn = this.src.getSynSubbandTree(n8, n3);
        PktHeaderBitReader pktHeaderBitReader = this.pph ? new PktHeaderBitReader(this.pphbais) : this.bin;
        int n9 = n2 == 0 ? 0 : 1;
        int n10 = n2 == 0 ? 1 : 4;
        boolean bl = false;
        for (int i = n9; i < n10; ++i) {
            if (n4 >= this.ppinfo[n3][n2].length) continue;
            bl = true;
        }
        if (!bl) {
            return false;
        }
        PrecInfo precInfo = this.ppinfo[n3][n2][n4];
        pktHeaderBitReader.sync();
        if (pktHeaderBitReader.readBit() == 0) {
            this.cblks = new Vector[n10 + 1];
            for (int i = n9; i < n10; ++i) {
                this.cblks[i] = new Vector();
            }
            ++this.pktIdx;
            if (this.isTruncMode && this.maxCB == -1) {
                int n11 = this.ehs.getPos() - n7;
                if (n11 > nArray[n8]) {
                    nArray[n8] = 0;
                    return true;
                }
                int n12 = n8;
                nArray[n12] = nArray[n12] - n11;
            }
            if (this.ephUsed) {
                this.readEPHMarker(pktHeaderBitReader);
            }
            return false;
        }
        if (this.cblks == null || this.cblks.length < n10 + 1) {
            this.cblks = new Vector[n10 + 1];
        }
        for (int i = n9; i < n10; ++i) {
            if (this.cblks[i] == null) {
                this.cblks[i] = new Vector();
            } else {
                this.cblks[i].removeAllElements();
            }
            SubbandSyn subbandSyn2 = (SubbandSyn)subbandSyn.getSubbandByIdx(n2, i);
            if (precInfo.nblk[i] == 0) continue;
            TagTreeDecoder tagTreeDecoder = this.ttIncl[n3][n2][n4][i];
            TagTreeDecoder tagTreeDecoder2 = this.ttMaxBP[n3][n2][n4][i];
            int n13 = precInfo.cblk[i] == null ? 0 : precInfo.cblk[i].length;
            for (int j = 0; j < n13; ++j) {
                int n14 = precInfo.cblk[i][j] == null ? 0 : precInfo.cblk[i][j].length;
                for (int k = 0; k < n14; ++k) {
                    Point point = precInfo.cblk[i][j][k].idx;
                    int n15 = point.x + point.y * subbandSyn2.numCb.x;
                    CBlkInfo cBlkInfo = cBlkInfoArray[i][point.y][point.x];
                    try {
                        int n16;
                        int n17;
                        int n18;
                        int n19;
                        int n20;
                        if (cBlkInfo == null || cBlkInfo.ctp == 0) {
                            int n21;
                            if (cBlkInfo == null) {
                                CBlkInfo cBlkInfo2 = new CBlkInfo(precInfo.cblk[i][j][k].ulx, precInfo.cblk[i][j][k].uly, precInfo.cblk[i][j][k].w, precInfo.cblk[i][j][k].h, this.nl);
                                cBlkInfoArray[i][point.y][point.x] = cBlkInfo2;
                                cBlkInfo = cBlkInfo2;
                            }
                            cBlkInfo.pktIdx[n] = this.pktIdx;
                            n5 = tagTreeDecoder.update(j, k, n + 1, pktHeaderBitReader);
                            if (n5 > n) continue;
                            n5 = 1;
                            for (n21 = 1; n5 >= n21; ++n21) {
                                n5 = tagTreeDecoder2.update(j, k, n21, pktHeaderBitReader);
                            }
                            cBlkInfo.msbSkipped = n21 - 2;
                            n20 = 1;
                            cBlkInfo.addNTP(n, 0);
                            ++this.ncb;
                            if (this.maxCB != -1 && !this.ncbQuit && this.ncb == this.maxCB) {
                                this.ncbQuit = true;
                                this.tQuit = n8;
                                this.cQuit = n3;
                                this.sQuit = i;
                                this.rQuit = n2;
                                this.xQuit = point.x;
                                this.yQuit = point.y;
                            }
                        } else {
                            cBlkInfo.pktIdx[n] = this.pktIdx;
                            if (pktHeaderBitReader.readBit() != 1) continue;
                            n20 = 1;
                        }
                        if (pktHeaderBitReader.readBit() == 1) {
                            ++n20;
                            if (pktHeaderBitReader.readBit() == 1) {
                                ++n20;
                                n5 = pktHeaderBitReader.readBits(2);
                                n20 += n5;
                                if (n5 == 3) {
                                    n5 = pktHeaderBitReader.readBits(5);
                                    n20 += n5;
                                    if (n5 == 31) {
                                        n20 += pktHeaderBitReader.readBits(7);
                                    }
                                }
                            }
                        }
                        cBlkInfo.addNTP(n, n20);
                        n6 += n20;
                        this.cblks[i].addElement(precInfo.cblk[i][j][k]);
                        int n22 = (Integer)this.decSpec.ecopts.getTileCompVal(n8, n3);
                        if ((n22 & 4) != 0) {
                            n19 = n20;
                        } else if ((n22 & 1) != 0) {
                            if (cBlkInfo.ctp <= 10) {
                                n19 = 1;
                            } else {
                                n19 = 1;
                                for (n18 = cBlkInfo.ctp - n20; n18 < cBlkInfo.ctp - 1; ++n18) {
                                    if (n18 < 9 || (n17 = (n18 + 2) % 3) != 1 && n17 != 2) continue;
                                    ++n19;
                                }
                            }
                        } else {
                            n19 = 1;
                        }
                        while (pktHeaderBitReader.readBit() != 0) {
                            int[] nArray2 = this.lblock[n3][n2][i][point.y];
                            int n23 = point.x;
                            nArray2[n23] = nArray2[n23] + 1;
                        }
                        if (n19 == 1) {
                            n16 = pktHeaderBitReader.readBits(this.lblock[n3][n2][i][point.y][point.x] + MathUtil.log2(n20));
                        } else {
                            int n24;
                            int n25;
                            cBlkInfo.segLen[n] = new int[n19];
                            n16 = 0;
                            if ((n22 & 4) != 0) {
                                n18 = cBlkInfo.ctp - n20;
                                n25 = 0;
                                while (n18 < cBlkInfo.ctp) {
                                    n24 = this.lblock[n3][n2][i][point.y][point.x];
                                    cBlkInfo.segLen[n][n25] = n5 = pktHeaderBitReader.readBits(n24);
                                    n16 += n5;
                                    ++n18;
                                    ++n25;
                                }
                            } else {
                                int n26 = cBlkInfo.ctp - n20 - 1;
                                n25 = 0;
                                for (n18 = cBlkInfo.ctp - n20; n18 < cBlkInfo.ctp - 1; ++n18) {
                                    if (n18 < 9 || (n17 = (n18 + 2) % 3) == 0) continue;
                                    n24 = this.lblock[n3][n2][i][point.y][point.x];
                                    cBlkInfo.segLen[n][n25] = n5 = pktHeaderBitReader.readBits(n24 + MathUtil.log2(n18 - n26));
                                    n16 += n5;
                                    n26 = n18;
                                    ++n25;
                                }
                                n24 = this.lblock[n3][n2][i][point.y][point.x];
                                n5 = pktHeaderBitReader.readBits(n24 + MathUtil.log2(n18 - n26));
                                n16 += n5;
                                cBlkInfo.segLen[n][n25] = n5;
                            }
                        }
                        cBlkInfo.len[n] = n16;
                        if (!this.isTruncMode || this.maxCB != -1 || (n5 = this.ehs.getPos() - n7) <= nArray[n8]) continue;
                        nArray[n8] = 0;
                        if (n == 0) {
                            cBlkInfoArray[i][point.y][point.x] = null;
                        } else {
                            cBlkInfo.len[n] = 0;
                            cBlkInfo.off[n] = 0;
                            cBlkInfo.ctp -= cBlkInfo.ntp[n];
                            cBlkInfo.ntp[n] = 0;
                            cBlkInfo.pktIdx[n] = -1;
                        }
                        return true;
                    }
                    catch (EOFException eOFException) {
                        if (n == 0) {
                            cBlkInfoArray[i][point.y][point.x] = null;
                        } else {
                            cBlkInfo.len[n] = 0;
                            cBlkInfo.off[n] = 0;
                            cBlkInfo.ctp -= cBlkInfo.ntp[n];
                            cBlkInfo.ntp[n] = 0;
                            cBlkInfo.pktIdx[n] = -1;
                        }
                        return true;
                    }
                }
            }
        }
        if (this.ephUsed) {
            this.readEPHMarker(pktHeaderBitReader);
        }
        ++this.pktIdx;
        if (this.isTruncMode && this.maxCB == -1) {
            n5 = this.ehs.getPos() - n7;
            if (n5 > nArray[n8]) {
                nArray[n8] = 0;
                return true;
            }
            int n27 = n8;
            nArray[n27] = nArray[n27] - n5;
        }
        return false;
    }

    public boolean readPktBody(int n, int n2, int n3, int n4, CBlkInfo[][][] cBlkInfoArray, int[] nArray) throws IOException {
        int n5;
        int n6 = this.ehs.getPos();
        boolean bl = false;
        int n7 = this.src.getTileIdx();
        boolean bl2 = false;
        int n8 = n2 == 0 ? 0 : 1;
        int n9 = n2 == 0 ? 1 : 4;
        for (n5 = n8; n5 < n9; ++n5) {
            if (n4 >= this.ppinfo[n3][n2].length) continue;
            bl2 = true;
        }
        if (!bl2) {
            return false;
        }
        for (n5 = n8; n5 < n9; ++n5) {
            for (int i = 0; i < this.cblks[n5].size(); ++i) {
                Point point = ((CBlkCoordInfo)this.cblks[n5].elementAt((int)i)).idx;
                CBlkInfo cBlkInfo = cBlkInfoArray[n5][point.y][point.x];
                cBlkInfo.off[n] = n6;
                n6 += cBlkInfo.len[n];
                try {
                    this.ehs.seek(n6);
                }
                catch (EOFException eOFException) {
                    if (n == 0) {
                        cBlkInfoArray[n5][point.y][point.x] = null;
                    } else {
                        cBlkInfo.len[n] = 0;
                        cBlkInfo.off[n] = 0;
                        cBlkInfo.ctp -= cBlkInfo.ntp[n];
                        cBlkInfo.ntp[n] = 0;
                        cBlkInfo.pktIdx[n] = -1;
                    }
                    throw new EOFException();
                }
                if (this.isTruncMode) {
                    if (bl || cBlkInfo.len[n] > nArray[n7]) {
                        if (n == 0) {
                            cBlkInfoArray[n5][point.y][point.x] = null;
                        } else {
                            cBlkInfo.len[n] = 0;
                            cBlkInfo.off[n] = 0;
                            cBlkInfo.ctp -= cBlkInfo.ntp[n];
                            cBlkInfo.ntp[n] = 0;
                            cBlkInfo.pktIdx[n] = -1;
                        }
                        bl = true;
                    }
                    if (!bl) {
                        int n10 = n7;
                        nArray[n10] = nArray[n10] - cBlkInfo.len[n];
                    }
                }
                if (!this.ncbQuit || n2 != this.rQuit || n5 != this.sQuit || point.x != this.xQuit || point.y != this.yQuit || n7 != this.tQuit || n3 != this.cQuit) continue;
                cBlkInfoArray[n5][point.y][point.x] = null;
                bl = true;
            }
        }
        this.ehs.seek(n6);
        return bl;
    }

    public final int getPPX(int n, int n2, int n3) {
        return this.decSpec.pss.getPPX(n, n2, n3);
    }

    public final int getPPY(int n, int n2, int n3) {
        return this.decSpec.pss.getPPY(n, n2, n3);
    }

    public boolean readSOPMarker(int[] nArray, int n, int n2, int n3) throws IOException {
        int n4;
        byte[] byArray = new byte[6];
        int n5 = this.src.getTileIdx();
        int n6 = n3 == 0 ? 0 : 1;
        int n7 = n3 == 0 ? 1 : 4;
        boolean bl = false;
        for (n4 = n6; n4 < n7; ++n4) {
            if (n >= this.ppinfo[n2][n3].length) continue;
            bl = true;
        }
        if (!bl) {
            return false;
        }
        if (!this.sopUsed) {
            return false;
        }
        n4 = this.ehs.getPos();
        if ((short)(this.ehs.read() << 8 | this.ehs.read()) != -111) {
            this.ehs.seek(n4);
            return false;
        }
        this.ehs.seek(n4);
        if (nArray[n5] < 6) {
            return true;
        }
        int n8 = n5;
        nArray[n8] = nArray[n8] - 6;
        this.ehs.readFully(byArray, 0, 6);
        int n9 = byArray[0];
        n9 <<= 8;
        if ((n9 |= byArray[1]) != -111) {
            throw new Error("Corrupted Bitstream: Could not parse SOP marker !");
        }
        n9 = byArray[2] & 0xFF;
        n9 <<= 8;
        if ((n9 |= byArray[3] & 0xFF) != 4) {
            throw new Error("Corrupted Bitstream: Corrupted SOP marker !");
        }
        n9 = byArray[4] & 0xFF;
        n9 <<= 8;
        if (!this.pph && (n9 |= byArray[5] & 0xFF) != this.pktIdx) {
            throw new Error("Corrupted Bitstream: SOP marker out of sequence !");
        }
        if (this.pph && n9 != this.pktIdx - 1) {
            throw new Error("Corrupted Bitstream: SOP marker out of sequence !");
        }
        return false;
    }

    public void readEPHMarker(PktHeaderBitReader pktHeaderBitReader) throws IOException {
        byte[] byArray = new byte[2];
        if (pktHeaderBitReader.usebais) {
            pktHeaderBitReader.bais.read(byArray, 0, 2);
        } else {
            pktHeaderBitReader.in.readFully(byArray, 0, 2);
        }
        int n = byArray[0];
        n <<= 8;
        if ((n |= byArray[1]) != -110) {
            throw new Error("Corrupted Bitstream: Could not parse EPH marker ! ");
        }
    }

    public PrecInfo getPrecInfo(int n, int n2, int n3) {
        return this.ppinfo[n][n2][n3];
    }
}

