/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.image;

import jj2000.j2k.image.BlkImgDataSrc;
import jj2000.j2k.image.DataBlk;
import jj2000.j2k.image.DataBlkInt;
import jj2000.j2k.image.ImgDataAdapter;

public class ImgDataConverter
extends ImgDataAdapter
implements BlkImgDataSrc {
    private DataBlk srcBlk = new DataBlkInt();
    private BlkImgDataSrc src;
    private int fp;

    public ImgDataConverter(BlkImgDataSrc blkImgDataSrc, int n) {
        super(blkImgDataSrc);
        this.src = blkImgDataSrc;
        this.fp = n;
    }

    public ImgDataConverter(BlkImgDataSrc blkImgDataSrc) {
        super(blkImgDataSrc);
        this.src = blkImgDataSrc;
        this.fp = 0;
    }

    public int getFixedPoint(int n) {
        return this.fp;
    }

    public DataBlk getCompData(DataBlk dataBlk, int n) {
        return this.getData(dataBlk, n, false);
    }

    public final DataBlk getInternCompData(DataBlk dataBlk, int n) {
        return this.getData(dataBlk, n, true);
    }

    private DataBlk getData(DataBlk dataBlk, int n, boolean bl) {
        DataBlk dataBlk2;
        int n2 = dataBlk.getDataType();
        if (n2 == this.srcBlk.getDataType()) {
            dataBlk2 = dataBlk;
        } else {
            dataBlk2 = this.srcBlk;
            dataBlk2.ulx = dataBlk.ulx;
            dataBlk2.uly = dataBlk.uly;
            dataBlk2.w = dataBlk.w;
            dataBlk2.h = dataBlk.h;
        }
        this.srcBlk = bl ? this.src.getInternCompData(dataBlk2, n) : this.src.getCompData(dataBlk2, n);
        if (this.srcBlk.getDataType() == n2) {
            return this.srcBlk;
        }
        int n3 = this.srcBlk.w;
        int n4 = this.srcBlk.h;
        switch (n2) {
            case 4: {
                float[] fArray = (float[])dataBlk.getData();
                if (fArray == null || fArray.length < n3 * n4) {
                    fArray = new float[n3 * n4];
                    dataBlk.setData(fArray);
                }
                dataBlk.scanw = this.srcBlk.w;
                dataBlk.offset = 0;
                dataBlk.progressive = this.srcBlk.progressive;
                int[] nArray = (int[])this.srcBlk.getData();
                this.fp = this.src.getFixedPoint(n);
                if (this.fp != 0) {
                    float f2 = 1.0f / (float)(1 << this.fp);
                    int n5 = n3 * n4 - 1;
                    int n6 = this.srcBlk.offset + (n4 - 1) * this.srcBlk.scanw + n3 - 1;
                    for (int i = n4 - 1; i >= 0; --i) {
                        int n7 = n5 - n3;
                        while (n5 > n7) {
                            fArray[n5] = (float)nArray[n6] * f2;
                            --n5;
                            --n6;
                        }
                        n6 -= this.srcBlk.scanw - n3;
                    }
                } else {
                    int n8 = n3 * n4 - 1;
                    int n9 = this.srcBlk.offset + (n4 - 1) * this.srcBlk.scanw + n3 - 1;
                    for (int i = n4 - 1; i >= 0; --i) {
                        int n10 = n8 - n3;
                        while (n8 > n10) {
                            fArray[n8] = nArray[n9];
                            --n8;
                            --n9;
                        }
                        n9 -= this.srcBlk.scanw - n3;
                    }
                }
                break;
            }
            case 3: {
                int[] nArray = (int[])dataBlk.getData();
                if (nArray == null || nArray.length < n3 * n4) {
                    nArray = new int[n3 * n4];
                    dataBlk.setData(nArray);
                }
                dataBlk.scanw = this.srcBlk.w;
                dataBlk.offset = 0;
                dataBlk.progressive = this.srcBlk.progressive;
                float[] fArray = (float[])this.srcBlk.getData();
                if (this.fp != 0) {
                    float f3 = 1 << this.fp;
                    int n11 = n3 * n4 - 1;
                    int n12 = this.srcBlk.offset + (n4 - 1) * this.srcBlk.scanw + n3 - 1;
                    for (int i = n4 - 1; i >= 0; --i) {
                        int n13 = n11 - n3;
                        while (n11 > n13) {
                            nArray[n11] = fArray[n12] > 0.0f ? (int)(fArray[n12] * f3 + 0.5f) : (int)(fArray[n12] * f3 - 0.5f);
                            --n11;
                            --n12;
                        }
                        n12 -= this.srcBlk.scanw - n3;
                    }
                } else {
                    int n14 = n3 * n4 - 1;
                    int n15 = this.srcBlk.offset + (n4 - 1) * this.srcBlk.scanw + n3 - 1;
                    for (int i = n4 - 1; i >= 0; --i) {
                        int n16 = n14 - n3;
                        while (n14 > n16) {
                            nArray[n14] = fArray[n15] > 0.0f ? (int)(fArray[n15] + 0.5f) : (int)(fArray[n15] - 0.5f);
                            --n14;
                            --n15;
                        }
                        n15 -= this.srcBlk.scanw - n3;
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Only integer and float data are supported by JJ2000");
            }
        }
        return dataBlk;
    }
}

