/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.quantization.dequantizer;

import jj2000.j2k.decoder.DecoderSpecs;
import jj2000.j2k.image.DataBlk;
import jj2000.j2k.image.DataBlkFloat;
import jj2000.j2k.image.DataBlkInt;
import jj2000.j2k.quantization.GuardBitsSpec;
import jj2000.j2k.quantization.QuantStepSizeSpec;
import jj2000.j2k.quantization.QuantTypeSpec;
import jj2000.j2k.quantization.dequantizer.CBlkQuantDataSrcDec;
import jj2000.j2k.quantization.dequantizer.Dequantizer;
import jj2000.j2k.quantization.dequantizer.StdDequantizerParams;
import jj2000.j2k.wavelet.synthesis.SubbandSyn;

public class StdDequantizer
extends Dequantizer {
    private QuantTypeSpec qts;
    private QuantStepSizeSpec qsss;
    private GuardBitsSpec gbs;
    private StdDequantizerParams params;
    private DataBlkInt inblk;
    private int outdtype;

    public StdDequantizer(CBlkQuantDataSrcDec cBlkQuantDataSrcDec, int[] nArray, DecoderSpecs decoderSpecs) {
        super(cBlkQuantDataSrcDec, nArray, decoderSpecs);
        if (nArray.length != cBlkQuantDataSrcDec.getNumComps()) {
            throw new IllegalArgumentException("Invalid rb argument");
        }
        this.qsss = decoderSpecs.qsss;
        this.qts = decoderSpecs.qts;
        this.gbs = decoderSpecs.gbs;
    }

    public int getFixedPoint(int n) {
        return 0;
    }

    public final DataBlk getCodeBlock(int n, int n2, int n3, SubbandSyn subbandSyn, DataBlk dataBlk) {
        return this.getInternCodeBlock(n, n2, n3, subbandSyn, dataBlk);
    }

    public final DataBlk getInternCodeBlock(int n, int n2, int n3, SubbandSyn subbandSyn, DataBlk dataBlk) {
        boolean bl = this.qts.isReversible(this.tIdx, n);
        boolean bl2 = this.qts.isDerived(this.tIdx, n);
        StdDequantizerParams stdDequantizerParams = (StdDequantizerParams)this.qsss.getTileCompVal(this.tIdx, n);
        int n4 = (Integer)this.gbs.getTileCompVal(this.tIdx, n);
        this.outdtype = dataBlk.getDataType();
        if (bl && this.outdtype != 3) {
            throw new IllegalArgumentException("Reversible quantizations must use int data");
        }
        int[] nArray = null;
        float[] fArray = null;
        int[] nArray2 = null;
        switch (this.outdtype) {
            case 3: {
                dataBlk = this.src.getCodeBlock(n, n2, n3, subbandSyn, dataBlk);
                nArray = (int[])dataBlk.getData();
                break;
            }
            case 4: {
                this.inblk = (DataBlkInt)this.src.getInternCodeBlock(n, n2, n3, subbandSyn, this.inblk);
                nArray2 = this.inblk.getDataInt();
                if (dataBlk == null) {
                    dataBlk = new DataBlkFloat();
                }
                dataBlk.ulx = this.inblk.ulx;
                dataBlk.uly = this.inblk.uly;
                dataBlk.w = this.inblk.w;
                dataBlk.h = this.inblk.h;
                dataBlk.offset = 0;
                dataBlk.scanw = dataBlk.w;
                dataBlk.progressive = this.inblk.progressive;
                fArray = (float[])dataBlk.getData();
                if (fArray != null && fArray.length >= dataBlk.w * dataBlk.h) break;
                fArray = new float[dataBlk.w * dataBlk.h];
                dataBlk.setData(fArray);
            }
        }
        int n5 = subbandSyn.magbits;
        if (bl) {
            int n6 = 31 - n5;
            for (int i = nArray.length - 1; i >= 0; --i) {
                int n7 = nArray[i];
                nArray[i] = n7 >= 0 ? n7 >> n6 : -((n7 & Integer.MAX_VALUE) >> n6);
            }
        } else {
            float f2;
            if (bl2) {
                int n8 = this.src.getSynSubbandTree((int)this.getTileIdx(), (int)n).resLvl;
                f2 = stdDequantizerParams.nStep[0][0] * (float)(1L << this.rb[n] + subbandSyn.anGainExp + n8 - subbandSyn.level);
            } else {
                f2 = stdDequantizerParams.nStep[subbandSyn.resLvl][subbandSyn.sbandIdx] * (float)(1L << this.rb[n] + subbandSyn.anGainExp);
            }
            int n9 = 31 - n5;
            f2 /= (float)(1 << n9);
            switch (this.outdtype) {
                case 3: {
                    for (int i = nArray.length - 1; i >= 0; --i) {
                        int n10 = nArray[i];
                        nArray[i] = (int)((float)(n10 >= 0 ? n10 : -(n10 & Integer.MAX_VALUE)) * f2);
                    }
                    break;
                }
                case 4: {
                    int n11 = dataBlk.w;
                    int n12 = dataBlk.h;
                    int n13 = n11 * n12 - 1;
                    int n14 = this.inblk.offset + (n12 - 1) * this.inblk.scanw + n11 - 1;
                    int n15 = n11 * (n12 - 1);
                    while (n13 >= 0) {
                        while (n13 >= n15) {
                            int n16 = nArray2[n14];
                            fArray[n13] = (float)(n16 >= 0 ? n16 : -(n16 & Integer.MAX_VALUE)) * f2;
                            --n14;
                            --n13;
                        }
                        n14 -= this.inblk.scanw - n11;
                        n15 -= n11;
                    }
                    break;
                }
            }
        }
        return dataBlk;
    }
}

